;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Circle Option Box
;;;

(ui-string "circle.name"                "Circle Options")
(ui-string "mo_circle_periodic_degree"  "Degree")
(ui-string "mo_circle_periodic_spans"   "Spans")
(ui-string "mo_circle_sweep"            "Sweep Angle")
(ui-string "mo_circle_segments"			"Segments")
(ui-string "mo_circle_degree"           "Degree")
(ui-string "mo_circle_spans"            "Spans")
(ui-string "mo_circle_periodic_mode"    "Periodic Circle")

(ui-string "mo_keypoint_circle_degree"  "Degree")
(ui-string "mo_keypoint_circle_spans"   "Spans")


(ui-editor "circle.options"
	
	(list 'title 'circle.name)

	(list 'symbols	'mo_circle_periodic_mode
					'mo_circle_periodic_degree 
					'mo_circle_periodic_spans
					'mo_circle_sweep
					'mo_circle_degree
					'mo_circle_spans
					'mo_circle_segments
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)
	
	(ui-tick-widget "mo_circle_periodic_mode"
		(list 'enabled (ui-eq "mo_allow_rat_curves_surfaces" #f))
		(list 'rebuild #t)
	)

	(ui-integer-widget "mo_circle_periodic_degree" 
		(list 'enabled (ui-and (ui-eq "mo_circle_periodic_mode" #t) (ui-eq "mo_allow_rat_curves_surfaces" #f)))
		(list 'range 1 7)
	)
	
	(ui-integer-widget "mo_circle_periodic_spans"
		(list 'enabled (ui-and (ui-eq "mo_circle_periodic_mode" #t) (ui-eq "mo_allow_rat_curves_surfaces" #f)))
		(list 'slider_range 3 20)
		(list 'range 3 10000)
	)

	(ui-angle-widget "mo_circle_sweep"
		(list 'enabled (ui-or (ui-eq "mo_allow_rat_curves_surfaces" #t) (ui-eq "mo_circle_periodic_mode" #f)))
		(list 'precision "%f6.2")
		(list 'range 0.5 360)
	)

	(ui-integer-widget "mo_circle_segments"
		(list 'enabled (ui-or (ui-eq "mo_allow_rat_curves_surfaces" #t) (ui-eq "mo_circle_periodic_mode" #f)))
		(list 'range 1 16)
	)

	(ui-integer-widget "mo_circle_degree"
		(list 'enabled (ui-or (ui-eq "mo_allow_rat_curves_surfaces" #t) (ui-eq "mo_circle_periodic_mode" #f)))
		(list 'range 2 7)
		(list 'assign (ui-and (ui-eq 'mo_circle_degree 2) (ui-eq 'mo_circle_spans 1))
					  'mo_circle_spans 2)
	)

	(ui-integer-widget "mo_circle_spans"
		(list 'enabled (ui-and (ui-eq "mo_circle_periodic_mode" #f) (ui-eq "mo_allow_rat_curves_surfaces" #f)))
		(list 'range 1 20)

		(list 'assign (ui-and (ui-eq 'mo_circle_spans 1) (ui-eq 'mo_circle_degree 2))
					  'mo_circle_degree 3)
	)
)

(ui-editor "keypoint_circle.options"
	(list 'title 'circle.name)
	(list 'symbols
			'mo_keypoint_circle_degree
			'mo_keypoint_circle_spans)

	(ui-integer-widget "mo_keypoint_circle_degree"
		(list 'range 2 7)
	)

	(ui-integer-widget "mo_keypoint_circle_spans"
		(list 'range 1 14)
	)
)
