;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Build Surf Menu

(ui-string "mp_fillet_srf_str"          "Surface Fillet")
(ui-string "mp_fillet_srf_attr_str"     "srfillet")
(ui-string "mp_freeform_blend_str"      "Freeform Blend")
(ui-string "mp_freeform_blend_attr_str" "ffblnd")
(ui-string "mp_profile_blend_str"       "Profile Blend")
(ui-string "mp_profile_blend_attr_str"  "prfblnd")
(ui-string "mp_tube_str"			    "Tube Flange")
(ui-string "mp_tube_attr_str"			"tbflan")
(ui-string "mp_fillet_flange_str"	    "Fillet Flange")
(ui-string "mp_fillet_flange_attr_str"	"filflan")
(ui-string "mp_blendsrf_str"            "blend")
(ui-string "mp_blendsrf_attr_str"       "blend")
(ui-string "mp_round_str"               "9.0 Round")
(ui-string "mp_round_attr_str"          "9.0 rnd")
(ui-string "mp_network_str"             "Curve Networks...")
(ui-string "mp_network_attr_str"        "crvnet")
(ui-string "mp_nsided_str"              "n-sided")
(ui-string "mp_nsided_attr_str"         "nsided")
(ui-string "mp_square_str"              "square")
(ui-string "mp_square_attr_str"         "square")
(ui-string "mp_rail_str"                "Rail Surface")
(ui-string "mp_rail_attr_str"           "rail")
(ui-string "mp_bevel_str"               "bevel")
(ui-string "mp_bevel_attr_str"          "bevel")
(ui-string "mp_plansrf_str"             "Set Planar")
(ui-string "mp_plansrf_attr_str"        "planar")
(ui-string "mp_extrude_str"             "extrude")
(ui-string "mp_extrude_attr_str"        "extrd")
(ui-string "mp_revolve_str"             "revolve")
(ui-string "mp_revolve_attr_str"        "revolv")
(ui-string "mp_skin_str"                "skin 2012")
(ui-string "mp_skin_attr_str"           "skin12")
(ui-string "mp_boundary_str"            "boundary")
(ui-string "mp_boundary_attr_str"       "bound")
(ui-string "mp_draft_str"               "Multi-Surface Draft")
(ui-string "mp_draft_attr_str"          "msdrft")
(ui-string "mp_combine_surfs_str"       "Combine Surfaces")
(ui-string "mp_combine_surfs_attr_str"  "cmbsrf")
(ui-string "mp_roundengine_str"          "13 Round")
(ui-string "mp_roundengine_attr_str"     "13 round")
(ui-string "mp_ballcorner_str"          "Ball Corner")
(ui-string "mp_ballcorner_attr_str"     "ballcrn")
(ui-string "mp_cornerblend_str"         "Corner Blend")
(ui-string "mp_cornerblend_attr_str"    "crnblnd")
(ui-string "mp_tubesurface_str"         "Tube Surface")
(ui-string "mp_tubesurface_attr_str"    "tubsrf")
(ui-string "mp_msf_round_str"           "Round")
(ui-string "mp_msf_round_attr_str"      "round")
(ui-string "mp_panel_gap_str"           "Panel Gap")
(ui-string "mp_panel_gap_attr_str"      "pnlgap")
(ui-string "mp_symmetric_fillet_str"           "Symmetric Fillet")
(ui-string "mp_symmetric_fillet_attr_str"      "symflt")
(ui-string "mp_vsrskin_str"				"Skin")
(ui-string "mp_vsrskin_attr_str"		"skin")
(ui-string "mp_profile_str"				"Profile")
(ui-string "mp_profile_attr_str"		"profile")
(ui-string "mp_autostitch_str"			"Stitch and Seam")
(ui-string "mp_autostitch_attr_str"		"stnsm")
(ui-string "mp_quicksurface_str"		"Surface From Mesh")
(ui-string "mp_quicksurface_attr_str"	"srfmsh")
(ui-string "mp_multiblend_str"			"Multi Blend")
(ui-string "mp_multiblend_attr_str"		"mtblnd")
(ui-string "mp_srf_offset_str"      "Surface Offset")
(ui-string "mp_srf_offset_attr_str" "srfoff")

; Need to include it conditionally.

(ui-function "mp_buildsurf_filletsrf"
	(list 'select			'mp_buildsurf 'MP_FILLET_SRF)
	(list 'command			"SurfaceFillet")
	(list 'label_string		'mp_fillet_srf_str)
	(list 'attribute_string	'mp_fillet_srf_attr_str)
	(list 'option_function	"FilletSrfControlBox")
	(list 'symbols	'mo_fillet_srf_radius_type
					'mo_fillet_srf_constr_method
					'mo_fillet_srf_variable_mode
					'mo_fillet_srf_radius
					'mo_fillet_srf_parameter_type
					'mo_fillet_srf_lead_radius
					'mo_fillet_srf_lead_type
					'mo_fillet_srf_knee_ratio
					'mo_fillet_srf_center_radius
					'mo_fillet_srf_form_factor
					'mo_fillet_srf_form_factor_version
					'mo_fillet_srf_curvature_in_bias
					'mo_fillet_srf_curvature_toggle
					'mo_fillet_srf_bias_factor
					'mo_fillet_srf_use_minimum_radius
					'mo_fillet_srf_minimum_radius
					'mo_fillet_srf_chordal_type
					'mo_fillet_srf_chord_distance
					'mo_fillet_srf_start_edge_flow
					'mo_fillet_srf_interior_flow
					'mo_fillet_srf_end_edge_flow
					'mo_fillet_srf_primary_clip
					'mo_fillet_srf_primary_clip_start
					'mo_fillet_srf_primary_clip_end
					'mo_fillet_srf_secondary_clip
					'mo_fillet_srf_secondary_clip_start
					'mo_fillet_srf_secondary_clip_end
					'mo_fillet_srf_single_span
					'mo_fillet_srf_explicit_control
					'mo_fillet_srf_u_degree
					'mo_fillet_srf_v_degree
					'mo_fillet_srf_max_num_spans
					'mo_fillet_srf_auto_recalc
					'mo_fillet_srf_trim_type
					'mo_fillet_srf_continuity_check
					'mo_fillet_srf_curvature_comb
					'mo_fillet_srf_short_edge_tol
					'mo_fillet_srf_surface_type
					'mo_fillet_srf_uniform_spans
					'mo_fillet_srf_num_uniform_spans
					'mo_fillet_inter_tangent_angle_maximum
					'mo_fillet_inter_continuity_check
					'mo_fillet_srf_proportional_crown
					'mo_fillet_srf_proportional_crown_flip
					'mo_fillet_srf_proportional_crown_value
					'mo_fillet_srf_proportional_crown_shape
					'mo_fillet_srf_proportional_crown_bias
					'mo_fillet_srf_create_metadata
					'mo_fillet_srf_create_history
	)
)


(ui-function "mp_buildsurf_freeformblend"
	(list 'select        	'mp_buildsurf 'MP_FREEFORM_BLEND)
	(list 'command			"FreeformBlend")
	(list 'label_string     'mp_freeform_blend_str)
	(list 'attribute_string 'mp_freeform_blend_attr_str)
	(list 'option_function  "FreeformBlendControlBox")
	(list 'symbols
			"mo_fillet_srf_chord_distance"
			"mo_fillet_srf_chordal_type"
			"mo_fillet_srf_minimum_radius"
			"mo_fillet_srf_num_uniform_spans"
			"mo_fillet_srf_parameter_type"
			"mo_fillet_srf_radius"
			"mo_fillet_srf_trim_type"
			"mo_fillet_srf_uniform_spans"
			"mo_fillet_srf_use_minimum_radius"
			"mo_fillet_srf_variable_mode"
			"mo_freeform_blend_Aside_continuity"
			"mo_freeform_blend_auto_recalc"
			"mo_freeform_blend_bias_factor"
			"mo_freeform_blend_Bside_continuity"
			"mo_freeform_blend_center_radius"
			"mo_freeform_blend_central_K_ratio"
			"mo_freeform_blend_constr_method"
			"mo_freeform_blend_continuity_check"
			"mo_freeform_blend_inter_continuity_check"
			"mo_freeform_blend_curvature_comb"
			"mo_freeform_blend_curvature_in_bias"
			"mo_freeform_blend_curvature_toggle"
			"mo_freeform_blend_end_edge_flow"
			"mo_freeform_blend_exact_num_spans"
			"mo_freeform_blend_explicit_control"
			"mo_freeform_blend_fitting_method_side1"
			"mo_freeform_blend_fitting_method_side2"
			"mo_freeform_blend_form_factor"
			"mo_freeform_blend_form_factor_version"
			"mo_freeform_blend_hybrid_infl_side1"
			"mo_freeform_blend_hybrid_infl_side2"
			"mo_freeform_blend_interior_flow"
			"mo_freeform_blend_is_G3_curvature"
			"mo_fillet_srf_three_segments"
			"mo_freeform_blend_knee_ratio"
			"mo_freeform_blend_lead"
			"mo_freeform_blend_max_num_spans"
			"mo_freeform_blend_pick_chain"
			"mo_freeform_blend_primary_clip"
			"mo_freeform_blend_primary_clip_end"
			"mo_freeform_blend_primary_clip_start"
			"mo_freeform_blend_prop_crown"
			"mo_freeform_blend_prop_crown_flip"
			"mo_freeform_blend_prop_crown_val"
			"mo_freeform_blend_prop_crown_shape"
			"mo_freeform_blend_prop_crown_bias"
			"mo_freeform_blend_range_primary"
			"mo_freeform_blend_range_primary_end"
			"mo_freeform_blend_range_primary_start"
			"mo_freeform_blend_range_secondary"
			"mo_freeform_blend_range_secondary_end"
			"mo_freeform_blend_range_secondary_start"
			"mo_freeform_blend_secondary_clip"
			"mo_freeform_blend_secondary_clip_end"
			"mo_freeform_blend_secondary_clip_start"
			"mo_freeform_blend_section_type"
			"mo_freeform_blend_segmentation"
			"mo_freeform_blend_shape_lock"
			"mo_freeform_blend_shape_slider"
			"mo_freeform_blend_shape_sliderB"
			"mo_freeform_blend_short_edge_tol"
			"mo_freeform_blend_single_span"
			"mo_freeform_blend_start_edge_flow"
			"mo_freeform_blend_start_edge_flow"
			"mo_freeform_blend_surface_type"
			"mo_freeform_blend_symmetric"
			"mo_freeform_blend_symmetric_continuity"
			"mo_freeform_blend_symmetric_peak"
			"mo_freeform_blend_symmetric_vdegree"
			"mo_freeform_blend_u_degree"
			"mo_freeform_blend_use_central_K"
			"mo_freeform_blend_use_form_factor_math"
			"mo_freeform_symmetric"
			"mo_freeform_symmetric_continuity"
			"mo_freeform_symmetric_peak"
			"mo_freeform_symmetric_vdegree"
            "mo_freeform_blend_create_metadata"
			"mo_freeform_blend_create_history"
			"mo_freeform_blend_modify_parameter"
			"mo_freeform_blend_side1_param"
			"mo_freeform_blend_side2_param"
	)
)

(ui-function "mp_buildsurf_profileblend"      
	(list 'select        	'mp_buildsurf 'MP_PROFILE_BLEND)
	(list 'command			"ProfileBlend")
	(list 'label_string     'mp_profile_blend_str)
	(list 'attribute_string 'mp_profile_blend_attr_str)
	(list 'option_function  "ProfileBlendControlBox")
	(list 'symbols
			'mo_profile_blend_continuityA
			'mo_profile_blend_continuityB
			'mo_profile_blend_surface_type
			'mo_profile_blend_single_span
			'mo_profile_blend_continuity
			'mo_profile_blend_auto_recalc
			'mo_profile_blend_interior_edge_align
			'mo_profile_blend_continuity_check
			'mo_profile_blend_explicit_control
			'mo_profile_blend_u_degree
			'mo_profile_blend_short_edge_tol
			'mo_profile_blend_max_num_spans
			'mo_profile_blend_exact_num_spans
			'mo_profile_blend_segmentation
			'mo_profile_blend_fitting_method_side1
			'mo_profile_blend_fitting_method_side2
			'mo_profile_blend_hybrid_infl_side1
			'mo_profile_blend_hybrid_infl_side2
			'mo_profile_blend_pick_chain
            'mo_profile_blend_create_metadata
			'mo_profile_blend_create_history
	 )
)

(ui-function "mp_buildsurf_tube"
	(list 'select        	'mp_buildsurf 'MP_TUBE)
	(list 'command			"TubeFlange")
	(list 'label_string     'mp_tube_str)
	(list 'attribute_string 'mp_tube_attr_str)
	(list 'option_function  "TubeFlangeControlBox")
	(list 'symbols
			'mo_tube_auto_recalc
			'mo_tube_center_radius
			'mo_tube_continuity_check
			'mo_tube_inter_continuity_check
			'mo_tube_create_flange
			'mo_tube_degree
			'mo_tube_explicit_control
			'mo_tube_ext_degree
			'mo_tube_ext_distance
			'mo_tube_ext_explicit_control
			'mo_tube_ext_flip
			'mo_tube_ext_max_spans
			'mo_tube_ext_type
			'mo_tube_flip
			'mo_tube_form_factor
			'mo_tube_form_factor_version
			'mo_tube_max_spans
			'mo_tube_parameter_type
			'mo_tube_parting_line_angle
			'mo_tube_pick_chain
			'mo_tube_radius
			'mo_tube_range
			'mo_tube_range_end
			'mo_tube_range_start
			'mo_tube_section_type
			'mo_tube_short_edge_tol
			'mo_tube_single_span
			'mo_tube_surface_type
			'mo_tube_sweep_angle
			'mo_tube_v_degree
			'mo_tube_variable_param
            'mo_tube_create_metadata
			'mo_tube_create_history
	)
)

(ui-function "mp_buildsurf_filletflange"      
	(list 'select        	'mp_buildsurf 'MP_FILLET_FLANGE)
	(list 'command			"FilletFlange")
	(list 'label_string     'mp_fillet_flange_str)
	(list 'attribute_string 'mp_fillet_flange_attr_str)
	(list 'option_function  "FilletFlangeControlBox")
	(list 'symbols
			'mo_fillet_flange_wall_type			'mo_fillet_flange_create_flange
			'mo_fillet_flange_flange_angle		'mo_fillet_flange_ext_type
			'mo_fillet_flange_draft_angle		'mo_fillet_flange_ext_distance
			'mo_fillet_flange_wall_flip			'mo_fillet_flange_ext_explicit_control
			'mo_fillet_flange_radius			'mo_fillet_flange_ext_degree
			'mo_fillet_flange_flip				'mo_fillet_flange_ext_max_spans
			'mo_fillet_flange_surface_type		'mo_fillet_flange_sweep_angle
			'mo_fillet_flange_section_type		'mo_fillet_flange_parting_line_angle
			'mo_fillet_flange_parameter_type	'mo_fillet_flange_variable_param
			'mo_fillet_flange_center_radius		'mo_fillet_flange_auto_trim
			'mo_fillet_flange_form_factor_version 'mo_fillet_flange_form_factor		
			'mo_fillet_flange_continuity_check	'mo_fillet_flange_inter_continuity_check
			'mo_fillet_flange_single_span		'mo_fillet_flange_auto_recalc
			'mo_fillet_flange_short_edge_tol	'mo_fillet_flange_show_wall
			'mo_fillet_flange_explicit_control	'mo_fillet_flange_extend_start
			'mo_fillet_flange_degree			'mo_fillet_flange_extend_end
			'mo_fillet_flange_v_degree			'mo_fillet_flange_max_spans
			'mo_fillet_flange_pick_chain		'mo_fillet_flange_single_span
			'mo_fillet_flange_range				'mo_fillet_flange_range_start
			'mo_fillet_flange_range_end         'mo_fillet_flange_create_metadata
			'mo_fillet_flange_create_history
	)
)

(ui-function "mp_buildsurf_blendsrf"    
	(list 'select        	'mp_buildsurf 'MP_MULTI_FILLET)
	(list 'command			"BlendSurface")
	(list 'label_string     'mp_blendsrf_str)
	(list 'attribute_string 'mp_blendsrf_attr_str)
)

(ui-function "mp_buildsurf_roundsrf"    
	(list 'select  		    'mp_buildsurf 'MP_ROUND)
	(list 'command			"Round90")
	(list 'label_string     'mp_round_str)
	(list 'attribute_string 'mp_round_attr_str)
	(list 'option_editor    "Modeling/mo_round_options.o.scm"
							'round.options)
)

(ui-function "mp_buildsurf_msf_round"
	(list 'select			'mp_buildsurf 'MP_MSFROUND)
	(list 'command			"Round")
	(list 'label_string		'mp_msf_round_str)
	(list 'attribute_string 'mp_msf_round_attr_str)
	(list 'option_function	"RoundControlBox")
	(list 'symbols
			'mo_msfround_default_radius			'mo_msfround_trim_type
			'mo_msfround_3feq_corner_type		'mo_msfround_3fne_corner_type
			'mo_msfround_mitred_corner_type		'mo_msfround_4sided_corner_type
	)
)

(ui-function "mp_buildsurf_network"     
	(list 'select           'mp_buildsurf 'MP_CURVE_NETWORK_EDITOR)
	(list 'command			"CurveNetworkEditor")
	(list 'label_string     'mp_network_str)
	(list 'attribute_string 'mp_network_attr_str)
	(list 'option_editor    "Modeling/mo_network_options.o.scm"
							'network.options)
)

(ui-function "mp_buildsurf_nsided"      
	(list 'command			"NSided")
	(list 'label_string     'mp_nsided_str)
	(list 'attribute_string 'mp_nsided_attr_str)
	(list 'option_function  "NSidedControls")
	(list 'symbols
			'mo_nsided_blendmode 'mo_nsided_num_sides
			'mo_nsided_continuity	'mo_nsided_rebuild
			'mo_nsided_keeporig
			'mo_holeFiller_continuity		'mo_holeFiller_rebuild
			'mo_holeFiller_max_new_spans	'mo_holeFiller_insert_double
			'mo_holeFiller_blend_control	'mo_holeFiller_surface_degree
			'mo_holeFiller_blend_weight		'mo_holeFiller_smooth_weight
			'mo_holeFiller_cubic_c_on_s		'mo_holeFiller_map_closest
			'mo_rail_surfeval		        'mo_rail_xsec_show_previous
			'mo_rail_history		        'mo_rail_auto_recalc
	)
)

(ui-function "mp_buildsurf_square"      
	(list 'select        	'mp_buildsurf 'MP_SQUARE)
	(list 'command			"Square")
	(list 'label_string     'mp_square_str)
	(list 'attribute_string 'mp_square_attr_str)
	(list 'option_function  "SquareControls")
	(list 'symbols
		'mo_square_have_surfaces	'mo_square_concrvs
		'mo_square_recon			'mo_square_blendmode
		'mo_square_boundary_vblend  
		'mo_square_boundary_ublend
		'mo_square_influence_factor1  
		'mo_square_influence_factor2
		'mo_square_contin_b1		'mo_square_contin_b2
		'mo_square_contin_b3		'mo_square_contin_b4
		'mo_square_rebuild_b1		'mo_square_rebuild_b2
		'mo_square_rebuild_b3		'mo_square_rebuild_b4
		'mo_square_create_history	'mo_square_xsec_keep
		'mo_square_xsec_show_previous	'mo_square_xsec_draw_mode
		'mo_square_cont_max_iter	'mo_square_g1_by_project
		'mo_square_g2_enhanced		'mo_square_skews_allowed
		'mo_square_surfeval			'mo_square_xsec_mode
		'mo_square_dataredn			'mo_square_blend
		'mo_square_tanscale_u		'mo_square_tanscale_v
		'mo_square_boundary_labels  'mo_square_explicit_control
		'mo_square_srfDegreeU       'mo_square_srfDegreeV
		'mo_square_degreeSync		'mo_square_continuity_check
		'mo_square_explicitSpansU	'mo_square_explicitSpansV
		'mo_square_explicit_max_iter 'mo_square_insert_at_midpoint
		'mo_square_colinear_b1		'mo_square_colinear_b2
		'mo_square_colinear_b3		'mo_square_colinear_b4
		'mo_square_cont_extra_passes    'mo_square_create_metadata
	)
)

(ui-function "mp_buildsurf_rail"      
	(list 'command				'mp_railsrf_command
      "Rail" "Monorail_I" "Monorail_II" "Birail_I" "Birail_II" "Birail_II+")
	(list 'label_string     'mp_rail_str)
	(list 'attribute_string 'mp_rail_attr_str)
	(list 'option_function  "RailControls")
	(list 'symbols
		'mp_railsrf_command         'mp_railsrf_com
		'mo_rail_pathcrvs
		'mo_rail_gencrvs 			'mo_rail_sweepmode
		'mo_rail_swproj 			'mo_rail_contsgc
		'mo_rail_contegc			'mo_rail_contspc
		'mo_rail_contepc			'mo_rail_transform
		'mo_rail_blend			'mo_rail_crvseg
		'mo_rail_view_vector		'mo_rail_explicit_control
		'mo_rail_srfDegreeGen		'mo_rail_srfDegreePath
		'mo_rail_degreeSync		'mo_rail_continuity_check
		'mo_rail_cont_max_iter	'mo_rail_explicitSpansGen
		'mo_rail_explicitSpansPath	'mo_rail_rebuild_genI
        'mo_rail_rebuild_path1 	'mo_rail_rebuild_path2
        'mo_rail_rebuild_gen1  	'mo_rail_rebuild_genL
		'mo_rail_explicit_max_iter 
		'mo_rail_blend_value

		'mo_rail_surfeval	'mo_rail_pivots
		'mo_rail_fixedcrv	'mo_rail_scale_xform
		'mo_rail_space1_pivot
		'mo_rail_space2_pivot 
		'mo_rail_rotate_xform
		'mo_rail_gen1_pivot
		'mo_rail_gen2_pivot
		'mo_rail_path_pivot1
		'mo_rail_path_pivot2
		'mo_rail_gen1_segment_start
		'mo_rail_gen1_segment_end
		'mo_rail_gen2_segment_start
		'mo_rail_gen2_segment_end
		'mo_rail_path1_segment_start
		'mo_rail_path1_segment_end
		'mo_rail_path2_segment_start
		'mo_rail_path2_segment_end
		'mo_rail_history		'mo_rail_auto_recalc
		'mo_rail_xsec_show_previous
		'mo_rail_boundary_labels
		'mo_rail_achieved_continuity_check
		'mo_rail_insert_at_midpoint	'mo_rail_colinear_isoparms
		'mo_swept_sweepmode
        'mo_rail_colinear_path1 	'mo_rail_colinear_path2
        'mo_rail_colinear_gen1  	'mo_rail_colinear_genL
        'mo_rail_create_metadata
	)
)

(ui-function "mp_buildsurf_bevel"       
	(list 'select        	'mp_buildsurf 'MP_BEVEL)
	(list 'command			"Bevel")
	(list 'label_string     'mp_bevel_str)
	(list 'attribute_string 'mp_bevel_attr_str)
	(list 'option_editor    "Modeling/mo_bevel_options.o.scm"
							'bevel.options)
)

(ui-function "mp_buildsurf_plansrf"     
	(list 'select        	'mp_buildsurf 'MP_FACE)
	(list 'command			"SetFace")
	(list 'label_string     'mp_plansrf_str)
	(list 'attribute_string 'mp_plansrf_attr_str)
	(list 'option_editor    "Modeling/mo_planarsurf_options.o.scm"
							'plansurf.options
		(ui-eq "trim_option"            #t))
)

(ui-function "mp_buildsurf_extrude"     
	(list 'select        	'mp_buildsurf 'MP_EXTRUDE)
	(list 'command			"Extrude")
	(list 'label_string     'mp_extrude_str)
	(list 'attribute_string 'mp_extrude_attr_str)
	(list 'option_editor    "Modeling/mo_extrude_options.o.scm"
							'extrude.options)
)

(ui-function "mp_buildsurf_revolve"     
	(list 'select        	'mp_buildsurf 'MP_REVOLVE)
	(list 'command			"Revolve")
	(list 'label_string     'mp_revolve_str)
	(list 'attribute_string 'mp_revolve_attr_str)
	(list 'option_function  "RevolveControlBox")
	(list 'symbols
		  'mo_revolve_axis
		  'mo_revolve_periodic
		  'mo_degrees
		  'mo_revolve_per_segment
		  'mo_revsections
		  'mo_revolve_geometry_type
		  'mo_revsegments
		  'mo_revolve_degree_periodic
		  'mo_revolve_spans_periodic
		  'mo_revolve_barrel_degree
		  'mo_revolve_chain_select
		  'mo_revolve_cont_check
		  'mo_revolve_history
		  'mo_revolve_axes
		  'mo_revolve_auto_recalc
		  'mo_revolve_segments
		  'mo_revolve_pitch
		  'mo_revolve_surface_type
		  'mo_revolve_sideglass_mode
		  'mo_revolve_barrel_rot_st
		  'mo_revolve_barrel_rot_ed
		  'mo_revolve_barrel_crv_st
		  'mo_revolve_barrel_crv_ed
		  'mo_revolve_helix_rot_st
		  'mo_revolve_helix_rot_ed
          'mo_revolve_metadata
		  )
)

(ui-function "mp_buildsurf_skin"        
	(list 'select        		'mp_buildsurf 'MP_SKIN)
	(list 'command				"Skin")
	(list 'label_string        	'mp_skin_str)
	(list 'attribute_string   	'mp_skin_attr_str)
	(list 'option_editor       	"Modeling/mo_skin_options.o.scm"
								'skin.options)
)

(ui-function "mp_buildsurf_boundary"    
	(list 'select        		'mp_buildsurf 'MP_BOUNDARY)
	(list 'command				"Boundary")
	(list 'label_string        	'mp_boundary_str)
	(list 'attribute_string  	'mp_boundary_attr_str)
	(list 'option_editor       	"Modeling/mo_boundary_options.o.scm"
								'boundary.options)
)

(ui-function "mp_buildsurf_draft"      
	(list 'select        	'mp_buildsurf 'MP_DRAFT)
	(list 'command			"MSDraft")
	(list 'label_string     'mp_draft_str)
	(list 'attribute_string 'mp_draft_attr_str)
	(list 'option_function  "MSDraftControlBox")
	(list 'symbols
			'mo_draft_type						'mo_draft_degree
			'mo_draft_surface_type				'mo_draft_vDegree
			'mo_draft_flange_angle				'mo_draft_max_spans
			'mo_draft_draft_angle				'mo_draft_variable_param
			'mo_draft_height					'mo_draft_continuity_check
			'mo_draft_flip						'mo_draft_auto_recalc
			'mo_draft_single_span				'mo_draft_length_mode
			'mo_draft_double_sided				'mo_draft_radial_orient
			'mo_draft_radial_refit
			'mo_draft_single_surface			'mo_draft_orientation_vector
			'mo_draft_explicit_control			'mo_draft_orient_vect_name
			'mo_draft_pick_chain				'mo_draft_orient_vect_presets
			'mo_draft_pull_vect_name			'mo_draft_orient_vector
			'mo_draft_pull_vect_presets			'mo_draft_flange_from_curve
			'mo_draft_pull_vector				'mo_draft_from_curve_mode
			'mo_draft_pick_isoParam				'mo_draft_miter_mode
			'mo_draft_pick_curve				'mo_draft_angle_calc
			'mo_draft_pick_trimEdge				'mo_draft_to_surface
			'mo_draft_pick_COS					'mo_draft_crown
			'mo_draft_intersect_flanges			'mo_draft_crown_flip
			'mo_draft_inter_continuity_check	'mo_draft_crown_type
			'mo_draft_tangent_angle_maximum		'mo_draft_crown_value
			'mo_draft_segmentation				'mo_draft_crown_shape
			'mo_draft_crown_bias
			'mo_draft_hybrid_infl				'mo_draft_fitting_method
			'mo_draft_modify_range				'mo_draft_exact_spans    
			'mo_draft_range_start               'mo_draft_range_end
            'mo_draft_create_metadata			'mo_draft_create_history
	)
)

(ui-function "mp_buildsurf_combine"     
	(list 'command				"CombineSurfs")
	(list 'label_string        	'mp_combine_surfs_str)
	(list 'attribute_string   	'mp_combine_surfs_attr_str)
	(list 'option_function       	"CombineSurfsControlBox")
	(list 'symbols
		  'mo_combine_surfaces_tolerance
		  'mo_combine_surfaces_angle_tolerance
		  'mo_combine_surfaces_iterate
		  'mo_combine_surfaces_udeg
		  'mo_combine_surfaces_vdeg
		  'mo_combine_surfaces_uspans
		  'mo_combine_surfaces_vspans
	)
)

(ui-function "mp_buildsurf_roundengine"     
    (list 'command				"Round13")
	(list 'label_string        'mp_roundengine_str)
	(list 'attribute_string   	'mp_roundengine_attr_str)
	(list 'option_editor       	"Modeling/mo_re_options.o.scm"
								'mo_roundengine.options)
)

(ui-function "mp_buildsurf_ballcorner"     
    (list 'command				"BallCorner")
	(list 'label_string        'mp_ballcorner_str)
	(list 'attribute_string   	'mp_ballcorner_attr_str)
	(list 'option_function      "BallCornerControlBox")
	(list 'symbols
		'mo_ballcorner_pivot_length_lock
		'mo_ballcorner_pivot_length_start
		'mo_ballcorner_pivot_length_end
		'mo_ballcorner_create_history
		'mo_ballcorner_continuity_check
		'mo_ballcorner_max_spans
		'mo_ballcorner_continuity_type
		'mo_ballcorner_degree_sides
		'mo_ballcorner_degree_pivot
		'mo_ballcorner_spans_sides
		'mo_ballcorner_spans_pivot
		'mo_ballcorner_build_surface
		'mo_ballcorner_trim_primary
		'mo_ballcorner_trim_type
		'mo_ballcorner_center_adjust
		'mo_ballcorner_center_height
		'mo_ballcorner_explicit_control
		'mo_ballcorner_show_helpers
		'mo_ballcorner_create_metadata
	)
)

(ui-function "mp_buildsurf_cornerblend"     
	(list 'command				"CornerBlend")
	(list 'label_string			'mp_cornerblend_str)
	(list 'attribute_string		'mp_cornerblend_attr_str)
	(list 'option_function		"CornerBlendControlBox")
	(list 'symbols
			"mo_cornerblend_tangent_offset"
			"mo_cornerblend_form_factor"
			"mo_cornerblend_shape_factor"
			"mo_cornerblend_continuity_type"
			"mo_cornerblend_explicit_control"
			"mo_cornerblend_udegree"
			"mo_cornerblend_vdegree"
			"mo_cornerblend_uspans"
			"mo_cornerblend_vspans"
			"mo_cornerblend_max_spans"
			"mo_cornerblend_ublend"
			"mo_cornerblend_vblend"
			"mo_cornerblend_blend_trim_type"
			"mo_cornerblend_blend_top_trim_type"
			"mo_cornerblend_continuity_check"
			"mo_cornerblend_create_history"
			"mo_cornerblend_auto_update"
			"mo_cornerblend_debug_geometry"
			"mo_cornerblend_create_metadata"
	)
)

(ui-function "mp_buildsurf_tubesurface"     
    (list 'command				"TubeSurface")
	(list 'label_string        'mp_tubesurface_str)
	(list 'attribute_string   	'mp_tubesurface_attr_str)
	(list 'option_function      "TubeSurfaceControlBox")
	(list 'symbols
		'mo_tube_surface_radius
        'mo_tube_surface_pick_chain
        'mo_tube_surface_single_span
        'mo_tube_surface_create_metadata
	)
)

(ui-function "mp_buildsurf_panelgap"
	(list 'command				"PanelGap")
	(list 'label_string			'mp_panel_gap_str)
	(list 'attribute_string		'mp_panel_gap_attr_str)
	(list 'option_function		"PanelGapControlBox")
	(list 'symbols
			"mo_panel_gap_wall_type"
			"mo_panel_gap_flange_angle"
			"mo_panel_gap_draft_angle"
			"mo_panel_gap_wall_flip"
			"mo_panel_gap_wall_uses_primary"
			"mo_panel_gap_wall_vector_name"
			"mo_panel_gap_wall_vector_presets"
			"mo_panel_gap_wall_vector_refresh"
			"mo_panel_gap_wall_vector_save"
			"mo_panel_gap_form_factor_version"
			"mo_panel_gap_primary_section_type"
			"mo_panel_gap_primary_parameter_type"
			"mo_panel_gap_primary_radius"
			"mo_panel_gap_primary_center_radius"
			"mo_panel_gap_primary_form_factor"
			"mo_panel_gap_primary_extension_type"
			"mo_panel_gap_primary_sweep_angle"
			"mo_panel_gap_variable_primary"
			"mo_panel_gap_primary_partline_angle"
			"mo_panel_gap_create_primary_flange"
			"mo_panel_gap_primary_extension_distance"
			"mo_panel_gap_primary_vector_name"
			"mo_panel_gap_primary_vector_presets"
			"mo_panel_gap_primary_vector_refresh"
			"mo_panel_gap_primary_vector_save"
			"mo_panel_gap_gap_distance"
			"mo_panel_gap_gap_flip"
			"mo_panel_gap_variable_gap"
			"mo_panel_gap_secondary_section_type"
			"mo_panel_gap_secondary_parameter_type"
			"mo_panel_gap_secondary_radius"
			"mo_panel_gap_secondary_center_radius"
			"mo_panel_gap_secondary_form_factor"
			"mo_panel_gap_secondary_extension_type"
			"mo_panel_gap_secondary_sweep_angle"
			"mo_panel_gap_variable_secondary"
			"mo_panel_gap_secondary_partline_angle"
			"mo_panel_gap_create_secondary_flange"
			"mo_panel_gap_secondary_extension_distance"
			"mo_panel_gap_secondary_vector_name"
			"mo_panel_gap_secondary_vector_presets"
			"mo_panel_gap_secondary_vector_refresh"
			"mo_panel_gap_secondary_vector_save"
			"mo_panel_gap_single_span"
			"mo_panel_gap_pick_chain"
			"mo_panel_gap_debug_geometry"
			"mo_panel_gap_create_type"
			"mo_panel_gap_closeout_surface"
			"mo_panel_gap_surface_type"
			"mo_panel_gap_trim_type"
			"mo_panel_gap_auto_recalc"
			"mo_panel_gap_explicit_control"
			"mo_panel_gap_u_degree"
			"mo_panel_gap_v_degree"
			"mo_panel_gap_max_spans"
			"mo_panel_gap_clip_primary"
			"mo_panel_gap_clip_primary_start"
			"mo_panel_gap_clip_primary_end"
			"mo_panel_gap_clip_secondary"
			"mo_panel_gap_clip_secondary_start"
			"mo_panel_gap_clip_secondary_end"
			"mo_panel_gap_gap_check"
			"mo_panel_gap_gap_samples"
			"mo_panel_gap_deviation_scale"
			"mo_panel_gap_deviation_threshold"
			"mo_panel_gap_continuity_check"
			"mo_panel_gap_short_edge_tol"
            "mo_panel_gap_create_metadata"
			"mo_panel_gap_create_history"
	)
)

(ui-function "mp_buildsurf_symmetric_fillet"
	(list 'command				"SymmetricFillet")
	(list 'label_string			'mp_symmetric_fillet_str)
	(list 'attribute_string		'mp_symmetric_fillet_attr_str)
	(list 'option_function		"SymmetricFilletControlBox")
	(list 'symbols
			"mo_symmetric_fillet_section_type"
			"mo_symmetric_fillet_curvature_toggle"
			"mo_symmetric_fillet_form_factor"
			"mo_symmetric_fillet_form_factor_version"
			"mo_symmetric_fillet_flip"
			"mo_symmetric_fillet_explicit_control"
			"mo_symmetric_fillet_u_degree"
			"mo_symmetric_fillet_v_degree"
			"mo_symmetric_fillet_max_num_spans"
			"mo_symmetric_fillet_start_edge_flow"
			"mo_symmetric_fillet_interior_flow"
			"mo_symmetric_fillet_end_edge_flow"
			"mo_symmetric_fillet_clip"
			"mo_symmetric_fillet_clip_start"
			"mo_symmetric_fillet_clip_end"
			"mo_symmetric_fillet_surface_type"
			"mo_symmetric_fillet_single_span"
			"mo_symmetric_fillet_short_edge_tol"
			"mo_symmetric_fillet_trim_type"
			"mo_symmetric_fillet_curvature_comb"
			"mo_symmetric_fillet_continuity_check"
			"mo_symmetric_fillet_auto_recalc"
			"mo_symmetric_fillet_pick_chain"
			"mo_symmetric_fillet_radius_check"
			"mo_symmetric_fillet_radius_samples"
			"mo_symmetric_fillet_create_history"
            "mo_symmetric_fillet_create_metadata"
			"mo_symmetric_fillet_create_history"
	)
)

(ui-function "mp_buildsurf_vsrskin"
	(list 'command				"SkinTool")
	(list 'label_string        	'mp_vsrskin_str)
	(list 'attribute_string   	'mp_vsrskin_attr_str)
    (list 'option_function      "SkinToolControlBox")
    (list 'symbols
          'mo_vsrskin_proportional_crown
          'mo_vsrskin_proportional_crown_val
          'mo_vsrskin_proportional_crown_shape
          'mo_vsrskin_proportional_crown_bias
          'mo_vsrskin_proportional_crown_flip
          'mo_vsrskin_multi_srf
          'mo_vsrskin_create_bezier
          'mo_vsrskin_explicit_control
          'mo_vsrskin_degree_u
          'mo_vsrskin_degree_v
          'mo_vsrskin_spans_u
          'mo_vsrskin_spans_v
          'mo_vsrskin_rel_len_tol'
          'mo_vsrskin_tolerance
          'mo_vsrskin_topology
          'mo_vsrskin_flow_ctrl_begin
          'mo_vsrskin_flow_ctrl_end
          'mo_vsrskin_trim
          'mo_vsrskin_history
          'mo_vsrskin_metadata
          'mo_vsrskin_auto_recalc
          'mo_vsrskin_chain_select
          'mo_vsrskin_in_canvas
          'mo_vsrskin_deviation
		  'mo_vsrskin_continuity_check
	)
)

(ui-function "mp_buildsurf_profile"
	(list 'command				"Profile")
	(list 'label_string			'mp_profile_str)
	(list 'attribute_string		'mp_profile_attr_str)
	(list 'option_function		"ProfileControlBox")
	(list 'symbols
			"mo_profile_target"
			"mo_profile_use_point"
			"mo_profile_profile_orientation"
			"mo_profile_orientation"
			"mo_profile_frame_travel"
			"mo_profile_scaling"
			"mo_profile_param"
			"mo_profile_frame_name"
			"mo_profile_frame_presets"
			"mo_profile_frame_refresh"
			"mo_profile_frame_save"

			"mo_profile_plane_name"
			"mo_profile_plane_presets"
			"mo_profile_plane_refresh"
			"mo_profile_plane_save"

			"mo_profile_surface_location"
			"mo_profile_transition_type"

			"mo_profile_surface_type"
			"mo_profile_single_span"
			"mo_profile_explicit_control"
			"mo_profile_u_degree"
			"mo_profile_v_degree"
			"mo_profile_max_num_spans"
			"mo_profile_short_edge_tol"
			"mo_profile_match_parameterization"

			"mo_profile_modify_range"
			"mo_profile_range_start"
			"mo_profile_range_end"
			"mo_profile_target_start"
			"mo_profile_target_end"

			"mo_profile_preview"
			"mo_profile_preview_param"

			"mo_profile_auto_recalc"
			"mo_profile_pick_chain"
			"mo_profile_create_history"
			"mo_profile_touch_line_type"
            "mo_profile_create_metadata"
			"mo_profile_create_history"
	)
)

(ui-function "mp_buildsurf_autostitch"
	(list 'command				"StitchAndSeam")
	(list 'label_string        	'mp_autostitch_str)
	(list 'attribute_string   	'mp_autostitch_attr_str)
	(list 'option_function		"StitchAndSeamControlBox")
	(list 'symbols
			"mo_auto_stitch_seam_type"
			"mo_auto_stitch_seam_offset"
			"mo_auto_stitch_seam_depth"
			"mo_auto_stitch_seam_shape"
			"mo_auto_stitch_seam_gap"
			"mo_auto_stitch_seam_side"
			"mo_auto_stitch_seam_flip"
			"mo_auto_stitch_want_clip"
			"mo_auto_stitch_clip_start"
			"mo_auto_stitch_clip_end"
			"mo_auto_stitch_want_bulgeA"
			"mo_auto_stitch_want_bulgeB"
			"mo_auto_stitch_bulge_size"
			"mo_auto_stitch_want_grooveA"
			"mo_auto_stitch_want_grooveB"
			"mo_auto_stitch_behave"
			"mo_auto_stitch_groove_size"
			"mo_auto_stitch_want_stitchA"
			"mo_auto_stitch_want_stitchB"
			"mo_auto_stitch_stitch_diameter"
			"mo_auto_stitch_stitch_length"
			"mo_auto_stitch_stitch_spacing"
			"mo_auto_stitch_stitch_angle"
			"mo_auto_stitch_stitch_tautness"
			"mo_auto_stitch_quick_stitch"
			"mo_auto_stitch_trim_stitch"
			"mo_auto_stitch_trim_seam"
			"mo_auto_stitch_start_edge_flow"
			"mo_auto_stitch_interior_flow"
			"mo_auto_stitch_end_edge_flow"
			"mo_auto_stitch_want_jitter"
			"mo_auto_stitch_stitch_jitter"
			"mo_auto_stitch_flip_direction"
			"mo_auto_stitch_flip_stitch"

			"mo_auto_stitch_trim_type"
			"mo_auto_stitch_auto_recalc"
			"mo_auto_stitch_pick_chain"
			"mo_auto_stitch_create_history"
			"mo_auto_stitch_create_metadata"
			"mo_auto_stitch_debug_geometry"
	)
)

(ui-function "mp_buildsurf_quicksurface"
	(list 'command				"SurfaceFromMesh")
	(list 'label_string        	'mp_quicksurface_str)
	(list 'attribute_string   	'mp_quicksurface_attr_str)
	(list 'option_function		"SurfaceFromMeshControlBox")
	(list 'symbols
			"mo_quicksrf_creationmode"
			"mo_quicksrf_u_degree"
			"mo_quicksrf_v_degree"
			"mo_quicksrf_smooth"
			"mo_quicksrf_smoothfactor"
			"mo_quicksrf_selectionmode"
			"mo_quicksrf_normalangle"
			"mo_quicksrf_minradiuslimit"
			"mo_quicksrf_pickradius"
			"mo_quicksrf_pickvisible"
			"mo_quicksrf_autoupdate"
			"mo_quicksrf_history"
            "mo_quicksrf_create_metadata"
			"mo_quicksrf_deviation"
			"mo_quicksrf_deviationscale"
			"mo_quicksrf_deviationsamples"
			"mo_quicksrf_deviationswapuv"
	)
)

(ui-function "mp_buildsurf_multiblend"
	(list 'command				"MultiBlend")
	(list 'label_string        	"mp_multiblend_str")
	(list 'attribute_string   	"mp_multiblend_attr_str")
	(list 'option_function		"MultiBlendControlBox")
	(list 'symbols
			"mo_multiblend_chain_select"
			"mo_multiblend_auto_update"
			"mo_multiblend_create_history"
			"mo_multiblend_debug_geometry"
			"mo_multiblend_check_deviation"
			"mo_multiblend_use_star_point"
			"mo_multiblend_star_point_type"
			"mo_multiblend_split_type"
			"mo_multiblend_udegree"
			"mo_multiblend_vdegree"
			"mo_multiblend_cross_variation"
			"mo_multiblend_seam_continuity"
			"mo_multiblend_edge_continuity"
			"mo_multiblend_single_surface"
			"mo_multiblend_inner_curvature_continuity"
			"mo_multiblend_shape_factor"
			"mo_multiblend_tolG0"
			"mo_multiblend_tolG1"
	)
)

(ui-function "mp_buildsurf_surfaceoffset"
	(list 'command          "SurfaceOffsetTool")
	(list 'label_string     'mp_srf_offset_str)
	(list 'attribute_string 'mp_srf_offset_attr_str)
	(list 'option_function  "SurfaceOffsetToolControlBox")
	(list 'symbols
			'mo_surface_offset_mode
			'mo_surface_offset_offset
			'mo_surface_offset_degree_definition
			'mo_surface_offset_fix_degree_u
			'mo_surface_offset_fix_degree_v
			'mo_surface_offset_min_degree
			'mo_surface_offset_span_definition
			'mo_surface_offset_fix_spans_u
			'mo_surface_offset_fix_spans_v
			'mo_surface_offset_max_spans
			'mo_surface_offset_short_edge_tolerance
			'mo_surface_offset_deviation_tolerance
			'mo_surface_offset_edge_accuracy
			'mo_surface_offset_face_cropping
			'mo_surface_offset_keep_continuity
			'mo_surface_offset_max_continuity
			'mo_surface_offset_check_continuity
			'mo_surface_offset_show_deviation
			'mo_surface_offset_both
			'mo_surface_offset_interlink
			'mo_surface_offset_history
			'mo_surface_offset_auto_recalc
			'mo_surface_offset_create_metadata
	)
)
