;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Scheme file for blend curves

(ui-symbol "mo_blend_crv_can_planarize" #f)
(ui-symbol "mo_blend_crv_can_dissociate" #f)
(ui-symbol "mo_blend_crv_can_switch_master_slave" #f)
(ui-symbol "mo_blend_crv_can_toggle_loc" #f)
(ui-symbol "mo_blend_crv_can_toggle_xyz" #f)
(ui-symbol "mo_blend_crv_can_toggle_geom" #f)
(ui-symbol "mo_blend_crv_pt_has_continuity" #f)
(ui-symbol "mo_blend_crv_pt_has_direction" #f)
(ui-symbol "mo_blend_crv_pt_has_curvature" #f)
(ui-symbol "mo_blend_crv_curve_selected" #f)

; This function goes into the palette - it opens the blend curve toolbox
(ui-function "mp_blend_crv_toolbox"
	(list 'command				"BlendCurveToolbox")
	(list 'label_string 		"Blend Curve Toolbox")
	(list 'attribute_string     "blend")
)

(ui-function "mp_blend_crv_create"
	(list 'command				"BlendCurve")
	(list 'label_string 		"blend curve create")
	(list 'attribute_string     "new")
	(list 'option_editor 		"Modeling/mo_blend_curve_options.o.scm"
								'blend_curve.options)
)

(ui-function "mp_blend_crv_edit"
	(list 'command				"BlendCurveAddPoints")
	(list 'attribute_string     "pt add")
	(list 'label_string 		"blend curve add points")
)

(ui-function "mp_blend_crv_edit_tangent"
	(list 'command              "BlendCurveEditTangent")
	(list 'attribute_string     "edit")
	(list 'label_string 		"blend curve edit")
)

(ui-function "mp_blend_crv_planarize"
	(list 'active (ui-eq "mo_blend_crv_can_planarize" #t))
	(list 'command				"BlendCurvePlanarize")
	(list 'attribute_string     "planariz")
	(list 'label_string 		"blend curve planarize")
)

(ui-function "mp_blend_crv_pt_dissociate"
	(list 'active (ui-eq "mo_blend_crv_can_dissociate" #t))
    (list 'command              "BlendCurvePtDissociate")
	(list 'label_string         "blend constraint dissociate")
	(list 'attribute_string     "detach")
)

(ui-function "mp_blend_crv_pt_make_master"
	(list 'active (ui-eq "mo_blend_crv_can_switch_master_slave" #t))
    (list 'command              "BlendCurveMakeMaster")
	(list 'label_string         "blend pt make master")
	(list 'attribute_string     "mk mstr")
)

(ui-function "mp_blend_crv_toggle_loc"
	(list 'active (ui-eq "mo_blend_crv_can_toggle_loc" #t))
    (list 'command              "BlendCurveToggleLoc")
	(list 'label_string         "blend constraint interp location")
	(list 'attribute_string     "pt loc")
)

(ui-function "mp_blend_crv_toggle_xyz"
	(list 'active (ui-eq "mo_blend_crv_can_toggle_xyz" #t))
    (list 'command              "BlendCurveToggleXYZ")
	(list 'label_string         "blend constraint interp direction")
	(list 'attribute_string     "pt xyz")
)

(ui-function "mp_blend_crv_toggle_geom"
	(list 'active (ui-eq "mo_blend_crv_can_toggle_geom" #t))
    (list 'command              "BlendCurveToggleGeom")
	(list 'label_string         "blend constraint interp geometry")
	(list 'attribute_string     "pt geom")
)

(ui-function "mp_blend_crv_G0"
	(list 'active (ui-eq "mo_blend_crv_pt_has_continuity" #t))
    (list 'command              "BlendCurveG0")
	(list 'label_string         "blend constraint G0")
	(list 'attribute_string     "pt G0")
)

(ui-function "mp_blend_crv_G1"
	(list 'active (ui-eq "mo_blend_crv_pt_has_continuity" #t))
    (list 'command              "BlendCurveG1")
	(list 'label_string         "blend constraint G1")
	(list 'attribute_string     "pt G1")
)

(ui-function "mp_blend_crv_G2"
	(list 'active (ui-eq "mo_blend_crv_pt_has_continuity" #t))
    (list 'command              "BlendCurveG2")
	(list 'label_string         "blend constraint G2")
	(list 'attribute_string     "pt G2")
)

(ui-function "mp_blend_crv_G3"
	(list 'active (ui-eq "mo_blend_crv_pt_has_continuity" #t))
    (list 'command              "BlendCurveG3")
	(list 'label_string         "blend constraint G3")
	(list 'attribute_string     "pt G3")
)

(ui-function "mp_blend_crv_G4"
	(list 'active (ui-eq "mo_blend_crv_pt_has_continuity" #t))
    (list 'command              "BlendCurveG4")
	(list 'label_string         "blend constraint G4")
	(list 'attribute_string     "pt G4")
)

(ui-function "mp_blend_crv_direction_ray"
	(list 'active (ui-eq "mo_blend_crv_pt_has_direction" #t))
    (list 'command              "BlendCurveDirectionRay")
	(list 'label_string         "blend constraint directed")
	(list 'attribute_string     "pt ray")
)

(ui-function "mp_blend_crv_direction_parallel"
	(list 'active (ui-eq "mo_blend_crv_pt_has_direction" #t))
    (list 'command              "BlendCurveDirectionParallel")
	(list 'label_string         "blend constraint parallel")
	(list 'attribute_string     "parallel")
)

(ui-function "mp_blend_crv_direction_parametric"
	(list 'active (ui-eq "mo_blend_crv_pt_has_curvature" #t))
    (list 'command              "BlendCurveDirectionParametric")
	(list 'label_string         "blend constraint parametric curvature")
	(list 'attribute_string     "param")
)

(ui-function "mp_blend_crv_direction_geometric"
	(list 'active (ui-eq "mo_blend_crv_pt_has_curvature" #t))
    (list 'command              "BlendCurveDirectionGeometric")
	(list 'label_string         "blend constraint geometric curvature")
	(list 'attribute_string     "geomet")
)

(ui-function "mp_blend_crv_degree_1"
	(list 'active (ui-eq "mo_blend_crv_curve_selected" #t))
    (list 'command              "BlendCurveDegree1")
	(list 'label_string         "blend curve degree 1")
	(list 'attribute_string     "deg 1")
)

(ui-function "mp_blend_crv_degree_2"
	(list 'active (ui-eq "mo_blend_crv_curve_selected" #t))
    (list 'command              "BlendCurveDegree2")
	(list 'label_string         "blend curve degree 2")
	(list 'attribute_string     "deg 2")
)

(ui-function "mp_blend_crv_degree_3"
	(list 'active (ui-eq "mo_blend_crv_curve_selected" #t))
    (list 'command              "BlendCurveDegree3")
	(list 'label_string         "blend curve degree 3")
	(list 'attribute_string     "deg 3")
)

(ui-function "mp_blend_crv_degree_5"
	(list 'active (ui-eq "mo_blend_crv_curve_selected" #t))
    (list 'command              "BlendCurveDegree5")
	(list 'label_string         "blend curve degree 5")
	(list 'attribute_string     "deg 5")
)

(ui-function "mp_blend_crv_degree_7"
	(list 'active (ui-eq "mo_blend_crv_curve_selected" #t))
    (list 'command              "BlendCurveDegree7")
	(list 'label_string         "blend curve degree 7")
	(list 'attribute_string     "deg 7")
)

(ui-function "mp_blend_crv_param_uniform"
	(list 'active (ui-eq "mo_blend_crv_curve_selected" #t))
    (list 'command              "BlendCurveUniform")
	(list 'label_string         "blend curve uniform")
	(list 'attribute_string     "uniform")
)

(ui-function "mp_blend_crv_param_chord"
	(list 'active (ui-eq "mo_blend_crv_curve_selected" #t))
    (list 'command              "BlendCurveChord")
	(list 'label_string         "blend curve chord")
	(list 'attribute_string     "chord")
)


