;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Anti-Alias Shaded Option Box
;;;

(ui-string "mw_antialias_surfaces.name"		 "Shaded Anti-Alias Options")
(ui-string "mo_antialias_quality"			    "Software Anti-Alias")
(ui-string "mo_antialias_samples"			    "Samples")
(ui-string "mo_antialias_radius"			       "Pixel Sample Radius")
(ui-string "mo_antialias_supersample"       "Supersampling")

(ui-string "mw_antialias_surfaces.quality.off"             "Off")
(ui-string "mw_antialias_surfaces.quality.low"             "Low")
(ui-string "mw_antialias_surfaces.quality.medium"          "Medium")
(ui-string "mw_antialias_surfaces.quality.high"            "High")
(ui-string "mw_antialias_surfaces.quality.userdefined"     "User defined")

(ui-string "mw_antialias_surfaces.hwquality.4x"               "4x")
(ui-string "mw_antialias_surfaces.hwquality.8x"               "8x")
(ui-string "mw_antialias_surfaces.hwquality.16x"              "16x")
(ui-string "mw_antialias_surfaces.hwquality.off"              "Off")


(ui-string 'ALIAS_SHADED_ANTIALIASING 						"Hardware Anti-Alias" )

(ui-editor "mw_antialias_surfaces.options"        

	(list 'title 'mw_antialias_surfaces.name)

    (list 'symbols 'mo_antialias_quality 'mo_antialias_samples 'mo_antialias_radius 'mo_antialias_is_surface_on 'mo_antialias_supersample )

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(list 'go_option_function "AntiAliasSurfacesGoButton" )

	(ui-popup-widget "mo_antialias_quality"
								(list 'rebuild #t)
                                (ui-choice "mw_antialias_surfaces.quality.off" 4)
                                (ui-choice "mw_antialias_surfaces.quality.low" 1)
                                (ui-choice "mw_antialias_surfaces.quality.medium" 2)
                                (ui-choice "mw_antialias_surfaces.quality.high" 3)
                                (ui-choice "mw_antialias_surfaces.quality.userdefined" 0)
    )

	(ui-popup-widget "mo_antialias_samples"
								(list 'enabled (ui-eq "mo_antialias_quality" 0))
                                (ui-choice "4" 4)
                                (ui-choice "9" 9)
                                (ui-choice "16" 16)
                                (ui-choice "25" 25)
                                (ui-choice "36" 36)
    )
    
	(ui-double-widget "mo_antialias_radius"
								(list 'enabled (ui-eq "mo_antialias_quality" 0))
								(list 'precision "%8.5")
								(list 'range 0.01 2.0)
								(list 'slider_range 0.01 2.0)
    )

	(ui-blank-widget)
	
	(ui-separator-widget)

    (ui-tick-widget "mo_antialias_supersample")

	(ui-popup-widget "ALIAS_SHADED_ANTIALIASING"
	                     (list 'rebuild #t)
								(ui-choice "mw_antialias_surfaces.hwquality.off" 0)
								(ui-choice "mw_antialias_surfaces.hwquality.4x"  1)
								(ui-choice "mw_antialias_surfaces.hwquality.8x"  2)
								(ui-choice "mw_antialias_surfaces.hwquality.16x" 3)
	)
)
