;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Anti-Alias Wireframe Option Box
;;;

(ui-string "mw_antialias_lines.name"					 "Wireframe Anti-Alias Options")

(ui-string "mo_antialias_single_line_width"				 "Single Line Width")
(ui-string "mo_antialias_double_line_width"				 "Double Line Width")
(ui-string "mo_antialias_force_smooth_lines"			 "Force Smooth Mode")

(ui-string "mw_antialias_lines.hwquality.4x"               "4x")
(ui-string "mw_antialias_lines.hwquality.8x"               "8x")
(ui-string "mw_antialias_lines.hwquality.16x"              "16x")
(ui-string "mw_antialias_lines.hwquality.off"              "Off")


(ui-string 'ALIAS_ANTIALIASING 						"Hardware Anti-Alias" )

(ui-editor "mw_antialias_lines.options"        

	(list 'title 'mw_antialias_lines.name)

    (list 'symbols 'mo_antialias_single_line_width 'mo_antialias_double_line_width 'mo_antialias_is_line_on 'mo_antialias_force_smooth_lines )

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(list 'go_option_function "AntiAliasLinesGoButton" )

	(ui-double-widget "mo_antialias_single_line_width"
										(list 'precision "%8.5")
										(list 'range 0.01 2.0)
										(list 'slider_range 0.01 2.0)
	)
    
	(ui-double-widget "mo_antialias_double_line_width"
										(list 'precision "%8.5")
										(list 'range 0.01 2.0)
										(list 'slider_range 0.01 2.0)
	)

	(ui-blank-widget)
			
	(ui-separator-widget)

	
    (ui-popup-widget "ALIAS_ANTIALIASING"
                     (list 'rebuild #t)
                            (ui-choice "mw_antialias_lines.hwquality.off" 0)
                            (ui-choice "mw_antialias_lines.hwquality.4x"  1)
                            (ui-choice "mw_antialias_lines.hwquality.8x"  2)
                            (ui-choice "mw_antialias_lines.hwquality.16x" 3)
    )

	(ui-blank-widget)

    (ui-tick-widget "mo_antialias_force_smooth_lines"
        (list 'enabled ( ui-ne "ALIAS_ANTIALIASING" 0 ) )
    )

    (ui-group-widget
        (list 'title "Restarting the application is required before your changes take effect" )
        (list 'enabled (ui-ne "mo_antialias_surface_showRestartMsg" 'ALIAS_ANTIALIASING) )
    )

	
)
