;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Add IK Handle Options
;;;

(ui-string "addikhandle.name"			"Add IK Handle Options")
(ui-string "mo_addikhandle_solver"		"Solver")
(ui-string "mo_addikhandle_control"		"Control Type")
(ui-string "mo_addikhandle_plane_ctrl"	"Orientation")
(ui-string "mo_addikhandle_weight_type" "Weight Type")
(ui-string "mo_addikhandle_weight"		"Weight")
(ui-string "mo_addikhandle_goal"		"Goal Type")

(ui-string "addikhandle.solver.multi"		"Multi-handle")
(ui-string "addikhandle.solver.single"		"Single-chain")
(ui-string "addikhandle.solver.spline"		"Spline-handle")

(ui-string "addikhandle.goal.position"      "Position")
(ui-string "addikhandle.goal.orient"        "Orientation")
(ui-string "addikhandle.goal.both"          "Both")

(ui-string "mo_addikhandle_create_ee"		"Create end-effector")
(ui-string "addikhandle.weight.sticky"   	"Sticky")
(ui-string "addikhandle.weight.lo"       	"Low")
(ui-string "addikhandle.weight.med"      	"Medium")
(ui-string "addikhandle.weight.hi"       	"High")	

(ui-string "mo_addikhandle_set_rest"		"Set Rest Pose")
(ui-string "addikhandle.control.trans"  	"Translation")	
(ui-string "addikhandle.control.plane"  	"Plane Rotation")	
(ui-string "addikhandle.control.plane_pole"	"Plane and Pole")	
(ui-string "addikhandle.planectrl.local"	"Local")	
(ui-string "addikhandle.planectrl.world"	"World")	

(ui-string "mo_addsphandle_pos_type"		"Position Type")
(ui-string "mo_addsphandle_twst_type"		"Twist Type")
(ui-string "mo_addsphandle_twist_root"		"Twist Root")
(ui-string "mo_addsphandle_plus_rhandle"	"Create Root Handle")
(ui-string "mo_addsphandle_create_curve"	"Create Curve")
(ui-string "mo_addsphandle_snap_curve"		"Snap Curve to Root")

(ui-string "addsphandle.pos.param"			"Parameter")	
(ui-string "addsphandle.pos.arc"			"Arc-length")	
(ui-string "addsphandle.twst.linear"		"Linear")	
(ui-string "addsphandle.twst.fosi"			"Fast Out Slow In")	
(ui-string "addsphandle.twst.sofi"			"Slow Out Fast In")	
(ui-string "addsphandle.twst.eoei"			"Ease Out Ease In")	

(ui-editor "add_ik_handle.options"         
	
	(list 'title 'addikhandle.name)

	(list 'symbols	'mo_addikhandle_solver		'mo_addikhandle_weight_type
					'mo_addikhandle_weight  	'mo_addikhandle_create_ee
					'mo_addikhandle_control		'mo_addsphandle_pos_type
					'mo_addsphandle_twst_type	'mo_addsphandle_plus_rhandle
					'mo_addsphandle_snap_curve
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)
	(list 'height	480)

	(ui-radio-widget	"mo_addikhandle_solver"
		(list 'rebuild   #t)
		(ui-choice	"addikhandle.solver.multi"	'MO_ADD_IKHANDLE_MULTI)
		(ui-choice	"addikhandle.solver.single"	'MO_ADD_IKHANDLE_SINGLE)
		(ui-choice	"addikhandle.solver.spline"	'MO_ADD_IKHANDLE_SPLINE)
	)

	(ui-separator-widget)

	(ui-radio-widget "mo_addsphandle_pos_type"
		(list 'enabled (ui-eq "mo_addikhandle_solver" 'MO_ADD_IKHANDLE_SPLINE))
		(ui-choice "addsphandle.pos.param"	'MO_ADDSP_POS_PARAM)
		(ui-choice "addsphandle.pos.arc"	'MO_ADDSP_POS_ARC)
	)

	(ui-popup-widget "mo_addsphandle_twst_type"
		(list 'enabled (ui-eq "mo_addikhandle_solver" 'MO_ADD_IKHANDLE_SPLINE))
		(ui-choice "addsphandle.twst.linear"	'MO_ADDSP_TWST_LINEAR)
		(ui-choice "addsphandle.twst.fosi"		'MO_ADDSP_TWST_FOSI)
		(ui-choice "addsphandle.twst.sofi"		'MO_ADDSP_TWST_SOFI)
		(ui-choice "addsphandle.twst.eoei"		'MO_ADDSP_TWST_EOEI)
	)

	(ui-tick-widget "mo_addsphandle_twist_root"
		(list 'enabled (ui-eq "mo_addikhandle_solver" 'MO_ADD_IKHANDLE_SPLINE))
	)

	(ui-tick-widget "mo_addsphandle_plus_rhandle"
		(list 'enabled (ui-eq "mo_addikhandle_solver" 'MO_ADD_IKHANDLE_SPLINE))
	)

	(ui-separator-widget
		(list 'enabled (ui-eq "mo_addikhandle_solver" 'MO_ADD_IKHANDLE_SPLINE))
	)

	(ui-tick-widget "mo_addsphandle_create_curve"
		(list 'enabled (ui-eq "mo_addikhandle_solver" 'MO_ADD_IKHANDLE_SPLINE))
		(list "rebuild" #t)
	)

	(ui-tick-widget "mo_addsphandle_snap_curve"
		(list 'enabled (ui-and 
						(ui-eq "mo_addikhandle_solver" 'MO_ADD_IKHANDLE_SPLINE)
						(ui-eq "mo_addsphandle_create_curve" #f)
					   )
	    )
	)

	(ui-radio-widget "mo_addikhandle_control"
		(list 'enabled (ui-eq "mo_addikhandle_solver" 'MO_ADD_IKHANDLE_SINGLE))
		(ui-choice "addikhandle.control.trans"		'MO_ADDIK_CONTROL_TRANS)
		(ui-choice "addikhandle.control.plane"		'MO_ADDIK_CONTROL_PLANE)
		(ui-choice "addikhandle.control.plane_pole"	'MO_ADDIK_CONTROL_PLANE_POLE
		)
	)

	(ui-radio-widget "mo_addikhandle_plane_ctrl"
		(list 'enabled (ui-eq "mo_addikhandle_solver" 'MO_ADD_IKHANDLE_SINGLE))
		(ui-choice "addikhandle.planectrl.local"	'MO_ADDIK_LOCAL_PLANE)
		(ui-choice "addikhandle.planectrl.world"	'MO_ADDIK_WORLD_PLANE)
	)

	(ui-separator-widget
		(list 'enabled (ui-eq "mo_addikhandle_solver" 'MO_ADD_IKHANDLE_SINGLE))
	)

	(ui-tick-widget "mo_addikhandle_set_rest"
		(list 'enabled (ui-eq "mo_addikhandle_solver" 'MO_ADD_IKHANDLE_SINGLE))
	)

	(ui-radio-widget "mo_addikhandle_weight_type" 
		(list 'rebuild #t)
		(list 'enabled   (ui-eq "mo_addikhandle_solver" 'MO_ADD_IKHANDLE_MULTI))
		(ui-choice "addikhandle.weight.sticky" 'MO_IK_WEIGHT_STICKY
			(list 'assign 'mo_addikhandle_weight			2.0)
		)
		(ui-choice "addikhandle.weight.lo" 'MO_IK_WEIGHT_SOFT
			(list 'assign 'mo_addikhandle_weight			5.0)
		)
		(ui-choice "addikhandle.weight.med" 'MO_IK_WEIGHT_MEDIUM
			(list 'assign 'mo_addikhandle_weight			10.0)
		)
		(ui-choice "addikhandle.weight.hi" 'MO_IK_WEIGHT_HARD
			(list 'assign 'mo_addikhandle_weight			50.0)
		)
	)

	(ui-double-widget	"mo_addikhandle_weight"	
		(list 'enabled   (ui-eq "mo_addikhandle_solver" 'MO_ADD_IKHANDLE_MULTI))
		(list 'precision "%f6.2")
		(list 'range 	 0.0 100.0)
	)

	(ui-separator-widget
		(list 'enabled 	 (ui-eq "mo_addikhandle_solver" 'MO_ADD_IKHANDLE_MULTI))
	)

	(ui-radio-widget    "mo_addikhandle_goal"
		(list 'enabled 	 (ui-eq "mo_addikhandle_solver" 'MO_ADD_IKHANDLE_MULTI))
		; (list 'rebuild   #t)
		(ui-choice "addikhandle.goal.position"  'MO_ADD_IKHANDLE_POSITION)
		(ui-choice "addikhandle.goal.orient"    'MO_ADD_IKHANDLE_ORIENT)
		(ui-choice "addikhandle.goal.both"      'MO_ADD_IKHANDLE_BOTH)
	)

	(ui-tick-widget	"mo_addikhandle_create_ee"
		(list 'enabled (ui-eq "mo_addikhandle_solver" 'MO_ADD_IKHANDLE_MULTI))
	)
)
