;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;---------------------------------------------------------
; Load all the .p.scm files that contain the function definitions
;;---------------------------------------------------------

	(ui-load "Modeling/al_functionNames.m.scm" )

	(if ( ui-symbol-true "studioviewer_menus_active" )
	  	(ui-load "Modeling/mo_studioviewer_file_menu.p.scm"))

	(ui-load "Modeling/al_functionDefinitions.m.scm" )

	(if ( ui-symbol-true "studioviewer_menus_active" )
	  	(ui-load "Modeling/mo_studioviewer_spacers.p.scm"))


(ui-menu-level "al_winMenu"             
	(list 'keepDims #f )
	(list 'title "ViewMenu")
	(list 'layout 'UI_MENU_LAYOUT )
	(list 'style 'UI_MENU_STYLE )
	(list 'container "Alias:viewmenu" )
	(list 'context "alias_window" )
)

(ui-menu-level "al_bookmarks"             
	(list 'keepDims #t )
	(list 'title "Variants")
	(list 'layout 'UI_SHELF_LAYOUT )
	(list 'style 'UI_SHELF_STYLE )
	(list 'context "alias_window" )
	(list 'trashcan 'FALSE )
;   Please do not remove this comment. If you uncomment
;   the line below,  it will embed the bookmarks inside
;   the shelf. However, there are still unresolved issues
;   around embedding that prevents inclusion of this 
;   functionality at this time. Please discuss with Anu or Bob.
;	(list 'container "Alias:bookmarks" )
	(list 'savable #f )
	(list 'tabs #t )
	(list 'allowMultipleSelect #t )

) (ui-level-state "al_bookmarks" 0 60 400 200 0
	(list 'layout 'UI_SHELF_LAYOUT )
	(list "al_bkdefault" "opened" )

)

(ui-function "al_productization_report"
    (list 'command				"ProductizationReport")
    (list 'label_string		"Productization Report")
    (list 'option_editor 	
        "Comlib/ma_prodreport.o.scm"
        'prodrep.options )
)

(ui-menu-level "al_menu_bar"            
	(list 'keepDims #t )
	(list 'title "Menu")
	(list 'layout 'UI_MENU_LAYOUT )
	(list 'style 'UI_MENU_STYLE )
	(list 'container "Alias" )
	(list 'context "alias_window" )
)(ui-level-state "al_menu_bar" 3 4 1589 1058 1 )

(ui-menu-level "al_action_menu_bar"            
	(list 'keepDims #t )
	(list 'title "action menu")
	(list 'layout 'UI_MENU_LAYOUT )
	(list 'style 'UI_MENU_STYLE )
	(list 'container "ae_windows" )
	(list 'context "action_window" )
)

(ui-menu-level "al_reference_menu_bar"            
	(list 'keepDims #t )
	(list 'title "Reference Menu")
	(list 'layout 'UI_MENU_LAYOUT )
	(list 'style 'UI_MENU_STYLE )
	(list 'container "ReferenceManager:menu_region_child" )
	(list 'context "alias_window" )
)

(ui-menu-level "xsec_menu_bar"            
	(list 'keepDims #t )
	(list 'title "Cross Section Menu")
	(list 'layout 'UI_MENU_LAYOUT )
	(list 'style 'UI_MENU_STYLE )
	(list 'container "CrossSectionManager:menu_region" )
	(list 'context "alias_window" )
)

(ui-menu-level "al_historyviz_menu_bar"            
	(list 'keepDims #t )
	(list 'title "History Visualizer Menu")
	(list 'layout 'UI_MENU_LAYOUT )
	(list 'style 'UI_MENU_STYLE )
	(list 'container "HistoryVisualizer:menu_region_child" )
	(list 'context "alias_window" )
)

(ui-menu-level "al_toolbox"             
	(list 'keepDims #t )
	(list 'title "Palette")
	(list 'layout 'UI_TBOX_LAYOUT )
	(list 'style 'UI_TBOX_STYLE )
	(list 'context "alias_window" )

	(if ( ui-symbol-true "studioviewer_menus_active" )
		(list 'container "Alias:palette" ))

) (ui-level-state "al_toolbox" 0 0 150 1172 1	)

(ui-menu-level "al_mmshelf"             
	(list 'keepDims #t )
	(list 'title "Default Marking Menus")
	(list 'layout 'UI_SHELF_LAYOUT )
	(list 'style 'UI_SHELF_STYLE )
	(list 'markingmenus #t )
) (ui-level-state "al_mmshelf" 354 694 872 124 1	)


(ui-menu-level "al_toolshelf"             
	(list 'keepDims #t )
	(list 'title "Default Shelves")
	(list 'layout 'UI_SHELF_LAYOUT )
	(list 'style 'UI_SHELF_STYLE )
) (ui-level-state "al_toolshelf" -4 1065 1600 107 1	)

;(ui-menu-level "al_modeling_toolshelf"             
;	(list 'keepDims #t )
;	(list 'title "Modeling Shelves")
;	(list 'layout 'UI_TBOX_LAYOUT )
;	(list 'style 'UI_SHELF_STYLE )
;) (ui-level-state "al_modeling_toolshelf" -4 1065 168 600 1	)
;
;(ui-menu-level "al_paint_toolshelf"             
;	(list 'keepDims #t )
;	(list 'title "Paint Shelves")
;	(list 'layout 'UI_TBOX_LAYOUT )
;	(list 'style 'UI_SHELF_STYLE )
;) (ui-level-state "al_paint_toolshelf" -4 1065 168 600 1	)
;
;(ui-menu-level "al_viz_toolshelf"             
;	(list 'keepDims #t )
;	(list 'title "Vizualize Shelves")
;	(list 'layout 'UI_TBOX_LAYOUT )
;	(list 'style 'UI_SHELF_STYLE )
;) (ui-level-state "al_viz_toolshelf" -4 1065 168 600 1	)

(ui-menu-level "al_aw_mmshelf"             
	(list 'keepDims #t )
	(list 'title "Action Window Marking Menus")
	(list 'layout 'UI_SHELF_LAYOUT )
	(list 'style 'UI_SHELF_STYLE )
	(list 'markingmenus #t )
) (ui-level-state "al_aw_mmshelf" 139 107 561 111 1	)

(ui-menu-level "al_2d_mmshelf"             
	(list 'keepDims #t )
	(list 'title "Paint Marking Menus")
	(list 'layout 'UI_SHELF_LAYOUT )
	(list 'style 'UI_SHELF_STYLE )
	(list 'markingmenus #t )
) (ui-level-state "al_2d_mmshelf" 356 569 859 119 1	
	(list 'levelopened 'FALSE )
	(list 'iconsize 'UI_SMALL_ICON )
)
(ui-menu-level "al_whatsnew_toolbox"             
	(list 'keepDims #t )
	(list 'title "What's New 2021")
	(list 'layout 'UI_SHELF_LAYOUT )
	(list 'style 'UI_TBOX_STYLE )
	;(list 'style 'UI_SHELF_STYLE )
	(list 'context "alias_window" )
) (ui-level-state "al_whatsnew_toolbox" 578 0 1124 101 1
	(list 'levelopened 'FALSE )
	(list 'iconsize 'UI_SMALL_ICON )
)

(ui-menu-level "al_steppershelf"             
	(list 'keepDims #t )
	(list 'title "Command Set")
	(list 'layout 'UI_SHELF_LAYOUT )
	(list 'style 'UI_SHELF_STYLE )
) (ui-level-state "al_steppershelf" 163 143 496 128 1	)

(ui-menu-level "VRML_toolbox"            
	(list 'keepDims #t )
	(list 'title "VRML tools")
	(list 'layout 'UI_TBOX_LAYOUT )
	(list 'style 'UI_TBOX_STYLE )
	(list 'context "alias_window" )
)(ui-level-state "VRML_toolbox" 356 569 859 119 1	)

(ui-menu-level "mo_keypoint_curve_palette"
	(list 'keepDims #t )
	(list 'title "Keypoint Curve Toolbox")
	(list 'layout 'UI_TBOX_LAYOUT )
	(list 'style 'UI_TBOX_STYLE )
) (ui-level-state "mo_keypoint_curve_palette" 139 218 140 300 1 )

(ui-menu-level "mo_curve_networks_palette"            
	(list 'keepDims #t )
	(list 'title "Curve Network Toolbox")
	(list 'layout 'UI_TBOX_LAYOUT )
	(list 'style 'UI_TBOX_STYLE )
) (ui-level-state "mo_curve_networks_palette" 23 198 140 300 1 )

(ui-menu-level "mo_blend_curve_palette"
	(list 'keepDims #t )
	(list 'title "Blend Curve Toolbox")
	(list 'layout 'UI_TBOX_LAYOUT )
	(list 'style 'UI_TBOX_STYLE )
)(ui-level-state "mo_blend_curve_palette" 139 218 140 300 1 )

(ui-menu-level "al_extras_palette"             
	(list 'keepDims #t )
	(list 'title "Shelf Extras")
	(list 'layout 'UI_SHELF_LAYOUT )
	(list 'style 'UI_TBOX_STYLE )
	(list 'context "alias_window" )
	(list 'tabs #f )
) (ui-level-state "al_extras_palette" 601 958 402 68 1 )

(ui-menu-level "al_deformation_toolbox"            
	(list 'keepDims #t )
	(list 'title "Transformer Rig Toolbox")
	(list 'layout 'UI_TBOX_LAYOUT )
	(list 'style 'UI_TBOX_STYLE )
	(list 'context "alias_window" )
)
(ui-level-state "al_deformation_toolbox" 231 787 140 177 1
	(list 'keepDims #t )
	(list 'layout 'UI_TBOX_LAYOUT )
	(list 'levelopened 'FALSE )
	(list 'iconsize 'UI_SMALL_ICON )
)

(ui-string "df_tooltab_str"  "Transformer Rig")
(ui-string "df_tooltab_attr"  "Def tools")

(ui-symbol "df_tooltab" 0 )
(ui-symbol "mo_transformerRig_can_add_target" #f)
(ui-symbol "mo_transformerRig_can_add_modifier" #f)
(ui-symbol "mo_transformerRig_can_add_constraint" #f)
(ui-symbol "mo_transformerRig_can_add_clamp_point" #f)
(ui-symbol "mo_transformerRig_can_revert" #f)
(ui-symbol "mo_transformerRig_can_remove_from_rig" #f)
(ui-symbol "mo_transformerRig_can_use_pick_mask" #f)

(ui-function "al_bugreport_info"
			 (list 'command		    "betaInfo")
			 (list 'label_string	    "Beta Program Info")
			 (list 'attribute_string    "betainfo")
)


(ui-function "mp_deform_toolBox"              
	(list 'command                  "TransformerRigToolbox")
	(list 'label_string             "Transformer Rig")
	(list 'attribute_string         "t-rig")
) 



(ui-function "al_TransformerRig"
	(list 'command			"TransformerRig")
	(list 'label_string			"Transformer Rig")
	(list 'attribute_string		"t-rig")
	(list 'option_function		"TransformerRigControlBox")
 	(list 'symbols		
          'TransformerRig_AutoRecalc
          'TransformerRig_ShowOriginal
          'TransformerRig_ShowBoth
          'TransformerRig_FittingEffort
          'TransformerRig_DrawCorrespondence
          'TransformerRig_DrawStat
          'TransformerRig_Density
          'TransformerRig_ScaleTangent
          'TransformerRig_NurbsWarpMethod
          'TransformerRig_FitBoundary
          'TransformerRig_MinDegreeExplicit
          'TransformerRig_MinDegreeAdaptive
          'TransformerRig_MinSpans
          'TransformerRig_CvShape
          'TransformerRig_MeshOutput
 	)
)

(ui-function "al_TransformerRigFlexible"
	(list 'active	(ui-eq "mo_transformerRig_can_add_target" #t ))
	(list 'command			"TransformerRigFlexible")
	(list 'label_string			"Add Flexible Targets")
	(list 'attribute_string		"flexible")
)

(ui-function "al_TransformerRigRigid"
	(list 'active	(ui-eq "mo_transformerRig_can_add_target" #t ))
	(list 'command			"TransformerRigRigid")
	(list 'label_string			"Add Rigid Targets")
	(list 'attribute_string		"rigid")
)

(ui-function "al_TransformerRigFreeModifier"
	(list 'active	(ui-eq "mo_transformerRig_can_add_modifier" #t ))
	(list 'command			"TransformerRigFreeModifier")
	(list 'label_string			"Add Free Modifiers")
	(list 'attribute_string		"free")
)

(ui-function "al_TransformerRigPreDefinedModifier"
	(list 'active	(ui-eq "mo_transformerRig_can_add_modifier" #t ))
	(list 'command			"TransformerRigPreDefinedModifier")
	(list 'label_string			"Add Predefined Modifiers")
	(list 'attribute_string		"predef")
)

(ui-function "al_TransformerRigConstraint"
	(list 'active	(ui-eq "mo_transformerRig_can_add_constraint" #t ))
	(list 'command			"TransformerRigConstraint")
	(list 'label_string			"Add Constraints")
	(list 'attribute_string		"const")
)

(ui-function "al_TransformerRigClamper"
	(list 'active	(ui-eq "mo_transformerRig_can_add_clamp_point" #t ))
	(list 'command			"TransformerRigClamper")
	(list 'label_string			"Add Clampers")
	(list 'attribute_string		"clamper")
)

(ui-function "al_TransformerRigRemoveFromRig"
	(list 'active	(ui-eq "mo_transformerRig_can_remove_from_rig" #t ))
	(list 'command			"TransformerRigRemoveFromRig")
	(list 'label_string			"Remove From Rig")
	(list 'attribute_string		"remove")
)

(ui-function "al_TransformerRigRevert"
	(list 'active	(ui-eq "mo_transformerRig_can_revert" #t ))
	(list 'command			"TransformerRigRevert")
	(list 'label_string			"Revert")
	(list 'attribute_string		"revert")
)

(ui-function "al_TransformerRigCommit"
	(list 'active	(ui-eq "mo_transformerRig_can_revert" #t ))
	(list 'command			"TransformerRigCommit")
	(list 'label_string			"Commit")
	(list 'attribute_string		"commit")
)

;; -- uncomment the following if you wanted to add activator points in Deformation
;;
;; (ui-function "al_TransformerRigActivator"
;; 	(list 'active	(ui-eq "mo_transformerRig_can_add_clamp_point" #t ))
;; 	(list 'command			"TransformerRigActivator")
;; 	(list 'label_string			"Add Activators")
;; 	(list 'attribute_string		"activator")
;; )
;; (ui-menu-add-entry "df_tooltab" "al_TransformerRigActivator")
;;
;; -- uncomment the above if you wanted to add activator points in Deformation

(ui-function "al_TransformerRigOpenPickMaskCBox"
    (list 'active   (ui-eq "mo_transformerRig_can_use_pick_mask" #t ))
	(list 'command			"TransformerRigOpenPickMaskCBox")
	(list 'label_string			"Show Pick Mask")
	(list 'attribute_string		"pmask")
)

;; Deformation lattice toolbox start ******************************************
;; ****************************************************************************

(ui-string "dfl_tooltab_str"  "Lattice Rig Tools")
(ui-string "dfl_tooltab_attr"  "Lattice")

(ui-symbol "dfl_tooltab" 0 )

(ui-function "mp_deform_lattice_toolBox"              
	(list 'command                  "LatticeRigToolbox")
	(list 'label_string             "Lattice Rig")
	(list 'attribute_string         "lattice")
) 

(ui-menu-level "al_deformation_lattice_toolbox"            
	(list 'keepDims #t )
	(list 'title "Lattice Rig Toolbox")
	(list 'layout 'UI_TBOX_LAYOUT )
	(list 'style 'UI_TBOX_STYLE )
	(list 'context "alias_window" )
)
(ui-level-state "al_deformation_lattice_toolbox" 231 444 140 137 1
    (list 'layout 'UI_TBOX_LAYOUT )
	(list 'levelopened 'FALSE )
	(list 'iconsize 'UI_SMALL_ICON )
)

(ui-symbol "mo_latticeRig_can_split_edge" #f)
(ui-symbol "mo_latticeRig_can_toggle_engage" #f)
(ui-symbol "mo_latticeRig_can_center_pivot" #f)
(ui-symbol "mo_latticeRig_can_pick_nothing" #f)
(ui-symbol "mo_latticeRig_can_add_constraint" #f)
(ui-symbol "mo_latticeRig_can_revert" #f)
(ui-symbol "mo_latticeRig_can_use_pick_mask" #f)

(ui-function "al_LatticeRig"
	(list 'command				"LatticeRig")
	(list 'label_string			"Lattice Rig")
	(list 'attribute_string		"Lattice")
	(list 'option_function		"LatticeRigControlBox")
 	(list 'symbols
          'LatticeRig_ShowOriginal
		  'LatticeRig_ShowBoth
		  'LatticeRig_NurbsWarpMethod
		  'LatticeRig_FitBoundary
		  'LatticeRig_MinDegreeExplicit
		  'LatticeRig_MinDegreeAdaptive
		  'LatticeRig_MinSpans
		  'LatticeRig_FittingEffort
		  'LatticeRig_ScaleTangent
		  'LatticeRig_AutoRecalc
		  'LatticeRig_MeshOutput
 	)
)

(ui-function "al_LatticeRigToggleEngage"
	(list 'active	(ui-eq "mo_latticeRig_can_toggle_engage" #t ))
	(list 'command				"LatticeRigToggleEngage")
	(list 'label_string			"Toggle lattice engage state")
	(list 'attribute_string		"engage")
)

(ui-function "al_LatticeRigSplitEdge"
	(list 'active	(ui-eq "mo_latticeRig_can_split_edge" #t ))
	(list 'command				"LatticeRigSplitEdge")
	(list 'label_string			"Split lattice edge")
	(list 'attribute_string		"split")
)

(ui-function "al_LatticeRigSimplify"
	(list 'active	(ui-eq "mo_latticeRig_can_split_edge" #t ))
	(list 'command				"LatticeRigSimplify")
	(list 'label_string			"Delete lattice edge")
	(list 'attribute_string		"delete")
)

(ui-function "al_LatticeRigCenterPivot"
	(list 'active	(ui-eq "mo_latticeRig_can_center_pivot" #t ))
	(list 'command				"LatticeRigCenterPivot")
	(list 'label_string			"Center lattice pivot")
	(list 'attribute_string		"pivot")
)

(ui-function "al_LatticeRigClearSelection"
	(list 'active	(ui-eq "mo_latticeRig_can_pick_nothing" #t ))
	(list 'command				"LatticeRigClearSelection")
	(list 'label_string			"Lattice clear selection")
	(list 'attribute_string		"clear")
)

(ui-function "al_LatticeRigConstraint"
	(list 'active	(ui-eq "mo_latticeRig_can_add_constraint" #t ))
	(list 'command			"LatticeRigConstraint")
	(list 'label_string			"Add Constraints")
	(list 'attribute_string		"constraint")
)

(ui-function "al_LatticeRigRevert"
	(list 'active	(ui-eq "mo_latticeRig_can_revert" #t ))
	(list 'command			"LatticeRigRevert")
	(list 'label_string			"Revert")
	(list 'attribute_string		"revert")
)

(ui-function "al_LatticeRigCommit"
	(list 'active	(ui-eq "mo_latticeRig_can_revert" #t ))
	(list 'command			"LatticeRigCommit")
	(list 'label_string			"Commit")
	(list 'attribute_string		"commit")
)

(ui-function "al_LatticeRigOpenPickMaskCBox"
    (list 'active   (ui-eq "mo_latticeRig_can_use_pick_mask" #t ))
	(list 'command			"LatticeRigOpenPickMaskCBox")
	(list 'label_string			"Show Pick Mask")
	(list 'attribute_string		"pmask")
)

;; Deformation lattice toolbox end *******************************************

;; Deformation twist toolbox start *******************************************
;; ***************************************************************************

(ui-string "dft_tooltab_str"  "Twist Rig Tools")
(ui-string "dft_tooltab_attr"  "Twist")

(ui-symbol "dft_tooltab" 0 )

(ui-function "mp_deform_twist_toolBox"              
	(list 'command                  "TwistRigToolbox")
	(list 'label_string             "Twist Rig")
	(list 'attribute_string         "twist")
) 

(ui-menu-level "al_deformation_twist_toolbox"            
	(list 'keepDims #t )
	(list 'title "Twist Rig Toolbox")
	(list 'layout 'UI_TBOX_LAYOUT )
	(list 'style 'UI_TBOX_STYLE )
	(list 'context "alias_window" )
)
(ui-level-state "al_deformation_twist_toolbox" 377 833 140 133 1
    (list 'layout 'UI_TBOX_LAYOUT )
	(list 'levelopened 'FALSE )
	(list 'iconsize 'UI_SMALL_ICON )
)

(ui-symbol "mo_twistRig_can_revert" #f)
(ui-symbol "mo_twistRig_can_use_pick_mask" #f)
(ui-symbol "mo_twistRig_has_valid_rig" #f)

(ui-function "al_TwistRig"
	(list 'command				"TwistRig")
	(list 'label_string			"Twist Rig")
	(list 'attribute_string		"Twist")
	(list 'option_function		"TwistRigControlBox")
 	(list 'symbols	
          'TwistRig_ShowOriginal
		  'TwistRig_ShowBoth
		  'TwistRig_NurbsWarpMethod
		  'TwistRig_FitBoundary
		  'TwistRig_MinDegreeExplicit
		  'TwistRig_MinDegreeAdaptive
		  'TwistRig_MinSpans
		  'TwistRig_FittingEffort
		  'TwistRig_AutoRecalc
		  'TwistRig_MeshOutput
		  'TwistRig_ShrinkTrim
 	)
)

(ui-function "al_TwistRigAddAngles"
	(list 'active	(ui-eq "mo_twistRig_has_valid_rig" #t ))
	(list 'command			"TwistRigAddAngles")
	(list 'label_string			"Add Twist Angle")
	(list 'attribute_string		"add")
)

(ui-function "al_TwistRigRemoveAngles"
	(list 'active	(ui-eq "mo_twistRig_has_valid_rig" #t ))
	(list 'command			"TwistRigRemoveAngles")
	(list 'label_string			"Remove Twist Angles")
	(list 'attribute_string		"remove")
)

(ui-function "al_TwistRigChangeAxisOrientation"
	(list 'active	(ui-eq "mo_twistRig_has_valid_rig" #t ))
	(list 'command			"TwistRigChangeAxisOrientation")
	(list 'label_string			"AxisLine")
	(list 'attribute_string		"axisLine")
)

(ui-function "al_TwistRigReferenceOtherTwist"
	(list 'active	(ui-eq "mo_twistRig_has_valid_rig" #t ))
	(list 'command			"TwistRigReferenceOtherTwist")
	(list 'label_string			"RefTwist")
	(list 'attribute_string		"reftwist")
)

(ui-function "al_TwistRigUnrefTwist"
	(list 'active	(ui-eq "mo_twistRig_has_valid_rig" #t ))
	(list 'command			"TwistRigUnrefTwist")
	(list 'label_string			"UnrefTwist")
	(list 'attribute_string		"unreftwist")
)

(ui-function "al_TwistRigRevert"
	(list 'active	(ui-eq "mo_twistRig_can_revert" #t ))
	(list 'command			"TwistRigRevert")
	(list 'label_string			"Revert")
	(list 'attribute_string		"revert")
)

(ui-function "al_TwistRigCommit"
	(list 'active	(ui-eq "mo_twistRig_can_revert" #t ))
	(list 'command			"TwistRigCommit")
	(list 'label_string			"Commit")
	(list 'attribute_string		"commit")
)

(ui-function "al_TwistRigOpenPickMaskCBox"
    (list 'active   (ui-eq "mo_twistRig_can_use_pick_mask" #t ))
	(list 'command			"TwistRigOpenPickMaskCBox")
	(list 'label_string			"Show Pick Mask")
	(list 'attribute_string		"pmask")
)

;; Deformation twist toolbox end *******************************************

;; Deformation bend toolbox start *******************************************
;; ***************************************************************************

(ui-string "dfb_tooltab_str"  "Bend Rig Tools")
(ui-string "dfb_tooltab_attr"  "Bend")

(ui-symbol "dfb_tooltab" 0 )

(ui-function "mp_deform_bend_toolBox"              
	(list 'command                  "BendRigToolbox")
	(list 'label_string             "Bend Rig")
	(list 'attribute_string         "bend")
) 

(ui-menu-level "al_deformation_bend_toolbox"            
	(list 'keepDims #t )
	(list 'title "Bend Rig Toolbox")
	(list 'layout 'UI_TBOX_LAYOUT )
	(list 'style 'UI_TBOX_STYLE )
	(list 'context "alias_window" )
)
(ui-level-state "al_deformation_bend_toolbox" 377 662 140 136 1
    (list 'layout 'UI_TBOX_LAYOUT )
	(list 'levelopened 'FALSE )
	(list 'iconsize 'UI_SMALL_ICON )
)

(ui-symbol "mo_bendRig_can_revert" #f)
(ui-symbol "mo_bendRig_can_use_pick_mask" #f)
(ui-symbol "mo_bendRig_has_valid_rig" #f)

(ui-function "al_BendRig"
	(list 'command				"BendRig")
	(list 'label_string			"Bend Rig")
	(list 'attribute_string		"Bend")
	(list 'option_function		"BendRigControlBox")
 	(list 'symbols		
		  'BendRig_NurbsWarpMethod
		  'BendRig_FitBoundary
		  'BendRig_MinDegreeExplicit
		  'BendRig_MinDegreeAdaptive
		  'BendRig_MinSpans
		  'BendRig_FittingEffort
		  'BendRig_MvcWarp
		  'BendRig_BendScaleToLength
		  'BendRig_AutoRecalc
		  'BendRig_MeshOutput
		  'BendRig_ShrinkTrim
 	)
)

(ui-function "al_BendChangeAxisOrientation"
	(list 'active	(ui-eq "mo_bendRig_has_valid_rig" #t ))
	(list 'command			"BendChangeAxisOrientation")
	(list 'label_string			"AxisLine")
	(list 'attribute_string		"axisLine")
)

(ui-function "al_BendRigRevert"
	(list 'active	(ui-eq "mo_bendRig_can_revert" #t ))
	(list 'command			"BendRigRevert")
	(list 'label_string			"Revert")
	(list 'attribute_string		"revert")
)

(ui-function "al_BendRigCommit"
	(list 'active	(ui-eq "mo_bendRig_can_revert" #t ))
	(list 'command			"BendRigCommit")
	(list 'label_string			"Commit")
	(list 'attribute_string		"commit")
)

(ui-function "al_BendRigOpenPickMaskCBox"
    (list 'active   (ui-eq "mo_bendRig_can_use_pick_mask" #t ))
	(list 'command			"BendRigOpenPickMaskCBox")
	(list 'label_string			"Show Pick Mask")
	(list 'attribute_string		"pmask")
)

;; Deformation bend toolbox end *******************************************

;; Deformation conform toolbox start *******************************************
;; ***************************************************************************

(ui-string "dfc_tooltab_str"  "Conform Rig")
(ui-string "dfc_tooltab_attr"  "Conform")

(ui-symbol "dfc_tooltab" 0 )

(ui-function "mp_deform_conform_toolBox"              
	(list 'command                  "ConformRigToolbox")
	(list 'label_string             "Conform Rig")
	(list 'attribute_string         "cnfrm")
) 

(ui-menu-level "al_deformation_conform_toolbox"            
	(list 'keepDims #t )
	(list 'title "Conform Rig Toolbox")
	(list 'layout 'UI_TBOX_LAYOUT )
	(list 'style 'UI_TBOX_STYLE )
	(list 'context "alias_window" )
)
(ui-level-state "al_deformation_conform_toolbox" 230 615 140 136 1
    (list 'layout 'UI_TBOX_LAYOUT )
	(list 'levelopened 'FALSE )
	(list 'iconsize 'UI_SMALL_ICON )
)

(ui-symbol "mo_conformRig_can_revert" #f)
(ui-symbol "mo_conformRig_can_use_pick_mask" #f)
(ui-symbol "mo_conformRig_has_valid_rig" #f)

(ui-function "al_ConformRig"
	(list 'command				"ConformRig")
	(list 'label_string			"Conform Rig")
	(list 'attribute_string		"Conform")
	(list 'option_function		"ConformRigControlBox")
 	(list 'symbols		
          'ConformRig_NurbsWarpMethod
		  'ConformRig_FitBoundary
		  'ConformRig_MinDegreeExplicit
		  'ConformRig_MinDegreeAdaptive
		  'ConformRig_MinSpans
		  'ConformRig_FittingEffort
		  'ConformRig_Influence
		  'ConformRig_AutoRecalc
		  'ConformRig_MeshOutput
		  'ConformRig_ShrinkTrim
 	)
)

(ui-function "al_ConformRigChangeContactPoint"
	(list 'active	(ui-eq "mo_conformRig_has_valid_rig" #t ))
	(list 'command		    "ConformRigChangeContactPoint")
	(list 'label_string			"Change Contact Point")
	(list 'attribute_string		"contact")
)

(ui-function "al_ConformRigRevert"
	(list 'active	(ui-eq "mo_conformRig_can_revert" #t ))
	(list 'command			"ConformRigRevert")
	(list 'label_string			"Revert")
	(list 'attribute_string		"revert")
)

(ui-function "al_ConformRigCommit"
	(list 'active	(ui-eq "mo_conformRig_can_revert" #t ))
	(list 'command			"ConformRigCommit")
	(list 'label_string			"Commit")
	(list 'attribute_string		"commit")
)

(ui-function "al_ConformRigOpenPickMaskCBox"
    (list 'active   (ui-eq "mo_conformRig_can_use_pick_mask" #t ))
	(list 'command			"ConformRigOpenPickMaskCBox")
	(list 'label_string			"Show Pick Mask")
	(list 'attribute_string		"pmask")
)

;; Deformation conform toolbox end *******************************************

;; Deformation featureSnap toolbox start ***************************************
;; ***************************************************************************

(ui-string "dffs_tooltab_str"  "Feature Snap Tools")
(ui-string "dffs_tooltab_attr"  "FeatureSnap")

(ui-symbol "dffs_tooltab" 0 )

(ui-function "mp_feature_snap_toolBox"              
	(list 'command                  "FeatureSnapToolbox")
	(list 'label_string             "Feature Snap")
	(list 'attribute_string         "featureSnap")
) 

(ui-menu-level "al_feature_snap_toolbox"            
	(list 'keepDims #t )
	(list 'title "Feature Snap Toolbox")
	(list 'layout 'UI_TBOX_LAYOUT )
	(list 'style 'UI_TBOX_STYLE )
	(list 'context "alias_window" )
)
(ui-level-state "al_feature_snap_toolbox" 139 218 140 430 0
    (list 'layout 'UI_TBOX_LAYOUT )
	(list 'levelopened 'FALSE )
	(list 'iconsize 'UI_SMALL_ICON )
)

(ui-symbol "mo_featureSnap_can_revert" #f)
(ui-symbol "mo_featureSnap_can_use_pick_mask" #f)
(ui-symbol "mo_featureSnap_has_valid_rig" #f)

(ui-function "al_FeatureSnap"
	(list 'command				"FeatureSnap")
	(list 'label_string			"Feature Snap")
	(list 'attribute_string		"FeatureSnap")
	(list 'option_function		"FeatureSnapControlBox")
 	(list 'symbols		
          'FeatureSnap_ShowOriginal
          'FeatureSnap_ShowBoth
          'FeatureSnap_MeshOutput
 	)
)

(ui-function "al_FeatureSnapRevert"
	(list 'active	(ui-eq "mo_featureSnap_can_revert" #t ))
	(list 'command			"FeatureSnapRevert")
	(list 'label_string			"Revert")
	(list 'attribute_string		"revert")
)

(ui-function "al_FeatureSnapCommit"
	(list 'active	(ui-eq "mo_featureSnap_can_revert" #t ))
	(list 'command			"FeatureSnapCommit")
	(list 'label_string			"Commit")
	(list 'attribute_string		"commit")
)

(ui-function "al_FeatureSnapPickPNormal"
	(list 'active	(ui-eq "mo_featureSnap_has_valid_rig" #t ))
	(list 'command			"FeatureSnapPickPNormal")
	(list 'label_string			"Pick Prescribed Normal")
	(list 'attribute_string		"+Nrml")
)

(ui-function "al_FeatureSnapClearPNormal"
	(list 'active	(ui-eq "mo_featureSnap_has_valid_rig" #t ))
	(list 'command			"FeatureSnapClearPNormal")
	(list 'label_string			"Clear Prescribed Normal")
	(list 'attribute_string		"-Nrml")
)

(ui-function "al_FeatureSnapOpenPickMaskCBox"
    (list 'active   (ui-eq "mo_featureSnap_can_use_pick_mask" #t ))
	(list 'command			"FeatureSnapOpenPickMaskCBox")
	(list 'label_string			"Show Pick Mask")
	(list 'attribute_string		"pmask")
)

;; Deformation featureSnap toolbox end **********************************

;; Deformation duplicatePlace toolbox start ***************************************
;; ***************************************************************************

(ui-string "dffp_tooltab_str"  "Duplicate Place")
(ui-string "dffp_tooltab_attr"  "DuplicatePlace")

(ui-symbol "dffp_tooltab" 0 )

(ui-function "mp_duplicate_place_toolBox"              
	(list 'command                  "DuplicatePlaceToolbox")
	(list 'label_string             "Duplicate Place Toolbox")
	(list 'attribute_string         "du plc")
) 

(ui-menu-level "al_duplicate_place_toolbox"            
	(list 'keepDims #t )
	(list 'title "Duplicate Place Toolbox")
	(list 'layout 'UI_TBOX_LAYOUT )
	(list 'style 'UI_TBOX_STYLE )
	(list 'context "alias_window" )
)
(ui-level-state "al_duplicate_place_toolbox" 139 218 140 430 0
    (list 'layout 'UI_TBOX_LAYOUT )
	(list 'levelopened 'FALSE )
	(list 'iconsize 'UI_SMALL_ICON )
)

(ui-symbol "mo_duplicatePlace_can_revert" #f)
(ui-symbol "mo_duplicatePlace_can_use_pick_mask" #f)
(ui-symbol "mo_duplicatePlace_has_valid_rig" #f)

(ui-function "al_DuplicatePlace"
	(list 'command				"DuplicatePlace")
	(list 'label_string			"Duplicate place")
	(list 'attribute_string		"du plc")
	(list 'option_function		"DuplicatePlaceControlBox")
 	(list 'symbols		
          'DuplicatePlace_ShowOriginal
          'DuplicatePlace_ShowBoth
          'DuplicatePlace_MeshOutput
 	)
)

(ui-function "al_DuplicatePlaceRevert"
	(list 'active	(ui-eq "mo_duplicatePlace_can_revert" #t ))
	(list 'command			"DuplicatePlaceRevert")
	(list 'label_string			"Revert")
	(list 'attribute_string		"revert")
)

(ui-function "al_DuplicatePlaceCommit"
	(list 'active	(ui-eq "mo_duplicatePlace_can_revert" #t ))
	(list 'command			"DuplicatePlaceCommit")
	(list 'label_string			"Commit")
	(list 'attribute_string		"commit")
)

(ui-function "al_DuplicatePlaceOpenPickMaskCBox"
    (list 'active   (ui-eq "mo_duplicatePlace_can_use_pick_mask" #t ))
	(list 'command			"DuplicatePlaceOpenPickMaskCBox")
	(list 'label_string			"Show pick mask")
	(list 'attribute_string		"pmask")
)

;; Deformation duplicatePlace toolbox end **********************************

	(ui-string	"mp_deformation_sub"			"Dynamic Shape Modeling") 
	(ui-string	"duplicate_place_sub"			"Object Placement") 

    (ui-string "al_mesh_NurbsToMesh_str" "NURBS to Mesh")
    (ui-string "al_mesh_NurbsToMesh_attr_str" "nrbtm")
    (ui-function "al_mesh_NurbsToMesh"
       (list 'command           "NurbsToMesh")
       (list 'label_string      'al_mesh_NurbsToMesh_str)
       (list 'attribute_string  'al_mesh_NurbsToMesh_attr_str)
	   (list 'option_editor 	"Modeling/mo_nurbsToMesh_options.o.scm"
								'nurbsToMesh.options)
    )

    (ui-string "al_mesh_SubdivToMesh_str" "Subdiv to Mesh")
    (ui-string "al_mesh_SubdivToMesh_attr_str" "subdtm")
    (ui-function "al_mesh_SubdivToMesh"
       (list 'command           "SubdivToMesh")
       (list 'label_string      'al_mesh_SubdivToMesh_str)
       (list 'attribute_string  'al_mesh_SubdivToMesh_attr_str)
       (list 'option_editor     "Modeling/mo_subdivToMesh_options.o.scm"
                                'subdivToMesh.options)
    )

    (ui-string "al_mesh_CloudToMesh_str" "Cloud to Mesh")
    (ui-string "al_mesh_CloudToMesh_attr_str" "cldtm")
    (ui-function "al_mesh_CloudToMesh"
       (list 'command           "CloudToMesh")
       (list 'label_string      'al_mesh_CloudToMesh_str)
       (list 'attribute_string  'al_mesh_CloudToMesh_attr_str)
	   (list 'option_editor 	"Modeling/mo_cloudToMesh_options.o.scm"
								'cloudToMesh.options)
    )
    
    (ui-string "al_mesh_DispMapToMesh_str" "Displacement Map to Mesh")
    (ui-string "al_mesh_DispMapToMesh_attr_str" "dsptm")
    (ui-function "al_mesh_DispMapToMesh"
       (list 'command           "DispMapToMesh")
       (list 'label_string      'al_mesh_DispMapToMesh_str)
       (list 'attribute_string  'al_mesh_DispMapToMesh_attr_str)
       (list 'option_editor 	"Modeling/mo_dispMapToMesh_options.o.scm"
								'dispMapToMesh.options)
    )

    (ui-string "al_mesh_MeshSubset_str" "Mesh Subset")
    (ui-string "al_mesh_MeshSubset_attr_str" "msbset")

    (ui-function "al_mesh_MeshSubset"
                 (list 'command			"MeshSubset")
                 (list 'label_string		'al_mesh_MeshSubset_str)
                 (list 'attribute_string		'al_mesh_MeshSubset_attr_str)
				 (list 'option_function      "MeshSubsetControlBox")
			     (list 'symbols
					   'mo_meshSubset_selectionMode
					   'mo_meshSubset_invisible
					   'mo_meshSubset_frontSelectionMode
					   'mo_meshSubset_normalAngle
					   'mo_meshSubset_pickRadius)
				 )

    (ui-string "al_mesh_MeshMerge_str" "Mesh Merge")
    (ui-string "al_mesh_MeshMerge_attr_str" "mmerg")

    (ui-function "al_mesh_MeshMerge"
	   (list 'command			"MeshMerge")
	   (list 'label_string		'al_mesh_MeshMerge_str)
	   (list 'attribute_string		'al_mesh_MeshMerge_attr_str)
    )

    (ui-string "al_mesh_MeshProjectCurve_str" "Mesh Project Curve")
    (ui-string "al_mesh_MeshProjectCurve_attr_str" "mpjcrv")

    (ui-function "al_mesh_MeshProjectCurve"
	   (list 'command			"MeshProjectCurve")
	   (list 'label_string		'al_mesh_MeshProjectCurve_str)
	   (list 'attribute_string		'al_mesh_MeshProjectCurve_attr_str)
    )

    (ui-string "al_mesh_MeshProjectNormal_str" "Mesh Project Normal")
    (ui-string "al_mesh_MeshProjectNormal_attr_str" "mpjnrm")

    (ui-function "al_mesh_MeshProjectNormal"
	   (list 'command			"MeshProjectNormal")
	   (list 'label_string		'al_mesh_MeshProjectNormal_str)
	   (list 'attribute_string		'al_mesh_MeshProjectNormal_attr_str)
    )

    (ui-string "al_mesh_MeshIntersect_str" "Mesh Intersect")
    (ui-string "al_mesh_MeshIntersect_attr_str" "misct")

    (ui-function "al_mesh_MeshIntersect"
	   (list 'command			"MeshIntersect")
	   (list 'label_string		'al_mesh_MeshIntersect_str)
	   (list 'attribute_string		'al_mesh_MeshIntersect_attr_str)
    )

    (ui-string "al_mesh_MeshCollar_str" "Mesh Collar")
    (ui-string "al_mesh_MeshCollar_attr_str" "mcoll")

    (ui-function "al_mesh_MeshCollar"
	   (list 'command			"MeshCollar")
	   (list 'label_string		'al_mesh_MeshCollar_str)
	   (list 'attribute_string		'al_mesh_MeshCollar_attr_str)
       (list 'option_function  "MeshCollarControlBox")
       (list 'symbols
             'mo_mesh_collar_width
             'mo_mesh_collar_spans
             'mo_mesh_collar_periodic
             'mo_mesh_collar_create_history
			 'mo_mesh_collar_auto_update
             'mo_mesh_collar_show_surface_deviation
             'mo_mesh_collar_show_deviation_map
             'mo_mesh_collar_devmap_autoramp)
    )

    (ui-string "al_mesh_MeshCut_str" "Mesh Cut")
    (ui-string "al_mesh_MeshCut_attr_str" "mcut")

    (ui-function "al_mesh_MeshCut"
	   (list 'command			"MeshCut")
	   (list 'label_string		'al_mesh_MeshCut_str)
	   (list 'attribute_string		'al_mesh_MeshCut_attr_str)
	   (list 'option_editor     "Modeling/mo_mesh_cut.o.scm"
			 'mesh.cut.options)

	   (list 'symbols			 'mo_mesh_cut_intersect_history)
    )
    
    (ui-string "al_mesh_MeshOffset_str" "Mesh Offset")
    (ui-string "al_mesh_MeshOffset_attr_str" "moff")

    (ui-function "al_mesh_MeshOffset"
	   (list 'command			"MeshOffset")
	   (list 'label_string		'al_mesh_MeshOffset_str)
	   (list 'attribute_string	'al_mesh_MeshOffset_attr_str)
           (list 'option_function   "MeshOffsetControlBox")
           (list 'symbols
                 'mo_meshOffset_distance
                 'mo_meshOffset_outputType)
    )   
    
    (ui-string "al_mesh_MeshReduce_str" "Mesh Reduce")
    (ui-string "al_mesh_MeshReduce_attr_str" "mredu")

    (ui-function "al_mesh_MeshReduce"
	   (list 'command			"MeshReduce")
	   (list 'label_string		'al_mesh_MeshReduce_str)
	   (list 'attribute_string	'al_mesh_MeshReduce_attr_str)
       (list 'option_function   "MeshReduceControlBox")
       (list 'symbols
             'mo_mesh_reduce_percentage
             'mo_mesh_reduce_mode
			 'mo_mesh_reduce_show_deviation_map
			 'mo_mesh_reduce_devmap_autoramp
			 'mo_dev_acceptable_distance
			 'mo_dev_ramp_distance
			 'mo_dev_identical_ramp
			 'mo_dev_use_bands
             'mo_mesh_reduce_max_deviation)
    )

    (ui-string "al_mesh_MeshRepair_str" "Mesh Repair")
    (ui-string "al_mesh_MeshRepair_attr_str" "mrepr")

    (ui-function "al_mesh_MeshRepair"
	   (list 'command			"MeshRepair")
	   (list 'label_string		'al_mesh_MeshRepair_str)
	   (list 'attribute_string	'al_mesh_MeshRepair_attr_str)
       (list 'option_function   "MeshRepairControlBox")
       (list 'symbols
             'mo_mesh_repair_show_problems
             'mo_mesh_repair_check_intersect
             'mo_mesh_repair_check_angles)
    )

    (ui-string "al_mesh_MeshHoleFill_str" "Mesh Hole Fill")
    (ui-string "al_mesh_MeshHoleFill_attr_str" "mhole")

    (ui-function "al_mesh_MeshHoleFill"
	   (list 'command			"MeshHoleFill")
	   (list 'label_string		'al_mesh_MeshHoleFill_str)
	   (list 'attribute_string	'al_mesh_MeshHoleFill_attr_str)   
           (list 'option_function  "MeshHoleFillControlBox")
           (list 'symbols
                 'mo_mesh_holefill_quality
                 'mo_mesh_holefill_maxholesize)
    )

    (ui-string "al_mesh_MeshStitch_str" "Mesh Stitch")
    (ui-string "al_mesh_MeshStitch_attr_str" "mstch")

    (ui-function "al_mesh_MeshStitch"
	   (list 'command			"MeshStitch")
	   (list 'label_string		'al_mesh_MeshStitch_str)
	   (list 'attribute_string	'al_mesh_MeshStitch_attr_str)
       (list 'option_function   "MeshStitchControlBox")
       (list 'symbols
             'mo_mesh_stitch_tolerance)
    )

    (ui-string "al_mesh_MeshBoundaries_str" "Mesh Boundaries")
    (ui-string "al_mesh_MeshBoundaries_attr_str" "mbndr")

    (ui-function "al_mesh_MeshBoundaries"
	   (list 'command			"MeshBoundaries")
	   (list 'label_string		'al_mesh_MeshBoundaries_str)
	   (list 'attribute_string	'al_mesh_MeshBoundaries_attr_str)   
    )


    (ui-string "al_mesh_MeshSmooth_str" "Mesh Smooth")
    (ui-string "al_mesh_MeshSmooth_attr_str" "msmth")

    (ui-function "al_mesh_MeshSmooth"
	   (list 'command			"MeshSmooth")
	   (list 'label_string		'al_mesh_MeshSmooth_str)
	   (list 'attribute_string	'al_mesh_MeshSmooth_attr_str)   
           (list 'option_function  "MeshSmoothControlBox")
           (list 'symbols
                 'mo_mesh_smooth_preserve_features
                 'mo_mesh_smooth_number_iterations
                 'mo_mesh_smooth_fix_boundary_vertices
                 'mo_mesh_smooth_use_maxdeviation
                 'mo_mesh_smooth_maxdeviation
				 'mo_mesh_smooth_show_deviation_map
				 'mo_mesh_smooth_devmap_autoramp
				 'mo_dev_acceptable_distance
				 'mo_dev_ramp_distance
				 'mo_dev_identical_ramp
				 'mo_dev_use_bands
                 'mo_mesh_smooth_radius
				 'mo_mesh_smooth_selection_mode
				 'mo_mesh_smooth_normal_angle
				 'mo_mesh_smooth_pick_radius)
    )


    (ui-string "al_mesh_MeshReverseNormals_str" "Reverse Mesh Orientation")
    (ui-string "al_mesh_MeshReverseNormals_attr_str" "revmsh")

    (ui-function "al_mesh_MeshReverseNormals"
	   (list 'command			"MeshReverseNormals")
	   (list 'label_string		'al_mesh_MeshReverseNormals_str)
	   (list 'attribute_string	'al_mesh_MeshReverseNormals_attr_str)   
    )

    (ui-string "al_mesh_MeshFlatten_str" "Mesh Flatten")
    (ui-string "al_mesh_MeshFlatten_attr_str" "mflat")

    (ui-function "al_mesh_MeshFlatten"
	   (list 'command			"MeshFlatten")
	   (list 'label_string		'al_mesh_MeshFlatten_str)
	   (list 'attribute_string	'al_mesh_MeshFlatten_attr_str)   
	   (list 'option_editor     "Modeling/mo_mesh_flatten_options.o.scm"
			                    'mesh.flatten.options)
    )

    (ui-string "al_mesh_MeshAlignment_str" "Mesh Positioning")
    (ui-string "al_mesh_MeshAlignment_attr_str" "mpos")

    (ui-function "al_mesh_MeshAlignment"
	   (list 'command			"MeshAlignment")
	   (list 'label_string		'al_mesh_MeshAlignment_str)
	   (list 'attribute_string	'al_mesh_MeshAlignment_attr_str)   
       (list 'option_function   "MeshAlignmentControlBox")
	   (list 'symbols
			 'mo_mesh_alignment_mode
			 'mo_mesh_alignment_iterations
			 'mo_mesh_alignment_auto_recalc
			 'mo_mesh_alignment_show_deviation_map
			 'mo_mesh_alignment_fast_deviation_map
			 'mo_mesh_alignment_sampling_percent
			 'mo_mesh_alignment_translate_x
			 'mo_mesh_alignment_translate_y
			 'mo_mesh_alignment_translate_z
			 'mo_mesh_alignment_rotate_x
			 'mo_mesh_alignment_rotate_y
			 'mo_mesh_alignment_rotate_z
			 'mo_mesh_alignment_rotationPivotType
			 'mo_mesh_alignment_rotationPivotPosition
			 'mo_mesh_alignment_cullWRTNormAngle
			 'mo_mesh_alignment_cullNormAngleValue
			 'mo_mesh_alignment_cullWRTMeanDistance
			 'mo_mesh_alignment_cullMeanDistanceFactor
			 'mo_mesh_alignment_UIcullNormAngleValue
			 'mo_mesh_alignment_UIcullMeanDistanceFactor
			 'mo_mesh_alignment_sampling_mode
			 'mo_dev_acceptable_distance
			 'mo_dev_ramp_distance
			 'mo_dev_identical_ramp
			 'mo_dev_use_bands
			 'mo_mesh_alignment_translate_mode
			 'mo_mesh_alignment_rotate_mode )
    )

    (ui-string "al_mesh_MeshBridge_str" "Mesh Bridge")
    (ui-string "al_mesh_MeshBridge_attr_str" "mbridg")

    (ui-function "al_mesh_MeshBridge"
	   (list 'command			"MeshBridge")
	   (list 'label_string		'al_mesh_MeshBridge_str)
	   (list 'attribute_string	'al_mesh_MeshBridge_attr_str)   
    )

    (ui-string "al_mesh_MeshMergeVertices_str" "Mesh Weld Vertices")
    (ui-string "al_mesh_MeshMergeVertices_attr_str" "mweld")

    (ui-function "al_mesh_MeshMergeVertices"
	   (list 'command			"MeshMergeVertices")
	   (list 'label_string		'al_mesh_MeshMergeVertices_str)
	   (list 'attribute_string	'al_mesh_MeshMergeVertices_attr_str)   
    )


    (ui-string "al_mesh_MeshFeatureCurves_str" "Mesh Extract Theoretical Intersection")
    (ui-string "al_mesh_MeshFeatureCurves_attr_str" "mtheor")

    (ui-function "al_mesh_MeshFeatureCurves"
	   (list 'command			"MeshFeatureCurves")
	   (list 'label_string		'al_mesh_MeshFeatureCurves_str)
	   (list 'attribute_string	'al_mesh_MeshFeatureCurves_attr_str)
       (list 'option_function  "MeshFeatureCurvesControlBox")
       (list 'symbols
             'mo_mesh_theoretical_radius
             'mo_mesh_theoretical_samples
             'mo_mesh_cross_curve_fit
             'mo_mesh_cross_curve_degree
             'mo_mesh_cross_curve_spans
             'mo_mesh_cross_curve_output
             'mo_mesh_cross_curve_distance
             'mo_mesh_theo_curve_rebuild
             'mo_mesh_theo_curve_degree
             'mo_mesh_theo_curve_spans
			 'mo_mesh_theo_create_theoreticalCurve
			 'mo_mesh_theo_create_featureCurve
			 'mo_mesh_theo_show_featureHelper
			 'mo_mesh_theo_show_curvature_map
			 'mo_mesh_theo_auto_recalc)
       )   

    (ui-string "al_mesh_MeshSharpen_str" "Mesh Edge Reconstruct")
    (ui-string "al_mesh_MeshSharpen_attr_str" "medge")

    (ui-function "al_mesh_MeshSharpen"
	   (list 'command			"MeshSharpen")
	   (list 'label_string		'al_mesh_MeshSharpen_str)
	   (list 'attribute_string	'al_mesh_MeshSharpen_attr_str)
       (list 'option_function  "MeshSharpenControlBox")
       (list 'symbols
             'mo_mesh_sharpen_radius
             'mo_mesh_sharpen_samples
             'mo_mesh_sharpen_cross_curve_distance
             'mo_mesh_sharpen_theo_curve_rebuild
             'mo_mesh_sharpen_theo_curve_degree
             'mo_mesh_sharpen_theo_curve_spans
             'mo_mesh_sharpen_output_surfaces
			 'mo_mesh_fillet_on
			 'mo_mesh_fillet_type
			 'mo_mesh_fillet_radius
			 'mo_mesh_fillet_chord_distance
			 )
       )

		(ui-string "al_mesh_MeshPatch_str" "Mesh Patch")
		(ui-string "al_mesh_MeshPatch_attr_str" "mptch")

		(ui-function "al_mesh_MeshPatch"
				(list 'command			"MeshPatch")
				(list 'label_string		'al_mesh_MeshPatch_str)
				(list 'attribute_string	'al_mesh_MeshPatch_attr_str)
				(list 'option_function  "MeshPatchControlBox")
				(list 'symbols
						'mo_mesh_patch_stitch_patch
						'mo_mesh_patch_stitch_tolerance
						)
		)

;; New modeBox tools

(ui-symbol "mo_movecv_mode"    	0 )
(ui-symbol "mo_movecv_pickhull" 0 )
(ui-symbol "mo_movecv_x"       #t )
(ui-symbol "mo_movecv_y"       #t )
(ui-symbol "mo_movecv_z"       #t )
(ui-symbol "mo_movecv_n"       #t )
(ui-symbol "mo_movecv_u"       #t )
(ui-symbol "mo_movecv_v"       #t )
(ui-symbol "mo_stepsize"    0.01 )

(ui-symbol "mo_mouse_warp"      1 )
(ui-symbol "mo_mouse_warp_index"    0 )
(ui-symbol "mo_mouse_warps" (list 1.0 5.0 10.0 50.0 ))

(ui-symbol "mo_pick_size"     4 )
(ui-symbol "mo_proxy_display" 0 )
(ui-symbol "mo_movecv_xf_mode" 0 )
(ui-symbol "mo_movecv_pmod_mode" 0 )
(ui-symbol "mo_movecv_falloff_type" 0 )
(ui-symbol "mo_movecv_pmod_ufalloff" 1.0 )
(ui-symbol "mo_movecv_pmod_vfalloff" 1.0 )
(ui-symbol "mo_movecv_pmod_uprec" 0 )
(ui-symbol "mo_movecv_pmod_vprec" 0 )
(ui-symbol "mo_movecv_pmod_usucc" 0 )
(ui-symbol "mo_movecv_pmod_vsucc" 0 )

(ui-function "mb_moveCV"           
	(list 'command        	"moveCV")
	(list 'label_string 	"Transform CV")
	(list 'attribute_string "xfrmcv" )
    (list 'option_function  "MoveCVOptions")

	(list 'symbols	'mo_movecv_mode	
                    'mo_movecv_pickhull
					'mo_movecv_x	
                    'mo_movecv_y
                    'mo_movecv_z
					'mo_movecv_n	
                    'mo_movecv_u	
                    'mo_movecv_v
					'mo_use_stepsize 
					'mo_lock_stepsize 
                    'mo_stepsize	
                    'mo_pick_size 
                    'mo_proxy_display 
                    'mo_mouse_warp 
                    'mo_mouse_warp_index
                    'mo_mouse_warps
                    'mo_movecv_xf_mode
                    'mo_movecv_pmod_mode
					'mo_movecv_falloff_type
                    'mo_movecv_pmod_ufalloff
                    'mo_movecv_pmod_vfalloff
                    'mo_movecv_pmod_uprec
                    'mo_movecv_pmod_vprec
                    'mo_movecv_pmod_usucc
                    'mo_movecv_pmod_vsucc )

)
		
(ui-function "mb_AssignCurrentShader"           
	(list 'command        	"AssignCurrentShader")
	(list 'label_string 	"Assign Current Shader")
	(list 'attribute_string "assign" )
)
(ui-function "mb_PickObjectsByShader"           
	(list 'command        	"PickObjectsByShader")
	(list 'label_string 	"Pick Objects By Current Shader")
	(list 'attribute_string "pickObjs" )
)
(ui-function "mb_CopyShader"           
	(list 'command        	"CopyShader")
	(list 'label_string 	"Copy Current Shader")
	(list 'attribute_string "copy" )
)
(ui-function "mb_CreateLayeredShader"           
	(list 'command        	"CreateLayeredShader")
	(list 'label_string 	"Create Layered Shader")
	(list 'attribute_string "layered" )
)
(ui-function "mb_DeleteUnusedShaders"           
	(list 'command        	"DeleteUnusedShaders")
	(list 'label_string 	"Delete Unused Shaders")
	(list 'attribute_string "delete" )
)
 

(ui-function "ma_extras_blank"         
	(list 'command				"ShelfExtras_BLANK_NoOp_function")
	(list 'set_popup_function       #f)
	(list 'label_string 		"blank")
	(list 'attribute_string 	"blank")
)
(ui-function "ma_extras_blank_vert"         
	(list 'command				"ShelfExtras_VERTICAL_NoOp_function")
	(list 'set_popup_function       #f)
	(list 'label_string 		"Vertical")
	(list 'attribute_string 	"vert")
)
(ui-function "ma_extras_blank_horz"         
	(list 'command				"ShelfExtras_HORIZONTAL_NoOp_function")
	(list 'set_popup_function       #f)
	(list 'label_string 		"Horizontal")
	(list 'attribute_string 	"horz")
)
(ui-function "ma_extras_braceleft"         
	(list 'command				"ShelfExtras_BraceLeft_NoOp_function")
	(list 'set_popup_function       #f)
	(list 'label_string 		"Left Brace")
	(list 'attribute_string 	"BraceL")
)
(ui-function "ma_extras_braceright"         
	(list 'command				"ShelfExtras_BraceRight_NoOp_function")
	(list 'set_popup_function       #f)
	(list 'label_string 		"Right Brace")
	(list 'attribute_string 	"braceR")
)
(ui-function "ma_extras_spacerdag"         
	(list 'command				"ShelfExtras_SpacerDag_NoOp_function")
	(list 'set_popup_function       #f)
	(list 'label_string 		"Spacer")
	(list 'attribute_string 	"spacer")
)
(ui-function "ma_extras_studio"         
	(list 'command				"ShelfExtras_Studio_NoOp_function")
	(list 'set_popup_function       #f)
	(list 'label_string 		"Studio")
	(list 'attribute_string 	"studio")
)


;;---------------------------------------
;;---------------------------------------
;;---------------------------------------

(ui-symbol "al_window_view"                    (ui-symbol-reference "MP_COPY"))
(ui-symbol "al_window_tools"                    (ui-symbol-reference "MP_COPY"))
(ui-symbol "al_window_show"                    (ui-symbol-reference "MP_COPY"))
(ui-symbol "al_window_modeling_aids"            (ui-symbol-reference "MP_COPY"))
(ui-symbol "al_window_paint"                    (ui-symbol-reference "MP_COPY"))

(ui-level-state "al_winMenu" 0 )
(ui-level-state "al_bookmarks" 110 400 1060 406 0 )

;; render panel

(ui-function "rp_lib_shaderball"              
	(list 'command                  "LibShaderBall")
	(list 'event_function			"LibDrawShaderBall" )
	(list 'label_string             "empty")
	(list 'attribute_string         "empty")
    (list 'iconcaching              #f )
	(list 'symbols                  'rp_lib_shaderball_path )
) 

(ui-function "rp_res_shaderball"              
	(list 'command                  "ResShaderBall")
	(list 'event_function			"ResDrawShaderBall" )
	(list 'label_string             "empty")
	(list 'attribute_string         "empty")
    (list 'iconcaching              #f )
	(list 'symbols                  'rp_res_shaderball_entry_type 'rp_res_shaderball_entry_name )
) 

;; Diagnostic Shade Tools

(ui-function "mb_DiagnosticShade_MultiColor"           
	(list 'command        	"DiagnosticShade_MultiColor")
	(list 'label_string 	"Multi Color")
	(list 'attribute_string "MulCol" )
	(list 'option_function                  "DiagShadeEditor")
	(list 'symbols	'mo_tglshade_material_red
                  'mo_tglshade_material_green
                  'mo_tglshade_material_blue
                  'mo_tglshade_material_shininess
				  'mo_diagnosticshade_multicolor_transp
                  'mo_tglshade_light_intensity
                  'mo_diagnosticshade_light_quality
                  'mo_diagnosticshade_reflections
				  )
)

(ui-function "mb_DiagnosticShade_RandomColor"           
	(list 'command        	"DiagnosticShade_RandomColor")
	(list 'label_string 	"Random Color")
	(list 'attribute_string "RanCol" )
	(list 'option_function                  "DiagShadeEditor")
	(list 'symbols	'mo_tglshade_random_saturation
                  'mo_tglshade_material_shininess
                  'mo_diagnosticshade_random_transp
                  'mo_tglshade_light_intensity
				  )
)

(ui-function "mb_DiagnosticShade_CurvatureEvaluation"           
	(list 'command        	"DiagnosticShade_CurvatureEvaluation")
	(list 'label_string 	"Curvature Evaluation")
	(list 'attribute_string "CurEvl" )
	(list 'option_function                  "DiagShadeEditor")
	(list 'symbols	'mo_dynshade_ui_crv_eval_type
                  'mb_curva_ramp_draw_scale
                  'dn_radius_threshold_enabled
                  'dn_radius_threshold
                  'dn_max_radius_threshold
                  'dn_max_radius_threshold_enabled
                  'mb_curva_ramp_draw_scale
                  'mb_curva_ramp_use_bands
                  'mo_diagnosticshade_curvature_transp )
   
)

(ui-function "mb_DiagnosticShade_IsoAngle"           
	(list 'command        	"DiagnosticShade_IsoAngle")
	(list 'label_string 	"Iso Angle")
	(list 'attribute_string "IsoAng" )
	(list 'option_function                  "DiagShadeEditor")
	(list 'symbols	'mo_isoangle_texture
                    'mo_isoangle_decay
                    'mo_diagnosticshade_isoangle_transp
					'mo_isoangle_vec
					'mo_isoangle_steps
                    'mo_isoangle_relax
                    'mo_isoangle_angle 
                    'mo_isoangle_rotation
					'mo_isoangle_width
					'mo_isoangle_cos_type 
					'mo_isoangle_curves_only )
)

(ui-function "mb_DiagnosticShade_Zebra"           
	(list 'command        	"DiagnosticShade_Zebra")
	(list 'label_string 	"Horizontal/Vertical")
	(list 'attribute_string "HorVer" )
	(list 'option_function                  "DiagShadeEditor")
	(list 'symbols	'mo_dynshade_stripe_texture_type	
                  'mo_diagshade_texture_lock
				  'mo_tglshade_texture_scale
                  'mo_diagnosticshade_zebra_transp
                  'mo_diagnostic_lighting_ambient
                  'mo_diagnostic_lighting_diffuse
				  'zebraThickness
				  )
)

(ui-function "mb_DiagnosticShade_SurfaceEvaluation"           
	(list 'command        	"DiagnosticShade_SurfaceEvaluation")
	(list 'label_string 	"Surface Evaluation")
	(list 'attribute_string "SurEvl" )
	(list 'option_function                  "DiagShadeEditor")
	(list 'symbols	'mo_dynshade_ui_srf_eval_type
                  'mo_diagnosticshade_surface_eval_transp
				  'mo_diagnosticshade_draft_vector
                  'mo_diagnosticshade_draft_rotation
                  'mo_diagnosticshade_draft_angle_pos
                  'mo_diagnosticshade_draft_angle_pos_tol
				  'mo_diagnosticshade_draft_angle_neg
				  'mo_diagnosticshade_draft_angle_neg_tol
				  'mo_diagnosticshade_draft_angle_pos_on
				  'mo_diagnosticshade_draft_angle_neg_on
				  
		          'mo_diagnosticshade_draft_curve_subdDepth
		          'mo_surface_cos_eval_visual
		          'mo_surface_cos_eval_autoRecalc
		          'mo_diagnosticshade_draft_angle_pos		
		          'mo_surface_cos_eval_history
		          'mo_diagnosticshade_draft_angle_neg
		          'mo_diagnosticshade_draft_angle_pos_on
		          'mo_diagnosticshade_draft_angle_neg_on
		          'mo_diagnosticshade_draft_curve_zeroLineOn
				  'mo_diagnosticshade_draft_curves_only
		          'mo_surface_cos_eval_shadeSurfaces
		          'mo_diagnosticshade_draft_curve_type
		          'mo_surface_cos_eval_createCurves
		          'mo_diagnosticshade_draft_angle_pos_tol
		          'mo_diagnosticshade_draft_angle_neg_tol
		          'mo_surface_cos_eval_pullAngleLinkValues
		          'mo_surface_cos_eval_vector_presets
				  )
)

(ui-function "mb_DiagnosticShade_UserDefinedTexture"           
	(list 'command        	"DiagnosticShade_UserDefinedTexture")
	(list 'label_string 	"User Defined Texture")
	(list 'attribute_string "UseTex" )
	(list 'option_function                  "DiagShadeEditor")
	(list 'symbols	'mo_diagnosticshade_texture_map_type
                  'mo_tglshade_user_texture
                  'mo_diagshade_texture_lock
                  'mo_tglshade_texture_scale
                  'mo_diagnosticshade_user_texture_transp
                  'mo_diagnostic_lighting_ambient
                  'mo_diagnostic_lighting_diffuse
				  )
)

(ui-function "mb_DiagnosticShade_LightTunnel"           
	(list 'command        	"DiagnosticShade_LightTunnel")
	(list 'label_string 	"Light Tunnel")
	(list 'attribute_string "LTunnel" )
	(list 'option_function                  "DiagShadeEditor")
	(list 'symbols	'mo_diag_shade_light_tunnel_visible
                    'mo_diag_shade_light_tunnel_band_color
                    'mo_diag_shade_light_tunnel_number_of_bands
                    'mo_diag_shade_light_tunnel_intensity
                    'mo_diagnosticshade_light_tunnel_transp
                    'mo_diag_shade_light_tunnel_band_width
                    'mo_diag_shade_light_tunnel_band_fringe
				  )
)

(ui-function "mb_DiagnosticShade_ClayAO"           
	(list 'command        	"DiagnosticShade_ClayAO")
	(list 'label_string 	"Clay w/ AO")
	(list 'attribute_string "ClayAO" )
	(list 'option_function                  "DiagShadeEditor")
	(list 'symbols	'mo_diagnosticshade_texture_map_type
                    'mo_diagnosticshade_clayAO_transp
				    'mo_diagnosticshade_clayColor
				  )
)


(ui-function "mb_DiagnosticShade_SaddleHightlight"           
	(list 'command        	"DiagnosticShade_SaddleHightlight")
	(list 'label_string 	"Isophotes")
	(list 'attribute_string "Isophotes" )
	(list 'option_function                  "DiagShadeEditor")
	(list 'symbols	'mo_diagnosticshade_saddle_lockeye
                  'mo_diagnosticshade_saddle_color1
                  'mo_diagnosticshade_saddle_color2
                  'mo_diagnosticshade_saddle_vec
                  'mo_diagnosticshade_saddle_numbands
				  'mo_diagnosticshade_saddle_transp
				  'mo_diagnosticshade_saddle_thickness
				  'mo_diagnosticshade_saddle_sharpness
				  )
)

(ui-function "mb_DiagnosticShade_VREDNurbsRT"           
	(list 'command        	"DiagnosticShade_VREDNurbsRT")
	(list 'label_string 	"VRED Nurbs Analysis")
	(list 'attribute_string "VRED" )
	(list 'option_function                  "DiagShadeEditor")
)

(ui-function "mb_DiagnosticShade_ShadeOff"           
	(list 'command        	"DiagnosticShade_ShadeOff")
	(list 'label_string 	"Shading Off")
	(list 'attribute_string "ShdOff" )
)

(ui-function "mb_DiagnosticShade_VisState1"           
	(list 'command        	"DiagnosticShade_VisState1")
	(list 'label_string 	"Visual State 1")
	(list 'attribute_string "Vis1" )
	(list 'option_function                  "DiagShadeEditor")
)

(ui-function "mb_DiagnosticShade_VisState2"           
	(list 'command        	"DiagnosticShade_VisState2")
	(list 'label_string 	"Visual State 2")
	(list 'attribute_string "Vis2" )
	(list 'option_function                  "DiagShadeEditor")
)

(ui-function "mb_DiagnosticShade_VisState3"           
	(list 'command        	"DiagnosticShade_VisState3")
	(list 'label_string 	"Visual State 3")
	(list 'attribute_string "Vis3" )
	(list 'option_function                  "DiagShadeEditor")
)

(ui-function "mb_DiagnosticShade_BoxMode"           
	(list 'command        	"DiagnosticShade_BoxMode")
	(list 'label_string 	"Box Mode")
	(list 'attribute_string "BoxMod" )
	(list 'option_function                  "DiagShadeEditor")
    (list 'symbols  'mo_diagnosticshade_boxmode_transp
                    'mo_diagnosticshade_boxmode_color)
)

(ui-function "mb_DiagnosticShade_FileState"           
	(list 'command        	"DiagnosticShade_FileState")
	(list 'label_string 	"File State")
	(list 'attribute_string "FileSt" )
)

(ui-function "mp_diagshade_editor"
    (list 'command                  "DiagShadeEditor")
    (list 'label_string             "Diagnostic Shading...")
    (list 'attribute_string         "diagshad")
)

(ui-function "mp_diagshade_light_control"
    (list 'command                  "auto_manip_light_control_action_function")
    (list 'label_string             "Diagnostic Light Control")
    (list 'attribute_string         "diagLight")
	(list 'option_editor 	        "Modeling/mo_automanip_lightcontrol_options.o.scm"
								    'automanip_lightcontrol.options)
)


(ui-symbol "al_diagshade_menu" 1)
(ui-menu "al_diagshade_menu"            
    (list 'label_string "Diagnostic Shade")
    (list 'attribute_string "diag")
)


(ui-menu-add-entry "al_diagshade_menu" "mb_DiagnosticShade_ShadeOff")
(ui-menu-add-entry "al_diagshade_menu" "mb_DiagnosticShade_MultiColor")
(ui-menu-add-entry "al_diagshade_menu" "mb_DiagnosticShade_RandomColor")
(ui-menu-add-entry "al_diagshade_menu" "mb_DiagnosticShade_CurvatureEvaluation")
(ui-menu-add-entry "al_diagshade_menu" "mb_DiagnosticShade_IsoAngle")
(ui-menu-add-entry "al_diagshade_menu" "mb_DiagnosticShade_Zebra")
(ui-menu-add-entry "al_diagshade_menu" "mb_DiagnosticShade_SurfaceEvaluation")
(ui-menu-add-entry "al_diagshade_menu" "mb_DiagnosticShade_UserDefinedTexture")
(ui-menu-add-entry "al_diagshade_menu" "mb_DiagnosticShade_LightTunnel")
(ui-menu-add-entry "al_diagshade_menu" "mb_DiagnosticShade_ClayAO")
(ui-menu-add-entry "al_diagshade_menu" "mb_DiagnosticShade_SaddleHightlight")
(ui-menu-add-entry "al_diagshade_menu" "mb_DiagnosticShade_VREDNurbsRT")
(ui-menu-add-entry "al_diagshade_menu" "mb_DiagnosticShade_VisState1")
(ui-menu-add-entry "al_diagshade_menu" "mb_DiagnosticShade_VisState2")
(ui-menu-add-entry "al_diagshade_menu" "mb_DiagnosticShade_VisState3")
(ui-menu-add-entry "al_diagshade_menu" "mb_DiagnosticShade_FileState")
(ui-menu-add-entry "al_diagshade_menu" "mb_DiagnosticShade_BoxMode")


(ui-menu-level "al_diagshadeEditorTools"            
	(list 'tabs #f )
	(list 'hideoptionsfororiginals #t )
	(list 'title "Diagnostic Shade")
	(list 'layout 'UI_TBOX_LAYOUT )
	(list 'style 'UI_TBOX_STYLE )
	(list 'container "DiagShade:ToolBox" )
	(list 'context "alias_window" )
)

(ui-level-add-menu "al_diagshadeEditorTools"        "al_diagshade_menu")

(ui-level-state "al_diagshadeEditorTools" 0	(list 'layout 'UI_TBOX_LAYOUT ) )

