(ui-symbol	'viewInVR.quality 		    1)
(ui-symbol	'viewInVR.system 		    5)
(ui-symbol	'viewInVR.tess_type         1)
(ui-symbol	'viewInVR.tolerance         0.01)
(ui-symbol	'viewInVR.limit_edge_length 0)
(ui-symbol	'viewInVR.max_edge_length   100.0)
(ui-symbol	'viewInVR.groundplane       0)
(ui-symbol	'viewInVR.groundplane.height    0.0)
(ui-symbol	'viewInVR.use_environment   0)
(ui-symbol	'viewInVR.show_environment  1)
(ui-symbol	'viewInVR.show_shadows      1)
(ui-symbol	'viewInVR.ssao.enable       0)
(ui-symbol	'viewInVR.ssao.radius       500.0)
(ui-symbol	'viewInVR.ssao.intensity    0.8)
(ui-symbol	'viewInVR.ssao.blur         8.0)
(ui-symbol	'viewInVR.libraryPath       "")
(ui-symbol	'viewInVR.matchingMode      0)

(ui-string "viewInVR.quality"               "Quality")
(ui-string "viewInVR.system"                "VR Device")
(ui-string "viewInVR.groundplane"           "Ground Plane Height")

(ui-string "viewInVR.quality.low"           "Low")
(ui-string "viewInVR.quality.medium"        "Medium")
(ui-string "viewInVR.quality.high"          "High")

(ui-string "viewInVR.ssao"                  "Screen Space Ambient Occlusion")
(ui-string "viewInVR.ssao.enable"           "Enable")
(ui-string "viewInVR.ssao.radius"           "Radius")
(ui-string "viewInVR.ssao.intensity"        "Intensity")
(ui-string "viewInVR.ssao.blur"             "Blur")

(ui-string "viewInVR.system.oculus"                 "Oculus Rift")
(ui-string "viewInVR.system.oculus_steam"           "Oculus Rift (via Steam VR)")
(ui-string "viewInVR.system.windowsmr_steam"        "Windows MR (via Steam VR)")
(ui-string "viewInVR.system.samsungodyssey_steam"   "Samsung Odyssey (via Steam VR)")
(ui-string "viewInVR.system.vive_steam"             "HTC Vive")
(ui-string "viewInVR.system.autodetect"             "Autodetect VR System")

(ui-string "viewInVR.tess_type"         "Tessellator")
(ui-string "viewInVR.tess_fast"         "Fast")
(ui-string "viewInVR.tess_accurate"     "Accurate")

(ui-string "viewInVR.tolerance"         "Tolerance")

(ui-string "viewInVR.limit_edge_length" "Limit Edge Length")
(ui-string "viewInVR.max_edge_length"   "Max Edge Length")
 
(ui-string "viewInVR.groundplane.hw_shade"      "Hardware Shade defined")
(ui-string "viewInVR.groundplane.auto_adjust"   "Auto Adjust")
(ui-string "viewInVR.groundplane.custom"        "User defined")
(ui-string "viewInVR.groundplane.height"        "Height")
(ui-string "viewInVR.use_environment"           "Use Environment")
(ui-string "viewInVR.show_environment"          "Show Background")
(ui-string "viewInVR.show_shadows"              "Show Ground Shadows")

(ui-string "viewInVR.matchingMode"              "Type")
(ui-string "viewInVR.matching.none"             "None")
(ui-string "viewInVR.matching.name"             "Alias Shader Name")
(ui-string "viewInVR.matching.uuid"             "Standard Matching")
(ui-string "viewInVR.libraryPath"               "Library Location")

(ui-editor "viewInVR.options"
	(list 'title "View in VR")
    (list 'symbols  "viewInVR.quality"
                    "viewInVR.ssao.enable"
                    "viewInVR.ssao.radius"
                    "viewInVR.ssao.blur"
                    "viewInVR.ssao.intensity"
                    "viewInVR.system"
                    "viewInVR.tess_type"
                    "viewInVR.tolerance"
                    "viewInVR.limit_edge_length"
                    "viewInVR.max_edge_length"
                    "viewInVR.groundplane"
                    "viewInVR.groundplane.height"
    )

    (ui-blank-widget '(half))
    (ui-group-widget ( list 'title "Render Settings" ) )
    (ui-blank-widget '(half))

	(ui-popup-widget "viewInVR.quality"		
		(ui-choice "viewInVR.quality.low"	        0)
		(ui-choice "viewInVR.quality.medium"	    1)
		(ui-choice "viewInVR.quality.high"	        2)
	)
    
    (ui-blank-widget '(half))
    (ui-group-widget ( list 'title "Screen Space Ambient Occlusion" ) )
    (ui-blank-widget '(half))

    (ui-tick-widget "viewInVR.ssao.enable" 
        (list 'rebuild #t)
    )
    (ui-double-widget "viewInVR.ssao.radius"
        (list 'precision "%8.1")
        (list 'range 1.0 1000.0)
        (list 'slider_range 1.0 1000.0)
        (list 'enabled (ui-eq "viewInVR.ssao.enable" #t))
    )
    (ui-double-widget "viewInVR.ssao.intensity"
        (list 'precision "%8.1")
        (list 'range 0.0 4.0)
        (list 'slider_range 0.0 4.0)
        (list 'enabled (ui-eq "viewInVR.ssao.enable" #t))
    )
    (ui-double-widget "viewInVR.ssao.blur"
        (list 'precision "%8.1")
        (list 'range 0.0 16.0)
        (list 'slider_range 0.0 16.0)
        (list 'enabled (ui-eq "viewInVR.ssao.enable" #t))
    )

    (ui-blank-widget '(half))
    (ui-group-widget ( list 'title "VR System" ) )
    (ui-blank-widget '(half))

    (ui-popup-widget "viewInVR.system"
		(list 'columns 1)
        (ui-choice "viewInVR.system.autodetect"             5)
        (ui-choice "viewInVR.system.vive_steam"             2)
		(ui-choice "viewInVR.system.oculus"                 0)
		(ui-choice "viewInVR.system.oculus_steam"           1)
		(ui-choice "viewInVR.system.windowsmr_steam"        3)
        (ui-choice "viewInVR.system.samsungodyssey_steam"   4)
	)

    (ui-blank-widget '(half))
    (ui-group-widget ( list 'title "Environment" ) )
    (ui-blank-widget '(half))

    (ui-tick-widget "viewInVR.use_environment" )
    (ui-tick-widget "viewInVR.show_environment" )
    (ui-tick-widget "viewInVR.show_shadows" )

    (ui-popup-widget "viewInVR.groundplane"
        (list 'rebuild #t)
		(ui-choice "viewInVR.groundplane.auto_adjust"   0)
        (ui-choice "viewInVR.groundplane.hw_shade"      1)
		(ui-choice "viewInVR.groundplane.custom"        2)
	)
    
    (ui-double-widget "viewInVR.groundplane.height"
        (list 'precision "%8.1")
        (list 'range -100000.0 100000.0)
        (list 'slider_range -1000.0 1000.0)
        (list 'enabled (ui-eq "viewInVR.groundplane" 2))
    )

    (ui-blank-widget '(half))
    (ui-group-widget ( list 'title "Tessellation" ) )
    (ui-blank-widget '(half))

	(ui-popup-widget "viewInVR.tess_type" 
        (list 'rebuild #t)
		(ui-choice "viewInVR.tess_fast"       0)
		(ui-choice "viewInVR.tess_accurate"   1)
	)

    (ui-double-widget "viewInVR.tolerance"
        (list 'precision "%8.5")
        (list 'range 0.0001 1.0)
        (list 'slider_range 0.01 1.0)
    )
 
    (ui-tick-widget "viewInVR.limit_edge_length"
        (list 'rebuild #t)
        (list 'enabled (ui-eq "viewInVR.tess_type" 1)))

    (ui-double-widget "viewInVR.max_edge_length"
        (list 'range 0.01 100.0)
        (list 'slider_range 0.1 10.0)
        (list 'enabled (ui-and (ui-eq "viewInVR.tess_type" 1)
                               (ui-eq "viewInVR.limit_edge_length" #t))))

    (ui-blank-widget '(half))
    (ui-group-widget ( list 'title "VRED Material Matching" ) )
    (ui-blank-widget '(half))

	(ui-popup-widget "viewInVR.matchingMode"		
        (list 'rebuild #t)
		(ui-choice "viewInVR.matching.none"     0)
		(ui-choice "viewInVR.matching.name"     1)
		(ui-choice "viewInVR.matching.uuid"     2)
	)
  
    (ui-string-widget			"viewInVR.libraryPath"
		(list 'rebuild #t)
		(list 'function			"viewInVR_library_browser" )
		(list 'functionlabel	"Browse...")
		(list 'enabled (ui-ne "viewInVR.matchingMode" 0))
	)
)

