;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Palette Layout Options
;;;

(ui-string "LevelTile.name"             "Palette/Shelves Layout")
(ui-string "tile.palette"               "Palette Position")
(ui-string "tile.shelf"        			"Shelf Position")
(ui-string "tile.lockres"         		"Keep Alias Window Size")
(ui-string "tile.lockpos"         		"Maintain Current Layout")

(ui-string "tile.left"					"Left" )
(ui-string "tile.right"					"Right" )
(ui-string "tile.bottom"				"Bottom" )
(ui-string "tile.top"					"Top" )
(ui-string "tile.float"					"Floating" )

(ui-string "conf_left" 		"Left")
(ui-string "conf_right" 	"Right")
(ui-string "conf_bottom" 	"Bottom")
(ui-string "conf_top" 		"Top")
(ui-string "conf_float" 	"Float")


(ui-string "tile.shelf.width"					"Icons Per Row" )
(ui-string "tile.tbox.width"					"Icons Per Row" )

(ui-string "tile.width.one"				"One" )
(ui-string "tile.width.two"				"Two" )
(ui-string "tile.width.three"			"Three" )
(ui-string "tile.width.four"			"Four" )


(ui-editor "leveltile.options"             

	(list 'title 'LevelTile.name)

	(list 'symbols 	'tile.palette
				  	'tile.left
					'tile.shelf
				  	'tile.bottom
					'tile.lockres
					'tile.lockpos
					'tile.tbox.width
				  	'tile.shelf.width

 					'conf_left
					'conf_right
					'conf_bottom
					'conf_top
					'conf_float
	)

	(list 'buttons 'Exit 'Go)

	(ui-separator-widget)

	(ui-radio-widget "tile.palette" 
		(ui-choice "tile.left" 		'TILE_LEFT)
		(ui-choice "tile.right" 	'TILE_RIGHT)
		(ui-choice "tile.bottom" 	'TILE_BOTTOM)
		(ui-choice "tile.top" 		'TILE_TOP)
		(ui-choice "tile.float" 	'TILE_FLOAT)
		(list 'rebuild #t)
	)

	( ui-blank-widget )
 	(ui-tick-left-widget 	"conf_left")
	(ui-tick-right-widget	"conf_right")        
	(ui-tick-left-widget	"conf_bottom"   )
	(ui-tick-right-widget	"conf_top")

	(ui-popup-widget "tile.tbox.width"
		(list 'enabled (ui-or (ui-eq "tile.palette" 'TILE_LEFT)
								(ui-eq "tile.palette" 'TILE_RIGHT)
						)
		)
		(ui-choice "tile.width.three" 3)
		(ui-choice "tile.width.four" 4)
	)

	(ui-separator-widget)

	(ui-radio-widget "tile.shelf" 
		(ui-choice "tile.left" 		'TILE_LEFT)
		(ui-choice "tile.right" 	'TILE_RIGHT)
		(ui-choice "tile.bottom" 	'TILE_BOTTOM)
		(ui-choice "tile.top" 		'TILE_TOP)
		(ui-choice "tile.float" 	'TILE_FLOAT)
		(list 'rebuild #t)
	)
	(ui-popup-widget "tile.shelf.width"
		(list 'enabled (ui-or (ui-eq "tile.shelf" 'TILE_LEFT)
								(ui-eq "tile.shelf" 'TILE_RIGHT)
						)
		)
		(ui-choice "tile.width.three" 3)
		(ui-choice "tile.width.four" 4)
	)

	(ui-separator-widget)

	(ui-tick-widget "tile.lockres")

)


