;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Linear Dim Options
;;;

(ui-string "linear.name"                "Linear Unit Options")
(ui-string "mo_ldimen_defined_state"    "User Defined")
(ui-string "mo_lmu_distance"            "Main Units")
(ui-string "mo_scaling_lmu"             "Scale Factor")
(ui-string "mo_lsu_distance"            "Sub Units")
(ui-string "mo_scaling_lsu"             "Scale Factor")
(ui-string "mo_lpu_distance"            "Pos. Units")
(ui-string "mo_scaling_lpu"             "Scale Factor")
(ui-string "mo_linear_update_grids"     "Update Grids")

(ui-string "linear.units.miles"         "Miles")
(ui-string "linear.units.yards"         "Yards")
(ui-string "linear.units.feet"          "Feet")
(ui-string "linear.units.inch"          "Inches")
(ui-string "linear.units.kilo"          "km")
(ui-string "linear.units.meters"        "m")
(ui-string "linear.units.centi"         "cm")
(ui-string "linear.units.milli"         "mm")

(ui-editor "linear.options"             

	(list 'title 'linear.name)

	(list 'symbols 	'mo_ldimen_defined_state	'mo_lmu_distance
					'mo_scaling_lmu				'mo_lsu_distance
					'mo_scaling_lsu				'mo_lpu_distance
					'mo_scaling_lpu				'mo_linear_update_grids
	)

	(list 'buttons 'Reset 'Exit 'Go)

;	User defined units
	(ui-tick-widget "mo_ldimen_defined_state" 
		(list "rebuild"))

	(ui-radio-widget "mo_lmu_distance"  
		(ui-choice "linear.units.milli" 'MO_MILLIMETERS)
		(ui-choice "linear.units.inch"  'MO_INCHES)
		(ui-choice "linear.units.centi" 'MO_CENTIMETERS)
		(ui-choice "linear.units.feet"  'MO_FEET)
		(ui-choice "linear.units.meters" 'MO_METERS)
		(ui-choice "linear.units.yards" 'MO_YARDS)
		(ui-choice "linear.units.kilo"  'MO_KILOMETERS)
		(ui-choice "linear.units.miles" 'MO_MILES)

	)

	(ui-double-widget "mo_scaling_lmu"  
		(list 'enabled (ui-eq "mo_ldimen_defined_state" #t))
		(list 'precision "%f15.4")
		(list 'range 0.0001 10.0)
	)

	(ui-popup-widget "mo_lsu_distance"  
		(ui-choice "linear.units.miles" 'MO_MILES)
		(ui-choice "linear.units.yards" 'MO_YARDS)
		(ui-choice "linear.units.feet"  'MO_FEET)
		(ui-choice "linear.units.inch"  'MO_INCHES)
		(ui-choice "linear.units.kilo"  'MO_KILOMETERS)
		(ui-choice "linear.units.meters" 'MO_METERS)
		(ui-choice "linear.units.centi" 'MO_CENTIMETERS)
		(ui-choice "linear.units.milli" 'MO_MILLIMETERS)
	)

	(ui-double-widget "mo_scaling_lsu"  
		(list 'enabled (ui-eq "mo_ldimen_defined_state" #t))
		(list 'precision "%f15.4")
		(list 'range 0.0001 10.0)
	)

	(ui-popup-widget "mo_lpu_distance"  
		(ui-choice "linear.units.miles" 'MO_MILES)
		(ui-choice "linear.units.yards" 'MO_YARDS)
		(ui-choice "linear.units.feet"  'MO_FEET)
		(ui-choice "linear.units.inch"  'MO_INCHES)
		(ui-choice "linear.units.kilo"  'MO_KILOMETERS)
		(ui-choice "linear.units.meters" 'MO_METERS)
		(ui-choice "linear.units.centi" 'MO_CENTIMETERS)
		(ui-choice "linear.units.milli" 'MO_MILLIMETERS)
	)

	(ui-double-widget "mo_scaling_lpu"  
		(list 'enabled (ui-eq "mo_ldimen_defined_state" #t))
		(list 'precision "%f15.4")
		(list 'range 0.0001 10.0)
	)

	(ui-tick-widget "mo_linear_update_grids" )

)
