;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;
;  
;  
;  
;  
;
	  
;;; Environment Tools Menu
;;;

(ui-string "ma_errlog_str"              "errlog...")
(ui-string "ma_errlog_attr_str"         "errlog")

(ui-string "ma_info_str"                "About Alias")

(ui-string "ma_info_attr_str"           "about")

(ui-string "ma_viewer_info_str"                "About StudioViewer...")
(ui-string "ma_viewer_info_str"                "About StudioViewer...")

(ui-string "ma_pref_str"                "Alias preferences...")
(ui-string "ma_pref_attr_str"           "prefs")
(ui-string "ma_savepref_str"            "Save Preferences")
(ui-string "ma_savepref_attr_str"       "save")
(ui-string "ma_exportpref_str"            "Export Preference Set...")
(ui-string "ma_exportpref_attr_str"       "export")
(ui-string "ma_importpref_str"            "Import Preference Set")
(ui-string "ma_importpref_attr_str"       "import")
(ui-string "ma_hotkeys_str"             "Hotkeys/Menu Editor...")
(ui-string "ma_hotkeys_attr_str"        "htkey")
(ui-string "ma_clutchkeys_str"          "Clutch Keys Editor...")
(ui-string "ma_clutchkeys_attr_str"     "clkey")
(ui-string "ma_cmdstep_str"             "Command Stepper")
(ui-string "ma_cmdstep_attr_str"        "cmd step")
(ui-string "ma_shotkeys_str"            "Toggle Single Hotkeys")
(ui-string "ma_shotkeys_attr_str"       "tsngle")
(ui-string "ma_angular_str"             "set angular units")
(ui-string "ma_angular_attr_str"        "angle")
(ui-string "ma_linear_str"              "set linear units")
(ui-string "ma_linear_attr_str"         "linear")
(ui-string "ma_envtools_tile"           "Palette/Shelves Layout")
(ui-string "ma_envtools_tile_attr"      "layout")
(ui-string "ma_config_str"              "General Preferences")
(ui-string "ma_config_attr_str"         "prefs")
(ui-string "ma_selection_str"           "Selection Options")
(ui-string "ma_selection_attr_str"      "selop")
(ui-string "ma_darktheme_str"           "Dark Color")
(ui-string "ma_darktheme_attr_str"      "dark")
(ui-string "ma_lighttheme_str"          "Light Color")
(ui-string "ma_lighttheme_attr_str"     "light")
(ui-string "ma_custmtheme_str"         "Customize...")
(ui-string "ma_custmtheme_attr_str"    "custom")

(ui-string "ma_mm_str"                  "Marking Menus...")
(ui-string "ma_mm_attr_str"             "mrkmn")
(ui-string "ma_shelf_extras_str"        "Shelf Extras...")
(ui-string "ma_shelf_extras_attr_str"   "xtras")
(ui-string "ma_2dmm_str"                "Paint marking menu")
(ui-string "ma_2dmm_attr_str"           "edit 2D MM")

(ui-string "ma_cs_edit_str"             "Command Set...")
(ui-string "ma_cs_edit_attr_str"        "cmdst")
(ui-string "ma_cs_forward_str"          "Step Forward")
(ui-string "ma_cs_forward_attr_str"     "stfwd")
(ui-string "ma_cs_backward_str"         "Step Backward")
(ui-string "ma_cs_backward_attr_str"    "stbwd")
(ui-string "ma_cs_restart_str"          "Restart")
(ui-string "ma_cs_restart_attr_str"     "rstart")

(ui-string "ma_togglecontrolpanel"       "Control Panel")
(ui-string "ma_togglecontrolpanel_attr"  "ctpnl")

(ui-string "ma_rebuild"       "Rebuild Parent")
(ui-string "ma_rebuild_attr"  "rparent")

(ui-string "ma_controlPanelEditor_str"    "Shape Editor...")
(ui-string "ma_controlPanelEditor_attr_str" "shped")

(ui-string "ma_lic_show_str"            "Product License Information" );
(ui-string "ma_lic_show_attr_str"       "info" );
(ui-string "ma_lic_borrow_str"          "Borrow License" );
(ui-string "ma_lic_borrow_attr_str"     "borrow" );
(ui-string "ma_lic_return_str"          "Return License Early" );
(ui-string "ma_lic_return_attr_str"     "Return" );

(ui-function "ma_togglecontrolpanel"       
	(list 'command				"ToggleControlPanel")
	(list 'label_string 		'ma_togglecontrolpanel )
	(list 'attribute_string 	'ma_togglecontrolpanel_attr )
	(list 'tick     			(ui-eval "isModeBoxOpened"))
)

(ui-function "ma_rebuild_parent"       
    (list 'command              "RebuildParent")
    (list 'label_string         'ma_rebuild )
    (list 'attribute_string     'ma_rebuild_attr )
)

(ui-function "ma_ControlPanelEditor"     
	(list 'command				"ControlPanelEditorToggleOpen")
	(list 'label_string        	'ma_controlPanelEditor_str)
	(list 'attribute_string   	'ma_controlPanelEditor_attr_str)

)


(ui-function "ma_envtools_errlog"       
	(list 'select 				'ma_envtools 'MA_VIEW_ERRLOG)
	(list 'command				"ViewErrlog")
	(list 'label_string 		'ma_errlog_str)
	(list 'attribute_string 	'ma_errlog_attr_str)
	(list 'set_popup_function	#f)
)

(ui-function "ma_envtools_info"         
	(list 'select 				'ma_envtools 'MA_SYSINFO)
	(list 'command				"SystemInfo")
	(list 'label_string 		'ma_info_str)
	(list 'attribute_string 	'ma_info_attr_str)
)

(ui-function "ma_viewer_envtools_info"         
	(list 'select 				'ma_envtools 'MA_SYSINFO)
	(list 'command				"StudioViewerSystemInfo")
	(list 'label_string 		'ma_viewer_info_str)
	(list 'attribute_string 	'ma_viewer_info_attr_str)
)

(ui-function "ma_mmedit_window"         
	(list 'select 				'ma_envtools 'MA_SYSINFO)
	(list 'command				"MarkingMenuEdit")
	(list 'label_string 		'ma_mm_str)
	(list 'attribute_string 	'ma_mm_attr_str)
    (list 'option_editor 	    "Comlib/ma_mm_options.o.scm"
								'mmopts.options)	
)

(ui-function "ma_extras_window"         
	(list 'select 				'ma_envtools 'MA_SYSINFO)
	(list 'command				"ShelfExtras_action_function")
	(list 'label_string 		'ma_shelf_extras_str)
	(list 'attribute_string 	'ma_shelf_extras_attr_str)
)

(ui-function "ma_envtools_pref"         
	(list 'select        		'ma_envtools 'MA_EDIT_ALIAS_PREFS)
	(list 'command				"EditAliasPreferences")
	(list 'label_string        	'ma_pref_str)
	(list 'attribute_string   	'ma_pref_attr_str)
)

(ui-function "ma_envtools_savepref"         
	(list 'command				"preferenceControl_outputNow")
	(list 'label_string        	'ma_savepref_str)
	(list 'attribute_string   	'ma_savepref_attr_str)
)

(ui-function "ma_envtools_exportprefset"         
	(list 'command				"SavePrefSet")
	(list 'label_string        	'ma_exportpref_str)
	(list 'attribute_string   	'ma_exportpref_attr_str)
)

(ui-function "ma_envtools_importprefset"         
	(list 'command				"LoadPrefSet")
	(list 'label_string        	'ma_importpref_str)
	(list 'attribute_string   	'ma_importpref_attr_str)
    (list 'option_editor 	    "Comlib/ma_aps_load.o.scm"
								'aps.options)	
)

(ui-function "ma_envtools_hotkeys"      
	(list 'select        		'ma_envtools 'MA_EDIT_HK)
	(list 'command				"EditHotKeys")
	(list 'label_string        	'ma_hotkeys_str)
	(list 'attribute_string   	'ma_hotkeys_attr_str)
)

(ui-function "ma_envtools_clutchkeys"    
	(list 'select        		'ma_envtools 'MA_EDIT_CK)
	(list 'command				"ClutchKeys")
	(list 'label_string        	'ma_clutchkeys_str)
	(list 'attribute_string   	'ma_clutchkeys_attr_str)
	(list 'option_function     	"ClutchKeysOpen")
    (list 'symbols              'ma_camtool
                                'ma_grdsnap
                                'ma_crvsnap
                                'ma_magsnap
                                'ma_mrkmenu
    )
)

(ui-function "ma_envtools_shotkeys"      
	(list 'select        		'ma_envtools 'MA_SINGLE_HK)
	(list 'command				"SingleHotKeys")
	(list 'label_string        	'ma_shotkeys_str)
	(list 'attribute_string   	'ma_shotkeys_attr_str)
	(list 'tick					(ui-eq 'SINGLE_HOTKEY_MODE #t))
)

(ui-function "ma_envtools_angular"      
	(list 'select        		'ma_envtools 'MA_ANGULAR_DIMEN)
	(list 'command				"SetAngular")
	(list 'label_string        	'ma_angular_str)
	(list 'attribute_string   	'ma_angular_attr_str)
	(list 'option_editor 		"Comlib/ma_angular_options.o.scm"
								'angular.options)
)

(ui-function "ma_envtools_linear"       
	(list 'select        		'ma_envtools 'MA_LINEAR_DIMEN)
	(list 'command				"SetLinear")
	(list 'label_string        	'ma_linear_str)
	(list 'attribute_string   	'ma_linear_attr_str)
	(list 'option_editor 		"Comlib/ma_linear_options.o.scm"
								'linear.options)
)

(ui-function "ma_envtools_config"       
	(list 'select        		'ma_envtools 'MA_CONFIG)
	(list 'command				"Configure")
	(list 'label_string        	'ma_config_str)
	(list 'attribute_string   	'ma_config_attr_str)
	(list 'option_editor 		"Comlib/ma_config_options.o.scm"
								'config.options)
)

(ui-function "ma_envtools_selection"       
	(list 'select        		'ma_envtools 'MA_SELECT)
	(list 'command				"SelectionOptions")
	(list 'label_string        	'ma_selection_str)
	(list 'attribute_string   	'ma_selection_attr_str)
	(list 'option_editor 		"Comlib/ma_selection_options.o.scm"
								'selection.options)
)

(ui-function "ma_envtools_tile"       
	(list 'select        		'ma_envtools 0)
	(list 'command				"PaletteLayout")
	(list 'label_string        	'ma_envtools_tile)
	(list 'attribute_string   	'ma_envtools_tile_attr)
	(list 'option_editor 		"Comlib/ma_tile.o.scm"
								'leveltile.options)
)

(ui-function "ma_dark_theme"
    (list 'command              "LoadDarkTheme")
    (list 'label_string         'ma_darktheme_str)
    (list 'attribute_string     'ma_darktheme_attr_str)
)

(ui-function "ma_light_theme"
    (list 'command              "LoadLightTheme")
    (list 'label_string         'ma_lighttheme_str)
    (list 'attribute_string     'ma_lighttheme_attr_str)
)

(ui-function "ma_custom_theme"
    (list 'command              "UserColors")
    (list 'label_string         'ma_custmtheme_str)
    (list 'attribute_string     'ma_custmtheme_attr_str)
)

; Command stepper submenu
(ui-function "ma_cs_edit"
    (list 'select               'ma_envtools 'MA_CS_EDIT)
	(list 'command				"cstepEdit")
	(list 'label_string        	'ma_cs_edit_str)
	(list 'attribute_string   	'ma_cs_edit_attr_str)
)
(ui-function "ma_cs_forward"
    (list 'select               'ma_envtools 'MA_CS_FORWARD)
	(list 'command				"cstepForward")
	(list 'label_string        	'ma_cs_forward_str)
	(list 'attribute_string   	'ma_cs_forward_attr_str)
)
(ui-function "ma_cs_backward"
    (list 'select               'ma_envtools 'MA_CS_BACKWARD)
	(list 'command				"cstepBackward")
	(list 'label_string        	'ma_cs_backward_str)
	(list 'attribute_string   	'ma_cs_backward_attr_str)
)
(ui-function "ma_cs_restart"
    (list 'select               'ma_envtools 'MA_CS_RESTART)
	(list 'command				"cstepRestart")
	(list 'label_string        	'ma_cs_restart_str)
	(list 'attribute_string   	'ma_cs_restart_attr_str)
)

; Licensing submenus

(ui-function "ma_license_show_info"
	(list 'command				"checkout_show_info_action_function")
	(list 'label_string        	'ma_lic_show_str)
	(list 'attribute_string   	'ma_lic_show_attr_str)
)

(ui-function "ma_license_borrow"
	(list 'command				"checkout_borrow_action_function")
    (list 'active (ui-eval "checkout_borrow_isAvailable") )
	(list 'label_string        	'ma_lic_borrow_str)
	(list 'attribute_string   	'ma_lic_borrow_attr_str)
)

(ui-function "ma_license_return"
	(list 'command				"checkout_return_action_function")
    (list 'active (ui-eval "checkout_return_isAvailable") )
	(list 'label_string        	'ma_lic_return_str)
	(list 'attribute_string   	'ma_lic_return_attr_str)
)

