;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Configuration Options

(ui-string "config.name"                "General Preferences")
(ui-string "conf_select_device"         "Pointing device")
(ui-string "conf_icon_size"             "Tool icons")
(ui-string "conf_layout"             	"ToolBox Layout")
(ui-string "conf_browser_type"          "Type of file browser")
(ui-string "mo_kybd_options"            "Default keyboard entry mode")
(ui-string "mo_viewmanip_mode"          "Viewing control action")
(ui-string "mo_viewmanip_arrow_angle"   "View step angle")
(ui-string "reuse_obj_names"            "Reuse object names")
(ui-string "conf_xform_constrain"  		"On ground plane")
(ui-string "conf_xform_cplane_constrain"  "On construction plane")
(ui-string "conf_view_transition_time"  "View transition time")
(ui-string "view_gadget"                "Viewing gadget")
(ui-string "conf_title_transparency"  	"Titlebar transparency")
(ui-string "use_pick_chooser"      		"Use pick chooser")
(ui-string "pa_ui_popup_interval"       "Hide windows during stroke")
(ui-string "pa_default_layer_size_x"    "Default canvas width")
(ui-string "pa_default_layer_size_y"    "Default canvas height")
(ui-string "pa_brush_snap_tolerance"    "Brush curve snap tolerance")
(ui-string "show_brush_preview"  		"Show brush stamp preview")
(ui-string "show_brush_cursor"  		"Show brush cursor outline")
(ui-string "show_paint_cursor" 			"Show paint cursor")
(ui-string "display_quality"            "Paint display quality")
(ui-string "pa_default_canvas_on_persp"   "Default canvas on persp")
(ui-string "pa_show_layer_thumbnail"    "Show thumbnails in canvas layer editor")
(ui-string "pa_open_paint_window"       "Launch new canvas in paint window")

(ui-string "pa_compress_tablet_events"    "Compress tablet motion events")

(ui-string "conf_common_prefix"         "Productize preference files")


(ui-string "use_axis_constrained_tumble"    "Allow axis constrained tumble")

(ui-string "mo_poi_type"      		"Point of interest")
(ui-string "use_dolly_to_mouse"    		"Dolly to mouse")
(ui-string "use_dolly_to_point"    		"Dolly to point")
(ui-string "conf_viewing_panel"			"View control")
(ui-string "use_nonp_scaling_box"		"Non proportional scaling box")
(ui-string "conf_surfpoint_jack_visable"		"Show point of interest jack")
(ui-string "conf_hide_cv_optim"		"Hide CV's")
(ui-string "conf_hide_locator_optim"		"Hide Locators")	

(ui-string "conf_choice_labels"         "Icon labels")
(ui-string "help_popup_level"           "Popup Help")
(ui-string "conf_show_layers_bar"		"Layers bar")
(ui-string "statusbar"					"Status bar")
(ui-string "titlefeedback"				"Title bar info")
(ui-string "conf_autosave_windows"		"Save workspace on exit")
(ui-string "conf_common_tool_window_dims"	"Use Common Tool Window Attributes")
(ui-string "conf_activate_layer_name"	"Activate Layer Name On Create")

(ui-string "conf_window_transparency"	"Window Transparency")
(ui-string "conf_remember_tool_window_state"  "Remember Tool Option Window Open/Close State")
(ui-string "conf_window_collapse_action"	"Window Collapse Action")
(ui-string "conf_current_tool_location"	    "Current Tool Location")
(ui-string "conf_inactive_window_opacity"	"Inactive Window Opacity")
(ui-string "conf_active_window_opacity"	    "Active Window Opacity")
(ui-string "conf_window_opacity_trans"	"Transition Speed")

(ui-string "conf_interface_scale"	"Interface Scale")

(ui-string "config.viewmanip.azim"  "Azimuth/Twist" )
(ui-string "config.viewmanip.tumble"  "Tumble/Zoom" )

(ui-string "config.poi.none"            "None" )
(ui-string "config.poi.dynamic"         "Dynamic" )
(ui-string "config.poi.persistant"      "Persistent" )

(ui-string "config.device.mouse"        "Mouse")
(ui-string "config.device.bitpad"       "Bitpad")
(ui-string "config.device.abs"          "Absolute")
(ui-string "config.device.rel"          "Relative")

(ui-string "config.paint_cursor.never"  "Off" )
(ui-string "config.paint_cursor.idle"   "Off during stroke" )
(ui-string "config.paint_cursor.always" "On")

(ui-string "config.paint_display.low"   "Low")
(ui-string "config.paint_display.medium" "Medium")
(ui-string "config.paint_display.high"   "High")

(ui-string "config.canvas_pesrp.prompt"  "Always prompt me" )
(ui-string "config.canvas_pesrp.canvas"  "Standard canvas" )
(ui-string "config.canvas_pesrp.overlay" "Overlay canvas")

(ui-string "config.canvas_paintwindow.prompt"  "Always prompt me" )
(ui-string "config.canvas_paintwindow.open"  "Always" )
(ui-string "config.canvas_paintwindow.none"  "Only in absence of modeling windows" )

(ui-string "config.iconsize.text"       "Text")
(ui-string "config.iconsize.small"      "Small")
(ui-string "config.iconsize.medium"     "Medium")
(ui-string "config.iconsize.large"      "Large")

(ui-string "config.browser.macos"		"Mac OS")
(ui-string "config.browser.nt"			"Windows")
(ui-string "config.browser.studio"      "Alias")

(ui-string "config.helploc.online"      "Autodesk Knowledge Network")
(ui-string "config.helploc.offline"     "Installed Help")

(ui-string "sm_time_x_trans"      "X Translate")
(ui-string "sm_time_y_trans"      "Y Translate")
(ui-string "sm_time_z_trans"      "Z Translate")
(ui-string "sm_time_x_rot"        "X Rotate")
(ui-string "sm_time_y_rot"        "Y Rotate")
(ui-string "sm_time_z_rot"        "Z Rotate")

(ui-string "sm_view_x_trans"      "X Translate")
(ui-string "sm_view_y_trans"      "Y Translate")
(ui-string "sm_view_z_trans"      "Z Translate")
(ui-string "sm_view_x_rot"        "X Rotate")
(ui-string "sm_view_y_rot"        "Y Rotate")
(ui-string "sm_view_z_rot"        "Z Rotate")

(ui-string "sm_time_accel_threshold"       "Acceleration threshold")
(ui-string "sm_time_accel_factor"       "Acceleration factor")
(ui-string "time_space"                 "Space Mouse Sensitivity")

(ui-string "Viz_asset_default_library_location"	        "User Library location")
(ui-string "Viz_asset_library_location_Env"	    "Library location")
(ui-string "Viz_ball_size"				 "Shader sample size")
(ui-string "Viz_shade_inactive_layers"	 "Shade Inactive Layers")
(ui-string "Viz_shade_reference_layers"  "Shade Reference Layers")

(ui-string "mo_delguidelines_keeparound"     "Maximum number of guidelines")
(ui-string "mo_create_guidelines"       "Guidelines during curve creation")
(ui-string "ly_name_or_number"			"Modeling layers mode")
(ui-string 'layers_mode.name            "Name")
(ui-string 'layers_mode.number          "Number")
(ui-string 'layers_mode.name_and_number "Both")
(ui-string "mo_vn_change_with_gn"		"When Geometric Normal Flips")
(ui-string 'visnormal_surfaceflip.reset "Reset Visual Normal")
(ui-string 'visnormal_surfaceflip.keep  "Keep Visual Normal")

(ui-string "linestl.object.all"         "All")
(ui-string "linestl.object.active"      "Active")
(ui-string "linestl.style.line"         "Line")
(ui-string "linestl.style.rounded"      "Round")
(ui-string "linestl.style.pyramid"      "Pyramid")
(ui-string "linestl.style.propor"      	"Proportional")
(ui-string "linestl.style.asymme"      	"Triangular")
(ui-string "mo_tgl_skl_bonestyle"		"Draw bone style")
(ui-string "mo_bonestyle_tab"			"Bone tab")
;; the following symbols are common with interactive grid setting option
(ui-string "XformGuides"      			"Transform guides")
(ui-string "mo_grid_corner_perspective_gnomen"	    "Show axis triad")

(ui-string 'ALIAS_COORD_SYS 						"Coordinate system" )
(ui-string 'ALIAS_MARKER_STYLE 						"CV/Vertex Draw Style" )
(ui-string 'ALIAS_JOINT_STYLE 						"Joint Draw Style" )
(ui-string 'ALIAS_FORCE_DEFAULT 					"Force Default Interface" )
(ui-string 'ALIAS_USE_STEREO 						"Enable Stereo Viewing" )
(ui-string 'ALIAS_ALT_HELP 							"" )
(ui-string 'ALIAS_LIBRARY_LOCATION 					"Browser library location" )
(ui-string 'ALIAS_DUMPSTER_LOCATION 				"Browser dumpster location" )
(ui-string 'ALIAS_PROXY_ENABLE	 					"Browser Web Proxy" )
(ui-string 'ALIAS_PROXY_HOSTNAME 					"Proxy Host Name:" )
(ui-string 'ALIAS_PROXY_PORT 						"Proxy Port" )
(ui-string 'ALIAS_PROXY_EXCEPTIONS 					"Proxy Exceptions" )
(ui-string 'PLUGIN_LOAD_VERBOSE 					"Plugin verbose output" )
(ui-string 'PLUGIN_PATH 							"Plugin search path" )

(ui-string 'conf_shared_toolClips_path 				"Shared ToolClips location" )
(ui-string 'conf_productize_prefix 				    "Productize Preference Files" )
(ui-string 'conf_rename_stage_on_save			    "Rename Stage on Save" )
(ui-string 'conf_save_stage_with_stageset		    "Save Wire on Stageset Save" )

(ui-string 'ALIAS_UNIX_SHELL						"Custom Shell Command" );

(ui-string 'ALIAS_EDITOR							"Editor" );

(ui-string 'ALIAS_SCANNER_APP						"Scanner Application" );
(ui-string 'ALIAS_SCANNER_OTHER						"Custom Application Path" );

(ui-string 'ALIAS_PRINTER_APP						"Printer Application" );
(ui-string 'ALIAS_PRINTER_OTHER						"Custom Application Path" );

(ui-string 'ALIAS_PLOT_DEVICE						"Default Plotter Name" );
(ui-string 'ALIAS_PLOT_OPTIONS						"Plotter Options" );
(ui-string 'ALIAS_PLOT_FILTER						"Plot Filter" );

(ui-string "undo_redo_limit_number"     "Limit undos")
(ui-string "undo_redo_limit_memory"     "Limit memory used")
(ui-string "undo_redo_number_limit"     "Maximum undos")
(ui-string "undo_redo_memory_limit"     "Maximum memory (Mbytes)")
(ui-string "conf_checkpoint_location"   "Checkpoint file location")
(ui-string "conf_msave_location"   		"MSave file location")
(ui-string "conf_exception_log_location"   	"Exception Log location")
(ui-string "conf_help_location"   		"Help location")
(ui-string "conf_help_lang"             "Help language")
(ui-string "conf_help_ALT_envset"       "Custom Help Location ")
(ui-string "conf_common_prefs_location"             "Shared Preference Location")
(ui-string "conf_common_prefs_location_Env"         "Shared Preference Location")
(ui-string "cam_clamp_test_dist"   		"Constraint sensitivity")

(ui-string "conf_mwindows_ramp"   		"Background gradient style")
(ui-string "conf_mwindows_ramp.none"  	"None" )
(ui-string "conf_mwindows_ramp.simple" 	"Linear" )
(ui-string "conf_mwindows_ramp.center" 	"Centered" )

(ui-string "conf_mwindows_ramp_range"	"Range")
(ui-string "conf_mwindows_ramp_size"	"Size")

(ui-string 'conf_create_icon_file	 	"Create .ICON files" )

;;Moveable Memory Stuff
(ui-string 'ALIAS_MOVEABLE_MEMORY       "Moveable Memory")
(ui-string 'ALIAS_MM_USE_DEFAULT	 	"Use default temp directory for scratch disk space" )
(ui-string "conf_moveable_memory_directory"   "Scratch Disk Space Directory")



(ui-editor "config.options"

	(list 'title 'config.name)

	(list 'height 548 )

	(list 'symbols 	'conf_select_device
					'mo_kybd_options
					'conf_layout
				  	'pa_ui_popup_interval
				  	'pa_brush_snap_tolerance
                    'pa_default_layer_size_x
                    'pa_default_layer_size_y
					'conf_icon_size
					'conf_browser_type
                    'conf_help_location
                    'conf_help_lang
					'conf_view_transition_time
					'cam_clamp_test_dist
					'conf_title_transparency
                    'conf_auto_adjust_clip_planes
					'time_space
					'use_pick_chooser
				  	'use_axis_constrained_tumble
				  	'mo_viewmanip_mode
				  	'mo_viewmanip_arrow_angle
					'mo_poi_type
					'use_dolly_to_point
					'use_dolly_to_mouse
					'conf_hide_cv_tumble
					'conf_hide_locator_tumble
					'use_nonp_scaling_box
					'conf_surfpoint_jack_visable
					'XformGuides
					'conf_mwindows_ramp
					'XformGuides
					'conf_viewing_panel
					'statusbar
					'conf_autosave_windows
					'conf_common_tool_window_dims
					'conf_activate_layer_name
                    'conf_window_transparency
					'conf_remember_tool_window_state
                    'conf_window_collapse_active
                    'conf_inactive_window_opacity
                    'conf_active_window_opacity
                    'conf_window_opacity_trans
                    'conf_interface_scale
					'titlefeedback
					'help_popup_level
					'sm_time_x_trans
					'sm_time_x_rot
					'sm_time_y_trans
					'sm_time_y_rot
					'sm_time_z_trans
					'sm_time_z_rot
					'sm_time_accel_threshold
					'sm_time_accel_factor
					'sm_view_x_trans
					'sm_view_x_rot
					'sm_view_y_trans
					'sm_view_y_rot
					'sm_view_z_trans
					'sm_view_z_rot
					'conf_choice_labels
					'conf_xform_constrain
					'conf_xform_cplane_constrain
	                'show_brush_preview
	                'show_paint_cursor
	                'show_brush_cursor
                    'display_quality
					'mo_delguidelines_keeparound
					'mo_tgl_skl_bonestyle
					'mo_bonestyle_tab
					'mo_set_grid_value
					'mo_grid_corner_perspective_gnomen
					'ly_name_or_number
					'mo_vn_change_with_gn
					'pa_show_layer_thumbnail
					'pa_compress_tablet_events
					'pa_open_paint_window

				  	;; Modeling
					'ALIAS_COORD_SYS
					'ALIAS_MARKER_STYLE
					'ALIAS_JOINT_STYLE

				  	;; UNDOS
				 	'undo_redo_limit_number
					'undo_redo_limit_memory
					'undo_redo_number_limit
					'undo_redo_memory_limit
					'ALIAS_POLY_UNDO_LEVELS

				  	;; FileSystem
					'ALIAS_ALT_HELP
					'ALIAS_LIBRARY_LOCATION
					'ALIAS_DUMPSTER_LOCATION
					'conf_shared_toolClips_path
					'conf_productize_prefix
					'conf_rename_stage_on_save
					'conf_save_stage_with_stageset

				  	;; System
				  	'ALIAS_USE_STEREO ;; implement
					'conf_checkpoint_location
					'conf_msave_location
					'conf_exception_log_location
					'ALIAS_MOVEABLE_MEMORY
					'ALIAS_MM_USE_DEFAULT
					'conf_moveable_memory_directory
					'conf_create_icon_file
					'conf_common_prefix

				  	;; Rendering
					;; 'ALIAS_RENDER_ENGINE 	implement in Renderer optionbox
					;; 'ALIAS_RENDER_LOCATION 	implement in Renderer optionbox

				  	;; Plugins
					'PLUGIN_PATH
					'PLUGIN_LOAD_VERBOSE

					;; Proxy Settings
					'ALIAS_PROXY_ENABLE
					'ALIAS_PROXY_PORT
					'ALIAS_PROXY_HOSTNAME
					'ALIAS_PROXY_EXCEPTIONS

				  	;; RESTART NOT NEEDED
				  	;; System
					'ALIAS_UNIX_SHELL
					'ALIAS_CUSTOM_UNIX_SHELL
					'ALIAS_EDITOR
					'ALIAS_EDITOR_APP
					'ALIAS_WORDPAD_APP

					'ALIAS_SCANNER_APP
					'ALIAS_SCANNER_OTHER

					'ALIAS_PRINTER_APP
					'ALIAS_PRINTER_OTHER

					'ALIAS_PLOT_DEVICE
					'ALIAS_PLOT_OPTIONS
					'ALIAS_PLOT_FILTER

					'ALIAS_PB_MAX_SWAP_PERCENTAGE
					'Viz_asset_default_library_location
					'conf_common_prefs_location
					'Viz_ball_size
					'Viz_shade_inactive_layers
					'Viz_shade_reference_layers
					'conf_current_tool_location
					'conf_window_collapse_action
					)
	(list 'buttons 'Exit 'Go)


;; Interface
 	(ui-page-widget
 		(list 'title "Interface")
 		(list 'name "interface")
 		(list 'groupname "interface_options_TabPage")
 		)

	(ui-radio-widget "conf_icon_size"
 			(ui-choice "config.iconsize.text" 'UI_NO_ICON)
 			(ui-choice "config.iconsize.small" 'UI_SMALL_ICON)
 			(ui-choice "config.iconsize.medium" 'UI_MED_ICON)
 			(ui-choice "config.iconsize.large" 'UI_BIG_ICON)
 		)

    (ui-popup-widget "conf_window_collapse_action"
                 (ui-choice "TITLEBAR CLICK" 0 )
                 (ui-choice "TITLEBAR DOUBLE CLICK" 1 )
                 (ui-choice "ICON SELECT" 2 )
                 )

    (ui-popup-widget "conf_current_tool_location"
                 (ui-choice "LEFT"  0 )
                 (ui-choice "RIGHT" 1 )
                 (ui-choice "OFF"   2 )
                 )

	(ui-blank-widget)

 	(ui-tick-left-widget 	"conf_autosave_windows")
 	(ui-tick-right-widget 	"conf_choice_labels")

    (ui-tick-left-widget	"conf_common_tool_window_dims"   )
 	(ui-tick-right-widget 	"statusbar")

    (ui-tick-left-widget	"conf_activate_layer_name"   )
	(ui-tick-right-widget	"titlefeedback")

	( ui-blank-widget )

    (ui-tick-widget	        "conf_window_transparency"
 						 (list 'rebuild #t)
                         )

 		(ui-double-widget "conf_inactive_window_opacity"
 						  (list 'enabled ( ui-eq "conf_window_transparency" #t ))
 						  (list 'range 0.01 0.9 ))

 		(ui-double-widget "conf_active_window_opacity"
 						  (list 'enabled ( ui-eq "conf_window_transparency" #t ))
 						  (list 'range 0.5 1.0 ))

 		(ui-double-widget "conf_window_opacity_trans"
 						  (list 'enabled ( ui-eq "conf_window_transparency" #t ))
 						  (list 'range 0.0 2.0 ))

    (ui-tick-widget    "conf_remember_tool_window_state"  )

	(ui-blank-widget)

	( ui-group-widget ( list 'title "Restart required for these values" ) )

 		(ui-double-widget "conf_interface_scale" (list 'range 0.75 3.0 ))
 ;;Input
 	(ui-page-widget
 			(list 'title "Input")
 			(list 'name "input")
 			(list 'groupname "interface_options_TabPage")
 			)


 		;; IMPLEMENT enable single key hot key mode


 		(ui-radio-widget "mo_kybd_options"
 			(ui-choice "config.device.abs"  'MO_KYBD_ABS)
 			(ui-choice "config.device.rel"  'MO_KYBD_REL)
 		)

		( ui-blank-widget )
		(ui-tick-widget	"use_pick_chooser"   )

		( ui-blank-widget )
		( ui-group-widget
			 	( list 'title "Mouse mapping for perspective move" )
			 	( list "nohilight" )
			 	)

 			(ui-popup-widget "conf_xform_constrain"
 						 (ui-choice "Left=X Mid=Y Right=Z" 	#t )
 						 (ui-choice "Left=Free Middle=X Right=Y" #f )
 						 )
 			(ui-popup-widget "conf_xform_cplane_constrain"
 						 (ui-choice "Left=X Mid=Y Right=Z" 	#t )
 						 (ui-choice "Left=Free Middle=X Right=Y" #f )
 						 )

 		(ui-group-widget
 			(list 'rebuild #t)
 			(list 'title "Space mouse device")
 			(list 'enabled (ui-eq "sm_device_avail" #t))
 		 )

 		(ui-radio-widget "time_space"
 						 (list 'rebuild #t)
 						 (list 'enabled (ui-eq "sm_device_avail" #t))
 						 (ui-choice "TIME SLIDER"       0)
 						 (ui-choice "VIEW CONTROLS"     1)
 						 )

 ;;;
 ;;; Time slider widgets
 ;;;
 		(ui-integer-widget "sm_time_x_trans"
 						   (list 'range 1 20)
 						   (list 'enabled (ui-eq "time_space" 0))
 						   )
 		(ui-integer-widget "sm_time_y_trans"
 						   (list 'range 1 20)
 						   (list 'enabled (ui-eq "time_space" 0))
 						   )
 		(ui-integer-widget "sm_time_z_trans"
 						   (list 'enabled (ui-eq "time_space" 0))
 						   (list 'range 1 20))
 		(ui-integer-widget "sm_time_x_rot"
 						   (list 'enabled (ui-eq "time_space" 0))
 					   (list 'range 1 20))
 		(ui-integer-widget "sm_time_y_rot"
 						   (list 'enabled (ui-eq "time_space" 0))
 						   (list 'range 1 20))
 		(ui-integer-widget "sm_time_z_rot"
 						   (list 'enabled (ui-eq "time_space" 0))
 						   (list 'range 1 20))
 		(ui-double-widget "sm_time_accel_threshold"
 						  (list 'enabled (ui-eq "time_space" 0))
 						  (list 'range 0.001 2.0))
 		(ui-double-widget "sm_time_accel_factor"
 						  (list 'enabled (ui-eq "time_space" 0))
 						  (list 'range 0.001 1.0))
 ;;;
 ;;;  View slider widgets
 ;;;
 		(ui-integer-widget "sm_view_x_trans"
 						   (list 'enabled (ui-eq "time_space" 1))
 						   (list 'range -20 20))
 		(ui-integer-widget "sm_view_y_trans"
 						   (list 'enabled (ui-eq "time_space" 1))
 						   (list 'range -20 20))
 		(ui-integer-widget "sm_view_z_trans"
 						   (list 'enabled (ui-eq "time_space" 1))
 						   (list 'range -20 20))
 		(ui-integer-widget "sm_view_x_rot"
 						   (list 'enabled (ui-eq "time_space" 1))
 						   (list 'range -20 20))
 		(ui-integer-widget "sm_view_y_rot"
 						   (list 'enabled (ui-eq "time_space" 1))
 						   (list 'range -20 20))
 		(ui-integer-widget "sm_view_z_rot"
 						   (list 'enabled (ui-eq "time_space" 1))
 						   (list 'range -20 20))

;; Viewing window
	(ui-page-widget
			(list 'title "Viewing")
			(list 'name "viewing")
			(list 'groupname "interface_options_TabPage")
			)

		(ui-popup-widget "conf_viewing_panel"
			(ui-choice "None" 0 )
			(ui-choice "View panel" 1 )
			(ui-choice "ViewCube" 2 )
			(list 'rebuild #t)
		)

		(ui-double-widget "conf_view_transition_time"
			(list 'range 0.0 4.0)
		)

		(ui-blank-widget )

		(ui-radio-widget "mo_viewmanip_mode"
			(ui-choice "config.viewmanip.azim"  1)
			(ui-choice "config.viewmanip.tumble"  0)
		)

		(ui-blank-widget)

		(ui-integer-widget "mo_viewmanip_arrow_angle"
			(list 'range 1 90)
		)

		(ui-tick-widget	"use_axis_constrained_tumble"
			(list 'rebuild #t)
		)
		(ui-integer-widget "cam_clamp_test_dist"
			(list 'range 1 10)
			(list 'enabled (ui-eq "use_axis_constrained_tumble" #t))
		)

		(ui-blank-widget)

		(ui-tick-left-widget "use_nonp_scaling_box")
		(ui-tick-right-widget "use_dolly_to_mouse")

		(ui-popup-widget "mo_poi_type"
			(list 'rebuild #t)
			(ui-choice "config.poi.none"        0)
			(ui-choice "config.poi.dynamic"     1)
			(ui-choice "config.poi.persistant"  2)
		)
		(ui-tick-left-widget "conf_surfpoint_jack_visable"
			(list 'enabled (ui-eq "mo_poi_type" 2 ))
        )
		(ui-tick-right-widget "use_dolly_to_point"
			(list 'enabled (ui-eq "mo_poi_type" 2 ))
		)

		(ui-blank-widget)
		( ui-group-widget ( list 'title "Viewing Transform Optimizations" ) )
			(ui-blank-widget)
			(ui-tick-left-widget "conf_hide_cv_optim")
			(ui-tick-right-widget "conf_hide_locator_optim")

 ;; Modeling window
 	(ui-page-widget
 		(list 'title "Model Windows")
 		(list 'name "modelingWindow")
 		(list 'groupname "interface_options_TabPage")
 		)
 		(ui-tick-left-widget 		"XformGuides"   )
 		(ui-tick-right-widget "mo_grid_corner_perspective_gnomen")

		(ui-blank-widget
			(list 'enabled (ui-eq "crosshair_supported" #f))
			( list "half" )
			)
		(ui-blank-widget
			( list "half" )
			)

        (ui-double-widget "conf_title_transparency"
			(list 'range 0.0 1.0)
		)

 		(ui-tick-left-widget "conf_auto_adjust_clip_planes")

		(ui-blank-widget)
		(ui-radio-widget "conf_mwindows_ramp"
			(ui-choice "conf_mwindows_ramp.none"  	0 )
			(ui-choice "conf_mwindows_ramp.simple" 	1 )
			(ui-choice "conf_mwindows_ramp.center" 	2 )
			(list 'rebuild #t)
		)
        
	(ui-blank-widget)
	( ui-group-widget ( list 'title "Restart required for these values" ) )
		(ui-blank-widget)
		(ui-blank-widget
			( list "half" )
			)
 		(ui-radio-widget "ALIAS_COORD_SYS"
 			(ui-choice "Y up" 1 )
 			(ui-choice "Z up" 0 )
 		)


;; Modeling

 	(ui-page-widget
 		 (list 'title     "Modeling")
 		 (list 'name      "modeling")
 		 (list 'groupname "interface_options_TabPage")
 		 )
		;;(ui-blank-widget)
 		(ui-integer-widget "mo_delguidelines_keeparound"
 						   (list 'range 0 10)
 						   )

 		(ui-radio-widget "ly_name_or_number"
 			(ui-choice "layers_mode.name" 'LY_NAME_MODE)
 			(ui-choice "layers_mode.number" 'LY_NUMBER_MODE)
 			(ui-choice "layers_mode.name_and_number" 'LY_NAME_NUMBER_MODE)
 		)
 		(ui-popup-widget "mo_vn_change_with_gn"
 			(ui-choice "visnormal_surfaceflip.reset" 'MO_SURFACE_FLIP_VN_RESET)
 			(ui-choice "visnormal_surfaceflip.keep" 'MO_SURFACE_FLIP_VN_KEEP)
 		)

 ;; Paint
  	(ui-page-widget
 		 (list 'title     "Paint")
 		 (list 'name      "paint")
 		 (list 'groupname "interface_options_TabPage")
		 (list 'enabled (ui-eq "sketch_module" #t))
 		 )

		(ui-popup-widget "display_quality"
 			(ui-choice "config.paint_display.low"  'PAINT_DISPLAY_LOW)
 			(ui-choice "config.paint_display.medium"  'PAINT_DISPLAY_MEDIUM)
 			(ui-choice "config.paint_display.high"  'PAINT_DISPLAY_HIGH)
		)

        (ui-blank-widget)

		(ui-tick-left-widget "show_brush_preview")
 		(ui-tick-right-widget "show_paint_cursor" )

		(ui-popup-widget "show_brush_cursor"
 			(ui-choice "config.paint_cursor.never"  'PAINT_SHOW_CURSOR_NEVER)
 		 	(ui-choice "config.paint_cursor.idle"  'PAINT_SHOW_CURSOR_IDLE)
 			(ui-choice "config.paint_cursor.always"  'PAINT_SHOW_CURSOR_ALWAYS)
		)

		(ui-blank-widget)
		(ui-double-widget "pa_ui_popup_interval"
			(list 'range 0.0 10.0)
 		)
		(ui-integer-widget "pa_brush_snap_tolerance"
			(list 'range 4 128)
		)

        (ui-blank-widget)
        (ui-integer-widget "pa_default_layer_size_x"
            (list 'slider_range 100 8000)
			(list 'range 100 8000)
        )
        (ui-integer-widget "pa_default_layer_size_y"
            (list 'slider_range 100 8000)
			(list 'range 100 8000)
        )
		(ui-popup-widget "pa_default_canvas_on_persp"
 			(ui-choice "config.canvas_pesrp.prompt"  'PAINT_CANVAS_PERSP_PROMPT)
 		 	(ui-choice "config.canvas_pesrp.canvas"  'PAINT_CANVAS_PERSP_CANVAS)
 			(ui-choice "config.canvas_pesrp.overlay"  'PAINT_CANVAS_PERSP_OVERLAY)
		)

        (ui-blank-widget)
		(ui-tick-left-widget "pa_show_layer_thumbnail")
		(ui-tick-left-widget "pa_compress_tablet_events")
        (ui-blank-widget)

		( ui-group-widget ( list 'title "Paint Workflow" ) )
		(ui-popup-widget "pa_open_paint_window"
 			(ui-choice "config.canvas_paintwindow.prompt"  'PAINT_CANVAS_PAINTWINDOW_PROMPT)
 		 	(ui-choice "config.canvas_paintwindow.open"  'PAINT_CANVAS_PAINTWINDOW_OPEN)
 			(ui-choice "config.canvas_paintwindow.none"  'PAINT_CANVAS_PAINTWINDOW_NONE)
		)

 ;; Visualization
  	(ui-page-widget
 		 (list 'title     "Visualization")
 		 (list 'name      "visualization")
 		 (list 'groupname "interface_options_TabPage")
 		 )

		(ui-popup-widget "Viz_ball_size";
 			(ui-choice "Small"  0 )
 		 	(ui-choice "Large"  1 )
		)
		(ui-blank-widget)

		( ui-string-widget "Viz_asset_default_library_location"
 		 	(list 'enabled (ui-eq "Viz_asset_library_location_EnvSet" #f))
			(list 'function			"Help_Directory_browser" )
			(list 'functionlabel    "Browse..." )
			)
        
		( ui-string-widget "Viz_asset_library_location_Env"
 		 	(list 'enabled (ui-eq "Viz_asset_library_location_EnvSet" #t))
 		 	(list 'disabled (ui-eq "Viz_asset_library_location_EnvSet" #t))
			)
        
		(ui-tick-left-widget "Viz_shade_inactive_layers")
		(ui-tick-left-widget "Viz_shade_reference_layers")

 ;; Animation
 	(ui-page-widget
 		 (list 'title     "Animation")
 		 (list 'name      "animation")
 		 (list 'groupname "interface_options_TabPage")
 		 (list 'enabled (ui-eq "animation_module" #t))
 		 )


 		(ui-radio-widget "mo_tgl_skl_bonestyle"
 		 	(list 'enabled (ui-eq "animation_module" #t))
 			(ui-choice "linestl.style.line" 'MO_TGL_SKL_LINE)
 			(ui-choice "linestl.style.rounded" 'MO_TGL_SKL_ROUND)
 			(ui-choice "linestl.style.pyramid" 'MO_TGL_SKL_PYRAMID)
 			(ui-choice "linestl.style.propor"  'MO_TGL_SKL_PROPOR)
 			(ui-choice "linestl.style.asymme"  'MO_TGL_SKL_ASYMME)
 			)

 		(ui-tick-widget	"mo_bonestyle_tab"
 		 	(list 'enabled (ui-eq "animation_module" #t))
 						)
;; System
	(ui-page-widget
		(list 'title "System")
		(list 'name "system")
		(list 'groupname "interface_options_TabPage")
		)
		
		(if (ui-symbol-true	"using_nt_os")
			( begin
				(ui-blank-widget)
				(ui-separator-widget)

				(ui-radio-widget "conf_browser_type"
					(ui-choice "config.browser.nt" 0)
					(ui-choice "config.browser.studio" 1)
			        (list 'rebuild #t)
				)
			)
		)

        ( ui-tick-widget "conf_create_icon_file"
            (list 'enabled 
                  ( ui-or
                    (ui-eq "conf_browser_type" 1 )
                    (ui-eq "using_xp_os" 1 )
                    )
             )
			(list 'rebuild #t)
		)
		
		( ui-string-widget "conf_msave_location"
			(list 'function			"MSave_Directory_browser" )
			(list 'functionlabel    "Browse..." )
		   )

		( ui-string-widget "conf_common_prefs_location"
 		 	(list 'enabled (ui-eq "conf_common_prefs_location_EnvSet" #f))
			(list 'function			"CommonPrefs_Directory_browser" )
			(list 'functionlabel    "Browse..." )
		   )

		( ui-string-widget "conf_common_prefs_location_Env"
 		 	(list 'enabled (ui-eq "conf_common_prefs_location_EnvSet" #t))
 		 	(list 'disabled (ui-eq "conf_common_prefs_location_EnvSet" #t))
		   )

		(ui-tick-widget "conf_productize_prefix")
		(ui-tick-widget "conf_rename_stage_on_save")
		(ui-tick-widget "conf_save_stage_with_stageset")
		(ui-blank-widget )
		( ui-group-widget ( list 'title "Restart required for these values" ) )
        ( ui-blank-widget )
		( ui-string-widget "conf_checkpoint_location"
			(list 'function			"CheckPoint_Directory_browser" )
			(list 'functionlabel    "Browse..." )
		   )
		( ui-string-widget "ALIAS_LIBRARY_LOCATION"
			(list 'function			"Bitmap_Directory_browser" )
			(list 'functionlabel    "Browse..." )
			)
		( ui-string-widget ""
			(list 'function			"Bitmap_Directory_browser" )
			(list 'functionlabel    "Browse..." )
		)
		( ui-string-widget "conf_exception_log_location"
			(list 'function			"ExceptionLog_Directory_browser" )
			(list 'functionlabel    "Browse..." )
		   )

		( ui-tick-widget "ALIAS_PROXY_ENABLE"
				(list 'enabled (ui-eq "alias_enable_webdav" #t) )
				(list 'rebuild #t)
			 )
		( ui-string-widget "ALIAS_PROXY_HOSTNAME"
		 			(list 'enabled (ui-eq "ALIAS_PROXY_ENABLE" #t)))
		( ui-string-widget "ALIAS_PROXY_PORT"
		 			(list 'enabled (ui-eq "ALIAS_PROXY_ENABLE" #t)))
		( ui-string-widget "ALIAS_PROXY_EXCEPTIONS"
		 			(list 'enabled (ui-eq "ALIAS_PROXY_ENABLE" #t)))

        ( ui-tick-widget "ALIAS_MM_USE_DEFAULT"
            (list 'enabled (ui-ne "using_ntamd64_os" #t))
			(list 'rebuild #t)
		)
        ( ui-string-widget "conf_moveable_memory_directory"
            (list 'enabled (ui-ne "using_ntamd64_os" #t))
            (list 'enabled (ui-ne "ALIAS_MM_USE_DEFAULT" #t))
            (list 'function			"MoveableMemory_Directory_browser" )
		    (list 'functionlabel    "Browse..." )
        )

;; Help
	(ui-page-widget
		(list 'title "Help")
		(list 'name "help")
		(list 'groupname "interface_options_TabPage")
		)
		
        (ui-radio-widget "help_popup_level"
                     (ui-choice "None" 	0 )
                     (ui-choice "ToolTips" 1 )
                     (ui-choice "ToolClips" 2 )
                     )
		(ui-blank-widget )
		( ui-group-widget ( list 'title "Restart required for these values" ) )
        (ui-popup-widget "conf_help_lang"
 			(ui-choice "English"  0 )
 		 	(ui-choice "Japanese"  1 )
            (ui-choice "Simplified Chinese" 2 )
		)
		(ui-blank-widget )
		(ui-blank-widget )
        (ui-radio-widget "conf_help_location"
					(ui-choice "config.helploc.online" 0)
					(ui-choice "config.helploc.offline" 1)
                    (list 'columns 1)
			        (list 'rebuild #t)
				)
		( ui-string-widget "ALIAS_ALT_HELP"
            (list 'enabled ( ui-and
                             (ui-eq "conf_help_location" 1 ) 
                             (ui-eq "aliasAltHelpEnvSet" 0 ) 
                             )
                  )
			(list 'function			"Help_Directory_browser" )
			(list 'functionlabel    "Browse..." )
			)

        (ui-popup-widget "conf_help_ALT_envset"
 			(ui-choice "Set by system administrator"  0 )
            (list 'enabled ( ui-and
                             (ui-eq "conf_help_location" 1 ) 
                             (ui-eq "aliasAltHelpEnvSet" 1 ) 
                             )
                  )
            )

		(ui-blank-widget )
		(ui-blank-widget )
		( ui-string-widget "conf_shared_toolClips_path"
			(list 'function			"ToolClips_Directory_browser" )
			(list 'functionlabel    "Browse..." )
		)

;; Miscellaneous
	(ui-page-widget
		(list 'title "Miscellaneous")
		(list 'name "misc")
		(list 'groupname "interface_options_TabPage")
		)
		( ui-group-widget
			 	( list 'title "General undo" )
			 	( list "nohilight" )
			 	)
		(ui-tick-left-widget "undo_redo_limit_number"
					(list 'rebuild #t)
					)
		(ui-tick-right-widget "undo_redo_limit_memory"
					(list 'rebuild #t)
					)

		(ui-integer-widget "undo_redo_number_limit"
			(list 'enabled (ui-eq 'undo_redo_limit_number #t))
			(list 'slider_range 1 100 )
			(list 'range 0 100)
			)


		(ui-integer-widget "undo_redo_memory_limit"
			(list 'enabled (ui-eq 'undo_redo_limit_memory #t))
			(list 'slider_range 1 500 )
			(list 'range 0 500)
			)

 		(ui-blank-widget)
		( ui-group-widget ( list 'title "Restart required for these values" ) )

		(ui-tick-widget "PLUGIN_LOAD_VERBOSE")
		(ui-string-widget "PLUGIN_PATH"
				(list 'function "Bitmap_Directory_browser" )
				(list 'functionlabel    "Browse..." )
		)
)
