;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;
;  
;  
;  
;  
;
;;;  Scheme for Variant hot key functions 
;;; (We have this so we can put them in the hotkey editor and 
;;; use them as choices - they don't appear in any menus).



( ui-function "al_variant_next"
	(list 'command 			"variantNext_action_function")
	(list 'label_string		"Display Next in Group" )
)
( ui-function "al_variant_prev"
	(list 'command 			"variantPrev_action_function")
	(list 'label_string		"Display Prev in Group" )
)
( ui-function "al_variant_delete"
	(list 'command 			"variantDelete_action_function")
	(list 'label_string		"Delete Current Variant" )
)
( ui-function "al_variant_cycle"
	(list 'command 			"variantCycle_action_function")
	(list 'label_string		"Cycle Variants in Group" )
)
( ui-function "al_variant_capture"
	(list 'command 			"variantCapture_action_function")
	(list 'label_string		"Capture New Variant in Group" )
)

( ui-function "al_variant_apply"
	(list 'command 			"variantApply_action_function")
	(list 'label_string		"Apply Variant" )
)


(ui-symbol "al_variant_actions" (ui-symbol-reference "M_UNUSED"))
(ui-menu "al_variant_actions"
	(list 'label_string "Variant Operations" )
)
(ui-menu-add-entry "al_variant_actions"	'al_variant_next)
(ui-menu-add-entry "al_variant_actions"	'al_variant_prev)
(ui-menu-add-entry "al_variant_actions"	'al_variant_delete)
(ui-menu-add-entry "al_variant_actions"	'al_variant_cycle)
(ui-menu-add-entry "al_variant_actions"	'al_variant_capture)

(ui-symbol "al_variants" (ui-symbol-reference "M_UNUSED"))
(ui-menu "al_variants"
	(list 'label_string "Variants" )
)


(ui-menu-level "al_variants_level"            
	(list 'title "Variant Lister")
	(list 'layout 'UI_MENU_LAYOUT )
	(list 'style 'UI_NOSHOW_STYLE )
	(list 'savable #f )
	(list 'context "alias_window" )
)


(ui-level-add-menu "al_variants_level" 'al_variant_actions)
(ui-level-add-menu "al_variants_level" 'al_variants)

(ui-level-state "al_variants_level" 0 60 400 200 0
	(list 'layout 'UI_SHELF_LAYOUT )
	(list "al_variants" "opened" )
)

