;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;
;  
;  
;  
;  
;
;;;  Scheme for special hot key functions 
;;; (We have this so we can put them in the hotkey editor and 
;;; use them as choices - they don't appear in any menus).

(ui-string "al_special_tgl_current_win" 		"Max / Min Current Window" ) 
(ui-string "al_special_tgl_tool_window" 		"Open Tool Window" )
(ui-string "al_special_tgl_edwins" 				"Toggle Editor Windows" )
(ui-string "al_special_tgl_checkpoints" 		"Toggle Checkpoint Autosave" )

(ui-string "al_special_cmd_suspend" 			"Suspend Rebuilds" ) 
(ui-string "al_special_cmd_resume" 				"Resume Rebuilds" )
(ui-string "al_special_cmd_tgl" 				"Toggle Rebuilds" )

(ui-string "al_special_cmd_tgl" 				"Toggle Rebuilds" )

(ui-string "al_special_Degrees_Span_tgl" 			"Toggle Degree Spans Window" )

(ui-string "al_special_display_all_off" 			"Display all, off")
(ui-string "al_special_display_all_on" 				"Display all, on")
(ui-string "al_special_display_all_current" 		"Display all, current")
(ui-string "al_special_display_active_off" 			"Display active, off")
(ui-string "al_special_display_active_on" 			"Display active, on")
(ui-string "al_special_display_active_current" 		"Display active, current")
(ui-string "al_special_display_tgl_local_axes"      "Toggle Local Axes, all windows")
(ui-string "al_special_display_tgl_stage"           "Toggle Stage")
(ui-string "al_special_display_view_flip"           "View Flip")
(ui-string "al_special_display_view_both"           "View Both")
(ui-string "al_special_display_tgl_stage_exclusive" "Toggle Stage Exclusive")

(ui-string "al_special_viewing_left"                "Left")
(ui-string "al_special_viewing_right"               "Right")
(ui-string "al_special_viewing_top"                 "Top")
(ui-string "al_special_viewing_bottom"              "Bottom")
(ui-string "al_special_viewing_front"               "Front")
(ui-string "al_special_viewing_back"                "Back")

(ui-string "al_special_anim_show_pose_all" 		"Show pose frame, all")
(ui-string "al_special_anim_show_pose_one" 		"Show pose frame 1")
(ui-string "al_special_anim_show_pose_two" 		"Show pose frame 2")
(ui-string "al_special_anim_show_pose_three" 	"Show pose frame 3")
(ui-string "al_special_anim_show_pose_four" 	"Show pose frame 4")

(ui-string "al_special_anim_pick_joint_upper"	"Pick upper joint")
(ui-string "al_special_anim_pick_joint_lower"	"Pick lower joint")
(ui-string "al_special_anim_toggle_anchor"		"Toggle anchor")
(ui-string "al_special_anim_view_prev_frame" 	"View previous frame")
(ui-string "al_special_anim_view_next_frame" 	"View next frame")
(ui-string "al_special_anim_view_prev_key_frame" 	"View previous keyframe")
(ui-string "al_special_anim_view_next_key_frame" 	"View next keyframe")

(ui-string "al_special_workspace_save_str" 	        "Workspace Save" )
(ui-string "al_special_workspace_save_attr_str"     "wsSave" )
(ui-string "al_special_workspace_retrieve_str" 	    "Workspace Retrieve" )
(ui-string "al_special_workspace_retrieve_attr_str" "wsRead" )
(ui-string "al_special_workspace_next_str" 	        "Retrieve Next Workspace" )
(ui-string "al_special_workspace_next_attr_str"     "wsNext" )

(ui-string "al_special_edit_shader_str"	   	    "Shader Editor Open")
(ui-string "al_special_edit_shader_attr_str"	"edSh")

(ui-function "al_special_tgl_tool_window"
	(list 'command 			"TglToolWin")
	(list 'label_string		'al_special_tgl_tool_window)
	(list 'attribute_string	'al_special_tgl_tool_window)
)

(ui-function "al_special_tgl_edwins"
	(list 'command 			"TglEdwins")
	(list 'label_string		'al_special_tgl_edwins)
	(list 'attribute_string	'al_special_tgl_edwins)
)
(ui-function "al_special_tgl_current_win"
	(list 'command 			"MinMaxWindow")
	(list 'label_string		'al_special_tgl_current_win)
	(list 'attribute_string	'al_special_tgl_current_win)
)
(ui-function "al_special_tgl_checkpoints"
	(list 'command 			"TglCheckpoints")
	(list 'label_string		'al_special_tgl_checkpoints)
	(list 'attribute_string	'al_special_tgl_checkpoints)
)
(ui-function "al_special_tgl_color_editor"
	(list 'command 			"openColorEditor")
	(list 'label_string		"Color Editor" )
	(list 'attribute_string	"color")
)
(ui-function "al_special_display_all_off"
	(list 'command 			"DisplayAllOff")
	(list 'label_string		'al_special_display_all_off)
	(list 'attribute_string	'al_special_display_all_off)
)

(ui-function "al_special_viewing_left"
    (list 'command             "setLeftView")
    (list 'label_string        'al_special_viewing_left)
    (list 'attribute_string    'al_special_viewing_left)
)
(ui-function "al_special_viewing_right"
    (list 'command             "setRightView")
    (list 'label_string        'al_special_viewing_right)
    (list 'attribute_string    'al_special_viewing_right)
)
(ui-function "al_special_viewing_top"
    (list 'command             "setTopView")
    (list 'label_string        'al_special_viewing_top)
    (list 'attribute_string    'al_special_viewing_top)
)
(ui-function "al_special_viewing_bottom"
    (list 'command             "setBottomView")
    (list 'label_string        'al_special_viewing_bottom)
    (list 'attribute_string    'al_special_viewing_bottom)
)
(ui-function "al_special_viewing_front"
    (list 'command             "setFrontView")
    (list 'label_string        'al_special_viewing_front)
    (list 'attribute_string    'al_special_viewing_front)
)
(ui-function "al_special_viewing_back"
    (list 'command             "setBackView")
    (list 'label_string        'al_special_viewing_back)
    (list 'attribute_string    'al_special_viewing_back)
)

(ui-function "al_special_cmd_suspend"
	(list 'command 			"Cmd_suspendRebuilds")
	(list 'label_string		'al_special_cmd_suspend)
	(list 'attribute_string	'al_special_cmd_suspend)
)
(ui-function "al_special_cmd_tgl"
	(list 'command 			"Cmd_tglRebuilds")
	(list 'label_string		'al_special_cmd_tgl)
	(list 'attribute_string	'al_special_cmd_tgl)
)
(ui-function "al_special_Degrees_Span_tgl"
	(list 'command 			"degreeSpansWindowTgl")
	(list 'label_string		'al_special_Degrees_Span_tgl)
	(list 'attribute_string	'al_special_Degrees_Span_tgl)
)
(ui-function "al_special_cmd_resume"
	(list 'command 			"Cmd_resumeRebuilds")
	(list 'label_string		'al_special_cmd_resume)
	(list 'attribute_string	'al_special_cmd_resume)
)
(ui-function "al_special_display_all_on"
	(list 'command 			"DisplayAllOn")
	(list 'label_string		'al_special_display_all_on)
	(list 'attribute_string	'al_special_display_all_on)
)

(ui-function "al_special_display_all_current"
	(list 'command 			"DisplayAllCurrent")
	(list 'label_string		'al_special_display_all_current)
	(list 'attribute_string	'al_special_display_all_current)
)

(ui-function "al_special_display_active_off"
	(list 'command 			"DisplayActiveOff")
	(list 'label_string		'al_special_display_active_off)
	(list 'attribute_string	'al_special_display_active_off)
)

(ui-function "al_special_display_active_on"
	(list 'command 			"DisplayActiveOn")
	(list 'label_string		'al_special_display_active_on)
	(list 'attribute_string	'al_special_display_active_on)
)

(ui-function "al_special_display_active_current"
	(list 'command 			"DisplayActiveCurrent")
	(list 'label_string		'al_special_display_active_current)
	(list 'attribute_string	'al_special_display_active_current)
)

(ui-function "al_special_display_tgl_local_axes"
	(list 'command 			"ToggleLocalAxesAllWin")
	(list 'label_string		'al_special_display_tgl_local_axes)
	(list 'attribute_string	'al_special_display_tgl_local_axes)
)

(ui-function "al_special_display_tgl_stage"
	(list 'command 			"ToggleStage")
	(list 'label_string		'al_special_display_tgl_stage)
	(list 'attribute_string	'al_special_display_tgl_stage)
)

(ui-function "al_special_display_view_flip"
	(list 'command 			"ViewFlip")
	(list 'label_string		'al_special_display_view_flip)
	(list 'attribute_string	'al_special_display_view_flip)
)

(ui-function "al_special_display_view_both"
	(list 'command 			"ViewBoth")
	(list 'label_string		'al_special_display_view_both)
	(list 'attribute_string	'al_special_display_view_both)
)

(ui-function "al_special_display_tgl_stage_exclusive"
	(list 'command 			"ToggleStageExclusive")
	(list 'label_string		'al_special_display_tgl_stage_exclusive)
	(list 'attribute_string	'al_special_display_tgl_stage_exclusive)
)

;; Animation special functions

(ui-function "al_special_anim_show_pose_all"
	(list 'command 			"ShowPoseFrameAll")
	(list 'label_string		'al_special_anim_show_pose_all)
	(list 'attribute_string	'al_special_anim_show_pose_all)
)

(ui-function "al_special_anim_show_pose_one"
	(list 'command 			"ShowPoseFrame1")
	(list 'label_string		'al_special_anim_show_pose_one)
	(list 'attribute_string	'al_special_anim_show_pose_one)
)

(ui-function "al_special_anim_show_pose_two"
	(list 'command 			"ShowPoseFrame2")
	(list 'label_string		'al_special_anim_show_pose_two)
	(list 'attribute_string	'al_special_anim_show_pose_two)
)

(ui-function "al_special_anim_show_pose_three"
	(list 'command 			"ShowPoseFrame3")
	(list 'label_string		'al_special_anim_show_pose_three)
	(list 'attribute_string	'al_special_anim_show_pose_three)
)

(ui-function "al_special_anim_show_pose_four"
	(list 'command 			"ShowPoseFrame4")
	(list 'label_string		'al_special_anim_show_pose_four)
	(list 'attribute_string	'al_special_anim_show_pose_four)
)

(ui-function "al_special_anim_pick_joint_upper"
	(list 'command 			"PickJointUpper")
	(list 'label_string		'al_special_anim_pick_joint_upper)
	(list 'attribute_string	'al_special_anim_pick_joint_upper)
)

(ui-function "al_special_anim_pick_joint_lower"
	(list 'command 			"PickJointLower")
	(list 'label_string		'al_special_anim_pick_joint_lower)
	(list 'attribute_string	'al_special_anim_pick_joint_lower)
)

(ui-function "al_special_anim_toggle_anchor"
	(list 'command 			"ToggleAnchor")
	(list 'label_string		'al_special_anim_toggle_anchor)
	(list 'attribute_string	'al_special_anim_toggle_anchor)
)

(ui-function "al_special_anim_view_prev_frame"
	(list 'command 			"viewPreviousFrame")
	(list 'label_string		'al_special_anim_view_prev_frame)
	(list 'attribute_string	'al_special_anim_view_prev_frame)
)

(ui-function "al_special_anim_view_next_frame"
	(list 'command 			"viewNextFrame")
	(list 'label_string		'al_special_anim_view_next_frame)
	(list 'attribute_string	'al_special_anim_view_next_frame)
)

(ui-function "al_special_anim_view_prev_key_frame"
	(list 'command 			"viewPreviousKeyframe")
	(list 'label_string		'al_special_anim_view_prev_key_frame)
	(list 'attribute_string	'al_special_anim_view_prev_key_frame)
)

(ui-function "al_special_anim_view_next_key_frame"
	(list 'command 			"viewNextKeyframe")
	(list 'label_string		'al_special_anim_view_next_key_frame)
	(list 'attribute_string	'al_special_anim_view_next_key_frame)
)

;; Special WorkSpace Functions


(ui-function "al_special_workspace_save"
	(list 'command 			"saveWorkSpace")
	(list 'label_string		'al_special_workspace_save_str )
	(list 'attribute_string	'al_special_workspace_save_attr_str )
)

(ui-function "al_special_workspace_retrieve"
	(list 'command 			"retrieveWorkSpace")
	(list 'label_string		'al_special_workspace_retrieve_str )
	(list 'attribute_string	'al_special_workspace_retrieve_attr_str )
    (list 'symbols
          'al_workspace_retrieve_path
    )
)

(ui-function "al_special_workspace_next"
	(list 'command 			"nextWorkSpace")
	(list 'label_string		'al_special_workspace_next_str )
	(list 'attribute_string	'al_special_workspace_next_attr_str )
)


;; Special Functions Level

(ui-menu-level "al_special_level"            
	(list 'title "Special")
	(list 'layout 'UI_MENU_LAYOUT )
	(list 'style 'UI_NOSHOW_STYLE )
	(list 'context "alias_window" )
)

(ui-string "al_special_useful" "Generally Useful Functions")
(ui-string "al_special_cmdhistory" "Construction History Functions")
(ui-string "al_special_viwing_str" "Viewing")
(ui-string "al_special_modeling" "Modeling Functions")
(ui-string "al_special_display_str" "Display Functions")
(ui-string "al_special_workspace_str" "Workspace Functions")
(ui-string "al_special_anim_str" 	"Animation Functions")
(ui-string "al_special_constr_str" "Construction Functions")


;; Special Display Functions 
(ui-symbol "al_special_useful"  (ui-symbol-reference "M_UNUSED"))
(ui-menu "al_special_useful"
	(list 'label_string 'al_special_useful)
	(list 'attribute_string 'al_special_useful)
)
(ui-menu-add-entry "al_special_useful"	'al_special_tgl_tool_window)
(ui-menu-add-entry "al_special_useful"	'al_special_tgl_current_win)
(ui-menu-add-entry "al_special_useful"	'al_special_tgl_edwins)
(ui-menu-add-entry "al_special_useful"	'al_special_tgl_checkpoints)
(ui-menu-add-entry "al_special_useful"	'al_special_tgl_color_editor)

(ui-string "al_special_category_isolate_next_str"	"Isolate Next Category")
(ui-symbol "al_special_category_isolate_next" (ui-symbol-reference "M_UNUSED"))
(ui-function "al_special_category_isolate_next"
	(list 'command 			"CategoryIsolateNext")
	(list 'label_string		'al_special_category_isolate_next_str)
)
(ui-menu-add-entry "al_special_useful"	'al_special_category_isolate_next)

(ui-string "al_special_category_isolate_prev_str"	"Isolate Previous Category")
(ui-symbol "al_special_category_isolate_prev" (ui-symbol-reference "M_UNUSED"))
(ui-function "al_special_category_isolate_prev"
	(list 'command 			"CategoryIsolatePrev")
	(list 'label_string		'al_special_category_isolate_prev_str)
)
(ui-menu-add-entry "al_special_useful"	'al_special_category_isolate_prev)

(ui-string "al_special_category_isolate_all_str"	"Show All Categories")
(ui-symbol "al_special_category_isolate_all" (ui-symbol-reference "M_UNUSED"))
(ui-function "al_special_category_isolate_all"
	(list 'command 			"CategoryIsolateAll")
	(list 'label_string		'al_special_category_isolate_all_str)
)
(ui-menu-add-entry "al_special_useful"	'al_special_category_isolate_all)

(ui-function "al_special_open_shader_editor"         
	(list 'command			"ShaderEditorOpen")
	(list 'label_string		'al_special_edit_shader_str)
	(list 'attribute_string	'al_special_edit_shader_attr_strr)
)
(ui-menu-add-entry "al_special_useful"	'al_special_open_shader_editor)

(ui-string "al_special_toggle_altshift_action_str" 	        "Toggle Viewing Control Action" ) ; Keys now customizable ( Not always alt/shift )
(ui-string "al_special_toggle_altshift_action_attr_str" 	"tglviewctrl" )
(ui-function "al_special_tgl_altshift_action"
	(list 'command 			"TglAltShiftAction")
	(list 'label_string		'al_special_toggle_altshift_action_str)
	(list 'attribute_string	'al_special_toggle_altshift_action_attr_str)
)
(ui-menu-add-entry "al_special_useful"	'al_special_tgl_altshift_action)

(ui-symbol "al_special_cmdhistory"  (ui-symbol-reference "M_UNUSED"))
(ui-menu "al_special_cmdhistory"
	(list 'label_string 'al_special_cmdhistory)
	(list 'attribute_string 'al_special_cmdhistory)
)
(ui-menu-add-entry "al_special_cmdhistory"	'al_special_cmd_suspend)
(ui-menu-add-entry "al_special_cmdhistory"	'al_special_cmd_resume)
(ui-menu-add-entry "al_special_cmdhistory"	'al_special_cmd_tgl)

(ui-symbol "al_special_modeling"  (ui-symbol-reference "M_UNUSED"))
(ui-menu "al_special_modeling"
	(list 'label_string 'al_special_modeling)
	(list 'attribute_string 'al_special_modeling)
)
(ui-menu-add-entry "al_special_modeling"	'al_special_Degrees_Span_tgl)

;; Special Display Functions 
(ui-menu "al_special_display"
	(list 'label_string 'al_special_display_str)
	(list 'attribute_string 'al_special_display_str)
)
(ui-menu-add-entry "al_special_display"	'al_special_display_all_off)
(ui-menu-add-entry "al_special_display"	'al_special_display_all_on)
(ui-menu-add-entry "al_special_display"	'al_special_display_all_current)
(ui-menu-add-entry "al_special_display"	'al_special_display_active_off)
(ui-menu-add-entry "al_special_display"	'al_special_display_active_on)
(ui-menu-add-entry "al_special_display"	'al_special_display_active_current)
(ui-menu-add-entry "al_special_display"	'al_special_display_tgl_local_axes)
(ui-menu-add-entry "al_special_display"	'al_special_display_tgl_stage)
(ui-menu-add-entry "al_special_display"	'al_special_display_view_flip)
(ui-menu-add-entry "al_special_display"	'al_special_display_view_both)
(ui-menu-add-entry "al_special_display"	'al_special_display_tgl_stage_exclusive)

;; Viewing 
(ui-menu "al_special_viewing"
    (list 'label_string 'al_special_viwing_str)
    (list 'attribute_string 'al_special_viwing_str)
)
(ui-menu-add-entry "al_special_viewing"    'al_special_viewing_left)
(ui-menu-add-entry "al_special_viewing"    'al_special_viewing_right)
(ui-menu-add-entry "al_special_viewing"    'al_special_viewing_top)
(ui-menu-add-entry "al_special_viewing"    'al_special_viewing_bottom)
(ui-menu-add-entry "al_special_viewing"    'al_special_viewing_front)
(ui-menu-add-entry "al_special_viewing"    'al_special_viewing_back)

;; Special WorkSpace Functions 
;;
(ui-menu "al_special_workspace"
	(list 'label_string 'al_special_workspace_str)
	(list 'attribute_string 'al_special_workspace_str)
)

(ui-menu-add-entry "al_special_workspace"	'al_special_workspace_save)
(ui-menu-add-entry "al_special_workspace"	'al_special_workspace_retrieve)
(ui-menu-add-entry "al_special_workspace"	'al_special_workspace_next )

;; Special Anim Functions

(ui-menu "al_special_anim"                  
	(list 'label_string 'al_special_anim_str)
	(list 'attribute_string 'al_special_anim_str)
)
(ui-menu-add-entry "al_special_anim"	'al_special_anim_show_pose_all)
(ui-menu-add-entry "al_special_anim"	'al_special_anim_show_pose_one)
(ui-menu-add-entry "al_special_anim"	'al_special_anim_show_pose_two)
(ui-menu-add-entry "al_special_anim"	'al_special_anim_show_pose_three)
(ui-menu-add-entry "al_special_anim"	'al_special_anim_show_pose_four)
(ui-menu-add-entry "al_special_anim"	'al_special_anim_pick_joint_upper)
(ui-menu-add-entry "al_special_anim"	'al_special_anim_pick_joint_lower)
(ui-menu-add-entry "al_special_anim"	'al_special_anim_toggle_anchor)
(ui-menu-add-entry "al_special_anim"	'al_special_anim_view_prev_frame)
(ui-menu-add-entry "al_special_anim"	'al_special_anim_view_next_frame)
(ui-menu-add-entry "al_special_anim"	'al_special_anim_view_prev_key_frame)
(ui-menu-add-entry "al_special_anim"	'al_special_anim_view_next_key_frame)

;; Special Construction Settings Functions
;; These are hidden and are invoked from the construction option editor.

(ui-menu "al_special_construction"
	(list 'label_string "al_special_constr_str")
	(list 'attribute_string "al_special_construction_str")
)
(ui-menu-add-entry "al_special_construction"    'mp_construction_set_all)

(ui-string 'al_special_paint_brush_paint_mode_str "Brush mode: paint")
(ui-function "al_special_paint_brush_paint"
	(list 'command 			"Paint.PaintMode")
	(list 'label_string		'al_special_paint_brush_paint_mode_str)
	(list 'attribute_string	'al_special_paint_brush_paint_mode_str)
)

(ui-string 'al_special_paint_brush_eraser_mode_str "Brush mode: eraser")
(ui-function "al_special_paint_brush_eraser"
	(list 'command 			"Paint.EraseMode")
	(list 'label_string		'al_special_paint_brush_eraser_mode_str)
	(list 'attribute_string	'al_special_paint_brush_eraser_mode_str)
)

(ui-string 'al_special_paint_brush_show_mode_str "Brush mode: show")
(ui-function "al_special_paint_brush_show"
	(list 'command 			"Paint.ShowMode")
	(list 'label_string		'al_special_paint_brush_show_mode_str)
	(list 'attribute_string	'al_special_paint_brush_show_mode_str)
)

(ui-string 'al_special_paint_brush_hide_mode_str "Brush mode: hide")
(ui-function "al_special_paint_brush_hide"
	(list 'command 			"Paint.HideMode")
	(list 'label_string		'al_special_paint_brush_hide_mode_str)
	(list 'attribute_string	'al_special_paint_brush_hide_mode_str)
)

(ui-string 'al_special_paint_brush_smear_mode_str "Brush mode: smear")
(ui-function "al_special_paint_brush_smear"
	(list 'command 			"Paint.SmearMode")
	(list 'label_string		'al_special_paint_brush_smear_mode_str)
	(list 'attribute_string	'al_special_paint_brush_smear_mode_str)
)

(ui-string 'al_special_paint_brush_blur_mode_str "Brush mode: blur")
(ui-function "al_special_paint_brush_blur"
	(list 'command 			"Paint.BlurMode")
	(list 'label_string		'al_special_paint_brush_blur_mode_str)
	(list 'attribute_string	'al_special_paint_brush_blur_mode_str)
)

(ui-string 'al_special_paint_brush_sharpen_mode_str "Brush mode: sharpen")
(ui-function "al_special_paint_brush_sharpen"
	(list 'command 			"Paint.SharpenMode")
	(list 'label_string		'al_special_paint_brush_sharpen_mode_str)
	(list 'attribute_string	'al_special_paint_brush_sharpen_mode_str)
)

(ui-string 'al_special_paint_brush_mode_iter_str "Cycle through brush mode")
(ui-function "al_special_paint_brush_iterate"
	(list 'command 			"Paint.IterateBrushMode")
	(list 'label_string		'al_special_paint_brush_mode_iter_str)
	(list 'attribute_string	'al_special_paint_brush_mode_iter_str)
)

(ui-string 'al_special_paint_radius_str "Radius")
(ui-function "al_special_paint_radius"
	(list 'command 			"Paint.Radius")
	(list 'label_string		'al_special_paint_radius_str)
	(list 'attribute_string	'al_special_paint_radius_str)
)

(ui-string 'al_special_paint_opacity_str "Opacity")
(ui-function "al_special_paint_opacity"
	(list 'command 			"Paint.Opacity")
	(list 'label_string		'al_special_paint_opacity_str)
	(list 'attribute_string	'al_special_paint_opacity_str)
)

(ui-string 'al_special_paint_rotate_str "Rotate")
(ui-function "al_special_paint_rotate"
	(list 'command 			"Paint.Rotate")
	(list 'label_string		'al_special_paint_rotate_str)
	(list 'attribute_string	'al_special_paint_rotate_str)
)

(ui-string 'al_special_paint_aspect_str "Aspect")
(ui-function "al_special_paint_aspect"
	(list 'command 			"Paint.Aspect")
	(list 'label_string		'al_special_paint_aspect_str)
	(list 'attribute_string	'al_special_paint_aspect_str)
)

(ui-string 'al_special_paint_picklayer_str "Pick layer")
(ui-function "al_special_paint_picklayer"
	(list 'command 			"Paint.PickLayer")
	(list 'label_string		'al_special_paint_picklayer_str)
	(list 'attribute_string	'al_special_paint_picklayer_str)
)
(ui-string 'al_special_paint_size_str "Size")
(ui-function "al_special_paint_size"
	(list 'command 			"Paint.Size")
	(list 'label_string		'al_special_paint_size_str)
	(list 'attribute_string	'al_special_paint_size_str)
)
(ui-string 'al_special_paint_value_str "Color Value")
(ui-function "al_special_paint_value"
	(list 'command 			"Paint.ColorValue")
	(list 'label_string		'al_special_paint_value_str)
	(list 'attribute_string	'al_special_paint_value_str)
)
(ui-string 'al_special_paint_coloropacity_str "Color Opacity")
(ui-function "al_special_paint_coloropacity"
	(list 'command 			"Paint.ColorOpacity")
	(list 'label_string		'al_special_paint_coloropacity_str)
	(list 'attribute_string	'al_special_paint_coloropacity_str)
)
(ui-string 'al_special_paint_hotspots_str "Marking Hot Spots")
(ui-function "al_special_paint_hotspots"
	(list 'command 			"Paint.HotSpots")
	(list 'label_string		'al_special_paint_hotspots_str)
	(list 'attribute_string	'al_special_paint_hotspots_str)
)
(ui-string 'al_special_paint_pan_str "Pan canvas")
(ui-function "al_special_paint_pan"
	(list 'command 			"Paint.Pan")
	(list 'label_string		'al_special_paint_pan_str)
	(list 'attribute_string	'al_special_paint_pan_str)
)
(ui-string 'al_special_paint_twist_str "Twist canvas")
(ui-function "al_special_paint_twist"
	(list 'command 			"Paint.Twist")
	(list 'label_string		'al_special_paint_twist_str)
	(list 'attribute_string	'al_special_paint_twist_str)
)
(ui-string 'al_special_paint_marq_add_str "Marquee add")
(ui-function "al_special_paint_marq_add"
	(list 'command 			"Paint.AddMode")
	(list 'label_string		'al_special_paint_marq_add_str)
	(list 'attribute_string	'al_special_paint_marq_add_str)
)
(ui-string 'al_special_paint_marq_sub_str "Marquee subtract")
(ui-function "al_special_paint_marq_sub"
	(list 'command 			"Paint.SubMode")
	(list 'label_string		'al_special_paint_marq_sub_str)
	(list 'attribute_string	'al_special_paint_marq_sub_str)
)
(ui-string 'al_special_paint_marq_new_str "Marquee new")
(ui-function "al_special_paint_marq_new"
	(list 'command 			"Paint.NewMode")
	(list 'label_string		'al_special_paint_marq_new_str)
	(list 'attribute_string	'al_special_paint_marq_new_str)
)
(ui-string 'al_special_paint_grab_color_str "Grab color")
(ui-function "al_special_paint_grab_color"
	(list 'command 			"Paint.GrabColor")
	(list 'label_string		'al_special_paint_grab_color_str)
	(list 'attribute_string	'al_special_paint_grab_color_str)
)
(ui-string 'al_special_paint_reset_clone_str "Reset clone")
(ui-function "al_special_paint_reset_clone"
	(list 'command 			"Paint.Clone")
	(list 'label_string		'al_special_paint_reset_clone_str)
	(list 'attribute_string	'al_special_paint_reset_clone_str)
)
(ui-string 'al_special_paint_reset_brush_str "Reset brush options")
(ui-function "al_special_paint_reset_brush"
	(list 'command 			"Paint.Resetoptions")
	(list 'label_string		'al_special_paint_reset_brush_str)
	(list 'attribute_string	'al_special_paint_reset_brush_str)
)
(ui-string 'al_special_paint_brush_snap_tr "Cycle through brush snap")
(ui-function "al_special_paint_brush_snap"
	(list 'command 			"Paint.BrushSnap")
	(list 'label_string		'al_special_paint_brush_snap_tr)
	(list 'attribute_string	'al_special_paint_brush_snap_tr)
)
(ui-string 'al_special_paint_brush_predicted_crv_str "Toggle predictive stroke (curvature)")
(ui-function "al_special_paint_brush_predicted_crv"
	(list 'command 			"Paint.PredictedStroke_crv")
	(list 'label_string		'al_special_paint_brush_predicted_crv_str)
	(list 'attribute_string	'al_special_paint_brush_predicted_crv_str)
)
(ui-string 'al_special_paint_brush_predicted_line_str "Toggle predictive stroke (line)")
(ui-function "al_special_paint_brush_predicted_line"
	(list 'command 			"Paint.PredictedStroke_line")
	(list 'label_string		'al_special_paint_brush_predicted_line_str)
	(list 'attribute_string	'al_special_paint_brush_predicted_line_str)
)
(ui-string 'al_special_paint_last_brush_str "Last brush")
(ui-function "al_special_paint_last_brush"
	(list 'command 			"Paint.SwitchToLastBrush")
	(list 'label_string		'al_special_paint_last_brush_str)
	(list 'attribute_string	'al_special_paint_last_brush_str)
)

(ui-string 'al_special_paint_str "Paint")

(ui-symbol "al_special_paint" (ui-symbol-reference "M_UNUSED"))
(ui-menu "al_special_paint"                  
	(list 'label_string 'al_special_paint_str)
	(list 'attribute_string 'al_special_paint_str)
)

(ui-menu-add-entry "al_special_paint" 'al_special_paint_hotspots) 

(ui-menu-add-entry "al_special_paint" 'al_special_paint_brush_iterate)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_brush_paint) 
(ui-menu-add-entry "al_special_paint" 'al_special_paint_brush_eraser)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_brush_show)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_brush_hide)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_brush_smear)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_brush_blur)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_brush_sharpen)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_value)

(ui-menu-add-entry "al_special_paint" 'al_special_paint_coloropacity) 

(ui-menu-add-entry "al_special_paint" 'al_special_paint_size) 
(ui-menu-add-entry "al_special_paint" 'al_special_paint_radius)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_opacity)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_rotate)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_aspect)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_grab_color)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_brush_snap)
	
(ui-menu-add-entry "al_special_paint" 'al_special_paint_last_brush)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_reset_brush)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_reset_clone)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_picklayer)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_pan)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_twist)

(ui-menu-add-entry "al_special_paint" 'al_special_paint_marq_add)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_marq_sub)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_marq_new)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_brush_predicted_crv)
(ui-menu-add-entry "al_special_paint" 'al_special_paint_brush_predicted_line)


;; hot keys for all the menu items from the canvas layer editor
;;
(ui-string 'al_special_paint_newlayer_str "New image layer")
(ui-string 'al_special_paint_newlayer_attr_str "nw im")
(ui-function "al_special_paint_newlayer"
	(list 'command 			"newlayer")
	(list 'label_string		'al_special_paint_newlayer_str)
	(list 'attribute_string	'al_special_paint_newlayer_attr_str)
)
(ui-string 'al_special_paint_newlayerimport_str "New image layer (import)")
(ui-function "al_special_paint_newlayerimport"
	(list 'command 			"NewLayerImport")
	(list 'label_string		'al_special_paint_newlayerimport_str)
	(list 'attribute_string	'al_special_paint_newlayerimport_str)
)
(ui-string 'al_special_paint_newlayercapture_str "New image layer (capture)")
(ui-function "al_special_paint_newlayercapture"
	(list 'command 			"newlayer_capturewindow")
	(list 'label_string		'al_special_paint_newlayercapture_str)
	(list 'attribute_string	'al_special_paint_newlayercapture_str)
)
(ui-string 'al_special_paint_newmask_str "New mask layer")
(ui-string 'al_special_paint_newmask_attr_str "nw msk")
(ui-function "al_special_paint_newmask"
	(list 'command 			"newmasklayer")
	(list 'label_string		'al_special_paint_newmask_str)
	(list 'attribute_string	'al_special_paint_newmask_attr_str)
)
(ui-string 'al_special_paint_newinvmask_str "New invisibility mask layer")
(ui-string 'al_special_paint_newinvmask_attr_str "nw iv")
(ui-function "al_special_paint_newinvmask"
	(list 'command 			"newstencillayer")
	(list 'label_string		'al_special_paint_newinvmask_str)
	(list 'attribute_string	'al_special_paint_newinvmask_attr_str)
)
(ui-string 'al_special_paint_duplicate_str "Duplicate")
(ui-string 'al_special_paint_duplicate_attr_str "du lay")
(ui-function "al_special_paint_duplicate"
	(list 'command 			"duplicatelayer")
	(list 'label_string		'al_special_paint_duplicate_str)
	(list 'attribute_string	'al_special_paint_duplicate_attr_str)
)
(ui-string 'al_special_paint_mergebelow_str "Merge below")
(ui-string 'al_special_paint_mergebelow_attr_str "mrgbl")
(ui-function "al_special_paint_mergebelow"
	(list 'command 			"mergelayer")
	(list 'label_string		'al_special_paint_mergebelow_str)
	(list 'attribute_string	'al_special_paint_mergebelow_attr_str)
)
(ui-string 'al_special_paint_mergevisible_str "Merge visible")
(ui-string 'al_special_paint_mergevisible_attr_str "mrgvis")
(ui-function "al_special_paint_mergevisible"
	(list 'command 			"mergevisiblelayer")
	(list 'label_string		'al_special_paint_mergevisible_str)
	(list 'attribute_string	'al_special_paint_mergevisible_attr_str)
)
(ui-string 'al_special_paint_mergeall_str "Merge all")
(ui-string 'al_special_paint_mergeall_attr_str "mrgall")
(ui-function "al_special_paint_mergeall"
	(list 'command 			"mergealllayers")
	(list 'label_string		'al_special_paint_mergeall_str)
	(list 'attribute_string	'al_special_paint_mergeall_attr_str)
)
(ui-string 'al_special_paint_clearlayer_str "Clear layer")
(ui-string 'al_special_paint_clearlayer_attr_str "clrcan")
(ui-function "al_special_paint_clearlayer"
	(list 'command 			"ClearImageLayer")
	(list 'label_string		'al_special_paint_clearlayer_str)
	(list 'attribute_string	'al_special_paint_clearlayer_attr_str)
)
(ui-string 'al_special_paint_clearhideshow_str "Clear hide show")
(ui-function "al_special_paint_clearhideshow"
	(list 'command 			"ClearHideShow")
	(list 'label_string		'al_special_paint_clearhideshow_str)
	(list 'attribute_string	'al_special_paint_clearhideshow_str)
)
(ui-string 'al_special_paint_rasterize_str "Rasterize layer")
(ui-function "al_special_paint_rasterize"
	(list 'command 			"rasterizelayer")
	(list 'label_string		'al_special_paint_rasterize_str)
	(list 'attribute_string	'al_special_paint_rasterize_str)
)
(ui-string 'al_special_paint_invertlayer_str "Invert layer")
(ui-function "al_special_paint_invertlayer"
	(list 'command 			"InvertLayer")
	(list 'label_string		'al_special_paint_invertlayer_str)
	(list 'attribute_string	'al_special_paint_invertlayer_str)
)
(ui-string 'al_special_paint_invertmarq_str "Invert marquee")
(ui-string 'al_special_paint_invertmarq_attr_str "invmq")
(ui-function "al_special_paint_invertmarq"
	(list 'command 			"InvertSelectionMaskLayer")
	(list 'label_string		'al_special_paint_invertmarq_str)
	(list 'attribute_string	'al_special_paint_invertmarq_attr_str)
)
(ui-string 'al_special_paint_invertmask_str "Invert mask")
(ui-function "al_special_paint_invertmask"
	(list 'command 			"InvertMaskLayer")
	(list 'label_string		'al_special_paint_invertmask_str)
	(list 'attribute_string	'al_special_paint_invertmask_str)
)
(ui-string 'al_special_paint_invertinvmask_str "Invert invisibility mask")
(ui-function "al_special_paint_invertinvmask"
	(list 'command 			"InvertStencil")
	(list 'label_string		'al_special_paint_invertinvmask_str)
	(list 'attribute_string	'al_special_paint_invertinvmask_str)
)
(ui-string 'al_special_paint_horizflip_str "Horizontal flip")
(ui-string 'al_special_paint_horizflip_attr_str "hflip")
(ui-function "al_special_paint_horizflip"
	(list 'command 			"FlipHorizontalLayer")
	(list 'label_string		'al_special_paint_horizflip_str)
	(list 'attribute_string	'al_special_paint_horizflip_attr_str)
)
(ui-string 'al_special_paint_vertflip_str "Vertical flip")
(ui-string 'al_special_paint_vertflip_attr_str "vflip")
(ui-function "al_special_paint_vertflip"
	(list 'command 			"FlipVerticalLayer")
	(list 'label_string		'al_special_paint_vertflip_str)
	(list 'attribute_string	'al_special_paint_vertflip_attr_str)
)
(ui-string 'al_special_paint_translayer_str "Transform layer")
(ui-string 'al_special_paint_translayer_attr_str "xlayr")
(ui-function "al_special_paint_translayer"
	(list 'command 			"TransformImage")
	(list 'label_string		'al_special_paint_translayer_str)
	(list 'attribute_string	'al_special_paint_translayer_attr_str)
)
(ui-string 'al_special_paint_delshape_str "Delete active shape")
(ui-function "al_special_paint_delshape"
	(list 'command 			"DeleteSelectedShape")
	(list 'label_string		'al_special_paint_delshape_str)
	(list 'attribute_string	'al_special_paint_delshape_str)
)
(ui-string 'al_special_paint_dellayer_str "Delete active layer")
(ui-string 'al_special_paint_dellayer_attr_str "dlyr")
(ui-function "al_special_paint_dellayer"
	(list 'command 			"deletelayer")
	(list 'label_string		'al_special_paint_dellayer_str)
	(list 'attribute_string	'al_special_paint_dellayer_attr_str)
)
(ui-string 'al_special_paint_delallhidinvmask_str "Delete all invisibility mask layer")
(ui-function "al_special_paint_delallhidinvmask"
	(list 'command 			"deleteAllHiddenInvisibleMasks")
	(list 'label_string		'al_special_paint_delallhidinvmask_str)
	(list 'attribute_string	'al_special_paint_delallhidinvmask_str)
)
(ui-string 'al_special_paint_deltransformgroup_str "Delete all layers in transform group")
(ui-function "al_special_paint_deltransformgroup"
	(list 'command 			"deleteAllTransformLayers")
	(list 'label_string		'al_special_paint_deltransformgroup_str)
	(list 'attribute_string	'al_special_paint_deltransformgroup_str)
)
(ui-string 'al_special_paint_delinvlayers_str "Delete all invisible layers")
(ui-function "al_special_paint_delinvisblelayers"
	(list 'command 			"deleteAllInvisibleLayers")
	(list 'label_string		'al_special_paint_delinvlayers_str)
	(list 'attribute_string	'al_special_paint_delinvlayers_str)
)
(ui-string 'al_special_paint_deleteall_str "Delete all layers")
(ui-function "al_special_paint_deleteall"
	(list 'command 			"DeleteAllLayers")
	(list 'label_string		'al_special_paint_deleteall_str)
	(list 'attribute_string	'al_special_paint_deleteall_str)
)
(ui-string 'al_special_paint_layertoimage_str "Copy layer to image")
(ui-function "al_special_paint_layertoimage"
	(list 'command 			"CopyLayerToImage")
	(list 'label_string		'al_special_paint_layertoimage_str)
	(list 'attribute_string	'al_special_paint_layertoimage_str)
)
(ui-string 'al_special_paint_layertomask_str "Copy layer to mask")
(ui-function "al_special_paint_layertomask"
	(list 'command 			"CopyLayerToMask")
	(list 'label_string		'al_special_paint_layertomask_str)
	(list 'attribute_string	'al_special_paint_layertomask_str)
)
(ui-string 'al_special_paint_layertomasklum_str "Copy layer to mask (lum)")
(ui-function "al_special_paint_layertomasklum"
	(list 'command 			"CopyLayerToMaskLum")
	(list 'label_string		'al_special_paint_layertomasklum_str)
	(list 'attribute_string	'al_special_paint_layertomasklum_str)
)
(ui-string 'al_special_paint_layertoinvmask_str "Copy layer to invisibility mask")
(ui-function "al_special_paint_layertoinvmask"
	(list 'command 			"CopyLayerToStencil")
	(list 'label_string		'al_special_paint_layertoinvmask_str)
	(list 'attribute_string	'al_special_paint_layertoinvmask_str)
)
(ui-string 'al_special_paint_layertoinvmasklum_str "Copy layer to invisibility mask (lum)")
(ui-function "al_special_paint_layertoinvmasklum"
	(list 'command 			"CopyLayerToStencilLum")
	(list 'label_string		'al_special_paint_layertoinvmasklum_str)
	(list 'attribute_string	'al_special_paint_layertoinvmasklum_str)
)
(ui-string 'al_special_paint_marqtomask_str "Marquee to mask")
(ui-function "al_special_paint_marqtomask"
	(list 'command 			"CopyMarqToMask")
	(list 'label_string		'al_special_paint_marqtomask_str)
	(list 'attribute_string	'al_special_paint_marqtomask_str)
)
(ui-string 'al_special_paint_hidenoncurlayer_str "Hide non-current layers")
(ui-function "al_special_paint_hidenoncurlayer"
	(list 'command 			"HideAllLayers")
	(list 'label_string		'al_special_paint_hidenoncurlayer_str)
	(list 'attribute_string	'al_special_paint_hidenoncurlayer_str)
)
(ui-string 'al_special_paint_showall_str "Show all layers")
(ui-function "al_special_paint_showall"
	(list 'command 			"ShowAllLayers")
	(list 'label_string		'al_special_paint_showall_str)
	(list 'attribute_string	'al_special_paint_showall_str)
)
(ui-string 'al_special_paint_tglmarq_str "Toggle marquee")
(ui-string 'al_special_paint_tglmarq_attr_str "tg mq")
(ui-function "al_special_paint_tglmarq_str"
	(list 'command 			"PaintTglSelMask")
	(list 'label_string		'al_special_paint_tglmarq_str)
	(list 'attribute_string	'al_special_paint_tglmarq_attr_str)
)
(ui-string 'al_special_paint_projsketch_str "Project sketch")
(ui-string 'al_special_paint_projsketch_attr_str "pjskch")
(ui-function "al_special_paint_projsketch"
	(list 'command 			"ProjectSketch")
	(list 'label_string		'al_special_paint_projsketch_str)
	(list 'attribute_string	'al_special_paint_projsketch_attr_str)
)

(ui-string 'al_special_paint_miscdisplaycurr_str "Display all/current layer")
(ui-function "al_special_paint_miscdisplaycurrent"
	(list 'command 			"ToggleDisplayOnlyCurrentLayer")
	(list 'label_string		'al_special_paint_miscdisplaycurr_str)
	(list 'attribute_string	'al_special_paint_miscdisplaycurr_str)
)
(ui-string 'al_special_paint_miscglbmask_str "Enable/disable all masks")
(ui-function "al_special_paint_misctoggleglobalmask"
	(list 'command 			"ToggleAllMasks")
	(list 'label_string		'al_special_paint_miscglbmask_str)
	(list 'attribute_string	'al_special_paint_miscglbmask_str)
)
(ui-string 'al_special_paint_miscdisglbmask_str "Show/hide all masks")
(ui-function "al_special_paint_misctoggledisplayglobalmask"
	(list 'command 			"ShowHideAllMasks")
	(list 'label_string		'al_special_paint_miscdisglbmask_str)
	(list 'attribute_string	'al_special_paint_miscdisglbmask_str)
)
(ui-string 'al_special_paint_miscfiltermsk_str "Show/hide linked masks in lister")
(ui-function "al_special_paint_miscfiltermaskinlister"
	(list 'command 			"FilterMasksInLister")
	(list 'label_string		'al_special_paint_miscfiltermsk_str)
	(list 'attribute_string	'al_special_paint_miscfiltermsk_str)
)

;;

(ui-string 'al_special_paint_layer_editor_str "Canvas Layer Editor")
(ui-symbol "al_special_paint_layer_editor" (ui-symbol-reference "M_UNUSED"))
(ui-menu "al_special_paint_layer_editor"                  
	(list 'label_string 'al_special_paint_layer_editor_str)
	(list 'attribute_string 'al_special_paint_layer_editor_str)
)








(ui-string 'al_special_ple_layer_sub "Layer")
(ui-submenu "al_special_ple_layer_sub")
(ui-submenu-add-entry "al_special_ple_layer_sub" "al_special_paint_newlayer")
(ui-submenu-add-entry "al_special_ple_layer_sub" "al_special_paint_newlayerimport")
(ui-submenu-add-entry "al_special_ple_layer_sub" "al_special_paint_newlayercapture")
(ui-submenu-add-entry "al_special_ple_layer_sub" "al_special_paint_newmask")
(ui-submenu-add-entry "al_special_ple_layer_sub" "al_special_paint_newinvmask")
(ui-submenu-add-entry "al_special_ple_layer_sub" "al_special_paint_duplicate")
(ui-submenu-add-entry "al_special_ple_layer_sub" "al_special_paint_mergebelow")
(ui-submenu-add-entry "al_special_ple_layer_sub" "al_special_paint_mergevisible")
(ui-submenu-add-entry "al_special_ple_layer_sub" "al_special_paint_mergeall")
(ui-menu-add-entry "al_special_paint_layer_editor" "al_special_ple_layer_sub" )

(ui-string 'al_special_ple_edit_sub "Edit")
(ui-submenu "al_special_ple_edit_sub")
(ui-submenu-add-entry "al_special_ple_edit_sub" "al_special_paint_clearlayer")
(ui-submenu-add-entry "al_special_ple_edit_sub" "al_special_paint_clearhideshow")
(ui-submenu-add-entry "al_special_ple_edit_sub" "al_special_paint_rasterize")
(ui-submenu-add-entry "al_special_ple_edit_sub" "al_special_paint_invertlayer")
(ui-submenu-add-entry "al_special_ple_edit_sub" "al_special_paint_invertmarq")
(ui-submenu-add-entry "al_special_ple_edit_sub" "al_special_paint_invertmask")
(ui-submenu-add-entry "al_special_ple_edit_sub" "al_special_paint_invertinvmask")
(ui-submenu-add-entry "al_special_ple_edit_sub" "al_special_paint_horizflip")
(ui-submenu-add-entry "al_special_ple_edit_sub" "al_special_paint_vertflip")
(ui-submenu-add-entry "al_special_ple_edit_sub" "al_special_paint_translayer")
(ui-submenu-add-entry "al_special_ple_edit_sub" "al_special_paint_delshape")
(ui-submenu-add-entry "al_special_ple_edit_sub" "al_special_paint_dellayer")
(ui-submenu-add-entry "al_special_ple_edit_sub" "al_special_paint_delallhidinvmask")
(ui-submenu-add-entry "al_special_ple_edit_sub" "al_special_paint_deltransformgroup")
(ui-submenu-add-entry "al_special_ple_edit_sub" "al_special_paint_delinvisblelayers")
(ui-submenu-add-entry "al_special_ple_edit_sub" "al_special_paint_deleteall")
(ui-menu-add-entry "al_special_paint_layer_editor" "al_special_ple_edit_sub" )

(ui-string 'al_special_ple_convert_sub "Convert")
(ui-submenu "al_special_ple_convert_sub")
(ui-submenu-add-entry "al_special_ple_convert_sub" "al_special_paint_layertoimage")
(ui-submenu-add-entry "al_special_ple_convert_sub" "al_special_paint_layertomask")
(ui-submenu-add-entry "al_special_ple_convert_sub" "al_special_paint_layertomasklum")
(ui-submenu-add-entry "al_special_ple_convert_sub" "al_special_paint_layertoinvmask")
(ui-submenu-add-entry "al_special_ple_convert_sub" "al_special_paint_layertoinvmasklum")
(ui-submenu-add-entry "al_special_ple_convert_sub" "al_special_paint_marqtomask")
(ui-menu-add-entry "al_special_paint_layer_editor" "al_special_ple_convert_sub" )

(ui-string 'al_special_ple_toggle_sub "Toggle")
(ui-submenu "al_special_ple_toggle_sub")
(ui-submenu-add-entry "al_special_ple_toggle_sub" "al_special_paint_hidenoncurlayer")
(ui-submenu-add-entry "al_special_ple_toggle_sub" "al_special_paint_showall")
(ui-submenu-add-entry "al_special_ple_toggle_sub" "al_special_paint_tglmarq_str")
(ui-menu-add-entry "al_special_paint_layer_editor" "al_special_ple_toggle_sub" )

(ui-string 'al_special_ple_project_sub "Project")
(ui-submenu "al_special_ple_project_sub")
(ui-submenu-add-entry "al_special_ple_project_sub" "al_special_paint_projsketch")
(ui-menu-add-entry "al_special_paint_layer_editor" "al_special_ple_project_sub" )

(ui-string 'al_special_ple_misc_sub "Miscellaneous")
(ui-submenu "al_special_ple_misc_sub")
(ui-submenu-add-entry "al_special_ple_misc_sub" "al_special_paint_miscdisplaycurrent")

(ui-submenu-add-entry "al_special_ple_misc_sub" "al_special_paint_misctoggleglobalmask")
(ui-submenu-add-entry "al_special_ple_misc_sub" "al_special_paint_misctoggledisplayglobalmask")
(ui-submenu-add-entry "al_special_ple_misc_sub" "al_special_paint_miscfiltermaskinlister")
(ui-menu-add-entry "al_special_paint_layer_editor" "al_special_ple_misc_sub" )

(ui-level-add-menu "al_special_level" 'al_special_useful)
(ui-level-add-menu "al_special_level" 'al_special_modeling)
(ui-level-add-menu "al_special_level" 'al_special_cmdhistory)
(ui-level-add-menu "al_special_level" 'al_special_display)
(ui-level-add-menu "al_special_level" 'al_special_workspace)
(ui-level-add-menu "al_special_level" 'al_special_anim)
(ui-level-add-menu "al_special_level" 'al_special_construction)
(ui-level-add-menu "al_special_level" 'al_special_paint)
(ui-level-add-menu "al_special_level" 'al_special_paint_layer_editor)
(ui-level-add-menu "al_special_level" 'al_special_viewing)
