;; Tooltips_Functions.scm:
;; -----------------------
;;
;;     Tooltips definitions for ui functions
;;
;;     Note: Refer to Tooltips.scm for more information on how to enter tooltips
;;
;;action menu: ListMode
	(ui-function-tooltip-item	"AW->Listmode->Picked"	"List picked objects"	"List picked objects")  ;Action Window: ListMode > Picked 
	(ui-function-tooltip-item	"AW->Listmode->All"	"List all objects" 
					"List all root-level items in the universe")  	;All 
;;action menu: Edit
	(ui-function-tooltip-item	"AW->Edit->Kfedit"	"Keyframe edit"	"Keyframe edit")  	;Keyframe Edit 
	(ui-function-tooltip-item	"AW->Edit->Expredit"	"Edit expression"	"Edit expression")  	;Edit expression 
	(ui-function-tooltip-item	"AW->Edit->Cut"	"Cut"	"Cut")  	;Cut 
	(ui-function-tooltip-item	"AW->Edit->Copy"	"Copy"	"Copy")  	;Copy 
	(ui-function-tooltip-item	"AW->Edit->Paste"	"Paste"	"Paste")  	;Paste 
	(ui-function-tooltip-item	"AW->Edit->CopySegment"	"Copy segment"	"Copy segment")  	;Copy segment 
	(ui-function-tooltip-item	"AW->Edit->PasteSegment"	"Paste segment"	"Paste segment")  	;Paste segment 
	(ui-function-tooltip-item	"AW->Edit->PasteOffsetSegment"	"Paste segment with offset"	
					"Paste segment with offset")	;Paste segment with offset 
	(ui-function-tooltip-item	"AW->Edit->Clear"	"Clear"	"Clear")  	;Clear 
	(ui-function-tooltip-item	"AW->Edit->Instance"	"Paste instance"	"Paste instance")  	;Paste instance 
	(ui-function-tooltip-item	"AW->Edit->ShowLink"	"Show instance"	"Show instance")  	;Show instance 
	(ui-function-tooltip-item	"AW->Edit->Undo"	"Undo"	"Undo")  	;Undo 
	(ui-function-tooltip-item	"AW->Edit->Redo"	"Redo"	"Redo")  	;Redo 
;;action menu: CurveTools
	(ui-function-tooltip-item	"AW->Crvtools->Appendframe"	"Append keyframes"	"Append keyframes")  	;Append keyframes 
	(ui-function-tooltip-item	"AW->Crvtools->Insertframe"	"Insert keyframes"	"Insert keyframes")  	;Insert keyframes 
	(ui-function-tooltip-item	"AW->Crvtools->Result"	"Use result"	"Use result")  	;Use result 
	(ui-function-tooltip-item	"AW->Crvtools->Simplify"	"Simplify"	"Simplify")  	;Simplify 
	(ui-function-tooltip-item	"AW->Crvtools->Lock"	"Toggle keyframe lock"	"Toggle keyframe lock")  	;Tgl keyframe lock 
;;action menu: Pick
	(ui-function-tooltip-item	"AW->Pick->Nothing"	"Pick nothing"	"Pick nothing")  	;Nothing 
	(ui-function-tooltip-item	"AW->Pick->Any"	"Pick any"	"Pick any")  	;Any 
	(ui-function-tooltip-item	"AW->Pick->KeyFrames"	"Pick keyframes"	"Pick keyframes")  	;Keyframes 
	(ui-function-tooltip-item	"AW->Pick->Curves"	"Pick curves"	"Pick curves")  	;Curves 
	(ui-function-tooltip-item	"AW->Pick->AnyTangents"	"Pick any tangents" 
					"Pick  all tangents of keyframes (in and out)")  	;Any tangents 
	(ui-function-tooltip-item	"AW->Pick->InTangents"	"Pick in-tangents" 
					"Pick only the in-tangents of keyframes")  	;In tangents 
	(ui-function-tooltip-item	"AW->Pick->OutTangents"	"Pick out-tangents" 
					"Pick only the out-tangents of keyframes")  	;Out tangents 
	(ui-function-tooltip-item	"AW->Pick->Templates"	"Pick template"	"Pick templated curves")  	;Template 
;;action menu: Xform
	(ui-function-tooltip-item	"AW->Xform->Move"	"Move"	"Move selected items in the Action window")  	;Move 
	(ui-function-tooltip-item	"AW->Xform->Scale_time"	"Scale time"	
					"Speed up or slow down action in selected curves or keyframes")  	;Scale time 
	(ui-function-tooltip-item	"AW->Xform->Scale_value"	"Scale value"
					"Scale the value of picked keyframes")  	;Scale value 
	(ui-function-tooltip-item	"AW->Xform->Random"	"Randomize"	"Assign random values to keyframes")  	;Randomize 
;;action menu: Views
	(ui-function-tooltip-item	"AW->Viewtools->FitView"	"Look at"	"Look at")  	;Look at 
	(ui-function-tooltip-item	"AW->Viewtools->Dolly"	"Dolly"	"Dolly")  	;Dolly 
	(ui-function-tooltip-item	"AW->Viewtools->Track"	"Track"	"Track")  	;Track 
	(ui-function-tooltip-item	"AW->Viewtools->UndoView"	"Undo view"	"Undo view")  	;Undo view 
	(ui-function-tooltip-item	"AW->Viewtools->RedoView"	"Redo view"	"Redo view")  	;Redo view 
;;action menu: DispTools
	(ui-function-tooltip-item	"AW->Disptools->TglTemplate"	"Toggle template"	"Toggle template")  	;Tgl template 
	(ui-function-tooltip-item	"AW->Disptools->ShwTangents"	"Toggle tangents"	"Toggle tangents")  	;Tgl tangents 
	(ui-function-tooltip-item	"AW->Disptools->ShwInfinity"	"Toggle infinity"	"Toggle infinity")  	;Tgl infinity 
	(ui-function-tooltip-item	"AW->Disptools->ShwCvs"	"Toggle keyframes"	"Toggle keyframes")  	;Tgl keyframes 
	(ui-function-tooltip-item	"AW->Disptools->ShwStats"	"Toggle stats"	"Toggle stats")  	;Tgl stats 
	(ui-function-tooltip-item	"AW->Disptools->ShwResults"	"Toggle result curves"	"Toggle result curves")  	;Tgl result curves 
	(ui-function-tooltip-item	"AW->Disptools->ShwSdl"	"Toggle curve names")  	;Tgl curve names 
;;action menu: ActionTools
	(ui-function-tooltip-item	"AW->ActionTools->Bconst"	"Constant before"	
					"Curve keeps value of first keyframe for all time values before it")  	;Constant before 
	(ui-function-tooltip-item	"AW->ActionTools->Aconst"	"Constant after"
					"Curve keeps value of last keyframe for all time values after it")  	;Constant after 
	(ui-function-tooltip-item	"AW->ActionTools->Bcycle"	"Cycle before"
					"Curve repeats itself before the first keyframe")  	;Cycle before 
	(ui-function-tooltip-item	"AW->ActionTools->Acycle"	"Cycle after"
					"Curve repeats itself after the last keyframe")  	;Cycle after 
	(ui-function-tooltip-item	"AW->ActionTools->BcycleOff"	"Cycle before with offset"
					"Curve repeats itself before the first keyframe, with offset")  	;Cycle before with offset 
	(ui-function-tooltip-item	"AW->ActionTools->AcycleOff"	"Cycle after with offset"
					"Curve repeats itself after the last keyframe, with offset")  	;Cycle after with offset 
	(ui-function-tooltip-item	"AW->ActionTools->Boscil"	"Oscillate before"
					"Curve repeats itself backwards and forwards before the first keyframe")  	;Oscillate before 
	(ui-function-tooltip-item	"AW->ActionTools->Aoscil"	"Oscillate after"
					"Curve repeats itself backwards and forwards after the last keyframe")  	;Oscillate after 
	(ui-function-tooltip-item	"AW->ActionTools->Blinear"	"Linear before"
					"Curve follows a straight line along the in-tangent of the first keyframe")  	;Linear before 
	(ui-function-tooltip-item	"AW->ActionTools->Alinear"	"Linear after"
					"Curve follows a straight line along the out-tangent of the last keyframe")  	;Linear after 
	(ui-function-tooltip-item	"AW->ActionTools->Bident"	"Identity before"
					"Curve continues in a 45-degree line before the first keyframe")  	;Identity before 
	(ui-function-tooltip-item	"AW->ActionTools->Aident"	"Identity after"
					"Curve continues in a 45-degree line after the last keyframe")  	;Identity after 
	(ui-function-tooltip-item	"AW->ActionTools->Comment"	"Comment"	"Add comments to actions")  ;Comment 
;;action menu: TangentType
	(ui-function-tooltip-item	"AW->Tangenttype->Smooth"	"Smooth" 
					"Make a smooth transition at the selected keyframe")  	;Smooth 
	(ui-function-tooltip-item	"AW->Tangenttype->Ilinear"	"Linear seg in"
					"Action is a straight line from the previous keyframe")  	;Linear seg in 
	(ui-function-tooltip-item	"AW->Tangenttype->Olinear"	"Linear seg out"
					"Action is a straight line to the next keyframe")  	;Linear seg out 
	(ui-function-tooltip-item	"AW->Tangenttype->Islow"	"Slow seg in"
					"Movement slows as it enters the selected keyframe")  	;Slow seg in 
	(ui-function-tooltip-item	"AW->Tangenttype->Oslow"	"Slow seg out"
					"Movement is slower as it leaves the selected keyframe, and then speeds up")  	;Slow seg out 
	(ui-function-tooltip-item	"AW->Tangenttype->Ifast"	"Fast seg in"
					"Movement speeds up as it enters the selected keyframe")  	;Fast seg in 
	(ui-function-tooltip-item	"AW->Tangenttype->Ofast"	"Fast seg out"
					"Movement is faster as it leaves the selected keyframe, and then slows down")  	;Fast seg out 
	(ui-function-tooltip-item	"AW->Tangenttype->InOut"	"In/Out"
					"Movement eases out of the keyframe, and eases in to the next keyframe")  	;In/Out 
	(ui-function-tooltip-item	"AW->Tangenttype->Flat"	"Flat"
					"In- and out-tangents of the new keyframe are horizontal")  	;Flat 
	(ui-function-tooltip-item	"AW->Tangenttype->Step"	"Step"	
					"The curve steps between the current and next keyframe")  	;Step 
	(ui-function-tooltip-item	"AW->Tangenttype->Fixed"	"Fixed" 
					"Tangents of selected keyframes are fixed, unless explicitly changed")  	;Fixed 
;;action menu: Preferences
	(ui-function-tooltip-item	"AW->Preferences->MarkingMenus"	"Edit marking menus")  	;Edit marking menus... 
	(ui-function-tooltip-item	"AW->Preferences->UpdModel"	"Toggle update model"
					"Action window changes update modeling windows at the same time")  	;Tgl update model 
	(ui-function-tooltip-item	"AW->Preferences->UpdModelOnXform"	"Tgl update model during Xform"
					"Action window changes update the model simultaneously/after they are made")  	;Tgl update model during Xform 
	(ui-function-tooltip-item	"ClsActionWindow"	"Close Action window")  	;Action Window... 
	(ui-function-tooltip-item	"AW->Preferences->ShortExpressions"	"Tgl short expressions"
					"Toggle short or long form for expressions")  	;Tgl short expressions 
;;menu: File
	(ui-function-tooltip-item	"NewFile"	"New file" "Create a new file") ; New 
	(ui-function-tooltip-item	"RetrieveStage"	"Open file" "Open a previously saved file"); Open 
	(ui-function-tooltip-item	"RecentFilesClear"	"Clear history" "Clear the list of recently opened files"); OpenRecent:Clear History
	(ui-function-tooltip-item	"StageSetRetrieve"	"Open stage set" "Open a stage set"); Open Stage Set
	(ui-function-tooltip-item	"SaveAll"	"Save" "Save changes to current file")  	;Save 
	(ui-function-tooltip-item	"SaveAllAs"	"Save as" "Save as a specific file name")  	;Save as 
	(ui-function-tooltip-item	"StageSetSave"	"Save stage set" "Save current stage set")  	;Save stageset 
	(ui-function-tooltip-item	"CheckPoint"	"Checkpoint" "Save or work with checkpoint backups")  	;Checkpoint 
	(ui-function-tooltip-item	"Retrieve"	"Import file" "Import contents of a file")  	;Import:File 
	(ui-function-tooltip-item	"RetrieveCloud"	"Import cloud" "Import point cloud data")  	;Import:Cloud 
	(ui-function-tooltip-item	"ImportAnim"	"Import animation" "Import animation data")  	;Import:Anim 
	(ui-function-tooltip-item	"ImportPaint"	"Import paint textures" "Import paint textures")  	;Import:Paint textures 
	(ui-function-tooltip-item	"NewImagePlane"	"Import image plane" "Import an image plane")  	;Import:Image plane
	(ui-function-tooltip-item	"ImportCanvas"	"Import canvas layer" "Import a canvas image layer")  	;Import:Image layer
	(ui-function-tooltip-item	"SaveActiveAs"	"Export active as" "Export wireframe scene information")  	;Export:Active as 
	(ui-function-tooltip-item	"SaveSDL"	"Export SDL" "Export rendering information as an SDL file")  	;Export:SDL 
	(ui-function-tooltip-item	"ExportAnim"	"Export animation" "Export animation channels")  	;Export:Anim 
	(ui-function-tooltip-item	"ExportPart"	"Export particles" "Export particles")  	;Export:Particles 
	(ui-function-tooltip-item	"SaveVRML"	"Export VRML 1" "Export model in VRML 1 format")  	;Export:VRML 1 
	(ui-function-tooltip-item	"Save_VRML2"	"Export VRML 2" "Export model in VRML 2 format")  	;Export:VRML 2 
	(ui-function-tooltip-item	"ExportSTL"	"Export STL" "Export model in STL format" )  	;Export:STL 
	(ui-function-tooltip-item	"ExportSLC"	"Export SLC" "Export model in SLC format")  	;Export:SLC 
	(ui-function-tooltip-item	"ExportPolygons"	"Export polygons" "Export model as polygons")  	;Export:Polygons 
	(ui-function-tooltip-item	"ExportRP"	"Export rapid prototype" "Export model for rapid prototyping" )  	;Export:Rapid Prototype 
	(ui-function-tooltip-item	"SaveScreen"	"Export screen" "Save the entire screen as an image file")  	;Export:Screen 
	(ui-function-tooltip-item	"SaveCurrentWindow"	"Export current window" "Save the current modeling window as an image file")  	;Export:Current window 
	(ui-function-tooltip-item	"ExportImageLayer"	"Export canvas layer"	"Export a sketch on an image layer")  	;Export:Image layer
	(ui-function-tooltip-item	"MakePicture"	"Make picture"	"Export all visible image layers as a single image")  	;Export:Make picture
	(ui-function-tooltip-item	"ReferenceManager"	"Reference manager"	"Open the Reference manager to load reference objects")  	;ReferenceManager
	(ui-function-tooltip-item	"PrintSetUp"	"Print setup" "Specify printing and plotting settings")  	;Output:Print setup
	(ui-function-tooltip-item	"PrintPreview"	"Print" "Preview what the current view and print settings will look like")  	;Output:Print preview
;remove following: no longer used?
;	(ui-function-tooltip-item	"Plot"		"Plot" "Send the model to a plotter")  	;Output:Plot... 
	(ui-function-tooltip-item	"List"		"Show list" "Show list of your files")  	;Show:List... 
	(ui-function-tooltip-item	"ShowImage"	"Show image" "View image files")  	;ShowImage
	(ui-function-tooltip-item	"FileRefList"	"Image references" "View and change paths to source image files")  	;ImageReferences:Image References...
	(ui-function-tooltip-item	"ExtractFileRefs"	"Extract image references" "Convert embedded images to image files")  	;ImageReferences:Extract Image References
	(ui-function-tooltip-item	"ExternalApps"	"External applications" "Run external applications")  	;External apps... 
; removed for V10:
;	(ui-function-tooltip-item	"EditSDL"	"Edit SDL" "Edit SDL files")  	;Edit SDL 
	(ui-function-tooltip-item	"Exit"		"Exit" "Exit Alias")  	;Exit 
;;menu: Edit
	(ui-function-tooltip-item	"Undo"		"Undo" "Undo previous action")  	;Undo 
	(ui-function-tooltip-item	"Redo"		"Redo" "Reverse the effects of the previous undo")  	;Redo
	(ui-function-tooltip-item	"ReInvokeFunction"	"Reinvoke last" "Reinvoke the last function you used")  	;Reinvoke last 
	(ui-function-tooltip-item	"Cut"		"Cut" "Copy selected objects to the clipboard and remove the originals")  	;Cut 
	(ui-function-tooltip-item	"CutImage"	"Cut image")  	;Cut Image
	(ui-function-tooltip-item	"Copy"		"Copy" "Copy selected objects to the clipboard")  	;Copy 
	(ui-function-tooltip-item	"CopyImage"	"Copy image")  	;Copy Image 
	(ui-function-tooltip-item	"Paste"		"Paste" "Paste objects from the clipboard")  	;Paste
	(ui-function-tooltip-item	"PasteImage"	"Paste image")  	;Paste Image
	(ui-function-tooltip-item	"CutKeyframes"	"Cut keyframes" "Cut animation keyframes")  	;Cut keyframes 
	(ui-function-tooltip-item	"CopyKeyframes"	"Copy keyframes" "Copy animation keyframes")  	;Copy keyframes 
	(ui-function-tooltip-item	"PasteKeyframes"	"Paste keyframes" "Paste animation keyframes")  	;Paste keyframes 
	(ui-function-tooltip-item	"ModelCopyGroupOn"	"Duplicate object" "Duplicate selected objects" )  	;Duplicate: object 
	(ui-function-tooltip-item	"DuplicateChannels"	
						"Duplicate channels" "Copy animation channels to another object" )  	;Duplicate: anim channels 
	(ui-function-tooltip-item	"OverlaySkeleton"	"Overlay skeleton" "Overlay skeleton attributes" )  	;Overlay skeleton 
	(ui-function-tooltip-item	"Mirror"	"Mirror" "Copy selected object across a world axis" )  	;Mirror 
	(ui-function-tooltip-item	"NewImage"	"Create image plane"	"Create new image plane")  	;New:Image plane (NT)
	(ui-function-tooltip-item	"SelHandleCreate"	"New selection handle" "Create selection handle")  	;New selection handle 
	(ui-function-tooltip-item	"CreateCluster"	"New cluster" "Create animation cluster")  	;New cluster 
	(ui-function-tooltip-item	"CreateSet"	"Create Set" "Create new set")  	;New set 
	(ui-function-tooltip-item	"Ungroup"	"Ungroup" "Ungroup grouped objects")  	;Ungroup 
	(ui-function-tooltip-item	"Group"		"Group" "Group selected objects")  	;Group 

	(ui-function-tooltip-item	"ChangeImage"		"Modify canvas plane"	"Resize a canvas plane")  	;Image layer:Modify canvas plane <NT>
	(ui-function-tooltip-item	"ZeroTransforms"	"Zero transforms" 
						"Apply transformations in hierachy to the last element")  	;Zero transforms 
	(ui-function-tooltip-item	"SetRestPose"	"Set rest pose" "Set rest pose for animation skeleton" )  	;Rest pose:Set rest pose 
	(ui-function-tooltip-item	"AssumeRestPose"	"Assume rest pose" "Assume rest pose for animation skeleton")  	;Rest pose:Assume rest pose 
	(ui-function-tooltip-item	"IKHandlesOnOff"	"IK handles on/off" "Toggle IK handles on/off" )  	;IK handles on/off 
	(ui-function-tooltip-item	"ConstraintsOnOff"	"Constraints on/off" "Toggle constraints on/off")  	;Constraints on/off 
;;menu: Delete
	(ui-function-tooltip-item	"DelActive"	"Delete active" "Delete active items")  	;Del active 
	(ui-function-tooltip-item	"DelConstrHistory"	"Delete construction history")  	;Del constr history 
	(ui-function-tooltip-item	"DE_DeleteGuidelines"	"Delete guidelines")  	;Del guidelines 
	(ui-function-tooltip-item	"LocatorDeleteAll"	"Delete locators" "Delete locators")  	;Del all locators 
	(ui-function-tooltip-item	"DeleteSelectionHandles" "Delete selection handles")  	;Del selection handles 
	(ui-function-tooltip-item	"DelChannels"	"Delete channels" "Delete animation channels")  	;Del channels 
	(ui-function-tooltip-item	"DelStaticActions"	"Delete static actions" "Delete static animation")  	;Del static actions 
	(ui-function-tooltip-item	"DelConstraints"	"Delete constraints")  	;Del constraints 
	(ui-function-tooltip-item	"DeleteImagePlanes"	"Delete image planes")  	;Del image planes 
	(ui-function-tooltip-item	"DelWindows"	"Delete windows" "Delete modeling or SBD windows")  	;Del windows 
	(ui-function-tooltip-item	"DelNullNodes"	"Delete null nodes" "Delete dag nodes with no attached geometry")  	;Del null nodes 
	(ui-function-tooltip-item	"DelProjTexture"	"Delete projective textures" "Delete projective textures")  	;Del projective textures 
	(ui-function-tooltip-item	"DelModel"	"Delete model" "Delete all objects in the model")
	(ui-function-tooltip-item	"deleteCanvasesFromConstPlane"	"Delete canvases from construction plane" 
								"Delete canvases from construction plane")	;Painting:Delete canvases from construction plane
	(ui-function-tooltip-item	"deleteCanvases"	"Delete canvases" "Delete canvases")	;Painting:Delete canvases
	(ui-function-tooltip-item	"deletelayer"	"Delete active image layer"	"Delete active image layer")  	;Painting:Del active image layer 
	(ui-function-tooltip-item	"deleteAllMasks"	"Delete all mask layers"	"Delete all mask layers")  	;Painting:Del all mask layers 
	(ui-function-tooltip-item	"ClearSketch"	"Delete sketch projections" "Delete sketch projection shaders")	;Painting:Delete sketch projection
;;menu: Layouts
	(ui-function-tooltip-item	"All"	"User windows" "View user windows")  	;All windows:User windows 
	(ui-function-tooltip-item	"All7"	"All windows" "View default Alias window layout" )  	;All windows:All windows
	(ui-function-tooltip-item	"All6"	"All (Top/Persp)" "View top and perspective windows")  	;All windows:All (Top/Persp) 
	(ui-function-tooltip-item	"All5"	"All (Front/Persp)" "View front and perspective windows")  	;All windows:All (Front/Persp) 
	(ui-function-tooltip-item	"All10"	"All (Back/Persp)" "View back and perspective windows")  	;All windows:All (Back/Persp) 
	(ui-function-tooltip-item	"All8"	"All (Right/Persp)" "View right and perspective windows")  	;All windows:All (Right/Persp) 
	(ui-function-tooltip-item	"All9"	"All (Left/Persp)" "View left and perspective windows")  	;All windows:All (Left/Persp) 
	(ui-function-tooltip-item	"All4"	"All (SketchPad)" "View all orthographic, two perspective windows")  	;All windows:All (SketchPad) 
	(ui-function-tooltip-item	"All3"	"All (Horizontal/Persp)" 
								"View all orthographic windows horizontally, with perspective window above")  	;All windows:All (Horizontal/Persp) 
	(ui-function-tooltip-item	"All2"	"All (Vertical/Persp)" 
								"View all orthographic windows vertically, with perspective window beside")  	;All windows:All (Vertical/Persp) 
	(ui-function-tooltip-item	"All1"	"All (Automotive)" "View layout for automobile design")  	;All windows:All (Automotive) 
	(ui-function-tooltip-item	"Perspective"	"Perspective" "Fill the screen with perspective view")  	;Perspective 
	(ui-function-tooltip-item	"Front"	"Front" "Fill the screen with front view")  	;Front 
	(ui-function-tooltip-item	"Back"	"Back" "Fill the screen with back view")  	;Back 
	(ui-function-tooltip-item	"Right"	"Right" "Fill the screen with right view")  	;Right 
	(ui-function-tooltip-item	"Left"	"Left" "Fill the screen with left view")  	;Left 
	(ui-function-tooltip-item	"Top"	"Top" "Fill the screen with top view")  	;Top 
	(ui-function-tooltip-item	"Bottom"	"Bottom" "Fill the screen with bottom view")  	;Bottom 
	(ui-function-tooltip-item	"PaintWindow"	"Paint" "Fill the screen with paint window")  	;Paint 
	(ui-function-tooltip-item	"New"	"New window" "Create a new modeling or paint window")  	;New window 
	(ui-function-tooltip-item	"FullScreen"	"Full screen" "Switch into full screen display mode")  	;Full screen 
	(ui-function-tooltip-item	"Display"	"Display/Hide" "Display or hide particular types of windows")  	;Display 
	(ui-function-tooltip-item	"Reopen"	"Reopen layout" "Reopens closed layout windows" )  	;Reopen 
	(ui-function-tooltip-item	"SaveLayout"	"Save layout" "Save current window layout")  	;User windows:Save 
	(ui-function-tooltip-item	"RetrieveLayout"	"Retrieve layout" "Retrieve previously saved layout")  	;User windows:Retrieve 
;;menu: ObjectDisplay
	(ui-function-tooltip-item	"DisplayControl"	"Control" "Hide or show surface and curve controls")  	;Control 
	(ui-function-tooltip-item	"DiagShadeEditor"	"Diagnostic shading" "Open the diagnostic shade window")  	;Diagnostic shading... 
	(ui-function-tooltip-item	"VisibleAll"	"Visible" "Show hidden objects")  	;Visible 
	(ui-function-tooltip-item	"Invisible"	"Invisible"  "Hide selected objects")  	;Invisible 
	(ui-function-tooltip-item	"HideUnselected"	"Hide unselected"  "Hide unselected objects")  	;Hide unselected 
	(ui-function-tooltip-item	"TglTemplate"	"Template" "Template selected objects")  	;Template 
	(ui-function-tooltip-item	"DrawStyle"	"Draw style" "Specify presentation of objects")  	;Draw style 
	(ui-function-tooltip-item	"LineStyle"	"Bone style" "Specify presentation of lines" )  	;Bone style 
	(ui-function-tooltip-item	"TglQuickWire"	"Quick Wire" "Toggle quick wire mode on/off")  	;Quick wire 
	(ui-function-tooltip-item	"TglSimpDisp"	"Display Simple" "Toggle level of detail displayed" )  	;Simple display 
	(ui-function-tooltip-item	"TglBoundingBox"	"Bounding box" "Toggle display from wireframes to bounding boxes" )  	;Bounding box 
;;menu: WindowDisplay
	(ui-function-tooltip-item	"TglGrid"	"Toggle grid" "Toggle grid display")  	;Window Toggles:Grid 
	(ui-function-tooltip-item	"TglLocators"	"Toggle locators" "Toggle locator display")  	;Window Toggles:Locator 
	(ui-function-tooltip-item	"TglCutin"	"Cut-in" "Toggle display of grid and cut-in screen")  	;Window Toggles:Cut-in 
	(ui-function-tooltip-item	"TglRenderStatus" "Toggle render status" 
								"Toggle display of render status")  	;Render Toggles:Render status 
	(ui-function-tooltip-item	"TglParticle"	"Toggle particles" 
								"Toggle display of particles")  	;Render Toggles:Particles 

	(ui-function-tooltip-item	"TglLights"	"Toggle lights" "Toggle display of lights")  	;Object Toggles:Lights 
	(ui-function-tooltip-item	"TglCamera"	"Toggle cameras" "Toggle display of cameras")  	;Object Toggles:Camera 
	(ui-function-tooltip-item	"TglCloud"	"Toggle clouds" "Toggle display of clouds")  	;Object Toggles:Clouds 
	(ui-function-tooltip-item	"TglConstPlanes"	"Toggle construction objects"
								"Toggle display of construction objects" );Object Toggles:Const objects 
	(ui-function-tooltip-item	"TglImagePlanes"	"Toggle image planes" 
								"Toggle display of image planes") ;Object Toggles:Image planes 
	(ui-function-tooltip-item	"TglSidCanvases"	"Toggle canvas planes" 
								"Toggle display of canvas planes") ;Object Toggles:Canvas planes 
	(ui-function-tooltip-item	"TglSkeleton"	"Toggle skeletons"
								"Toggle display of skeletons" )  	;Object Toggles:Skeletons 
	(ui-function-tooltip-item	"TglTextures"	"Toggle textures"
								"Toggle display of textures")  	;Object Toggles:Textures 
	(ui-function-tooltip-item	"TglShade"	"Hardware shade" 
								"Toggle between wireframe and shaded views")  	;Shade 
	(ui-function-tooltip-item	"TglHiddenLine"	"Hidden line" "Hide or show back facing wireframe lines")  	;Hidden line 
	(ui-function-tooltip-item	"Title_Bar"	"Title bar" "Hide or show the model view title bars" )  	;Title bar 
	(ui-function-tooltip-item	"TglWindowSync"	"Window sync" "Toggle synchronization of orthographic windows" )  	;Window sync 
	(ui-function-tooltip-item	"TglAntiAliasLines"	"Wireframe anti-alias" "Toggle or adjust the anti-aliasing of model wireframes")  	;Anti-Alias:Wireframe Anti-Alias
	(ui-function-tooltip-item	"TglAntiAliasSurfaces"	"Shaded anti-alias" "Toggle or adjust the anti-aliasing of shaded surfaces")  	;Anti-Alias:Shaded Anti-Alias
	(ui-function-tooltip-item	"TransparencyDisplay"	"Transparency" "Adjust the transparency of different types of objects in the view")  	;Transparency 
	(ui-function-tooltip-item	"XrayControls"	"Xray" "Control which components show through shaded surfaces")  	;Xray Controls 
	(ui-function-tooltip-item	"VisibilityDisplay"	"Show" "Change multiple show display states simultaneously")  	;Show 
	(ui-function-tooltip-item	"TglModel"	"Toggle model" "Toggle display of wireframes")  	;Model 
	(ui-function-tooltip-item	"TglSmooth"	"Smooth" "Toggle smoothing of lines and surfaces" )  	;Smooth 
	(ui-function-tooltip-item	"PolyControl"	"Toggle polygon control" "Change display of polygons")  	;Polygon control 
	(ui-function-tooltip-item	"TglPivots"	"Toggle pivots" "Toggle display of pivots")  	;Pivots 
	(ui-function-tooltip-item	"DE_ToggleGuidelines"	"Toggle guidelines" "Toggle display of guidelines");Guidelines 
	(ui-function-tooltip-item	"TglSelectionHandles"	"Toggle selection handles" "Toggle display of selection handles");Selection handles 
	(ui-function-tooltip-item	"TglIKHandles"	"Toggle IK handles" "Toggle display of IK handles" )  	;Ik handles 
	(ui-function-tooltip-item	"TglConstraints"	"Toggle constraints" "Toggle display of constraints" );Constraints 
	(ui-function-tooltip-item   "statusbar"	"Status Bar" "Toggle display of the status bar (lower left of main window)" )  	;Status Bar
;;menu: Layers
	(ui-function-tooltip-item	"LayerNew"	"New layer" "Create a new layer")  	;New
	(ui-function-tooltip-item	"AssignToConstructionlayer"	"Assign Objects" "Assign selected objects to the current construction layer")  	;Assign Objects
	(ui-function-tooltip-item	"LayerPickObjects"	"Select objects on selected layers" 
								"Pick objects on selected layers" )  	;Select:Objects on selected layers 
	(ui-function-tooltip-item	"LayerSelectByActiveDags"	"Select layers by picked objects" 
								"Select all layers with picked objects")  	;Select:Layers by picked objects 
	(ui-function-tooltip-item	"LayerSelectAll"	"Select all layers")  	;Select:All Layers 
	(ui-function-tooltip-item	"LayerRange"		"Select layer range" 
								"Select a range of layers" )  	;Select:Layer Range 
	(ui-function-tooltip-item	"LayerSetPickable"	"Set layer pickable" 
								"Make objects in the layer pickable")  	;Set State:Pickable 
	(ui-function-tooltip-item	"LayerSetSnap"		"Set layer reference" 
								"Make objects in the layer snappable (but not pickable)") ;Set State:Reference 
	(ui-function-tooltip-item	"LayerSetInActive"	"Set layer inactive" 
								"Make objects in the layer inactive")  	;Set State:Inactive 
	(ui-function-tooltip-item	"LayerDelete"		"Delete selected layers"	"Delete selected layers")  	;Delete:Selected 
	(ui-function-tooltip-item	"LayerDeleteUnassigned"	"Delete unused layers"	"Delete unused layers")  	;Delete:Unused 
	(ui-function-tooltip-item	"LayerDeleteDuplicate"	"Merge duplicate layers"	"Merge duplicate layers")  	;Delete:Merge duplicate layers 
	(ui-function-tooltip-item	"LayerMakeVisible"	"Set layer visible"
								"Make objects in selected layers visible")  	;Visibility:Visible 
	(ui-function-tooltip-item	"LayerMakeInvisible"	"Set layer invisible"
								"Make objects in selected layers invisible")  	;Visibility:Invisible 
	(ui-function-tooltip-item	"LayerMakeSymmetric"	"Layer symmetry on"
								"Show mirrored half of objects in layer")  	;Symmetry:On 
	(ui-function-tooltip-item	"LayerMakeUnsymmetric"	"Layer symmetry off"
								"Hide mirrored half of objects in layer")  	;Symmetry:Off 
	(ui-function-tooltip-item	"LayerSetSymmPlane"	"Set layer symmetry plane"
								"Define plane of symmetry for layer")  	;Symmetry:Set plane 
	(ui-function-tooltip-item	"LayerCreateSymmGeometry"	"Create symmetric geometry"
								"Convert the mirrored layer geometry into real geometry")  	;Symmetry:Create geometry 
	(ui-function-tooltip-item	"LayerAnimationON"	"Layer playback on"
								"Show animation playback for objects in layer")  	;Playback:Playback ON 
	(ui-function-tooltip-item	"LayerAnimationOFF"	"Layer playback off"
								"Hide animation playback for objects in layer")  	;Playback:Playback OFF 
	(ui-function-tooltip-item	"LayerSetCreation"	"Set creation layer"
								"Set a creation layer by typing its name or number")  	;Set creation layer 
	(ui-function-tooltip-item	"LayerAssign"		"Assign to layer"
								"Assign selected objects to a layer by typing its name")  	;Assign to layer 
	(ui-function-tooltip-item	"LayerUndoAssign"	"Undo layer assign"
								"Assign selected objects to default layer" )  	;Undo assign 
	(ui-function-tooltip-item	"TglLayers"		"Toggle layers"
								"Enable/Disable all layers and layer tools")  	;Tgl layers 
	(ui-function-tooltip-item	"TglLayerList"		"Toggle layer bar"
								"Toggle display of layer bar")  	;Tgl Layers Bar 
	(ui-function-tooltip-item	"LayerTglEmpty"	"Toggle unused layers"
								"Toggle display of unused layers")  	;Tgl unused layers
;;menu: Canvas
	(ui-function-tooltip-item	"NewCanvas"	"New canvas"    "Create a new paint canvas")  	;New canvas
	(ui-function-tooltip-item	"AddPaint"	"New canvas on construction plane"
                                "Create a new paint canvas on a construction plane")  	;New canvas on construction plane
	(ui-function-tooltip-item	"NewOverlay"	"New overlay canvas"    "Create a new overlay canvas")  	;New overlay canvas
	(ui-function-tooltip-item	"ResizeCanvas"	"Resize canvas" "Interactively adjust the size or position of a canvas")  	;Resize canvas
	(ui-function-tooltip-item	"CropImagePlane"	"Crop to marquee"   "Interactively crop or extend a canvas")  	;Crop to marquee
	(ui-function-tooltip-item	"ProjectSketch"	"Project sketch" "Apply canvas paint to geometry, creating a matching shader")


	(ui-function-tooltip-item	"CutImage"	"Cut image")  	;Cut Image
	(ui-function-tooltip-item	"CopyImage"	"Copy image")  	;Copy Image 
	(ui-function-tooltip-item	"PasteImage"	"Paste image")  	;Paste Image
	(ui-function-tooltip-item	"NewImage"	"Create image plane"	"Create new image plane")  	;New:Image plane (NT)
	(ui-function-tooltip-item	"PaintLayerShowHiddenPaint"	"Show hidden paint"	"Show hidden paint in the image layer")  	;Modify layer: Show hidden paint <NT>
	(ui-function-tooltip-item	"PaintLayerDeleteHiddenPaint"	"Clear hidden paint"	"Remove hidden paint from the image layer")  ;Modify layer: Clear hidden paint <NT>
	(ui-function-tooltip-item	"PaintClrSelMask"	"Clear selection mask"	"Remove objects in the selection mask")  	;Modify layer: Clear selection mask <NT>
	(ui-function-tooltip-item	"InvertMaskLayer"	"Invert layer mask"	"Invert the layer mask")  	;Modify layer: Invert layer mask <NT>
	(ui-function-tooltip-item	"FlipHorizontalVerticalLayer"	"Horizontal and vertical flip"	
						"Flip the image layer both horizontally and vertically")  	;Effect: Horizontal and vertical flip <NT>
	(ui-function-tooltip-item	"toggle2DPanel"		"Tgl paint panel"	"Use the paint panel to update brushes and shapes")  	;Tgl paint panel <NT>
	(ui-function-tooltip-item	"SwitchToPaintUI"	"Paint default UI"	"Set up the window for painting and sketching")  	;Paint Default UI <NT>
	(ui-function-tooltip-item	"SwitchToModelingUI"	"Modeling default UI"	"Set up the window for modeling")  	;Modeling Default UI<NT>
;;menu: Render
	(ui-function-tooltip-item	"RO_Renderer"	"Render" "Create one or a sequence of images with a software renderer")  	;Render 
	(ui-function-tooltip-item	"ApplyShaders"	"Apply shaders" "Dynamically apply shaders to one or more surfaces")  	;Apply shaders
	(ui-function-tooltip-item	"Globals"	"Render globals" "View or edit render settings for the entire scene")  	;Globals... 
	(ui-function-tooltip-item	"RenderStats"	"Render stats" "Edit and optimize the rendering attributes of surfaces")  	;Editors: Render stats ... 
	(ui-function-tooltip-item	"LinkEditor"	"Light links" "Link lights to surfaces, and manage these links")  ;Editors: Light links... 
	(ui-function-tooltip-item	"DirectRender"	"Direct render" "Render the active window directly on screen")  	;Direct render 
	(ui-function-tooltip-item	"QuickTimeVR"	"Render to quicktimeVR" "Create a QuickTimeVR file from screen or from a software render")  	;Render to QuickTimeVR 
	(ui-function-tooltip-item	"MovieRender"	"Convert frames to movie" "Create a QuickTime or Avi file from a sequence of frames")  	;Convert frames to Movie
	(ui-function-tooltip-item	"BakeOcclusion"	"Compute occlusion" "Create general areas of shadow on a nurbs surface")  	;Ambient Occlusion: Compute
	(ui-function-tooltip-item	"DeleteOcclusion"	"Delete occlusion" "Remove ambient occlusion from the scene or from selected objects")  	;Ambient Occlusion: Delete
	(ui-function-tooltip-item	"ToggleOcclusion"	"Toggle occlusion" "Toggle the display of ambient occlusion on or off")  	;Ambient Occlusion: Toggle display


;;menu: Animation
	(ui-function-tooltip-item	"SetKeyframeCurrent"	"Set keyframe" "Set keyframe animation")  	;Set keyframe 
	(ui-function-tooltip-item	"AutoKeyframeCurrent"	"Auto keyframe" "Set keyframes automatically when parameters change value")  	;Auto keyframe 
	(ui-function-tooltip-item	"Playback"	"Playback" "Play back animation")  	;Playback 
	(ui-function-tooltip-item	"PlaybackOptions"	"Playback options" "Change playback options" )  	;Playback options... 
	(ui-function-tooltip-item	"ParamControl"	"Animation parameter control" "Set global and local animatable properties")  	;Param control... 
	(ui-function-tooltip-item	"ActionWindow"	"Action window" "Use the Action window to create and work with keyframes" )  	;Action window... 
	(ui-function-tooltip-item	"TimeSlider"	"Toggle time slider" 
								"Toggle display of the animation time slider")  	;Tgl time slider... 
	(ui-function-tooltip-item	"RunIk"		"Run IK" "Animate the IK handles attached to a skeleton")  	;Run IK 
	(ui-function-tooltip-item	"MotionDynamics"	"Run dynamics" "Run a dynamics simulation" )  	;Run dynamics 
	(ui-function-tooltip-item	"Turntable"	"Turntable" 
								"Turntable animation (circle around a pivot)")  	;Turntable 
	(ui-function-tooltip-item	"SimpleTurntable"	"Turntable" 
								"Turntable animation ")  	;Simpler version of Turntable for StudioViewer
	(ui-function-tooltip-item	"NewTimeWarp"	"New time warp" "Apply a time warp")  	;Time Warps:New time warp 
	(ui-function-tooltip-item	"Cycles"	"New cycles warp" 
								"Cycle through sections of animation with a time warp")  	;Time Warps:New cycles warp 
	(ui-function-tooltip-item	"TimeScale"	"New scale warp" 
								"Scale animation timing with a time warp")  	;Time Warps:New scale warp 

    ; Flipbook is replaced by Fcheck on NT (but both use the same command name)
    (if (ui-symbol-true "using_nt_os") 
			(ui-function-tooltip-item	"Flipbook"	"Fcheck" "View images using the fcheck utility")
       )
    (if (not(ui-symbol-true "using_nt_os"))
			(ui-function-tooltip-item	"Flipbook"	"Flipbook" "Preview rendered animation")
       )

	(ui-function-tooltip-item	"MoviePlayer"	"SGI Movie/QuickTime" 
								"Create SGI and Apple format movie files")  	;SGI Movie/QuickTime 

;;menu: Windows
	(ui-function-tooltip-item	"ToolBox"	"Palette" 
								"Toggle display of the tool palette")  	;Palette... 
	(ui-function-tooltip-item	"ToolShelfs"	"Shelves"
								"Toggle display of the shelves")  	;Shelves... 
	(ui-function-tooltip-item	"InfoWindow"	"Information window"
								"View and edit information for selected objects")  	;Information:Information window... 
	(ui-function-tooltip-item	"LayerStats"	"Layer stats" 	
								"View modeling layers and their attributes")  	;Information:Layer stats... 
	(ui-function-tooltip-item	"ModelLayersCategory"	"Layer categories" 	
								"Create groups of modeling layers for ease of selection")  	;Information:Layer categories... 
	(ui-function-tooltip-item	"DeviationTable"	"Deviation table"
								"View detailed numeric information for a deviation comb")  	;Information:Deviation table... 
	(ui-function-tooltip-item	"CmdHistory"	"History view"
								"View or edit object history")  	;Information:History view 
	(ui-function-tooltip-item	"ConstructionPlaneLister"	"Construction plane editor"
								"View or edit construction planes")  	;Editors:Construction plane editor...
	(ui-function-tooltip-item	"PaintLayerLister"	"Canvas layer editor"	
                                "Create or edit image, mask or shape layers")  	;Editors:Canvas layer editor...
	(ui-function-tooltip-item	"ControlPanelEditorToggleOpen"	"Shape editor"	
                                "Make changes to paint shapes")  	;Editors:Shape editor...
	(ui-function-tooltip-item	"CrossSectionManager"	"Cross section manager"	
                                "Create and edit cross sections on nurbs or mesh data")  	;Editors:Cross section manager...
	(ui-function-tooltip-item	"ObjectLister"	"Object lister"	
                                "View objects and their hierarchies in the scene")  	;Object lister...
	(ui-function-tooltip-item	"BookMarkLister"	"Variant lister"
								"Toggle display of the Variant Lister")  	;Variant lister... 
	(ui-function-tooltip-item	"MlistAll"	"Multi-lister: List all" 
								"View multi-lister with all swatches")  	;Multi-lister:List all... 
	(ui-function-tooltip-item	"MlistPicked"	"Multi-lister: Picked" 
								"View multi-lister with only those swatches assigned to active objects")  ;Multi-lister:Picked... 
	(ui-function-tooltip-item	"MlistShaders"	"Multi-lister: Shaders" 
								"View multi-lister with shader swatches")  	;Multi-lister:Shaders... 
	(ui-function-tooltip-item	"MlistLights"	"Multi-lister: Lights"
								"View multi-lister with light swatches")  	;Multi-lister:Lights... 
	(ui-function-tooltip-item	"MlistGlows"	"Multi-lister: Glows"
								"View multi-lister with glow swatches")  	;Multi-lister:Glows... 

; remove for FOD  FocusOnDesign
 	(ui-function-tooltip-item	"MlistForces"	"Multi-lister: Forces"
 		"View multi-lister with force swatches")  	;Multi-lister:Forces... 

	(ui-function-tooltip-item	"MlistParticles"	"Multi-lister: Particles"
								"View multi-lister with particle swatches")  ;Multi-lister:Particles... 

; remove for FOD  FocusOnDesign
 	(ui-function-tooltip-item	"MlistDeformations"	"Multi-lister: Warps"
 		"View multi-lister with warp swatches")  	;Multi-lister:Warps... 

	(ui-function-tooltip-item	"AnimStats"	"Anim stats"
								"View animation attributes for selected DAG nodes")  	;Information:Anim stats... 
	(ui-function-tooltip-item	"AnimInfo"	"Scene info"
								"View all attributes for a scene file")  	;Information:Scene info... 
	(ui-function-tooltip-item	"StageEdit"	"Stages" "View and work with stages")  	;Edit:Stages... 
 	(ui-function-tooltip-item   	"CameraEditor"	"Cameras" 
								"Change properties of cameras and canvas planes")  	;Edit:Cameras... 
	(ui-function-tooltip-item	"SkeletonEditor"	"Skeletons" 
								"Create and change the properties of joints in skeletons")  	;Edit:Skeletons... 
	(ui-function-tooltip-item	"EditCluster"	"Clusters" "Edit cluster attributes")  	;Edit:Clusters... 
	(ui-function-tooltip-item	"ColorSwatch"	"Color swatch" "Use the color swatch to change colors")  	;Edit:Color swatch... 
	(ui-function-tooltip-item	"SetLister"	"Set lister" "Select or deselect sets")  	;Sets:Set lister... 
	(ui-function-tooltip-item	"EditSet"	"Edit set" "Edit set properties (members, names, types")  	;Sets:Edit set... 
	(ui-function-tooltip-item	"DeformationCntrl"	"Deformation control"
								"Open the Deformation Control window to work with CV clusters")  	;Deformation cntrl... 
	(ui-function-tooltip-item	"ExpressionWin"	"Expression controls"
								"Edit expression controls")  	;Expression controls... 
;;menu: Preferences
	(ui-function-tooltip-item	"ShortMenus"	"Short menus" "Switch to short menus")  	;Menus: Short menus
	(ui-function-tooltip-item	"LongMenus"	"Long menus" "Switch to long menus")  	;Menus: Long menus 
	(ui-function-tooltip-item	"default3D_activate"	"Default workflow" "Switch application into default workflow ")  	;Workflows: Default
	(ui-function-tooltip-item	"modeling_activate"	"Modeling workflow" "Switch application into modeling workflow ")  	;Workflows: Modeling
	(ui-function-tooltip-item	"paint_activate"	"Paint workflow" "Switch application into paint workflow ")  	;Workflows: Paint
	(ui-function-tooltip-item	"render_activate"	"Visualize workflow" "Switch application into visualize workflow ")  	;Workflows: Render
	(ui-function-tooltip-item	"EditHotKeys"	"Hotkeys/menu editor" "Customize hotkeys and menus")  	;Interface:Hotkeys / Menu editor... 
	(ui-function-tooltip-item	"ClutchKeys"	"Clutch Key editor" "Customize Clutch Keys")  	;Interface:Clutch Key editor...
	(ui-function-tooltip-item	"SingleHotKeys"	"Toggle single hotkeys" "Use single key hotkeys without key modifiers" )  	;Tgl single hotkeys mode 
	(ui-function-tooltip-item	"PaletteLayout"	"Palette/shelves layout" "Tile the palette, shelf and main window" )  	;Interface:Palette/Shelves layout 
	(ui-function-tooltip-item	"ShelfExtras_action_function"	"Shelf extras" "Insert icons to organize custom shelf content")  	;Interface:Shelf extras...
	(ui-function-tooltip-item	"color_themes_sub" "Color Themes" "Choose dark/light/customized color themes")      ;Color Theme Editor (UserColors)
	(ui-function-tooltip-item	"Configure"	"General preferences" "Customize general application preferences")  	;General preferences...
	(ui-function-tooltip-item	"SelectionOptions"	"Selection options" "Change mouse selection behavior in the application")  	;Selection Options
	(ui-function-tooltip-item	"UpdateWin"	"Performance options" "Optimize which scene elements undergo an update and when")  	;Performance options... 
	(ui-function-tooltip-item	"ConstructionOptions"	"Construction options" "Set construction units and tolerances for modeling")  	;Construction options... 
	(ui-function-tooltip-item	"RestoreOptions"	"Retrieve options" "Retrieve previously saved user options settings")  	;User Options:Retrieve options 
	(ui-function-tooltip-item	"SaveOptions"	"Save options" "Save your user options settings")  	;User Options:Save options 
	(ui-function-tooltip-item	"LoadPrefSet"	"Load preference set" 
                                "Modify your layout and preferences with a previously saved preference set") 	;User Preferences:Load preference set...
	(ui-function-tooltip-item	"SavePrefSet"	"Save preference set" 
                                "Save your layout and preferences for use by another user or on another machine") 	;User Preferences:Load preference set...

	(ui-function-tooltip-item	"MarkingMenuSwitch_Standard"	"Standard marking menu" "Use standard marking menu (default)")  ;Marking menus: Standard marking menu
	(ui-function-tooltip-item	"MarkingMenuSwitch_Paint"	"2D marking menu" "Switch to 2D (paint) marking menu")  	;Marking menus: 2D marking menu
	(ui-function-tooltip-item	"MarkingMenuEdit"	"Marking menus" "Customize marking menus")  	;Interface:Marking menus... 
	(ui-function-tooltip-item	"ToggleControlPanel"	"Control panel" 
								"Toggle display of the control panel")  	;Windows:Control Panel
	(ui-function-tooltip-item   "RebuildParent"    "Rebuild Parent" 
                                "Rebuild Parent")      ;Rebuild Parent  
	(ui-function-tooltip-item	"EditAliasPreferences"	"Alias preferences"
								"Change the Alias preferences")  	;Alias preferences... 
								
	(ui-function-tooltip-item   "LoadDarkTheme"     "Dark Theme"    "Set color theme to drak")
	(ui-function-tooltip-item   "LoadDarkTheme"     "Light Theme"    "Set color theme to light")
	(ui-function-tooltip-item   "LoadDarkTheme"     "Customize..."    "Customize color theme")

;;menu: Utilities

	(ui-function-tooltip-item	"PIM_Manager"	"Plug-in manager"   "Load plug-ins for extra functionality")  	;Plug-in Manager...
	(ui-function-tooltip-item	"cstepEdit"	"Command set"
								"Create sequence of tools and menu items to use again")  	;Command stepper:Command set... 
	(ui-function-tooltip-item	"cstepForward"	"Step forward" 
								"Step forward through the command stepper")  	;Command stepper:Step forward 
	(ui-function-tooltip-item	"cstepBackward"	"Step backward"
								"Step backward through the command stepper")  	;Command stepper:Step backward 
	(ui-function-tooltip-item	"cstepRestart"	"Command step restart"
								"Restart the command stepper sequence")  	;Command stepper:Restart 
	(ui-function-tooltip-item	"Sbd"	"SBD window" "Open or close the SBD window")  	;SBD:SBD Window
	(ui-function-tooltip-item	"CompressSbd"	"Compress SBD" "Collapse SBD hierarchies into single nodes")  	;SBD:Comrpress SBD
	(ui-function-tooltip-item	"ExpandSbd"	"Expand SBD" "Expand compressed SBD hierarchies")  	;SBD:Expand SBD 
	(ui-function-tooltip-item	"SysInfoManualCheck"	"System diagnostics"	"Evaluate hardware and driver compatibility")  	;System Information:System Diagnostics...
	(ui-function-tooltip-item	"SysInfoOpenLog"	"System diagnostics log"	"Display last system diagnostics run")  	;System Information:System Diagnostics Log...
	(ui-function-tooltip-item	"ViewErrlog"	"Errlog" "Show any errors logged during the current or earlier sessions")  	;Error log...

;;menu: Help
	(ui-function-tooltip-item	"OnlineDocs"	"Alias help" "View online help documentation")  	;Alias Help 
	(ui-function-tooltip-item	"KeyMapHelp"	"Show modifier keys" "View details on modifier keys")  	;Show modifier keys 
   	(ui-function-tooltip-item	"DesignReasons"	"Why Alias Design" "View compelling reasons to use Alias Design" )  	;Why Alias Design
	(ui-function-tooltip-item   "LearningMovies"	"Essential Skills" "View Alias Essential Skills Movies") ;Essential Skills
	(ui-function-tooltip-item   "LearningStudio"	"Learning Alias" "View Alias Tutorials") ; Tutorials
    (ui-function-tooltip-item   "WhatsNewHelp"	"What's new" "View information about changes in this version of Alias")  	;Whats New
    (ui-function-tooltip-item   "WhatsNewMovies"	"What's new movies" "Watch movies illustrating changes in this version of Alias")  	;Whats New Movies
    (ui-function-tooltip-item   "AliasWavefrontSupport"	"Support Center" "Contact the Support Center")  	;Support Center
    (ui-function-tooltip-item   "SustainableDesign"	"Sustainable Design" "Explore Autodesk's Sustainable Design initiatives")  	;Sustainable Design
    (ui-function-tooltip-item   "AliasWavefrontCommunity"	"Alias Design Community" "Visit the Alias Design Community")  	;Alias Design Community
   	(ui-function-tooltip-item	"AliasSampleFiles"	"Sample files" "Download sample, courseware, and documentation PDF files" )  	;Sample Files
    (ui-function-tooltip-item   "DAOption"	"Desktop Analytics Program" "Participate in the Desktop Analytics Program")  	;Desktop Analytics Program
    (ui-function-tooltip-item   "reportProblem"	"Report a problem" "Report a Problem")  	;Report a Problem
    (ui-function-tooltip-item   "suggestFeature"	"Suggest a feature" "Suggest a Feature")  	;Suggest a Feature
	(ui-function-tooltip-item   "visitIdeaStation"	"visit IdeaStation" "visit IdeaStation")  	;visit IdeaStation
    (ui-function-tooltip-item   "AliasWavefrontEStore"	"Autodesk Online Store" "Visit the Autodesk online store")  	;Autodesk Online Store
	(ui-function-tooltip-item	"CommandSearch"	"Tool locator" "Find a tool or menu in the application")  	;Tool Locator
	(ui-function-tooltip-item	"FunctionHelp"	"What's this?" "View help on a tool or menu (select tool or menu after invoking)")  	;Help on function 
   	(ui-function-tooltip-item	"SystemInfo"	"About Alias" "Information about Alias" )  	;About Alias

;;ControlPanelTools: Evaluate
	(ui-function-tooltip-item	"moveCV"	"Transform CV" "Transform CVs and hulls")  	;Move CV 
	(ui-function-tooltip-item	"scansurf_deviation"	"Show deviations" 
								"Measure scan data to surface deviation")  	;ScanSurfDeviation 
	(ui-function-tooltip-item	"mbCurveCurvature"	"Curvature" 
								"Check curvature with combs and color maps")  	;Curvature 
;;Palette: Pick
	(ui-function-tooltip-item	"Nothing"	"Pick nothing" "De-select all active objects")  	;Nothing 
	(ui-function-tooltip-item	"Object"	"Pick object" "Pick one or more objects")  	;Object 
	(ui-function-tooltip-item	"SelectionSet"	"Pick selection set" "Pick one or more selection sets")  	;Object 
	(ui-function-tooltip-item	"Component"	"Pick component" "Pick individual object components")  	;Component 
	(ui-function-tooltip-item	"Template"	"Pick template" "Pick one or more templated objects")  	;Template 
	(ui-function-tooltip-item	"EditPoint"	"Pick edit point" "Pick one or more edit points")  	;Edit point 
	(ui-function-tooltip-item	"CV"	"Pick CV" "Pick one or more control vertices (CVs)")  	;Point Types:CV 
	(ui-function-tooltip-item	"Hull"	"Pick hull" "Pick one or more control hulls")  	;Point Types:Hull 
	(ui-function-tooltip-item	"Cluster"	"Pick cluster" "Pick a cluster node")  	;Point Types:Cluster 
	(ui-function-tooltip-item	"BlendPoint"	"Pick blend point"	"Pick blend points")  	;Point Types:Blend point 
	(ui-function-tooltip-item	"Joint"	"Pick joint" "Pick a joint node")  	;Joint 
	(ui-function-tooltip-item	"IK_Handle"	"Pick IK handle" "Pick an IK handle")  	;IK handle 
	(ui-function-tooltip-item	"CurveOnSurf"	"Pick curve-on-surface" "Pick one or more curves-on-surface")  	;Object Types:Curve on surf 
	(ui-function-tooltip-item	"PickByShader"	"Pick by shader"		"Pick one or more shaded objects")

    ; On NT, PickImagePlane/PickImageLayer are swapped into same TuiChoice based on an option setting
	; On Unix, there is only one function (PickImagePlane)
    (if (ui-symbol-true "using_nt_os")
		(begin
			(ui-function-tooltip-item	"PickImagePlane" "Pick image plane" 
										"Pick one or more image planes (change option setting to pick image layers)")	
 			(ui-function-tooltip-item	"PickImageLayer" "Pick image layer" 
										"Pick one or more image layers (change option setting to pick image planes)")
			)
       )
    (if (not(ui-symbol-true "using_nt_os"))
			(ui-function-tooltip-item	"PickImagePlane" "Pick image plane" 
										"Pick one or more image planes")	
       )

	(ui-function-tooltip-item	"AllObjLights"	"Pick all obj/lights" "Pick all objects and lights in a scene")  	;Object Types:All obj/lights 
	(ui-function-tooltip-item	"SelectionHandle"	"Pick selection handle" 
						"Pick objects by clicking on selection handles")  	;Object Types:Selection handle 
	(ui-function-tooltip-item	"CloudPick"	"Pick cloud" "Pick a point cloud by picking one of its points")  	;Cloud 
	(ui-function-tooltip-item	"Locator"	"Pick locator" "Pick one or more locators")  	;Pick locator 
;;Palette: Xform
	(ui-function-tooltip-item	"Move"	"Move"	"Move selected objects")  	;Move 
	(ui-function-tooltip-item	"Rotate"	"Rotate"	"Rotate selected objects")  	;Rotate 
	(ui-function-tooltip-item	"Scale"	"Scale"	"Change the size of selected objects (uniformly, in all dimensions)")  	;Scale 
	(ui-function-tooltip-item	"NonpScale"	"Non proportional scale"	
						"Change the size of selected objects in one or more dimensions")  	;Nonp scale 
	(ui-function-tooltip-item	"PropMove"	"Proportional modification"	
						"Deform the area on a curve or surface surrounding one or more CVs")  ;Modify:Proportional mod 
	(ui-function-tooltip-item	"MoveCVNormal"	"Move CV normal" 
						"Deform geometry by moving its CVs along a normal or tangent")  	;Modify:Move CV normal 
	(ui-function-tooltip-item	"RotationalScale"	"Rotational scale" 
						"Deform curves and surfaces about a pivot point")  	;Modify:Rotational scale
	(ui-function-tooltip-item	"SetPivot"	"Set pivot" 
						"Move the rotation/scaling pivot points of objects")  	;Local:Set pivot 
	(ui-function-tooltip-item	"CenterPivot"	"Center pivot" "Center the pivot point of an object")  	;Local:Center pivot 
	(ui-function-tooltip-item	"SetLocalAxes"	"Set local axes" "Set local axes")  	;Local:Set local axes 
	(ui-function-tooltip-item	"SelHandleMove"	"Move selection handle" "Move selection handles")  	;Local:Move selection handle 
	(ui-function-tooltip-item	"DE_DragKeypoint"	"Drag keypoints" "Edit keypoint curves by moving their keypoints")  	;Drag keypoints 
	(ui-function-tooltip-item	"PlaceProjection"	"Place projection"	"Project texture placement objects")  	;Place projection 
	(ui-function-tooltip-item	"ArrayTool"	"Array"	"Create an array of objects")  	;Array
	(ui-function-tooltip-item	"PathArray"	"Path array"	"Create an array of objects along a path")  	;Path array
;;Palette: Paint
	(ui-function-tooltip-item	"PencilDefault"	"Pencil"	
								"Apply a pencil stroke to the active image layer")  	;Pencil:Pencil
	(ui-function-tooltip-item	"PencilRound"	"Pencil round"	
								"Apply a round pencil stroke to the active image layer")  	;Pencil:Pencil Round

;;Palette: Paint (SurfaceStudio Pencils only)
	(ui-function-tooltip-item	"Pencil2BBlack"	"Black pencil"	
								"Apply a black pencil stroke to the active image layer")  	;Pencil:Black pencil
	(ui-function-tooltip-item	"Pencil2BWhite"	"White pencil"	
								"Apply a white pencil stroke to the active image layer")  	;Pencil:White pencil 
	(ui-function-tooltip-item	"Pencil2BRed"	"Red pencil"	
								"Apply a red pencil stroke to the active image layer")  	;Pencil:Red pencil
	(ui-function-tooltip-item	"Pencil2BBlue"	"Blue pencil"	
								"Apply a blue pencil stroke to the active image layer")  	;Pencil:Blue pencil
	(ui-function-tooltip-item	"Pencil2BGreen"	"Green pencil"	
								"Apply a green pencil stroke to the active image layer")  	;Pencil:Green pencil
	(ui-function-tooltip-item	"Pencil2BYellow"	"Yellow pencil"	
								"Apply a yellow pencil stroke to the active image layer")  	;Pencil:Yellow pencil

;;Palette: Paint
	(ui-function-tooltip-item	"MarkerInk"	"Marker ink"	
								"Apply an ink marker stroke to the active image layer")  	;Marker:Marker ink
	(ui-function-tooltip-item	"MarkerFine2"	"Marker fine"	
								"Apply a fine marker stroke to the active image layer")  	;Marker:Marker fine
	(ui-function-tooltip-item	"MarkerBroad"	"Marker broad"	
								"Apply a broad marker stroke to the active image layer")  	;Marker:Marker broad
	(ui-function-tooltip-item	"AirbrushSoft"	"Airbrush soft"	
								"Apply a soft airbrush stroke to the active image layer")  	;Airbrush:Airbrush soft
	(ui-function-tooltip-item	"AirbrushMedium2"	"Airbrush medium"	
								"Apply a medium airbrush stroke to the active image layer")  	;Airbrush:Airbrush medium
	(ui-function-tooltip-item	"PastelSoft"	"Pastel soft"	
								"Apply a soft pastel stroke to the active image layer")  	;Pastel soft
	(ui-function-tooltip-item	"SolidbrushFelt"	"Brush felt"	
								"Apply a felt brush stroke to the active image layer")  	;Solid brush:Brush felt
	(ui-function-tooltip-item	"SolidbrushLarge2"	"Brush solid"	
								"Apply a solid brush stroke to the active image layer")  	;Solid brush:Brush solid
	(ui-function-tooltip-item	"EraserSoftBrush"	"Eraser soft"	
								"Gradually remove paint from the active image layer with each stroke")  	;Eraser:Eraser soft
	(ui-function-tooltip-item	"EraserHardBrush"	"Eraser hard"	
								"Fully remove paint from the active image layer with each stroke")  	;Eraser:Eraser hard
	(ui-function-tooltip-item	"ClearImageLayer"	"Clear canvas layer"	
								"Delete the contents of the active image layer")  	;Eraser:Clear canvas layer
	(ui-function-tooltip-item	"Sharpenbrush"	"Sharpen brush"	
								"Apply an edge sharpen filter on the active image layer with each stroke")  	;Effect brush:Sharpen brush
	(ui-function-tooltip-item	"Blurbrush"	"Blur brush"	
								"Apply a blur filter on the active image layer with each stroke")  	;Effect brush:Blur brush
	(ui-function-tooltip-item	"Smearbrush"	"Smear brush"	
								"Apply a smear filter on the active image layer with each stroke")  	;Effect brush:Smear brush
	(ui-function-tooltip-item	"Clonebrush"	"Clone brush"	
								"Apply strokes using a brush consisting of a region of the image")  	;Effect brush:Clone brush
	(ui-function-tooltip-item	"Dodgebrush"	"Dodge brush"	
								"Apply strokes to lighten highlights, midtones, or shadows in the image")  	;Effect brush:Dodge brush
	(ui-function-tooltip-item	"Burnbrush"	"Burn brush"	
								"Apply strokes to darken highlights, midtones, or shadows in the image")  	;Effect brush:Dodge brush
	(ui-function-tooltip-item	"FloodFill"	"Flood fill"	
								"Fill a region of the active image layer with a solid color")  	;Flood fill
	(ui-function-tooltip-item	"PickLayer"	"Pick layer by color"	
								"Select an image layer by clicking on paint in the layer")  	;Pick layer by color
	(ui-function-tooltip-item	"PickLayer"	"Pick layer by color"	
								"Select an image layer by clicking on paint in the layer")  	;Pick layer by color
	(ui-function-tooltip-item	"MagicWand"		"Magic wand"		
								"Select a similarly colored area of an image layer")  	;Select:Magic wand
	(ui-function-tooltip-item	"MarqueePoly"		"Marquee polyline"		
								"Select a polygonal region of an image layer")  	;Select:Marquee polyline
	(ui-function-tooltip-item	"MarqueeLasso"		"Marquee lasso"		
								"Select a freeform region of an image layer")  	;Select:Marquee lasso
	(ui-function-tooltip-item	"MarqueeRect"		"Marquee rectangle"		
								"Select a rectangular region of an image layer")  	;Select:Marquee rectangle
	(ui-function-tooltip-item	"MarqueeEllipse"		"Marquee ellipse"		
								"Select an elliptical or circular region of an image layer")  	;Select:Marquee ellipse
	(ui-function-tooltip-item	"PaintTglSelMask"		"Toggle marquee"		
								"Toggle a paint selection marquee on or off")  	;Select:Toggle marquee
	(ui-function-tooltip-item	"InvertSelectionMaskLayer"		"Invert marquee"		
								"Reverse the selected region bounded by a marquee")  	;Select:Invert marquee
	(ui-function-tooltip-item	"ClearSelectionMask"		"Clear marquee"		
								"Remove the marquee from the active image layer")  	;Select:Clear marquee
	(ui-function-tooltip-item	"TransformMarquee"		"Transform marquee"		
								"Move, scale or rotate the selection region defined by a marquee")  	;Select:Transform marquee
	(ui-function-tooltip-item	"MakeShapeImage"		"Make image shape"		
								"Create a paint region or outline from modeling curves")  	;Shape:Make image shape
	(ui-function-tooltip-item	"MakeShapeMask"		"Make mask shape"		
								"Create a mask from modeling curves")  	;Shape:Make mask shape
	(ui-function-tooltip-item	"MakeShapeStencil"		"Make invisibility mask shape"		
								"Create an invisibility mask from modeling curves")  	;Shape:Make mask shape
	(ui-function-tooltip-item	"TextImage"		"Text image"		
								"Create raster-based text on the active image layer")  	;Text image
	(ui-function-tooltip-item	"PaintSymmetry"		"Modify canvas brush symmetry"		
								"Sketch and automatically mirror the strokes bilaterally or radially")  	;Paint symmetry:Modify canvas brush symmetry
	(ui-function-tooltip-item	"PaintSymmetryToggle"		"Toggle canvas brush symmetry"		
								"Toggle brush stroke mirroring on or off")  	;Paint symmetry:Toggle canvas brush symmetry
	(ui-function-tooltip-item	"ColorWheelEditor"		"Color editor"		
								"Open the color editor to change brush colors")  	;Color editor

;;Palette: PaintEdit
	(ui-function-tooltip-item	"TransformImage"		"Transform layer"		
								"Move, scale or rotate the content of one or more image layers")  	;Modify layer:Transform layer
	(ui-function-tooltip-item	"FlipHorizontalLayer"	"Horizontal flip"		
								"Flip the active image layer from right to left")  	;Modify layer:Horizontal flip
	(ui-function-tooltip-item	"FlipVerticalLayer"	"Vertical flip"		
								"Flip the active image layer from top to bottom")  	;Modify layer:Vertical flip
	(ui-function-tooltip-item	"ImageDeform"	"Deform image layer"		
								"Warp an image layer by moving its four corners and sides")  	;Deform image layer
	(ui-function-tooltip-item	"MakeShapeWarp"	"Make warp shape"		
								"Warp an image layer in a localized area using control curves")  	;Make warp shape
	(ui-function-tooltip-item	"ImageColorEditor"	"Color manipulation"		
								"Adjust multiple color and luminance attributes in a single interface")  	;Color correction:Color manipulation...
	(ui-function-tooltip-item	"BrightnessContrastLayer"	"Brightness/contrast"		
								"Adjust the brightness or contrast on the active image layer")  	;Color correction:Brightness and contrast...
	(ui-function-tooltip-item	"SaturationValueLayer"	"Saturation/value"		
								"Adjust the color saturation or value on the active image layer")  	;Color correction:Saturation and value...
	(ui-function-tooltip-item	"DodgeLayer"	"Dodge"		
								"Lighten highlights, shadows, or midtones on the active image layer")  	;Color correction:Dodge...
	(ui-function-tooltip-item	"BurnLayer"	"Burn"		
								"Darken highlights, shadows, or midtones on the active image layer")  	;Color correction:Dodge...
	(ui-function-tooltip-item	"ColorBalanceLayer"	"Color balance"		
								"Adjust color values on the active image layer")  	;Color correction:Color balance...
	(ui-function-tooltip-item	"ColorReplaceLayer"	"Color replace (HSV)"		
								"Select a color or range of colors and replace it with another range")  	;Color correction:Color replace (HSV)...
	(ui-function-tooltip-item	"ColorReplaceLayer_HSL"	"Color replace (HSL)"		
								"Select a color or range of colors and replace it with another range")  	;Color correction:Color replace (HSL)...
	(ui-function-tooltip-item	"SharpenLayer"	"Sharpen layer"		
								"Apply an edge sharpen filter to the active image layer")  	;Color correction:Sharpen...
	(ui-function-tooltip-item	"BlurLayer"	"Blur layer"		
					 			"Apply a blur filter to the active image layer")  	;Color correction:Blur...
	(ui-function-tooltip-item	"newlayer"	"New image layer"		
								"Create a new image layer for the current canvas")  	;Layer operations:New image layer
	(ui-function-tooltip-item	"newmasklayer"	"New mask layer"		
								"Create a new mask layer for the current canvas")  	;Layer operations:New mask layer
	(ui-function-tooltip-item	"newstencillayer"	"New invisibility mask layer"		
								"Create a new invisibility mask layer for the current canvas")  	;Layer operations:New invisibility mask layer
	(ui-function-tooltip-item	"newlayerfolder"	"New layer folder"		
								"Create a new folder in the current canvas to organize image layers")  	;Layer operations:New image layer folder 
	(ui-function-tooltip-item	"duplicatelayer"	"Duplicate layer"		
								"Create a copy of the active image layer")  	;Layer operations:New invisibility mask layer
	(ui-function-tooltip-item	"mergelayer"		"Merge below"	
								"Merge the active layer with the layer beneath it")  	;Layer operations:Merge below
	(ui-function-tooltip-item	"mergevisiblelayer"	"Merge visible layers"
								"Merge all visible image layers into one image layer")  ;Layer operations:Merge visible layers
	(ui-function-tooltip-item	"mergealllayers"	"Merge all layers"
								"Merge all image layers in the current canvas")  ;Layer operations:Merge all layers

;;Paint (Miscellaneous)
	(ui-function-tooltip-item	"PencilHB"	"HB Pencil"	"Sketch with a HB pencil")  	;Pencil:HB Pencil
	(ui-function-tooltip-item	"Pencil2B"	"2B Pencil"	"Sketch with a 2B pencil")  	;Pencil:2B Pencil (NT Sketching)
	(ui-function-tooltip-item	"Pencil4B"	"4B Pencil"	"Sketch with a 4B pencil")  	;Pencil:4B Pencil 
	(ui-function-tooltip-item	"Pencil6B"	"6B Pencil"	"Sketch with a 6B pencil")  	;Pencil:6B Pencil 
	(ui-function-tooltip-item	"Pencil2H"	"2H Pencil"	"Sketch with a 2H pencil")  	;Pencil:2H Pencil 
	(ui-function-tooltip-item	"Pencil6H"	"6H Pencil"	"Sketch with a 6H pencil")  	;Pencil:6H Pencil 
	(ui-function-tooltip-item	"MarkerSmall"	"Small Marker"		"Sketch with a Small Marker")  	;Marker:Small Marker 
	(ui-function-tooltip-item	"MarkerMedium"	"Medium Marker"		"Sketch with a Medium Marker")  	;Marker:Medium Marker 
	(ui-function-tooltip-item	"MarkerLarge"	"Large Marker"		"Sketch with a Large Marker")  	;Marker:Large Marker 
	(ui-function-tooltip-item	"AirbrushSmall"	"Small Airbrush"	"Sketch with a Small Airbrush")  	;Airbrush:Small Airbrush 
	(ui-function-tooltip-item	"AirbrushMedium"	"Medium Airbrush"	"Sketch with a Medium Airbrush")  	;Airbrush:Medium Airbrush 
	(ui-function-tooltip-item	"AirbrushLarge"	"Large Airbrush"	"Sketch with a Large Airbrush")  	;Airbrush:Large Airbrush 
	(ui-function-tooltip-item	"SolidbrushFine"	"Fine Solidbrush"	"Sketch with a Fine Solidbrush")  	;Solidbrush:Fine Solidbrush 
	(ui-function-tooltip-item	"SolidbrushSmall"	"Small Solidbrush"	"Sketch with a Small Solidbrush")  	;Solidbrush:Small Solidbrush
	(ui-function-tooltip-item	"SolidbrushMedium"	"Medium Solidbrush"	"Sketch with a Medium Solidbrush")  	;Solidbrush:Medium Solidbrush
	(ui-function-tooltip-item	"SolidbrushLarge"	"Large Solidbrush"	"Sketch with a Large Solidbrush")  	;Solidbrush:Large Solidbrush
	(ui-function-tooltip-item	"EraserSolidFine"	"Fine Solid Eraser"	"Sketch with a Fine Solid Eraser")  	;Eraser:Fine Solid Eraser
	(ui-function-tooltip-item	"EraserSolidSmall"	"Small Solid Eraser"	"Sketch with a Small Solid Eraser")  	;Eraser:Small Solid Eraser 
	(ui-function-tooltip-item	"EraserSolidMedium"	"Medium Solid Eraser"	"Sketch with a Medium Solid Eraser")  	;Eraser:Medium Solid Eraser 
	(ui-function-tooltip-item	"EraserSolidLarge"	"Large Solid Eraser"	"Sketch with a Large Solid Eraser")  	;Eraser:Large Solid Eraser 
	(ui-function-tooltip-item	"EraserAirbrushSmall"	"Small Airbrush Eraser"	"Sketch with a Small Airbrush Eraser")  	;Eraser:Small Airbrush Eraser 
	(ui-function-tooltip-item	"EraserAirbrushMedium"	"Medium Airbrush Eraser"	"Sketch with a Medium Airbrush Eraser")  	;Eraser:Medium Airbrush Eraser 
	(ui-function-tooltip-item	"EraserAirbrushLarge"	"Large Airbrush Eraser"	"Sketch with a Large Airbrush Eraser")  	;Eraser:Large Airbrush Eraser 
	(ui-function-tooltip-item	"SharpenbrushSmall"	"Small Sharpenbrush"	"Sharpen with a small brush")  	;Sharpenbrush: Small Sharpenbrush
	(ui-function-tooltip-item	"SharpenbrushMedium"	"Medium Sharpenbrush"	"Sharpen with a medium brush")  	;Sharpenbrush: Medium Sharpenbrush
	(ui-function-tooltip-item	"SharpenbrushLarge"	"Large Sharpenbrush"	"Sharpen with a large brush")  	;Sharpenbrush: Large Sharpenbrush
	(ui-function-tooltip-item	"BlurbrushSmall"	"Small Blurbrush"	"Blur with a small brush")  	;Blurbrush: Small Blurbrush
	(ui-function-tooltip-item	"BlurbrushMedium"	"Medium Blurbrush"	"Blur with a medium brush")  	;Blurbrush: Medium Blurbrush
	(ui-function-tooltip-item	"BlurbrushLarge"	"Large Blurbrush"	"Blur with a large brush")  	;Blurbrush: Large Blurbrush
	(ui-function-tooltip-item	"SmearbrushSmall"	"Small Smearbrush"	"Smear with a small brush")  	;Smearbrush: Small Smearbrush
	(ui-function-tooltip-item	"SmearbrushMedium"	"Medium Smearbrush"	"Smear with a medium brush")  	;Smearbrush: Medium Smearbrush
	(ui-function-tooltip-item	"SmearbrushLarge"	"Large Smearbrush"	"Smear with a large brush")  	;Smearbrush: Large Smearbrush
	(ui-function-tooltip-item	"ClonebrushSmall"	"Small Clonebrush"	"Duplicate paint on other parts of the canvas with a small brush")  	;Clonebrush: Small Clonebrush
	(ui-function-tooltip-item	"ClonebrushMedium"	"Medium Clonebrush"	"Duplicate paint on other parts of the canvas with a medium brush")  	;Clonebrush: Medium Clonebrush
	(ui-function-tooltip-item	"ClonebrushLarge"	"Large Clonebrush"	"Duplicate paint on other parts of the canvas with a large brush")  	;Clonebrush: Large Clonebrush
	(ui-function-tooltip-item	"MarqueeRect"	"Marquee (rectangle)"	"Select a rectangular area of the image layer")  	;Select: Marquee (rectangle)
	(ui-function-tooltip-item	"MarqueeCircle"		"Marquee (circle)"	"Select a circular area of the image layer")  		;Select: Marquee (circle)
	(ui-function-tooltip-item	"MarqueeEllipse"	"Marquee (ellipse)"	"Select a elliptical area of the image layer")  	;Select: Marquee (ellipse)
	(ui-function-tooltip-item	"MakeShape"		"Make shape"		"Create a shape from outline curves")  	;Shape: Make shape
;;Palette: Curves
	(ui-function-tooltip-item	"DE_CurveCV"	"New CV curve" "Create new curve by placing its CVs")  	;New Curves:New Curve (cvs) 
	(ui-function-tooltip-item	"DE_CurveEditPoint"	"New Edit Point curve" 
						"Create new curve by placing its edit points")  	;New Curves:New Curve (edit pts) 
	(ui-function-tooltip-item	"DE_CurveSketch"	"New Sketch curve"	
						"Create new curve by sketching it freehand")  	;New Curves:New Curve (sketch) 
	(ui-function-tooltip-item	"BlendCurveToolbox"	"Blend curve toolbox" 
						"Create and use blend curves from a toolbox")  	;Blend curve toolbox 
	(ui-function-tooltip-item	"NewCurveOnSurf"	"New curve-on-surface" "Draw a curve-on-surface")  	;Curves:New curve on surface
	(ui-function-tooltip-item	"Sweeps"		"Sweeps" "Use a palette of sweep curves")  	;Curves:New curve on surface 
	(ui-function-tooltip-item	"Autotrace"		"Autotrace"	"Automatically trace curves from an image plane")  	;Curves:Autotrace 
	(ui-function-tooltip-item	"Digitize"		"Digitize"	"Create curves using a digitizing tablet")  	;Curves:Digitize 
	(ui-function-tooltip-item	"SetupDigitizer"	"Set up digitizer"	
						"Set up the digitizer to match the modeling window")  	;Curves:Setup digitizer 
	(ui-function-tooltip-item	"DE_LineTangentTo"	"Line tangent to curve" 
						"Draw a keypoint line tangent to a curve")  	;Lines (Tangent):Line tangent to curve 
	(ui-function-tooltip-item	"DE_LineTangentFromTo"	"Line tangent from/to curves"
						"Draw a keypoint line between two curves")  	;Lines (Tangent):Line tangent from/to curve 
	(ui-function-tooltip-item	"DE_LinePerpendicular"	"Line perpendicular"
						"Draw a keypoint line perpendicular from or to a curve")  	;Lines (Tangent):Line perpendicular
	(ui-function-tooltip-item	"DE_Line"		"Line" "Draw a single key line: set down two points")  	;Lines:Line 
	(ui-function-tooltip-item	"DE_LinePoly"		"Polyline" "Draw a polyline: set down multiple points")  	;Lines:Polyline 
	(ui-function-tooltip-item	"DE_LineParallel"	"Parallel line" "Draw a line parallel to a curve")  	;Lines:Parallel line 
	(ui-function-tooltip-item	"DE_LineAtAngle"	"Line at angle" "Draw a line at an angle to a curve")  	;Lines:Line at angle 
	(ui-function-tooltip-item	"DE_LineArc"		"Line-arc" "Draw a sequence of lines and arcs")  		;Line-arc 
	(ui-function-tooltip-item	"DE_Arc"		"Arc (three point)"
						"Draw an arc by laying down three points")  	;Arcs:Arc (three point) 
	(ui-function-tooltip-item	"DE_ArcTwoPoint"  	"Arc (two point)"
						"Draw an arc by laying down two points and specifying its center or radius")  	;Arcs:Arc (two point) 
	(ui-function-tooltip-item	"DE_ArcTangent"	"	Arc tangent to curve"
						"Draw an arc tangent to a curve (the start point is on the curve)")  	;Arcs:Arc tangent to curve 
	(ui-function-tooltip-item	"DE_ArcConcentric"  	"Concentric arc" 
						"Draw an arc with the same center point as another arc")  		;Arcs:Concentric arc 
	(ui-function-tooltip-item	"DE_Circle"		"Circular arc"
						"Draw a circle by specifying its centerpoint and a point that lies on it")	;Arcs:Circular arc 
	(ui-function-tooltip-item	"DE_Rectangle"		"Rectangle"
						"Draw a rectangle by specifying its two diagnol corners")	;Lines:Polyline
	(ui-function-tooltip-item	"Ellipse"		"Ellipse"
						"Draw an ellipse by specifying its centerpoint and radii")  		;Ellipse 
	(ui-function-tooltip-item	"FitCurve"		"Fit curve"	"Create higher quality curves from cross section line data")  	;Fit Curve 
;;Palette: Curve Edit
	(ui-function-tooltip-item	"CurveEditor"		"Curve Editor"	
						"Use the Curve Editor to type in the tangent or position of a curve")  	;Modify:Curve editor 
	(ui-function-tooltip-item	"AddPoints"		"Add points"	
						"Add points to a curve (pick the CV or edit point at beginning or end of the curve)")  	;Modify:Add points 
	(ui-function-tooltip-item	"TransformCurve"		"Transform curve"	
						"Position a curve so it intersects two rail curves")  	;Modify:Transform curve
	(ui-function-tooltip-item	"AdjustWeight"		"Adjust weight" 
						"Change a curve by adjusting the amount of pull made by selected CVs")  	;Modify:Adjust weight 
	(ui-function-tooltip-item	"Multiplicity"		"Adjust multiplicity" 
						"Change the sharpness of bends in a curve at selected CVs")  	;Modify:Multiplicity 
	(ui-function-tooltip-item	"AdjustIntersection"	"Adjust intersection"
						"Modify a curve to intersect another curve, or check that they already intersect")  	;Modify:Adjust intersection 
	(ui-function-tooltip-item	"Stretch"		"Stretch curve"	"Stretch or reshape a curve by using handles")  	;Modify:Stretch 
	(ui-function-tooltip-item	"DuplicateCurve"	"Duplicate curve"	"Create a duplicate free curve from existing geometry")  	;Create:Duplicate curve 
	(ui-function-tooltip-item	"CombineCurves"		"Combine curves"	
						"Create a 3D curve from two planar curves (orthogonal projections)")  	;Create:Combine curves 
	(ui-function-tooltip-item	"ProjectTangent"	"Project tangent"	
						"Modify a curve or edge to get tangency with an adjoining surface")  	;Project tangent 
	(ui-function-tooltip-item	"DE_Break"		"Break curve at keypoint" 
						"Cut a keypoint curve at a keypoint to get two curves")  	;Cut:Break curve at keypoint 
	(ui-function-tooltip-item	"DE_Join"		"Join curves"
						"Join two keypoint curves at overlapping end points")  	;Cut:Join curves 
	(ui-function-tooltip-item	"DeleteSegment"		"Delete segment" 
						"Delete spans between two edit points (the shape of the curve is kept)")  	;Cut:Delete segment 
	(ui-function-tooltip-item	"BreakAtInflections"	"Break curve at inflections"
						"Automatically break a curve at all its inflection points")  	;Cut:Break curve at inflections 
	(ui-function-tooltip-item	"GlobalCrvIntersect"	"Intersect curves and detach"
						"Intersect curves and detach")  	;Cut:Intersect curves and detach
	(ui-function-tooltip-item	"RebuildCurve"	"Rebuild curve" 
						"Rebuild a curve with different geometric properties")  	;Rebuild curve 
	(ui-function-tooltip-item	"DrawPrecision"	"Draw precision"
						"Change how precisely curves are drawn on the display")  	;Draw precision 
	(ui-function-tooltip-item	"CurvePlanar"	"Curve planarize" 
						"Flatten a curve or edge so that its points lie on the same plane")  	;Curve planarize 
	(ui-function-tooltip-item	"CurveSection"	"Curve section"	
						"Cut or trim curves based on their spatial intersection ")  	;Curve section
	(ui-function-tooltip-item	"SortSections"	"Sort sections"	
						"Sort section lines into layers based on their axis orientation")  	;Sort sections
	(ui-function-tooltip-item	"ReverseCurve"	"Reverse curve"	
						"Reverse direction of curves")
												 
;;Palette: Objects
	(ui-function-tooltip-item	"Text"		"Text"	"Create text (select another tool to stop)")  	;Text... 
	(ui-function-tooltip-item	"Sphere"	"Sphere"	"Create sphere primitives (select another tool to stop)")  	;Primitives:Sphere 
	(ui-function-tooltip-item	"Torus"		"Torus"	"Create torus primitives (select another tool to stop)")  	;Primitives:Torus 
	(ui-function-tooltip-item	"Circle"	"Circle"	"Create circle primitives (select another tool to stop)")  	;Primitives:Circle 
	(ui-function-tooltip-item	"Cylinder"	"Cylinder"	"Create cylinder primitives (select another tool to stop)")  	;Primitives:Cylinder 
	(ui-function-tooltip-item	"Cone"	"Cone"	"Create cone primitives (select another tool to stop)")  	;Primitives:Cone 
	(ui-function-tooltip-item	"Cube"	"Cube"	"Create cube primitives (select another tool to stop)")  	;Primitives:Cube 
	(ui-function-tooltip-item	"Plane"	"Plane"	"Create plane primitives (select another tool to stop)")  	;Primitives:Plane 
	(ui-function-tooltip-item	"Jack"	"Jack"	"Create jack primitives (select another tool to stop)")  	;Primitives:Jack 
	(ui-function-tooltip-item	"DrawSkeleton"	"Draw skeleton"	"Draw a skeleton to animate (select another tool to stop)")  	;Draw skeleton 
	(ui-function-tooltip-item	"AddIkHandle"	"Add IK handle"	"Add IK handles to a skeleton")  	;Add IK handle 
	(ui-function-tooltip-item	"Point"	"Point light"	"Create point lights")  	;Lights:Point 
	(ui-function-tooltip-item	"Spot"	"Spot light"	"Create spot lights")  	;Lights:Spot 
	(ui-function-tooltip-item	"Directional"	"Directional light"	"Create directional lights")  	;Lights:Directional 
	(ui-function-tooltip-item	"Ambient"	"Ambient light"	"Create ambient lights")  	;Lights:Ambient 
	(ui-function-tooltip-item	"Area"	"Area light"	"Create area lights")  	;Lights:Area 
	(ui-function-tooltip-item	"Volume"	"Volume light"	"Create volume lights")  	;Lights:Volume 
	(ui-function-tooltip-item	"Linear"	"Linear light"	"Create linear lights")  	;Lights:Linear 
	(ui-function-tooltip-item	"CreateDefaults"	"Create defaults"	"Create default lighting for the scene")  	;Lights:Create defaults 
	(ui-function-tooltip-item	"PlanarProjection"	"Planar projection"	
						"Create a new planar texture projection")  	;Projections:Planar 
	(ui-function-tooltip-item	"ConcentricProjection"	"Concentric projection"	
						"Create a new concentric texture projection")  	;Projections:Concentric 
	(ui-function-tooltip-item	"TriplanarProjection"	"Triplanar projection"	
						"Create a new triplanar texture projection")  	;Projections:Triplanar 
	(ui-function-tooltip-item	"SphericalProjection"	"Spherical projection"	
						"Create a new spherical texture projection")  	;Projections:Spherical 
	(ui-function-tooltip-item	"BallProjection"	"Ball projection"	
						"Create a new ball texture projection")  	;Projections:Ball 
	(ui-function-tooltip-item	"CylindricalProjection"	"Cylindrical projection"	
						"Create a new cylindrical texture projection")  	;Projections:Cylindrical 
	(ui-function-tooltip-item	"CubicProjection"	"Cubic projection"	
						"Create a new cubic texture projection")  	;Projections:Cubic 
	(ui-function-tooltip-item	"CameraProjection"	"Camera projection"	
						"Create a new camera texture projection")  	;Projections:Camera 
;;Palette: Object Edit
	(ui-function-tooltip-item	"Attach"	"Attach"	"Attach curves or surfaces")  	;Attach:Attach 
	(ui-function-tooltip-item	"Detach"	"Detach"	
						"Detach a curve or surface at an edit point or isoparm")  	;Attach:Detach 
	(ui-function-tooltip-item	"Align"	"Align"	"Align two curves or surfaces")  	;Align 
	(ui-function-tooltip-item	"Align2008"	"Align 2008"	"Align two curves or surfaces using 2008 align tool")  	;Align 2008
	(ui-function-tooltip-item	"SymAlign"	"Symmetry plane align"	
						"Align curves or surfaces with their mirrored half")  	;Symmetry Plane Align 
	(ui-function-tooltip-item	"Smooth"	"Smooth"	
						"Smooth all or part of a curve or surface (use mouse buttons for control)")  	;Smooth 
	(ui-function-tooltip-item	"OffsetHistory"	"Offset"	"Create a new object, offset from the original")  	;Offset:Offset 
	(ui-function-tooltip-item	"TransformerRigToolbox"	"Transformer rig"	
								"Apply a transformer rig to a surface, curve or mesh")  	;Dynamic Shape Modeling;Transformer Rig
	(ui-function-tooltip-item	"LatticeRigToolbox"	"Lattice rig"	
								"Apply a lattice rig to a surface, curve or mesh")  	;Dynamic Shape Modeling;Lattice Rig
	(ui-function-tooltip-item	"TwistRigToolbox"	"Twist rig"	
								"Apply a twist rig to a surface, curve or mesh")  	;Dynamic Shape Modeling;Twist Rig
	(ui-function-tooltip-item	"BendRigToolbox"	"Bend rig"	
								"Apply a bend rig to a surface, curve or mesh")  	;Dynamic Shape Modeling;Bend Rig
	(ui-function-tooltip-item	"ConformRigToolbox"	"Conform rig"	
								"Apply a conform rig to a surface, curve or mesh")  	;Dynamic Shape Modeling;Conform Rig
	(ui-function-tooltip-item	"Extend"	"Extend"	"Extend a curve at its end, or surface at its edge")  	;Extend 
	(ui-function-tooltip-item	"ObjectSymmetric"	"Symmetric Modeling"	"Make a curve or surface symmetric with respect to layer symmetry plane.")  	;ObjectSymmetric
	(ui-function-tooltip-item	"Insert"	"Insert"	
						"Insert new points into a curve, or isoparms into a surface")  	;Insert 
	(ui-function-tooltip-item	"Close"	"Close"	"Close open curves or surfaces, or open ones that are closed")  	;Close 
	(ui-function-tooltip-item	"FitBspline"	"Fit B-spline"	
						"Convert linear (degree 1) geometry to cubic (degree 3)")  	;Fit b-spline 
	(ui-function-tooltip-item	"AddConstraint"	"Constrain to"	
						"Constrain selected object to point at, aim at, or orient itself to another object")  	;Constrain:Constrain to 
	(ui-function-tooltip-item	"CreateConstraint"	"Create constraint"	
						"Create a general constraint on an object")  	;Constrain:Create constraint 
	(ui-function-tooltip-item	"EditConstraint"	"Edit UV constraint"	
						"Change the UV directions of an existing constraint")  	;Constrain:Edit uv constraint 
	(ui-function-tooltip-item	"OrientNormals"	"Set surface orientation"	
						"Orient surface normals so they point toward or away from the camera")  	;Orientation:Set surface orientation
	(ui-function-tooltip-item	"ReverseDirection"	"Reverse visual surface orientation"	
						"Reverse direction of surface normals without affecting UV direction")  	;Orientation:Reverse visual surface orientation
	(ui-function-tooltip-item	"UnifyNormals"	"Unify surface orientation"	
						"Make surface normals across multiple surfaces all point in one directon")  	;Orientation:Unify surface orientation
	(ui-function-tooltip-item	"ReverseUV"	"Reverse surface uv"	
						"Reverse or swap the UV direction of a surface")  	;Reverse surface UV
	(ui-function-tooltip-item	"EditComment"	"Edit comment"	"Attach a text comment to the selected object")  	;Edit comment 
	(ui-function-tooltip-item	"PatchPrecision"	"Patch precision"	
						"Set the number of isoparms drawn for a surface (affects display only)")  	;Patch precision 
	(ui-function-tooltip-item	"HullPrecision"	"Hull precision"	
						"Set the coarseness of surfaces drawn in simple display mode")  	;Hull precision 
	(ui-function-tooltip-item	"MultilistEdit"	"Multi-list edit"	"Open multi-lister attributes on the selected object or the environment")  	;Multi-list edit 
	(ui-function-tooltip-item	"QueryGeometry"	"Query edit"	
						"View information about an object, or edit its construction history")  	;Query edit 
	(ui-function-tooltip-item	"ObjectEditor"	"Object editor"	"Edit curves and surfaces with the object editor")  	;Object editor
	(ui-function-tooltip-item	"ExpandInstances"	"Expand instances"	"Create real geometry in place of instanced objects")  	;Expand instances 
	(ui-function-tooltip-item	"SmoothTool"	"Smooth"	"Smooth a curve or surface")  	;VSRSmooth
;;Palette: Surfaces
	(ui-function-tooltip-item	"SetFace"	"Set planar"	"Make a planar face from bounding curves")  	;Set planar 
	(ui-function-tooltip-item	"Revolve"	"Revolve" "Revolve a curve to make a surface")  	;Revolve 
	(ui-function-tooltip-item	"Skin"	"Skin 2012"	"Skin a surface across cross-section curves")  	;Skin 
	(ui-function-tooltip-item	"Extrude"	"Extrude"	
						"Extrude a generation curve along a path curve to create a tubular surface")  	;Swept surfaces:Extrude 
	(ui-function-tooltip-item	"Swept"	"Swept surface"	
						"Sweep generation curves along a path, with optional transforms along the path")  	;Swept surfaces:Swept 
	(ui-function-tooltip-item	"Birail"	"Birail surface"	
						"Sweep generation curves along two path curves (rails)")  	;Swept surfaces:Birail 
	(ui-function-tooltip-item	"Birail_I"	"Rail surface"	
						"Sweep generation curves along one or two path curves (rails)")  	;Swept surfaces:Rail surface 
	(ui-function-tooltip-item	"AnimSweepOption"	"Anim sweep"
						"Create a surface by sweeping an animated curve through time")  	;Swept surfaces:Anim sweep 
	(ui-function-tooltip-item	"Square"	"Square"	
						"Create a surface from 4 boundary curves (keeps continuity with adjacent surfaces)")  	;Boundary surfaces:Square 
	(ui-function-tooltip-item	"BallCorner"	"Ball corner"	
						"Create a surface between 3 intersecting transition surfaces and a primary surface")  	;Ball corner
	(ui-function-tooltip-item	"Boundary"	"Boundary surface"
						"Create a surface by blending between 3 or 4 boundary curves")  	;Boundary surfaces:Boundary 
	(ui-function-tooltip-item	"NSided"	"N-sided"
						"Create a surface with up to 8 sides")  	;Boundary surfaces:N-sided 
	(ui-function-tooltip-item	"Bevel"	"Bevel"	"Create an extruded surface with a beveled edge")  	;Fillet surfaces:Bevel 
	(ui-function-tooltip-item	"Fillet"	"Fillet"
						"Create a fillet surface or curve between two existing surfaces or curves")  	;Fillet surfaces:Fillet 
	(ui-function-tooltip-item	"BlendSurface"	"Blend fillet"	
						"Create a surface that blends between two existing boundaries")  	;Fillet surfaces:Blend 
	(ui-function-tooltip-item	"Round90"	"9.0 Round"
						"Create fillet surfaces and rounded corners between existing surfaces")  	;(OLD) Fillet surfaces:Round 
	(ui-function-tooltip-item	"Round"		"Round"  
						"Create fillet surfaces and rounded corners between existing surfaces")  	;Round
	(ui-function-tooltip-item	"SurfaceFillet"	"Surface fillet"  
						"Create fillet surfaces between multiple surfaces")  	;MultiSurface Fillet:Surface fillet
	(ui-function-tooltip-item	"SymmetricFillet"	"Symmetric fillet"
						"Create fillet surfaces using surface curves")  	;MultiSurface Fillet:Symmetric fillet
	(ui-function-tooltip-item	"FreeformBlend"	"Freeform blend"  
						"Create a transitional surface based on two input contact lines")  	;Multi-surface blend:Freeform blend
	(ui-function-tooltip-item	"ProfileBlend"	"Profile blend"  
						"Create one or many transition surfaces between multiple surface boundaries")  	;Multi-surface blend:Profile blend
	(ui-function-tooltip-item	"FilletFlange"	"Fillet flange"  
						"Create a surface fillet and linear flange wall")  	;Rolled edge:Fillet flange
	(ui-function-tooltip-item	"TubeFlange"	"Tube flange"  
						"Create a surface fillet and tubular flange wall")  	;Rolled edge:Tube flange
	(ui-function-tooltip-item	"TubularOffset"	"Tubular offset"  
						"Create a tube surface and intersect with surfaces to generate offset curves")  	;Rolled edge:Tubular offset
	(ui-function-tooltip-item	"PanelGap"	"Panel gap"  
						"Create a filleted opening across the interior of one or more surfaces")  	;Rolled edge:Panel gap
	(ui-function-tooltip-item	"MSDraft"	"Multi-surface draft"  
						"Create a ruled surface that extends away at an angle to the original surface")  	;Draft surfaces:Multi-surface draft
	(ui-function-tooltip-item	"Draft" "Draft/Flange"	
						"Create a ruled surface from a curve or surface curve at a specific angle")  	;Draft surfaces:Draft/Flange
	(ui-function-tooltip-item	"TubeSurface" "Tube surface"	
						"Create a tube surface using free curves as a path")  	;Tube surface
	(ui-function-tooltip-item	"CurveNetworkEditor"	"Curve networks"
						"Build surfaces from a network of intersecting curves")  	;Curve networks... 
	(ui-function-tooltip-item	"Flange" "Flange (or Draft)"	
						"Pull a surface out from a curve (use option box to set draft or flange)")  	;Flange
	(ui-function-tooltip-item	"CombineSurfs"	"Combine surfaces"
						"Create a single new surface from several separate surfaces")  	;Combine surfaces 
	(ui-function-tooltip-item	"SkinTool"	"Skin"	"Skin a surface across cross-section curves")  	;SkinTool 
	(ui-function-tooltip-item	"SurfaceFromMesh"	"Surface from mesh"
						"Create a surface from a region of a mesh")  	;SurfaceFromMesh 
;;Palette: Surface Edit
	(ui-function-tooltip-item	"Project"	"Project"	
						"Create curve-on-surface by projecting a curve (in one vector direction)")  	;Create CurvesOnSurface:Project 
	(ui-function-tooltip-item	"Intersect"	"Intersect"	
						"Create curve-on-surface where two surfaces intersect")  	;Create CurvesOnSurface:Intersect 
	(ui-function-tooltip-item	"GeometryMapping"	"Geometry mapping"
						"Create curve-on-surface by mapping a curve onto a surface")  	;Create CurvesOnSurface:Geometry mapping 
	(ui-function-tooltip-item	"Trim"	"Trim"	"Trim or divide surfaces using curves-on-surface or projected curves")  	;Trim:Trim 
	(ui-function-tooltip-item	"TrimDivide"	"Trim divide"	"Divide a surface at a curve-on-surface")  	;Trim:Trim divide 
	(ui-function-tooltip-item	"Untrim"	"Untrim"	"Return a trimmed surface to its original untrimmed state")  	;Trim:Untrim 
	(ui-function-tooltip-item	"TrimConvert"	"Trim convert"
						"Convert a four-sided trimmed surface into an untrimmed (natural) surface")  	;Trim:Trim convert 
	(ui-function-tooltip-item	"ShellStitch"	"Shell stitch"	"Stitch selected surfaces together into a shell")  	;Stitch:Shell stitch 
	(ui-function-tooltip-item	"ShellUnStitch"	"Shell unstitch"	
						"Unstitch a shell into its original surfaces")  	;Stitch:Shell unstitch 
	(ui-function-tooltip-item	"ShellSubtract"	"Shell subtract"	
						"Subtract the volume of one shell from another")  	;Shells:Shell subtract 
	(ui-function-tooltip-item	"ShellIntersect"	"Shell intersect"
						"Keep the intersecting volume of two shells and discard the rest")  	;Shells:Shell intersect 
	(ui-function-tooltip-item	"ShellUnion"	"Shell union"
						"Combine the volumes of two shells into one new shell")  	;Shells:Shell union 
	(ui-function-tooltip-item	"HullPlanarize"	"Planarize hull" 
						"Modify surface hulls to lie on a plane")  	;Shells:Shell union 
	(ui-function-tooltip-item	"AlignMesh"	"Align mesh"
						"Align several adjacent surfaces to have continuity")  	;Align mesh 
	(ui-function-tooltip-item	"AlignHull"	"Align hull"	"Align surface hulls to their best-fit planes")  	;Align hull 
	(ui-function-tooltip-item	"RebuildSurface"	"Rebuild surface"	
						"Rebuild a surface with different geometric properties")  	;Rebuild surface 
	(ui-function-tooltip-item	"Claymate"	"Claymate"	
						"Integrate digitized clay model data with surfaces")  	;Claymate... 
	(ui-function-tooltip-item	"GlobalDeform"	"Global deformation"
						"Deform multiple surfaces (surface continuity is maintained)")  	;Fender bender 
	(ui-function-tooltip-item	"FitScan"	"Fit scan"	"Fit an existing surface to scan data")  	;Fit scan 
	(ui-function-tooltip-item	"NewFitScan"	"Fit scan"	"Fit an existing surface to scan data")  	;New fit scan 
	(ui-function-tooltip-item	"NurbsToBezierTool"	"NURBS to Bezier"	"Convert multi-span NURBS surfaces to Bezier")  	;NURBS to Bezier
;;Palette: Mesh
	(ui-function-tooltip-item	"NurbsToMesh"	"NURBS to Mesh"	
								"Convert NURBS surfaces to mesh objects")	;Mesh Tessellation:Nurbs to mesh 
	(ui-function-tooltip-item	"CloudToMesh"	"Cloud to mesh"	
								"Convert cloud data to mesh objects")	;Mesh Tessellation:Cloud to mesh 
	(ui-function-tooltip-item	"DispMapToMesh"	"Displacement map to mesh"	
								"Convert a displacement map on nurbs surfaces to mesh geometry")	;Mesh Tessellation:Cloud to mesh 
	(ui-function-tooltip-item	"MeshSubset"	"Mesh subset"	
								"Select portions of meshes and split them into separate pieces")	;Mesh Partitioning:Mesh subset
	(ui-function-tooltip-item	"MeshMerge"	"Mesh merge"	
								"Combine smaller meshes into one large mesh")	;Mesh Partitioning:Mesh merge
	(ui-function-tooltip-item	"MeshCut"	"Mesh cut"	
								"Split a mesh into separate components")	;Mesh Partitioning:Mesh cut
	(ui-function-tooltip-item	"MeshProjectCurve"	"Mesh project curve"	
								"Project curves onto a mesh")	;Mesh Curves:Mesh project curve
	(ui-function-tooltip-item	"MeshProjectNormal"	"Mesh project normal"	
								"Project curves normal to a mesh")	;Mesh Curves:Mesh project normal
	(ui-function-tooltip-item	"MeshIntersect"	"Mesh intersect"	
								"Create curves at the intersections of meshes")	;Mesh Curves:Mesh intersect 
	(ui-function-tooltip-item	"MeshFeatureCurves"	"Mesh extract theoretical intersection"	
								"Create theoretical curve intersections on a mesh")	;Mesh Curves:Mesh extract theoretical intersection
	(ui-function-tooltip-item	"MeshBoundaries"	"Mesh boundaries"	
								"Create degree 1 curves from selected mesh boundaries")	;Mesh Curves:Mesh boundaries
	(ui-function-tooltip-item	"MeshSmooth"	"Mesh smooth"	
								"Smooth regions of a mesh")	;Mesh Cleanup:Mesh smooth
	(ui-function-tooltip-item	"MeshReduce"	"Mesh reduce"	
								"Reduce the number of triangles in a mesh while trying to preserve its shape")	;Mesh Cleanup:Mesh reduce
	(ui-function-tooltip-item	"MeshHoleFill"	"Mesh hole fill"	
								"Fill holes in a mesh")	;Mesh Cleanup:Mesh hole fill
	(ui-function-tooltip-item	"MeshBridge"	"Mesh bridge"	
								"Build small bridges across gaps in a mesh")	;Mesh Cleanup:Mesh bridge
	(ui-function-tooltip-item	"MeshMergeVertices"	"Mesh weld vertices"	
								"Merge all coincident vertices in a mesh")	;Mesh Cleanup:Mesh weld vertices
	(ui-function-tooltip-item	"MeshRepair"	"Mesh repair"	
								"Repair degenerate, non-manifold or non-intersecting edges by deleting triangles")	;Mesh repair
	(ui-function-tooltip-item	"MeshCollar"	"Mesh collar"	
								"Create a nurbs collar along any mesh boundary or curve on mesh")	;Mesh collar
	(ui-function-tooltip-item	"MeshOffset"	"Mesh offset"	
								"Offset meshes to create STL-ready mesh objects")	;Mesh offset
	(ui-function-tooltip-item	"MeshStitch"	"Mesh stitch"	
								"Seal gaps between the boundaries of components in a mesh")	;Mesh stitch
	(ui-function-tooltip-item	"MeshReverseNormals"	"Reverse mesh orientation"	
								"Reverse the direction of normals on mesh components or the entire mesh")	;Reverse mesh orientation
	(ui-function-tooltip-item	"MeshAlignment"	"Mesh positioning"	
								"Align a scanned source mesh to a destination mesh")	;Mesh positioning
	(ui-function-tooltip-item	"MeshSharpen"	"Mesh edge reconstruct"	
								"Create clean edges over areas of high curvature in a mesh")	;Mesh edge reconstruct
	(ui-function-tooltip-item	"MeshPatch"	"Mesh patch"	
								"Fill holes in meshes while recognizing curvature characteristics of surrounding area")	;Mesh patch
	(ui-function-tooltip-item	"MeshReverseNormals"	"Reverse mesh orientation"	"Reverse orientation of meshes or mesh components") 
;;Palette: Cameras
	(ui-function-tooltip-item	"Tumble"	"Tumble"	"Revolve the view around the view center or a fixed point")  	;World Move camera:Tumble 
	(ui-function-tooltip-item	"Track"	"Track"	"Slide the view horizontally or vertically")  	;World Move camera:Track 
	(ui-function-tooltip-item	"Dolly"	"Dolly"	"Move the view forward or backward")  	;World Move camera:Dolly 
	(ui-function-tooltip-item	"MultiView"	"Track/dolly/tumble"
						"Track, dolly, and tumble by using keyboard-mouse actions")  	;World Move camera:Track/dolly/tumble 
	(ui-function-tooltip-item	"One2One"	"Calibrate 1:1"
						"Calibrate the display to a true scale of 1:1")
	(ui-function-tooltip-item	"TglOne2One"	"Toggle 1:1"
						"Toggle the 1:1 true scale display state on or off")
	(ui-function-tooltip-item	"Twist"	"Twist"	"Rotate the camera in the viewing plane")  	;Local Move camera:Twist 
	(ui-function-tooltip-item	"AzimInc"	"Azimuth/elevation"	
						"Revolve the view around a center of interest")  	;Local Move camera:Azimuth/elevation 
	(ui-function-tooltip-item	"YawPitch"	"Yaw/pitch"	"Change the camera yaw (horizontal rotation) or pitch (vertical rotation)")  	;Local Move camera:Yaw/pitch 
	(ui-function-tooltip-item	"Zoom"	"Zoom"	"Zoom in or out by changing the field of view")  	;Zoom 
	(ui-function-tooltip-item	"LookAt"	"Look at"	"Center the view on a picked object, or the entire scene if nothing is picked")  	;Look at 
	(ui-function-tooltip-item	"SetNonProportional" "Set non proportional view" "Set non proportional view scaling")  	;Set Non Proportional View
	(ui-function-tooltip-item	"TglNonProportional" "Toggle non proportional view" "Toggle between proportional and non proportional views")  	;Tgl Non Proportional View
	(ui-function-tooltip-item	"Previous"	"Previous view"	"Move (undo) the camera to its previous position")  	;Previous view 
	(ui-function-tooltip-item	"ResetView"	"Reset view"	"Reset a window to its default view, and reset clipping planes")  	;Reset view 
	(ui-function-tooltip-item	"TglStereo"	"Toggle Stereo" "Toggle Stereo viewing on the perspective camera")  	;Toggle Stereo
	(ui-function-tooltip-item	"NewCamera"	"New camera" "Create a new perspective camera")  	;New camera 
	(ui-function-tooltip-item	"Clone"	"Clone"	"Create a duplicate window of the current view")  	;Clone 
	(ui-function-tooltip-item	"AdjustClip"	"Adjust clipping plane"	
						"Adjust the near and far distances at which objects are no longer drawn")  	;Adjust clipping plane 
	(ui-function-tooltip-item	"MatchThreePoint"	"Match perspective"
						"Match perspective camera to image planes")  	;Match Perspective 
;;Palette: Construction
	(ui-function-tooltip-item	"CreatePoint"	"Point"	"Create a reference point")  	;Point 
	(ui-function-tooltip-item	"CreateLineSeg"	"Vector"	
						"Create a reference vector by clicking in two places or picking two points")  	;Vector 
	(ui-function-tooltip-item	"CreatePlane"	"Plane"	
						"Create a reference plane by clicking in three places, or picking a point and vector")  	;Plane 
	(ui-function-tooltip-item	"SetConstPlane"	"Set construction plane"	
						"Make the picked reference plane the construction plane")  	;Set construction plane 
	(ui-function-tooltip-item	"ToggleCP"	"Toggle construction plane"	
						"Switch between the current construction plane and the world axes")  	;Tgl construction plane 
	(ui-function-tooltip-item	"GridSpacing"	"Grid spacing"	
						"Change the spacing between grid lines")  	;Hidden:Grid spacing 
	(ui-function-tooltip-item	"GridPreset"	"Grid preset"	
						"Return the grid spacing to a preset value")  	;Grid preset 
;;Palette: Anim
	(ui-function-tooltip-item	"SetMotion"	"Set motion"	"Animate along a path")  	;Set motion 
	(ui-function-tooltip-item	"SetKeyShape"	"Set key shape"	"Metamorphose an object into another by pulling CVs")  	;Set key shape 
	(ui-function-tooltip-item	"ViewFrame"	"View frame"	"View individual frames of animation")  	;View frame 
	(ui-function-tooltip-item	"PoseAnimationPrompt"	"Pose animation"	
						"Create custom playback sequence for irregular keyframe progressions")  	;Pose animation 
	(ui-function-tooltip-item	"Autofly"	"Autofly"	"Animate a camera view along a path")  	;Autofly 
;;Palette: Locators
	(ui-function-tooltip-item	"LocatorMove"	"Move locator"	"Pick and move a locator")  	;Move locator 
	(ui-function-tooltip-item	"LocatorAnnotate"	"Annotate"	
						"Add a label to an existing point or locator")  	;Annotate 
	(ui-function-tooltip-item	"LocatorDist"	"Distance"	
						"Measure the distance between two points or locators")  	;Measure:Distance 
	(ui-function-tooltip-item	"LocatorAngle"	"Angle"	
						"Measure the angle between three points or locators")  	;Measure:Angle 
	(ui-function-tooltip-item	"LocatorRadius"	"Radius"	"Measure the radius of a curve or arc")  	;Measure:Radius 
	(ui-function-tooltip-item	"LocatorDiameter"	"Diameter"	"Measure the diameter of a circle")  	;Measure:Diameter 
	(ui-function-tooltip-item	"LocatorClosestPoint"	"Closest point deviation"	
						"View the distance between a locator and the closest point on a curve or surface")  	;Deviation:Closest Point 
	(ui-function-tooltip-item	"Deviation"	"Deviation"	
						"View the closest distance between two curves or surfaces")  	;Deviation:Deviation 
	(ui-function-tooltip-item	"MinMaxDeviation"	"Curve to curve deviation"
						"View deviation comb between two curves")  	;Deviation:Curve to curve
	(ui-function-tooltip-item	"MinMaxDevSrfSrf"	"Surface to surface deviation"
						"View deviation comb between two surfaces")  	;Deviation:Surface to surface
	(ui-function-tooltip-item	"MinMaxDevCrvSrf"	"Curve to surface deviation"
						"View deviation comb between a curve and a surface")  	;Deviation:Curve to surface
	(ui-function-tooltip-item	"MinMaxDevMeshSrf"	"Mesh to surface deviation"
						"View deviation between a mesh and a surface")  	;Deviation:Mesh to surface
	(ui-function-tooltip-item	"MinMaxCloud"	"Cloud to surface deviation"
						"View deviation comb between a point cloud and a surface")  	;Deviation:Cloud to surface
	(ui-function-tooltip-item	"DraftProperties"	"Draft properties"	"View undercuts and out-of-draft areas")  	;Draft properties 
	(ui-function-tooltip-item	"ArcLength"	"Arc length"	"Measure the true length of a curve or surface")  	;Arc length 
	(ui-function-tooltip-item	"CurveCurvature"	"Curve curvature"	"View the curvature or radius comb of a curve")  	;Curve curvature 
;;Palette: Evaluate
	(ui-function-tooltip-item	"SurfaceContinuity"	
						"Surface continuity"	"Check continuity between and within surfaces")  	;Continuity:Surface continuity 
	(ui-function-tooltip-item	"CurveContinuity"	
						"Curve continuity"	"Check continuity between curves")  	;Continuity:Curve continuity 
	(ui-function-tooltip-item	"Highlights"	"Highlights"	
						"Create curve-on-surfaces corresponding to highlight lines")  	;Surface evaluate;Highlight
	(ui-function-tooltip-item	"Curvature"	"Curvature"	
						"Create curve-on-surfaces along lines of constant curvature")  	;Surface evaluate;Curvature
	(ui-function-tooltip-item	"Contour"	"Contour"	
						"Create curve-on-surfaces from a single-plane cross section")  	;Surface evaluate;Contour
	(ui-function-tooltip-item	"Horizon"	"Horizon"	
						"Create curve-on-surfaces from horizon lines as seen from a point in space")  	;Surface evaluate;Contour
	(ui-function-tooltip-item	"DynamicCrossSection"	"Dynamic section"	
						"View a cross section of surfaces or meshes by dragging a plane through the model")  	;Dynamic Section 
	(ui-function-tooltip-item	"PartingLine"	"Parting line"	
						"Create curve-on-surfaces at the boundaries of out-of-draft areas")  	;Parting line 
	(ui-function-tooltip-item	"MinMaxCurvature"	"Min/max curvature"
						"Display minimum and maximum curvature on a surface or a set of surfaces")  	;Min/max curvature 
	(ui-function-tooltip-item	"MassProperties14"	"Mass properties"
						"Display mass properties, volume, and surface area of the model")  	;Mass properties 
	(ui-function-tooltip-item	"ModelCheckCmd"	"Check model"	
						"Evaluate objects for common problems that may prevent data transfer")  	;Check model
	(ui-function-tooltip-item	"DeviationMap"	"Deviation map"	
						"Show the distances between a set of surfaces or meshes as a colored error map")  	;Deviation map
	(ui-function-tooltip-item	"ContactAnalysis"	"Contact analysis"	
						"Evaluate the safety of a model for potential human impact with sharp surfaces")  	;Contact analysis
	(ui-function-tooltip-item	"DynamicMeasurement"	"Dynamic measurement"	
						"Measure distances quickly on wireframe or shaded surfaces")  	;Dynamic measurement
	(ui-function-tooltip-item	"PedestrianProtection"	"Pedestrian protection"
						"Evaluate frontal impact pedestrian contact points")  	;Pedestrian protection
	(ui-function-tooltip-item	"SurfCosEval"	"Surface evaluate"	
						"Create curves-on-surface for various criteria")  	;Surface evaluate... 
	(ui-function-tooltip-item	"SurfCurvature"	"Surface curvature"	
						"View surface curvature via a color texture")  	;Surface Curvature:Surf curvature 
	(ui-function-tooltip-item	"SurfCurvParams"	"Surface curvature params"
						"Fine-tune how the Surface curvature tool displays colors")  	;Surface Curvature:Surf curv params... 
	(ui-function-tooltip-item	"SurfaceHighlight"	"Highlight"	
						"View surface flaws via a color texture that simulates natural highlights")  	;Highlights:Highlight 
	(ui-function-tooltip-item	"HighlightParams"	"Highlight params"
						"Fine-tune how the Highlight tool displays colors")  	;Highlights:Highlight params... 
;;Palette: Point Clouds
	(ui-function-tooltip-item	"Subset"	"Subset"	
						"Discard unwanted points, or divide a large cloud into smaller clouds")  	;Subset 
	(ui-function-tooltip-item	"CloudCrvProject"	"Project curve"	
						"Project a curve onto a selected point cloud")  	;Project curve 
	(ui-function-tooltip-item	"Gridded"	"Gridded surfaces"
						"Create a surface fitted to cloud points, bounded by four curves")  	;Surfaces:Gridded 
	(ui-function-tooltip-item	"Detailed"	"Detailed surfaces"
						"Create a trimmed-surface fitted to cloud points, bounded by any number of curves")  	;Surfaces:Detailed 
	(ui-function-tooltip-item	"Corners"	"Corner surfaces"
						"Create a surface fitted to cloud points, using four selected points as its corners")  	;Surfaces:Corners 
	(ui-function-tooltip-item	"CloudMerge"	"Merge"	
						"Merge selected point clouds into a single large cloud")  	;Merge 
	(ui-function-tooltip-item	"Tessellate"	"Tessellate"	"Create a polyset by sampling points in a point cloud")  	;Tessellate 
;;Blend Curve: BlendCrv Tools
	(ui-function-tooltip-item	"BlendCurve"	"Create blend curve"	"Create new blend curves in the scene")  		;Blend curve create 
	(ui-function-tooltip-item	"BlendCurveAddPoints"	"Blend curve add points"	"Add blend points to blend curves")  	;Blend curve add points 
	(ui-function-tooltip-item	"BlendCurveEditTangent"	"Blend curve edit"	"Move a blend point or edit the direction constraints of multiple blend points")  	;Blend curve edit tangent
	(ui-function-tooltip-item	"BlendCurvePlanarize"	"Blend curve planarize"	"Flatten blend curves to a plane")  		;Blend curve planarize
	(ui-function-tooltip-item	"BlendCurveEdit"	"Edit blend curve"	
						"Select a blend curve for editing (required for other blend curve tools)")  		;Blend curve edit 
	(ui-function-tooltip-item	"BlendCurveDeletePoint"	"Delete blend constraint"	
						"Delete blend constraint from the curve selected for editing")  	;Constraint Edits:Blend constraint delete 
	(ui-function-tooltip-item	"BlendCurvePtDissociate"	"Dissociate blend constraint"
						"Detach a constraint from the curve selected for editing")  	;Constraint Edits:Blend constraint dissociate 
	(ui-function-tooltip-item	"BlendCurveMakeMaster"	"Make master blend point"
						"Reverse the master-slave relationship between attached blend curves")  	;Constraint Edits:Blend pt make master 
	(ui-function-tooltip-item	"BlendCurveToggleLoc"	"Blend constraint interpolation location"
						"Constrain the curve selected for editing to go through a constraint")  	;Constraint Interpolation Direction:Blend constraint interp location 
	(ui-function-tooltip-item	"BlendCurveToggleXYZ"	"Blend constraint interpolation direction"
						"Constrain the curve to go through a constraint in a certain direction")  	;Constraint Interpolation Direction:Blend constraint interp direction 
	(ui-function-tooltip-item	"BlendCurveToggleGeom"	"Blend constraint interpolation geometry"
						"Constrain the tangent of the curve selected for editing to another object")  	;Constraint Interpolation Direction:Blend constraint interp geometry 
	(ui-function-tooltip-item	"BlendCurveDirectionRay"	"Blend constraint directed"
						"Change the sub-type of a direction constraint (set direction of its tangent)")  	;Constraint Direction Type:Blend constraint directed 
	(ui-function-tooltip-item	"BlendCurveDirectionParallel"	"Blend constraint parallel"
						"Change the sub-type of a direction constraint (make tangent parallel to a line)")  	;Constraint Direction Type:Blend constraint parallel 
	(ui-function-tooltip-item	"BlendCurveG0"	"Blend constraint G0"	
						"Change a constraint's continuity to positional (G0)")  	;Constraint Continuity:Blend constraint G0 
	(ui-function-tooltip-item	"BlendCurveG1"	"Blend constraint G1"	
						"Change a constraint's continuity to tangent (G1)")  	;Constraint Continuity:Blend constraint G1 
	(ui-function-tooltip-item	"BlendCurveG2"	"Blend constraint G2"	
						"Change a constraint's continuity to curvature (G2)")  	;Constraint Continuity:Blend constraint G2 
	(ui-function-tooltip-item	"BlendCurveG3"	"Blend constraint G3"	
						"Change a constraint's continuity to constant rate of curvature change (G3)")  	;Constraint Continuity:Blend constraint G3 
	(ui-function-tooltip-item	"BlendCurveG4"	"Blend constraint G4"	
						"Change a constraint's continuity to constant rate of change of rate of change (G4)")  	;Constraint Continuity:Blend constraint G4 
	(ui-function-tooltip-item	"BlendCurveDirectionGeometric"	"Blend constraint geometric curvature"
						"Use parametric curvature when a geometry constraint is attached to a surface")  	;Constraint Curvature Type:Blend constraint geometric curvature 
	(ui-function-tooltip-item	"BlendCurveDirectionParametric"	"Blend constraint parametric curvature"
						"Use geometric curvature when a geometry constraint is attached to a surface")  	;Constraint Curvature Type:Blend constraint parametric curvature 
	(ui-function-tooltip-item	"BlendCurveDegree1"	"Blend curve degree 1" 
						"Change degree of curvature to 1 for curve selected for editing")  	;Curve Degree:Blend curve degree 1 
	(ui-function-tooltip-item	"BlendCurveDegree2"	"Blend curve degree 2" 
						"Change degree of curvature to 2 for curve selected for editing")  	;Curve Degree:Blend curve degree 2 
	(ui-function-tooltip-item	"BlendCurveDegree3"	"Blend curve degree 3" 
						"Change degree of curvature to 3 for curve selected for editing")  	;Curve Degree:Blend curve degree 3 
	(ui-function-tooltip-item	"BlendCurveDegree5"	"Blend curve degree 5" 
						"Change degree of curvature to 5 for curve selected for editing")  	;Curve Degree:Blend curve degree 5 
	(ui-function-tooltip-item	"BlendCurveDegree7"	"Blend curve degree 7" 
						"Change degree of curvature to 7 for curve selected for editing")  	;Curve Degree:Blend curve degree 7 
	(ui-function-tooltip-item	"BlendCurveChord"	"Blend curve chord"
						"Use chord-length edit point spacing for curve selected for editing")  	;Curve Knot Spacing:Blend curve chord 
	(ui-function-tooltip-item	"BlendCurveUniform"	"Blend curve uniform"
						"Use uniform edit point spacing for curve selected for editing")  	;Curve Knot Spacing:Blend curve uniform 
;;Curve Networks: CrvNet Tools
	(ui-function-tooltip-item	"CN_Pick"	"Pick curve network"	"Pick a curve network")  	;Pick network 
	(ui-function-tooltip-item	"CN_New"	"New curve network"	"Create a new curve network from a mesh of curves")  	;New network 
	(ui-function-tooltip-item	"CN_PosContinuity"	"Positional continuity"
						"Change continuity enforced on a curve to positional")  	;Continuity:Positional continuity 
	(ui-function-tooltip-item	"CN_TanContinuity"	"Tangent continuity"
						"Change continuity enforced on a curve to tangent")  	;Continuity:Tangent continuity 
	(ui-function-tooltip-item	"CN_CurvContinuity"	"Curvature continuity"
						"Change continuity enforced on a curve to curvature")  	;Continuity:Curvature continuity 
	(ui-function-tooltip-item	"CN_Add"	"Add curve to network"	"Add curves to the curve network")  	;Add/subtract curves:Add curve to network 
	(ui-function-tooltip-item	"CN_Subtract"	"Remove curve from network"	"Remove curves from the curve network")  	;Add/subtract curves:Remove curve from network 
	(ui-function-tooltip-item	"CN_Implied"	"Implied tangency"	
						"Maintain tangency along a symmetry plane (for later duplication)")  	;Implied tangency 
	(ui-function-tooltip-item	"CN_Analyze"	"Analyze network"	
						"View information about a curve network")  	;Analyze network
	(ui-function-tooltip-item	"CN_MapShape"	"Reset sculpt curves mapping"
						"Reset mapping, weight, and influence of sculpt curves")  	;Reset sculpt curves mapping 
	(ui-function-tooltip-item	"CN_AddControl"	"Add sculpt curve"	"Add a sculpt curve to the network")  	;Add/delete sculpt:Add sculpt curve 
	(ui-function-tooltip-item	"CN_DelControl"	"Delete sculpt curve"	"Remove a sculpt curve from the network")  	;Add/delete sculpt:Delete sculpt curve 
	(ui-function-tooltip-item	"CN_Pin"	"Pin edge"	
						"Specify whether or not curve segments are influenced by sculpt curves")  	;Pin edge 
	(ui-function-tooltip-item	"CN_UnitWeight"	"Unit weight"
						"Specify that a sculpt curve has the same influence over its length")  	;Influence weights:Unit weight 
	(ui-function-tooltip-item	"CN_MultiWeight"	"Multi weight"
						"Specify that a sculpt curve has different amounts of influence along its length")  	;Influence weights:Multi weight 
	(ui-function-tooltip-item	"CN_Lock"	"Lock intersection"	
						"Edit a curve while maintaining its intersections with other curves in the network")  	;Lock intersection 
	(ui-function-tooltip-item	"CN_RegionHigh"	"Large region"	
						"Specify that a sculpt curve has influence over a large region")  	;Region of influence:Large region 
	(ui-function-tooltip-item	"CN_RegionMedium"	"Medium region"	
						"Specify that a sculpt curve has influence over a medium region")  	;Region of influence:Medium region 
	(ui-function-tooltip-item	"CN_RegionLow"	"Small region"	
						"Specify that a sculpt curve has influence over a small region")  	;Region of influence:Small region 
	(ui-function-tooltip-item	"CN_AutoUpdateToggle"	"Toggle auto-update"
						"Toggle if curve network surfaces are updated whenever a curve is changed")  	;Toggle auto-update 
	(ui-function-tooltip-item	"CN_Build"	"Build network"
						"Explicitly rebuild the curve network surfaces")  	;Build network 
