;
;; Tooltip Definitions:
;;
;; Syntax:
;;
;;      All UI tooltip items have the same syntax but are distinguished
;;      by the class name in the tooltip-item command and are stored internally
;;      in separate tables.  
;;
;;		(ui-<class>-tooltip-item "<tooltip ID>" "<tip text>" ["<tip long text"])
;;
;;      where:
;;
;;          <tooltip ID>: is a unique identifier for this tooltip.
;;                        See below for how to specify tooltips for 
;;                        various ui objects and how the id is matched.
;;
;;          <tip text>:   is a text field containing the tip text (typically
;;                        contains short string such as command name/title)
;;
;;          <tip long text>: is a text field containing an optional long
;;                           tip string (typically provides more information
;;                           than the tip text about the command function or use
;;                           If the long text string is not specified the same
;;                           string will be used for short and long tips
;;     
;;
;; How To Use:
;;
;;      There are several classes of tooltips that can be specified.
;;      The tooltip classes distinguish differences in how the tooltips are
;;      specified, matched to various ui elements and processed by the software.
;;
;;      UI Function widgets (ui-function-tooltip-item):
;;           -this will associate the tooltips with ui-functions which are 
;;            also referred to as ui-choices (menu commands, pallette and 
;;            shelf items, etc.)
;;           -specify the ui-function command name as the tooltip id. 
;;            All UI items that invoke this command will get the correct tooltip.  
;;           -Note that default tooltips will be generated for ui functions
;;            by the software in the event that they are not found in the list 
;;            of ui-function-tooltip-items specified externally. 
;;           -note also that in the case of shelf items, a user-defined label
;;            will be used if it exists (overriding both the default tip text 
;;            and any values that may be specified in this file). 
;;
;;            example:
;;                (ui-function-tooltip-item "New"       ; command name
;;                                          "New File"  ; short tip
;;                                          "Create a new file") ; long tip
;;
;;
;;      UI Cells (ui-cell-tooltip-item):
;;           -this will associate a tooltip with a cell by matching on the cell
;;            name. 
;;           -the cell name is specified as the tooltip id.
;;           -the event handler for initiating tooltip display must be
;;            associated with each cell (tooltips_by_cellname_eh)
;;           -no default tips are provided for cells unless the text is
;;            found here (i.e. if the text is not in the cell tooltip table, a
;;            tip will not be shown).
;;           
;;            example:
;;                (ui-cell-tooltip-item "HistoryButton"       ; cell name
;;                                      "Promptline History"  ; short tip
;;                                      "Display promptline history window") ; long tip
;;
;;      Custom (ui-custom-tooltip-item):
;;           -any unique tooltip id can be used to make a custom tooltip item.
;;            There is no pre-defined behaviour associated with these items, the
;;            software requesting such an item must handle initiating the tip,
;;            retrieving/setting the tip text and other info appropriately.
;;
;;            example:
;;                 (ui-custom-tooltip-item  "TrashCan"   ; tipID 
;;                                          "Delete"     ; short tip
;;                                          "Drag and drop to delete"); long tip
;;
;;                 Note: in this example the ID "TrashCan" is hardcoded in the 
;;                       software
;;
;;
;;
;;
;; UI Function (UI Choice) Tooltips:
;; ---------------------------------
;; (pallette, shelf, menu commands etc.)
;;
;
; Loaded from a separate file
;
(ui-load "Comlib/Tooltips_Functions.scm")
;;
;; Customized Tooltips (special-case ID matching and handling)
;; -----------------------------------------------------------
;; Note: ID fields are specified in the code - change them here at your peril!
;;
;;
;;Diagnostic Shading Editor Shade Modes
;;
(if (ui-symbol-true "studioviewer_menus_active")
	(begin
	  ; StudioViewer
		(ui-custom-tooltip-item  "DiagShade.SHADE_NONE" "Shaded"
							 "Shade with materials assigned to surfaces")
		(ui-custom-tooltip-item  "DiagShade.SHADE_MULTI_COLOR" "Single Color"
								 "Shade with single color");
		(ui-custom-tooltip-item  "DiagShade.SHADE_RANDOM_COLOR" "Surface Layout"
								 "Shade with random colors to show surface layout"); 
		(ui-custom-tooltip-item  "DiagShade.SHADE_SRF_EVAL" "Surface Evaluation"
								 "Shade with surface evaluation map");
		(ui-custom-tooltip-item  "DiagShade.SHADE_CRV_EVAL" "Curvature Evaluation"
								 "Shade with curvature evaluation map");
		(ui-custom-tooltip-item  "DiagShade.SHADE_STRIPE_TEXTURE" "Horizontal/Vertical"
								 "Shade with horizontal or vertical highlights"); 
		(ui-custom-tooltip-item  "DiagShade.SHADE_TEXTURE3" "Double-horizon"
								 "Shade with double-horizon texture"); 
		(ui-custom-tooltip-item  "DiagShade.SHADE_TEXTURE7" "User-defined texture"
								 "Shade with a user-defined texture"); 
		(ui-custom-tooltip-item  "DiagShade.SHADE_VISUALSTATE1" "Visual State 1"
								 "Shade using visual state 1");
		(ui-custom-tooltip-item  "DiagShade.SHADE_VISUALSTATE2" "Visual State 2"
								 "Shade using visual state 2");
		(ui-custom-tooltip-item  "DiagShade.SHADE_VISUALSTATE3" "Visual State 3"
								 "Shade using visual state 3");
		(ui-custom-tooltip-item  "DiagShade.SHADE_FILESTATE" "File State"
								 "Shade using file state");
		)
	(begin
	  ; all StudioProducts excluding the StudioViewer
		(ui-custom-tooltip-item  "DiagShade.SHADE_NONE" "Shading Off"
							 "Turn off diagnostic shading")
		(ui-custom-tooltip-item  "DiagShade.SHADE_MULTI_COLOR" "Multi Color"
								 "Diagnostic shade using multiple colors");
		(ui-custom-tooltip-item  "DiagShade.SHADE_RANDOM_COLOR" "Random Color"
								 "Diagnostic shade using random colors"); 
		(ui-custom-tooltip-item  "DiagShade.SHADE_SRF_EVAL" "Surface Evaluation"
								 "Diagnostic shade using surface evaluation map");
		(ui-custom-tooltip-item  "DiagShade.SHADE_CRV_EVAL" "Curvature Evaluation"
								 "Shade with curvature evaluation map");
		(ui-custom-tooltip-item  "DiagShade.SHADE_ISOANGLE" "Iso Angle"
								 "Diagnostic shade using iso-angle highlights"); 
		(ui-custom-tooltip-item  "DiagShade.SHADE_STRIPE_TEXTURE" "Horizontal/Vertical"
								 "Diagnostic shade using horizontal or vertical highlights"); 
		(ui-custom-tooltip-item  "DiagShade.SHADE_TEXTURE3" "Double-horizon"
								 "Diagnostic shade using double-horizon texture"); 
		(ui-custom-tooltip-item  "DiagShade.SHADE_TEXTURE7" "User-defined texture"
								 "Diagnostic shade using a user-defined texture"); 
		(ui-custom-tooltip-item  "DiagShade.SHADE_VISUALSTATE1" "Visual State 1"
								 "Shade using visual state 1");
		(ui-custom-tooltip-item  "DiagShade.SHADE_VISUALSTATE2" "Visual State 2"
								 "Shade using visual state 2");
		(ui-custom-tooltip-item  "DiagShade.SHADE_VISUALSTATE3" "Visual State 3"
								 "Shade using visual state 3");
		(ui-custom-tooltip-item  "DiagShade.SHADE_FILESTATE" "File State"
								 "Shade using file state");
		(ui-custom-tooltip-item  "DiagShade.VISUALSTATE_SHADE_SETTINGS" "Launch the Shade Settings Option Box"
								 "Launch the Shade Settings Option Box");
		(ui-custom-tooltip-item  "DiagShade.VISUALSTATE_ENV_EDIT" "Launch the Environment Editor"
								 "Launch the Environment Editor");
		(ui-custom-tooltip-item  "DiagShade.VISUALSTATE_SAVE" "Save the environment to your prefs"
								 "Save the environment to your prefs");
		(ui-custom-tooltip-item  "DiagShade.DRAFT_ANGLE_UPDATE" "Update pull direction using selected vector or plane"
								 "Update pull direction using selected vector or plane");
        (ui-custom-tooltip-item  "DiagShade.ISO_ANGLE_SET_X" "Align vector with X axis"
								 "Align vector with X axis");
        (ui-custom-tooltip-item  "DiagShade.ISO_ANGLE_SET_Y" "Align vector with Y axis"
								 "Align vector with Y axis");
        (ui-custom-tooltip-item  "DiagShade.ISO_ANGLE_SET_Z" "Align vector with Z axis"
								 "Align vector with Z axis");
        (ui-custom-tooltip-item  "DiagShade.ISO_ANGLE_SHOW_MANIP" "Show the vector manipulator"
								 "Show the vector manipulator");
        (ui-custom-tooltip-item  "DiagShade.ISO_ANGLE_CREATE_CURVES" "Create Iso Angle Curves"
								 "Create Iso Angle Curves");
        (ui-custom-tooltip-item  "DiagShade.ISO_ANGLE_DELETE_CURVES" "Delete Iso Angle Curves"
								 "Delete Iso Angle Curves");
        (ui-custom-tooltip-item  "DiagShade.DRAFT_SET_X" "Align vector with X axis"
								 "Align vector with X axis");
        (ui-custom-tooltip-item  "DiagShade.DRAFT_SET_Y" "Align vector with Y axis"
								 "Align vector with Y axis");
        (ui-custom-tooltip-item  "DiagShade.DRAFT_SET_Z" "Align vector with Z axis"
								 "Align vector with Z axis");

		)
)
 

;;
;; Cell Tooltips (matched by cell-name)
;; ------------------------------------
;;
;(ui-cell-tooltip-item  "help" "Online Help") ; Help icon

;;Trashcans on the shelf and control panel
(ui-cell-tooltip-item  "trashcan" "Delete" "Drag and drop to delete")

;Alias main window promptline history
(ui-cell-tooltip-item  "HistoryButton" "Promptline History" 
					   "Open promptline history window")

;Main window component pick icons
(ui-cell-tooltip-item  "mo_pick_lights" "Pick Lights" "Enables/disables lights in component pick" )
(ui-cell-tooltip-item  "mo_pick_meshes" "Pick Meshes" "Enables/disables meshes in component pick" )
(ui-cell-tooltip-item  "mo_pick_constr_obj" "Pick Construction Objects" "Enables/disables construction objects in component pick") 
(ui-cell-tooltip-item  "mo_pick_curves" "Pick Curves" "Enables/disables curves in component pick")
(ui-cell-tooltip-item  "mo_pick_surfaces" "Pick Surfaces" "Enables/disables surfaces in component pick") 
(ui-cell-tooltip-item  "mo_pick_shells" "Pick Shells" "Enables/disables shells in component pick") 
(ui-cell-tooltip-item  "mo_pick_scans" "Pick Sections" "Enables/disables sections in component pick") 
(ui-cell-tooltip-item  "mo_pick_others" "Pick Others" "Enables/disables lights, cameras and solid textures in component pick")


;Main window snap icons
(ui-cell-tooltip-item  "magnet_snap" "Snap to CV/Edit Point" )
(ui-cell-tooltip-item  "grid_snap"   "Snap to Grid" )
(ui-cell-tooltip-item  "curve_snap"  "Snap to Curve" )  
(ui-cell-tooltip-item  "curve_snap_divisions"  "Curve Snap Divisions" )  

(ui-cell-tooltip-item  "cmdHistory"  "Command History" )  
(ui-cell-tooltip-item  "refManagerButton"  "Reference Data" )  

(ui-cell-tooltip-item  "curvatureTickbox" "Curvature ON/OFF" )
;;
;Main window brush color chip
(ui-cell-tooltip-item "colorbox"  "Brush Color" "Select brush color using the color editor")
(ui-cell-tooltip-item "ColorGrab" "Grab Brush Color" "Select brush color using the eye dropper")


;Main window pick image layer/pick image plane icons
(ui-cell-tooltip-item  "mo_pick_image_plane" "Pick Image Plane" "Enables/disables image plane in image pick")
(ui-cell-tooltip-item  "mo_pick_image_layer" "Pick Active Image Layer" "Enables/disables sketch image layer in image pick")


;ObjectLister
(ui-cell-tooltip-item  "branchexpander" "Expand/Contract ... <SHIFT> to effect descendants" "Expand/Contract Branch -- <Shift>-select to Expand/Contract Decendants")
(ui-cell-tooltip-item  "ObjectListerInfoBox" "Show/Hide Model Information" )
(ui-cell-tooltip-item  "ObjectListerNextPicked" "Goto the next picked list item" )
(ui-cell-tooltip-item  "ObjectListerPrevPicked" "Goto the previous picked list item" )
(ui-cell-tooltip-item  "ObjectListerSearch" "Enter start of object name to search for and pick" )
(ui-cell-tooltip-item  "ObjectListerSBDTick" "Show SBD order" )
(ui-cell-tooltip-item  "BranchExpandCollapseAllBtn" "Expand/Contract All Branches" )

;;; branch icons
(ui-custom-tooltip-item "ObjLister.LAYER_ICON" "Object Layer" "Object Layer")
(ui-custom-tooltip-item "ObjLister.GROUP_MEMBERSHIP" "Object Hierarchy" "Object Hierarchy")
(ui-custom-tooltip-item "ObjLister.SYMMETRY" "Toggle Layer Symmetry" "Toggle Layer Symmetry")
(ui-custom-tooltip-item "ObjLister.LAYER_CONTENT" "Objects in layer" "Number of objects in layer")
(ui-custom-tooltip-item "ObjLister.LAYER_ANIM" "Toggle Layer Playback" "Toggle Layer Playback")
(ui-custom-tooltip-item "ObjLister.LAYERBAR" "Add/Remove from Layer Bar" "Add/Remove from Layer Bar")
(ui-custom-tooltip-item "ObjLister.LAYER_STATE" "Layer Pick State" "Layer Pick State")
(ui-custom-tooltip-item "ObjLister.LAYER_NUMBER" "Layer Number" "Layer Number")
(ui-custom-tooltip-item "ObjLister.SET_MEMBERSHIP" "Object Set" "Object Set")
(ui-custom-tooltip-item "ObjLister.SET_EXCLUSIVITY" "Set Exclusivity" "Set Exclusivity")

;Layer Categories
(ui-custom-tooltip-item "LayerCategories.NUM_LAYERS" "Number of Layers" "Number of Layers")

;Reference Manager
(ui-custom-tooltip-item "RefManager.STATUS_QUEUED" "Import Queued" "Import Queued")
(ui-custom-tooltip-item "RefManager.STATUS_ACTIVE" "Translating" "Translating")
(ui-custom-tooltip-item "RefManager.STATUS_CANCELING" "Cancelling" "Cancelling")
(ui-custom-tooltip-item "RefManager.STATUS_FINISHED" "Ready for Import" "Ready for Import")
(ui-custom-tooltip-item "RefManager.STATUS_ERROR" "Translation Error" "Translation Error")
(ui-custom-tooltip-item "RefManager.STATUS_OUT_OF_DATE" "Reference out of date" "Reference out of date")
(ui-custom-tooltip-item "RefManager.STATUS_SOURCE_MISSING" "Reference Source can't be found" "Reference Source can't be found")
(ui-custom-tooltip-item "RefManager.STATUS_WREF_MISSING" "Cached Reference missing" "Cached Reference missing")
(ui-custom-tooltip-item "RefManager.STATUS_CIRCULAR_REFERENCE" "Circular Reference Error" "Circular Reference can't be imported")

(ui-cell-tooltip-item "RefManager.ImportTranslation" "Import Translation" "Import Translation")
(ui-cell-tooltip-item "RefManager.TranslationFailed" "Translation Failed" "Translation Failed")

(ui-cell-tooltip-item "ReferenceDirNotFound" "Directory not found" "Directory not found")
(ui-cell-tooltip-item "ReferenceOutputDir" "Set as output directory" "Set as output directory")

;Canvas Layer Editor
(ui-cell-tooltip-item  "ConstructionPlaneLister"  "Construction plane editor" )
(ui-cell-tooltip-item  "CanvasInfoEditor"  "Canvas general information" )
(ui-cell-tooltip-item  "newlayerfolder"  "Canvas layer folder" )  
(ui-cell-tooltip-item  "newlayer"  "Canvas image layer" )
(ui-cell-tooltip-item  "newmasklayer"  "Canvas mask layer" )
(ui-cell-tooltip-item  "newstencillayer"  "Canvas invisibility mask layer" )
(ui-cell-tooltip-item  "duplicatelayer"  "Duplicate layer" )
(ui-cell-tooltip-item  "ClearImageLayer"  "Clear Image " )
(ui-cell-tooltip-item  "deletelayer"  "Delete Layer" )
(ui-cell-tooltip-item  "canvasname"  "Canvas name" )
(ui-cell-tooltip-item  "canvasnameselector"  "Canvas selector" )
(ui-cell-tooltip-item  "canvaspick"  "Pick canvas" )
(ui-cell-tooltip-item  "canvaslookat"  "Lookat canvas" )
(ui-cell-tooltip-item  "canvasset"  "Set canvas" )
(ui-cell-tooltip-item  "canvaslock"  "Lock canvas" )
(ui-cell-tooltip-item  "canvasvisible"  "Canvas visibility" )
(ui-cell-tooltip-item  "cnvlayername"  "Canvas layer name" )
(ui-cell-tooltip-item  "cnvlayerassociate"  "Number of associated masks" )
(ui-cell-tooltip-item  "cnvlayerblend"  "Blend mode" )
(ui-cell-tooltip-item  "canvasblendselector"  "Blend mode selector" )
(ui-cell-tooltip-item  "cnvlayeropacity"  "Canvas layer opacity" )
(ui-cell-tooltip-item  "cnvlayervisible"  "Canvas layer visibility" )
(ui-cell-tooltip-item  "cnvlayereditordivider"  "Splitter" )
(ui-cell-tooltip-item  "canvasshowcurrent"  "Display only current layer" )
(ui-cell-tooltip-item  "canvasshowall"  "Display all layers" )
(ui-cell-tooltip-item  "maskshowlink"  "Show/hide linked masks in lister" )
(ui-cell-tooltip-item  "maskdisable"  "Enable/disable all masks" )
(ui-cell-tooltip-item  "maskvisible"  "Show/hide all masks" )

;HotSpots
(ui-cell-tooltip-item  "HS01"  "Set Paint brush mode" )
(ui-cell-tooltip-item  "HS02"  "Set Erase brush mode" )
(ui-cell-tooltip-item  "HS03"  "Set Hide brush mode" )
(ui-cell-tooltip-item  "HS04"  "Set Show brush mode" )
(ui-cell-tooltip-item  "HS05"  "Set Smear brush mode" )
(ui-cell-tooltip-item  "HS06"  "Set Blur brush mode" )
(ui-cell-tooltip-item  "HS07"  "Set Sharpen brush mode" )
(ui-cell-tooltip-item  "HS08"  "Set Dodge brush mode" )
(ui-cell-tooltip-item  "HS09"  "Set Burn brush mode" )
(ui-cell-tooltip-item  "HS10"  "Adjust brush Size -- Min and Max radius adjusted together" )
(ui-cell-tooltip-item  "HS11"  "Adjust brush Radius -- Min radius up/down, Max radius left/right" )
(ui-cell-tooltip-item  "HS12"  "Adjust brush Rotation" )
(ui-cell-tooltip-item  "HS13"  "Adjust brush Aspect" )
(ui-cell-tooltip-item  "HS14"  "Adjust color Value" )
(ui-cell-tooltip-item  "HS15"  "Adjust brush Opacity -- Min opacity up/down, Max opacity left/right" )
(ui-cell-tooltip-item  "HS16"  "Zoom canvas" )
(ui-cell-tooltip-item  "HS17"  "Pan canvas" )
(ui-cell-tooltip-item  "HS18"  "Reset brush to default settings" )
(ui-cell-tooltip-item  "HS19"  "Return to Last Brush used" )
(ui-cell-tooltip-item  "HS20"  "Open the color editor to change the current color" )
(ui-cell-tooltip-item  "HS21"  "Twist canvas" )
(ui-cell-tooltip-item  "HS22"  "Clear predictive stroke mode" )
(ui-cell-tooltip-item  "HS23"  "Set Line predictive stroke mode" )
(ui-cell-tooltip-item  "HS24"  "Set Curvature predictive stroke mode" )

(ui-cell-tooltip-item  "MoveCVHS01"  "XYZ"  "Move CVs along the X, Y, Z world axes" )
(ui-cell-tooltip-item  "MoveCVHS02"  "View"  "Move CVs according to the current view" )
(ui-cell-tooltip-item  "MoveCVHS03"  "Parallel"  "Move CVs parallel to a vector or hull line" )
(ui-cell-tooltip-item  "MoveCVHS04"  "NUV"  "Move CVs along the normal, or in the U or V direction on a surface" )
(ui-cell-tooltip-item  "MoveCVHS05"  "Projected"  "Move CVs in the direction of a hull line, a vector, or constrained to a reference plane" )
(ui-cell-tooltip-item  "MoveCVHS06"  "Slide"  "Move CVs along their hull" )
(ui-cell-tooltip-item  "MoveCVHS07"  "CV"  "Select and transform individual CVs" )
(ui-cell-tooltip-item  "MoveCVHS08"  "Hull"  "Select and transform a hull line" )
(ui-cell-tooltip-item  "MoveCVHS09"  "Move"  "Move CVs" )
(ui-cell-tooltip-item  "MoveCVHS10"  "Rotate"  "Rotate CVs around a pivot point" )
(ui-cell-tooltip-item  "MoveCVHS11"  "Scale"  "Scale CVs uniformly along all axes" )
(ui-cell-tooltip-item  "MoveCVHS12"  "Non proportional scale"  "Scale CVs by different amounts along each axis" )
(ui-cell-tooltip-item  "MoveCVHS13"  "Proportional modification"  "Proportionally modify CVs" )
(ui-cell-tooltip-item  "MoveCVHS14"  "Set pivot"  "Position the pivot point of the picked object" )
(ui-cell-tooltip-item  "MoveCVHS15"  "Non proportional scale"  "Scale CVs by different amounts along each axis" )
(ui-cell-tooltip-item  "MoveCVHS16"  "Rotate"  "Rotate CVs around a pivot point" )

(ui-cell-tooltip-item  "MoveCV_Xlocked"  "Lock X"  "Lock transformation in X" )
(ui-cell-tooltip-item  "MoveCV_Ylocked"  "Lock Y"  "Lock transformation in Y" )
(ui-cell-tooltip-item  "MoveCV_Zlocked"  "Lock Z"  "Lock transformation in Z" )
(ui-cell-tooltip-item  "MoveCV_UseStepSize"  "Use step size"  "Multiply transforms by step size for mouse clicks and arrow keys. " )
(ui-cell-tooltip-item  "MoveCV_LockStepSize"  "Lock step size"  "Lock step size to a single step per mouse action" )
(ui-cell-tooltip-item  "titlebarClose"  "Window close"  "Window close" )
(ui-cell-tooltip-item  "titlebarCollapse"  "Window collapse (Left click for pulldown)"  "Window collapse (Left click for pulldown)" )
(ui-cell-tooltip-item  "titlebarPulldown"  "Window pulldown menu"  "Window pulldown menu" )
(ui-cell-tooltip-item  "titlebarFit"  "Fit window to contents"  "Fit window to contents" )

(ui-cell-tooltip-item  "newVariant"  "New Variant"  "Capture a new variant" )
(ui-cell-tooltip-item  "Apply Camera"  "Apply camera"  "Apply Camera" )
(ui-cell-tooltip-item  "Apply Shading"  "Apply shading"  "Apply shading" )
(ui-cell-tooltip-item  "Apply Geometry"  "Apply geometry"  "Apply geometry" )
(ui-cell-tooltip-item  "Apply Layer Visibility"  "Apply layer visibility"  "Apply layer visibility" )
(ui-cell-tooltip-item  "Apply Catagory Visibility"  "Apply catagory visibility"  "Apply catagory visibility" )
(ui-cell-tooltip-item  "Apply Symmetry Only"  "Apply symmetry only"  "Apply symmetry only" )
(ui-cell-tooltip-item  "Apply Camera"  "Apply Camera"  "Apply camera" )
(ui-cell-tooltip-item  "Start Stop"  "Start/Stop playback of variants"  "Start/Stop playback of selected of group variants" )
(ui-cell-tooltip-item  "Prev Variant"  "Apply previous variant"  "Apply previous variant" )
(ui-cell-tooltip-item  "Next Variant"  "Apply next variant"  "Apply next variant" )
(ui-cell-tooltip-item  "DeleteVariantGroup"  "Delete variant group"  "Delete variant group" )
(ui-custom-tooltip-item  "cycle time"  "Cycle Time"  "Cycle Time" )
(ui-custom-tooltip-item  "variant scale"  "Variant Scale"  "Variant Scale" )

;; Cross Sections Lister

(ui-cell-tooltip-item  "combIcon"  "Toggle Curvature"  "Toggle curvature on cross sections" )
(ui-cell-tooltip-item  "curvatureTitle"  "Curvature Column"  "Curvature Column" )
(ui-cell-tooltip-item  "applyCrossSections"  "Apply Cross Sections"  "Apply Cross Sections" )
(ui-cell-tooltip-item  "applySelectedSections"  "Apply Active Cross Sections"  "Apply Active Cross Sections" )
(ui-cell-tooltip-item  "clearCrossSections"  "Clear Cross Sections off Picked/All Objects"  "Clear Cross Sections off Picked/All Objects" )

;; History Visualizer

(ui-cell-tooltip-item  "HistoryVisualizerZoomButton"  "Zoom Window"  "Open zoom window" )
