;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;
;  
;  
;  
;  
;
;------------------------------------------------------------------------
;
;	Purpose:	Set defaults for Scheme variables.liasPref type scheme vars
;				Those are variables which are read before productization
;				is known.
;
;-------------------------------------------------------------------------
(define UI_SYMBOL_GROUP_MISCELLANEOUS 0)       ;default groupId
(define UI_SYMBOL_GROUP_UNITS 1)
(define UI_SYMBOL_GROUP_TOLERANCES 2)
(define UI_SYMBOL_GROUP_RENDER_GLOBALS 3)
(define UI_SYMBOL_GROUP_ALIASPREFS 4)
(define UI_SYMBOL_GROUP_NOSAVE 5)

(ui-load "Comlib/ALmenu.dscm")
(ui-load "MOMenu/MOmenu.dscm")
(ui-load "Anim/ANmenu.dscm")
(ui-load "Render/REmenu.dscm")
(ui-load "Paint/PAmenu.dscm")


(ui-symbol "ALIAS_PB_MAX_SWAP_PERCENTAGE"			75 UI_SYMBOL_GROUP_ALIASPREFS )

(ui-symbol "ALIAS_COORD_SYS"						0 UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_FORCE_DEFAULT"					#f UI_SYMBOL_GROUP_ALIASPREFS )

(ui-symbol "ALIAS_ANTIALIASING"						0 UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_SHADED_ANTIALIASING"				0 UI_SYMBOL_GROUP_ALIASPREFS )

(ui-symbol "ALIAS_CURVE_PRECISION"					8 UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_ALT_HELP"							"" UI_SYMBOL_GROUP_ALIASPREFS )
(cond
 ((ui-symbol-true "using_hpux_os")
   (ui-symbol "ALIAS_EDITOR"		    			"dtpad" UI_SYMBOL_GROUP_ALIASPREFS ))
 ((ui-symbol-true "using_linux_os")
  (ui-symbol "ALIAS_EDITOR"                         "gedit" UI_SYMBOL_GROUP_ALIASPREFS))
 ((ui-symbol-true "using_irix_os")
  (ui-symbol "ALIAS_EDITOR"                         "jot" UI_SYMBOL_GROUP_ALIASPREFS))
 ((ui-symbol-true "using_mac_os")
   (ui-symbol "ALIAS_EDITOR"		    			"TextEdit" UI_SYMBOL_GROUP_ALIASPREFS ))
 (#t
  (ui-symbol "ALIAS_EDITOR"                         "notepad" UI_SYMBOL_GROUP_ALIASPREFS)))
(ui-symbol "ALIAS_WORDPAD_APP"						"" UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "PLUGIN_PATH"							"" UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "PLUGIN_LOAD_VERBOSE"					#f UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_INCLUDE_LINESTYLE_IN_TRIM"		#t UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_PROXY_ENABLE"						0 UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_PROXY_PORT"						"" UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_PROXY_HOSTNAME"					"" UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_PROXY_EXCEPTIONS"					"" UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_MARKER_STYLE"						2 UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_JOINT_STYLE"						0 UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_SCANNER_APP"						"/usr/sbin/gscan" UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_SCANNER_OTHER"					"" UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_RENDER_ENGINE"					"localhost" UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_RENDER_LOCATION"					"user_data/demo" UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_UNIX_SHELL"						"" UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_CUSTOM_UNIX_SHELL"				"" UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_DEFAULT_SHADER"					"" UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_DUMPSTER_LOCATION"				"" UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_LIBRARY_LOCATION"					"" UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_DEFAULT_PROJECT"					"" UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_USE_STEREO"						#f UI_SYMBOL_GROUP_ALIASPREFS )

(ui-symbol "ALIAS_PRINTER_APP"						"" UI_SYMBOL_GROUP_ALIASPREFS )

(ui-symbol "ALIAS_PLOT_DEVICE"						"postscript" UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_PLOT_FILTER"						"" UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_PLOT_OPTIONS"						"-oh" UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "dogface1"						"-oh" UI_SYMBOL_GROUP_ALIASPREFS )

(ui-symbol "SetUpPrint_TabPage" 					"Output_page" UI_SYMBOL_GROUP_ALIASPREFS )
;(ui-symbol "align_control_TabPage" 					"simple_page" UI_SYMBOL_GROUP_ALIASPREFS )
;(ui-symbol "square_control_TabPage" 				"simple_page" UI_SYMBOL_GROUP_ALIASPREFS )
;(ui-symbol "rail_control_TabPage" 					"simple_page" UI_SYMBOL_GROUP_ALIASPREFS )
;(ui-symbol "fillet_srf_TabPage" 					"simple_page" UI_SYMBOL_GROUP_ALIASPREFS )
;(ui-symbol "holeFiller_TabPage" 					"simple_page" UI_SYMBOL_GROUP_ALIASPREFS )
;(ui-symbol "draft_TabPage" 							"simple_page" UI_SYMBOL_GROUP_ALIASPREFS )
;(ui-symbol "freeform_blend_TabPage" 				"simple_page" UI_SYMBOL_GROUP_ALIASPREFS )


(if (ui-symbol-true "using_hpux_os" )
   (ui-symbol "ALIAS_PRINTER_APP"					"$ALIAS_LOCATION/bin/alias_printPS" UI_SYMBOL_GROUP_ALIASPREFS )
   )
(ui-symbol "dogface2"						"-oh" UI_SYMBOL_GROUP_ALIASPREFS )

(if (ui-symbol-true "using_sun_os" )
   (ui-symbol "ALIAS_PRINTER_APP"					"$ALIAS_LOCATION/bin/alias_printPS" UI_SYMBOL_GROUP_ALIASPREFS )
   )

(if (ui-symbol-true "using_linux_os" )
   (ui-symbol "ALIAS_PRINTER_APP"					"$ALIAS_LOCATION/bin/alias_printPS" UI_SYMBOL_GROUP_ALIASPREFS )
   )

(if (ui-symbol-true "using_irix_os" )
   (ui-symbol "ALIAS_PRINTER_APP"					"/usr/sbin/glp" UI_SYMBOL_GROUP_ALIASPREFS )
   )


(ui-symbol "ALIAS_SCANNER_APP"						"" UI_SYMBOL_GROUP_ALIASPREFS )

(if (ui-symbol-true "using_hpux_os" )
   (ui-symbol "ALIAS_SCANNER_APP"					"$ALIAS_LOCATION/bin/scan" UI_SYMBOL_GROUP_ALIASPREFS )
   )

(if (ui-symbol-true "using_sun_os" )
   (ui-symbol "ALIAS_SCANNER_APP"					"$ALIAS_LOCATION/bin/scan" UI_SYMBOL_GROUP_ALIASPREFS )
   )

(if (ui-symbol-true "using_linux_os" )
   (ui-symbol "ALIAS_SCANNER_APP"					"$ALIAS_LOCATION/bin/scan" UI_SYMBOL_GROUP_ALIASPREFS )
   )

(if (ui-symbol-true "using_irix_os" )
   (ui-symbol "ALIAS_SCANNER_APP"					"/usr/sbin/gscan" UI_SYMBOL_GROUP_ALIASPREFS )
   )

(ui-symbol "conf_select_device"		  	'MOUSE UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_kybd_options"         	0 UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "mo_viewmanip_mode"         	0 UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "mo_viewmanip_arrow_angle"  	45 UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "pa_ui_popup_interval"      	0.0 		UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_title_transparency"   	0.6 		UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "pa_brush_snap_tolerance"   	25 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "pa_default_layer_size_x"   	1900 		UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "pa_default_layer_size_y"   	1200 		UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "pa_default_canvas_on_persp"   	'PAINT_CANVAS_PERSP_PROMPT 		UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_icon_size"            	'UI_SMALL_ICON UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_browser_type"         	0 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_help_location"        	0 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_help_lang"        	0 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_help_ALT_envset"       0 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "aliasAltHelpEnvSet"         0 			UI_SYMBOL_GROUP_NOSAVE)

(ui-symbol "whatsNewHighlights"         1 			UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "conf_shared_toolClips_path" 	"" 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_productize_prefix" 	#t 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_rename_stage_on_save" 	#t 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_save_stage_with_stageset" 	#f 			UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "time_space"          		0 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "use_pick_chooser" 			#t 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_poi_type"		 	2			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "use_dolly_to_point"	 		#t			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "use_dolly_to_mouse"	 		#f			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_hide_cv_optim"        #f          UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_hide_locator_optim"   #f          UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "conf_surfpoint_jack_visable"	 	#t			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "use_nonp_scaling_box" 		#f			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "XformGuides"		 		#t			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_viewing_panel"			2			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "statusbar"				  	#f 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "titlefeedback"			  	#t 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_autosave_windows"	 	#t 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_common_tool_window_dims"	#t 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_activate_layer_name"	#f 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_remember_tool_window_state"   #t  UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "conf_window_transparency"	    #f 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_window_collapse_action"    0 		UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_current_tool_location"    0 		UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_inactive_window_opacity"	0.2 	UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_active_window_opacity"	1.0 	UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_window_opacity_trans"	1.0 	        UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "conf_interface_scale"	1.0 	        UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "help_popup_level"		 	2 			UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "mo_grid_corner_perspective_gnomen"	#t 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "use_cplane_view_coordsys" 	#f 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "cam_clamp_test_dist" 		3 			UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "conf_mwindows_ramp" 		1 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_show_layers_bar"   	#f          UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "layers_active"             	#t          UI_SYMBOL_GROUP_ALIASPREFS)

; Clutch keys menu config
(ui-symbol "ma_camtool"                 9           UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "ma_grdsnap"                 8           UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "ma_crvsnap"                 12          UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "ma_magsnap"                 4           UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "ma_mrkmenu"                 5           UI_SYMBOL_GROUP_ALIASPREFS)

; undo/redo options
(ui-symbol "undo_redo_limit_number" 	#t			UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "undo_redo_limit_memory" 	#t			UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "undo_redo_number_limit" 	11			UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "undo_redo_memory_limit" 	300			UI_SYMBOL_GROUP_ALIASPREFS )


; Space mouse options -- timeslider
(ui-symbol "sm_time_x_trans"       		10			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "sm_time_y_trans"       		10			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "sm_time_z_trans"       		10			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "sm_time_x_rot"         		10			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "sm_time_y_rot"         		10			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "sm_time_z_rot"         		10			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "sm_time_accel_threshold"  	0.5			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "sm_time_accel_factor"  		0.5			UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "sm_view_x_trans"     		10			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "sm_view_y_trans"     		10			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "sm_view_z_trans"     		10			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "sm_view_x_rot"       		10			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "sm_view_y_rot"       		10			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "sm_view_z_rot"       		10			UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "conf_productize_prefix"	  	#t			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_choice_labels"		  	#t			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_xform_constrain"		#t 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_xform_cplane_constrain"	#t 		UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_view_transition_time"	0.5 		UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_checkpoint_location" ""            UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "conf_msave_location" ""                 UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "conf_exception_log_location" ""         UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "conf_common_prefs_location" ""          UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "conf_common_prefs_location_Env" ""      UI_SYMBOL_GROUP_NOSAVE )
(ui-symbol "conf_common_prefs_location_EnvSet" #f   UI_SYMBOL_GROUP_NOSAVE )

(ui-symbol "conf_moveable_memory_directory" ""      UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ALIAS_MM_USE_DEFAULT"       1           UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "conf_create_icon_file"      1           UI_SYMBOL_GROUP_ALIASPREFS )

(ui-symbol "show_brush_preview"			#t 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "show_paint_cursor"			#t 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "show_brush_cursor" 			'PAINT_SHOW_CURSOR_IDLE 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "pa_show_layer_thumbnail"	#t 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "pa_compress_tablet_events"	#t 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "pa_open_paint_window"		'PAINT_CANVAS_PAINTWINDOW_OPEN 			UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "display_quality"            'PAINT_DISPLAY_HIGH UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_delguidelines_keeparound"		2			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_tgl_skl_bonestyle"       4			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_bonestyle_tab"       	#f			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "ly_name_or_number"			1			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "use_axis_constrained_tumble"	#t 			UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_vn_change_with_gn"		1			UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "mo_show_dashed_symmetry" 1 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "SINGLE_HOTKEY_MODE" #f UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "mo_crv_precision_default" 16 UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "workflow_level" 0 UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "ask_multi_session_warning" #t UI_SYMBOL_GROUP_ALIASPREFS)
						 
(ui-symbol "conf_curvesnap_division" 1 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_curvesnap_intersect" 1 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_curvesnap_intersect_proj" 0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_curvesnap_to_center" 0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "conf_curvesnap_to_pivot" 0 UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "mo_tgls_apply_to_all" #t UI_SYMBOL_GROUP_ALIASPREFS)

; Vizualization Panel stuff
(ui-symbol "Viz_asset_default_library_location" "" UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "Viz_asset_library_location"         "" UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "Viz_asset_library_location_Env"     "" UI_SYMBOL_GROUP_NOSAVE)
(ui-symbol "Viz_asset_library_location_EnvSet"  #f UI_SYMBOL_GROUP_NOSAVE)
(ui-symbol "Viz_ball_size"                      0  UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "Viz_shade_inactive_layers"          #f UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "Viz_shade_reference_layers"         #f UI_SYMBOL_GROUP_ALIASPREFS)

; iMan stuff
(ui-symbol "aw_iman_userid" "" UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "aw_iman_group" "" UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "aw_iman_role" "" UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "aw_iman_autologin" 1  UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "aw_iman_userdata0" 0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "aw_iman_userdata1" 0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "aw_iman_userdata2" 0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "aw_iman_userdata3" 0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "aw_iman_userdata4" 0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "aw_iman_userdata5" 0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "aw_iman_userdata6" 0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "aw_iman_userdata7" 0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_iman_asm_lister_x"	0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_iman_asm_lister_y"	0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_iman_asm_lister_h"	400 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_iman_asm_lister_w"	800 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_iman_plm_variant_rule_x" 0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_iman_plm_variant_rule_y" 0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_iman_plm_variant_rule_h" 800 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_iman_plm_variant_rule_w" 400 UI_SYMBOL_GROUP_ALIASPREFS)


(ui-symbol "default3D_mo_create_guidelines"      0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "default3D_mo_use_stepsize"           0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "default3D_newcrv.progressive_degree" 0 UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "paint_mo_create_guidelines"      0 UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "paint_mo_use_stepsize"           0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "paint_newcrv.progressive_degree" 1 UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "ce_slider_color_model"          0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "ColorEditor_TabPage" "wheel" UI_SYMBOL_GROUP_ALIASPREFS )

(ui-symbol "mo_view_publish_bookmark_site_url" "http://" UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_view_publish_bookmark_userID" "" UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "mo_view_publish_bookmark_userID" "" UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "mo_shade_preset"		"" UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "reference_manager_view" 2 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "reference_manager_filter_surfaces" #f UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "reference_manager_filter_curves" #f UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "reference_manager_filter_meshes" #f UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "reference_manager_filter_shells" #f UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "historyviz_view" 1 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "historyviz_grouptargets" 0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "historyviz_hideonreplace" 0 UI_SYMBOL_GROUP_ALIASPREFS)

;; Automanip prefs
(ui-symbol "mo_diagshade_lightcontrol_location" 4  UI_SYMBOL_GROUP_ALIASPREFS)

;; Viewcube prefs
(ui-symbol "mo_viewcube_position" 1  UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_viewcube_size"     0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_viewcube_opacity"                         25  UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_viewcube_keepupright"                     #t UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_viewcube_snap_to_view"                    #f UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_viewcube_fit_to_view"                     #t UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_viewcube_ortho_faces"                     #t UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_viewcube_previous_camera"                 0  UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mm_show_optionbox"				#t UI_SYMBOL_GROUP_ALIASPREFS )

(ui-symbol "mo_shader_bake"                     #t UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_shader_bake_installed_images"    #t UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "mo_replace_shader_asset"    #t UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_replace_shader_selected" #f UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_replace_shader_dir"      "" UI_SYMBOL_GROUP_ALIASPREFS)

;(ui-symbol "align_control_TabPage" "simple_page" UI_SYMBOL_GROUP_ALIASPREFS )
;(ui-symbol "square_control_TabPage" "simple_page" UI_SYMBOL_GROUP_ALIASPREFS )
;(ui-symbol "rail_control_TabPage" "simple_page" UI_SYMBOL_GROUP_ALIASPREFS )
;(ui-symbol "fillet_srf_TabPage" "simple_page" UI_SYMBOL_GROUP_ALIASPREFS)
;(ui-symbol "holeFiller_TabPage" "simple_page" UI_SYMBOL_GROUP_ALIASPREFS)
;(ui-symbol "draft_TabPage" "simple_page" UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "face_selection" #t  UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "face_selection_closest" #t  UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "selection_behaviour_LMB" 'UI_SELECT_TOGGLE  UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "selection_behaviour_MMB" 'UI_SELECT_ADD  UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "selection_behaviour_RMB" 'UI_SELECT_UNPICK  UI_SYMBOL_GROUP_ALIASPREFS)

; Multi-Lister Shaderball size - Default is BR_SMALLICON = 8
(ui-symbol "mo_shader_display_mode"    8 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "ObjectLister_embedded" #f UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "ObjectLister_pinned" #f UI_SYMBOL_GROUP_ALIASPREFS )

(ui-symbol "LayerCategories_embedded" #f UI_SYMBOL_GROUP_ALIASPREFS )
(ui-symbol "LayerCategories_pinned" #f UI_SYMBOL_GROUP_ALIASPREFS )

(ui-symbol "mo_pmod_falloff_uv_lock"  #f UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_pmod_falloff_winpos_set"  #f UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_pmod_falloff_winpos_x"    0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_pmod_falloff_winpos_y"    0 UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "mo_object_lister_width"    300 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_object_lister_height"   3000 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_object_lister_ypos"     0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_object_lister_opened"   #f UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_object_lister_yTopOffset"   21 UI_SYMBOL_GROUP_ALIASPREFS)

(ui-symbol "mo_categories_lister_width"       300 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_categories_lister_height"      3000 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_categories_lister_ypos"        0 UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_categories_lister_opened"      #f UI_SYMBOL_GROUP_ALIASPREFS)
(ui-symbol "mo_categories_lister_yTopOffset"  21 UI_SYMBOL_GROUP_ALIASPREFS)


; Don't ask Confirm symbols
(ui-interface-symbol "dont_show_sugarhill_dialog" 0 )
(ui-interface-symbol "dont_show_whatsnewhighlights_dialog" 0 )
(ui-interface-symbol "dont_show_VizAssetLibraryList_newfeature" 0)
(ui-interface-symbol "learning_movies_dont_show_option" 0 )
(ui-interface-symbol "dontask_retrieve_legacy" 0 )
(ui-interface-symbol "dontask_shortlong" 0)
(ui-interface-symbol "mo_dontask_iconEdit" 0)
(ui-interface-symbol "pa_showWarn_overlay" 1)
(ui-interface-symbol "pa_showWarn_doublebuffer" 0)
(ui-interface-symbol "pa_showWarn_mmx" 0)
(ui-interface-symbol "pa_showWarn_overlay" 0)
(ui-interface-symbol "pa_showWarn_tablet" 0)
(ui-interface-symbol "pa_showWarn_remindSetHotKey" #t)
(ui-interface-symbol "mo_dontask_shelfTabDelete" 0)
(ui-interface-symbol "mo_dontask_shelfsetDelete" 0)
(ui-interface-symbol "mo_dontask_bmTabDelete" 0)
(ui-interface-symbol "mo_dontask_trimgroups" 0)
(ui-interface-symbol "dontask_export_current_window" 0)
(ui-interface-symbol "mo_dontask_qtvr" 0)
(ui-interface-symbol "dontask_retrieve_legacy" 0)
(ui-interface-symbol "mo_dontask_exportBakedOrientationToWire" 0)
(ui-interface-symbol "mo_tglshade_cube_supported" 0)
(ui-interface-symbol "pa_modifierkey_conflictshow" 0)
(ui-interface-symbol "dontask_noopShortMenus" 0)
(ui-interface-symbol "mo_dontask_WorkSpaceDelete" 0)
(ui-interface-symbol "dontask_multi_session_warning" 0)
(ui-interface-symbol "dontask_workflow_level_B" 0)
(ui-interface-symbol "mo_dontask_reset_tool" 0)
(ui-interface-symbol "mo_dontask_reset_window_warning" 0)
(ui-interface-symbol "mo_dontask_prefsSetsDelete" 0)
(ui-interface-symbol "mo_dontask_multiListerEnvWarning" 0)
(ui-interface-symbol "mo_dontask_license_released" 0)
(ui-interface-symbol "mo_dontask_historyvizNothingToDelete" 0)
(ui-interface-symbol "mo_dontask_historyvizDeleteSelected" 0)
(ui-interface-symbol "mo_dontask_historyvizQueryEditTooMany" 0)
(ui-interface-symbol "mo_dontask_historyvizQueryEditNothingSelected" 0)
(ui-interface-symbol "mo_dontask_historyvizNothingToSuspend" 0)
(ui-interface-symbol "mo_dontask_historyvizNothingToPick" 0)
(ui-interface-symbol "mo_dontask_historyvizReplaceNothingSelected" 0)
(ui-interface-symbol "mo_dontask_subdivDeleteRejected" 0)
(ui-interface-symbol "mo_dontask_appendNumberToLayerName" 0)
(ui-interface-symbol "mo_dontask_replaceShaderAll" 0)
(ui-interface-symbol "mo_dontask_replaceShaderResult" 0)
(ui-interface-symbol "mo_dontask_IntelGraphics" 0)
(ui-interface-symbol "mo_dontask_pluginManagerSecurityWarning" 0)


; boundary symbols
(ui-interface-symbol "mcheck_boundary" 34.5416)
(ui-interface-symbol "fullpath_boundary" 29.2354)
(ui-interface-symbol "ReferenceManager_boundary" 49.3151)
(ui-interface-symbol "modeBox_boundary" 62.8945)
(ui-interface-symbol "modeBox_shelf_boundary" 71.9876)
(ui-interface-symbol "modelingPanelShelves_boundary" 74.2038)
(ui-interface-symbol "classicPanelShelves_boundary" 67.2467)
(ui-interface-symbol "paintPanelShelves_boundary" 84.7661)
(ui-interface-symbol "subdsPanelShelves_boundary" 50.0)
(ui-interface-symbol "renderPanelShelves2_boundary" 64.6552)
(ui-interface-symbol "renderPanelShelves_boundary" 57.0690)
(ui-interface-symbol "nameinfo_boundary" 20.3125)

; slideout symbols
(ui-interface-symbol "moveCV_spot_slideout_opened" 1 )
(ui-interface-symbol "moveCV_spot_sub_slideout_opened" 1 )

;; Tool Symbols
(ui-interface-symbol "tool_window_was_opened" #f )

; Marking Menu Editor
(ui-interface-symbol "mmedit_shelf_choice" 1)
(ui-interface-symbol "mmedit_icon_mode" 3)

;; Other
(ui-interface-symbol "variance_scale" 1.0 )


(ui-interface-symbol "vistaBrowseWireReadFileDisplayIndex"      3  )
(ui-interface-symbol "vistaBrowseWireWriteFileDisplayIndex"     0  )
(ui-interface-symbol "vistaBrowseRefReadFileDisplayIndex"       46  )
(ui-interface-symbol "vistaBrowseRefWriteFileDisplayIndex"      0  )
(ui-interface-symbol "vistaBrowseOtherReadFileDisplayIndex"     -1  )
(ui-interface-symbol "vistaBrowseOtherWriteFileDisplayIndex"    0  )

;; VRED Render window properties
(ui-interface-symbol "vredLL.winX" -1 )
(ui-interface-symbol "vredLL.winY" -1 )
(ui-interface-symbol "vredLL.winW" 600 )
(ui-interface-symbol "vredLL.winH" 400 )
(ui-interface-symbol "vredLL.winState" 1)

