;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; surface creation Option Box
;;;

(ui-string "cloudSurfCreate.name"   "Point Cloud Gridded Surfaces Options")
(ui-string "cd_surf_numRefines" "Refinements")
(ui-string "cd_surf_resSurfUSpans"  "Surface Spans Between U Isoparms")
(ui-string "cd_surf_resSurfVSpans"  "Surface Spans Between V Isoparms")
(ui-string "cd_surf_continuity"  "Continuity to Adjacent Surface(s)")
(ui-string "cd_surf_continuityOptions.None"  "project boundary to cloud")
(ui-string "cd_surf_continuityOptions.Pos"   "hold position")
(ui-string "cd_surf_continuityOptions.Tan"   "hold position and tangent")
(ui-string "cd_surf_dataType"  "Fit Surface To")
(ui-string "cd_surf_dataType.scattered"      "Scattered Data")
(ui-string "cd_surf_dataType.crossSections"  "Cross section Data")
(ui-string "cd_surf_radius"  "Spacing Between Cross sections")

(ui-editor "cloudSurfQuick.options"             
	
	(list 'title 'cloudSurfCreate.name)
	(list 'symbols 'cd_surf_numRefines
	      'cd_surf_UGridSpans
	      'cd_surf_VGridSpans
	      'cd_surf_resSurfUSpans
	      'cd_surf_resSurfVSpans
	      'cd_surf_continuity
	      'cd_surf_dataType
	      'cd_surf_radius
    )

	(ui-separator-widget)
;	(ui-integer-widget "cd_surf_numRefines"
;	    (list 'range 1 100)
;	)
	(ui-integer-widget "cd_surf_resSurfUSpans"
	    (list 'range 1 100)
	)
	(ui-integer-widget "cd_surf_resSurfVSpans"
	    (list 'range 1 100)
	)
	(ui-radio-widget "cd_surf_continuity" 
                (list 'columns 1)
		(ui-choice "cd_surf_continuityOptions.None"  -1)
		(ui-choice "cd_surf_continuityOptions.Pos"    0)
		(ui-choice "cd_surf_continuityOptions.Tan"    1)
	) 
	(ui-separator-widget)
	(ui-radio-widget "cd_surf_dataType" 
                (list 'columns 1)
		(list "rebuild")
		(ui-choice "cd_surf_dataType.scattered"       0)
		(ui-choice "cd_surf_dataType.crossSections"   1)
	) 

	(ui-distance-widget "cd_surf_radius"
		(list "rebuild")
		(list 'enabled (ui-eq "cd_surf_dataType"  1))
	    (list 'precision "%f6.4")
	    (list 'range 0.01 10.0)
        )

	(list 'buttons 'Reset 'Save 'Exit 'Go)
)
