;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; New Time Warp Options
;;;

(ui-string "twarp.name"                 "New Time Warp Options")
(ui-string "ao_new_level_objects"       "Objects")
(ui-string "ao_new_level_params"        "Parameters")
(ui-string "ao_new_level_hier"          "Hierarchy")
(ui-string "ao_new_level_range"         "Time Range")
(ui-string "ao_new_level_start"         "Start Frame")
(ui-string "ao_new_level_end"           "End Frame")

(ui-string "twarp.object.all"           "All")
(ui-string "twarp.object.active"        "Active")
(ui-string "twarp.object.sets"          "Sets")
(ui-string "twarp.params.all"           "All")
(ui-string "twarp.params.global"        "Global")
(ui-string "twarp.params.local"         "Local")
(ui-string "twarp.hier.none"            "None")
(ui-string "twarp.hier.below"           "Below")
(ui-string "twarp.range.all"            "All")
(ui-string "twarp.range.menu"           "Option Window")

(ui-editor "twarp.options"              
	
	(list 'title 'twarp.name)

	(list 'symbols 	'ao_new_level_objects		'ao_new_level_params
					'ao_new_level_hier			'ao_new_level_range
					'ao_new_level_start			'ao_new_level_end
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

    	(ui-radio-widget "ao_new_level_objects" 
		(list 'columns 3)
		(ui-choice "twarp.object.all"   'AO_TIME_ALL)
		(ui-choice "twarp.object.active" 'AO_TIME_ACTIVE)
		(ui-choice "twarp.object.sets"  'AO_TIME_SETS)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_new_level_params" 
		(list 'columns 3)
		(ui-choice "twarp.params.all"   'AO_TIME_ALL)
 		(ui-choice "twarp.params.global" 'AO_TIME_GLOBAL_PARAM_CTRL)
		(ui-choice "twarp.params.local" 'AO_TIME_LOCAL_PARAM_CTRL)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_new_level_hier" 
		(list 'columns 3)
		(ui-choice "twarp.hier.none"    'AO_HIER_NONE)
		(ui-choice "twarp.hier.below"   'AO_HIER_BELOW)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_new_level_range" 
		(list 'columns 2)
		(list 'rebuild #t)
		(ui-choice "twarp.range.all"    'AO_TIME_ALL)
		(ui-choice "twarp.range.menu"   'AO_FROMOPTMENU)
	)

	(ui-double-widget "ao_new_level_start" 
		(list 'enabled (ui-eq "ao_new_level_range" 'AO_FROMOPTMENU))
		(list 'slider_range 1 100)
		(list 'precision "%f6.3")
	)

	(ui-double-widget "ao_new_level_end" 
		(list 'enabled (ui-eq "ao_new_level_range" 'AO_FROMOPTMENU))
		(list 'slider_range 1 100)
		(list 'precision "%f6.3")
	)

)
