;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Time Scale Options
;;;

(ui-string "tscale.name"                "Time Scale Options")
(ui-string "ao_scale_objects"           "Objects")
(ui-string "ao_scale_params"            "Parameters")
(ui-string "ao_scale_hier"              "Hierarchy")
(ui-string "ao_scale_range"             "Time Range")
(ui-string "ao_scale_start"             "Start Frame")
(ui-string "ao_scale_end"               "End Frame")
(ui-string "ao_scale_time"              "Time Scale")

(ui-string "tscale.object.all"          "All")
(ui-string "tscale.object.active"       "Active")
(ui-string "tscale.object.sets"         "Sets")
(ui-string "tscale.params.all"          "All")
(ui-string "tscale.params.global"       "Global")
(ui-string "tscale.params.local"        "Local")
(ui-string "tscale.hier.none"           "None")
(ui-string "tscale.hier.below"          "Below")
(ui-string "tscale.range.all"           "All")
(ui-string "tscale.range.menu"          "Option Window")

(ui-editor "tscale.options"             

	(list 'title 'tscale.name)

	(list 'symbols 	'ao_scale_objects		'ao_scale_params
					'ao_scale_hier			'ao_scale_range
					'ao_scale_start			'ao_scale_end
					'ao_scale_time
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "ao_scale_objects" 
		(list 'columns 3)
		(ui-choice "tscale.object.all"  'AO_TIME_ALL)
		(ui-choice "tscale.object.active" 'AO_TIME_ACTIVE)
		(ui-choice "tscale.object.sets" 'AO_TIME_SETS)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_scale_params"  
		(list 'columns 3)
		(ui-choice "tscale.params.all"  'AO_TIME_ALL)
		(ui-choice "tscale.params.global" 'AO_TIME_GLOBAL_PARAM_CTRL)
		(ui-choice "tscale.params.local" 'AO_TIME_LOCAL_PARAM_CTRL)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_scale_hier"    
		(ui-choice "tscale.hier.none"   'AO_HIER_NONE)
		(ui-choice "tscale.hier.below"  'AO_HIER_BELOW)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_scale_range"   
		(list 'rebuild #t)
		(ui-choice "tscale.range.all"   'AO_TIME_ALL)
		(ui-choice "tscale.range.menu"  'AO_FROMOPTMENU)
	)

	(ui-separator-widget)

	(ui-double-widget "ao_scale_start"  
		(list 'enabled (ui-eq "ao_scale_range" 'AO_FROMOPTMENU))
		(list 'slider_range 1 100)
		(list 'precision "%f6.3")
	)

	(ui-double-widget "ao_scale_end"    
		(list 'enabled (ui-eq "ao_scale_range" 'AO_FROMOPTMENU))
		(list 'slider_range 1 100)
		(list 'precision "%f6.3")
	)

	(ui-double-widget "ao_scale_time"   
		(list 'precision "%f6.3")
		(list 'slider_range 1 10)
		(list 'range 0.001 1000.0)
	)

)
