;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;
	 
;;; Animate Sweep Options
;;;

(ui-string "sweep.name"                 "Animate Sweep Options")
(ui-string "ao_make_sweep"              "Sweep")
(ui-string "ao_sweep_group"             "Snapshots")
(ui-string "ao_sweep_paramtype"         "Parameters")
(ui-string "ao_sweep_hierarchy"         "Hierarchy")
(ui-string "ao_sweep_rangefrom"         "Frame Range")
(ui-string "ao_sweep_startframe"        "Start Frame")
(ui-string "ao_sweep_endframe"          "End Frame")
(ui-string "ao_sweep_skipby"            "By Frame")

(ui-string "sweep.type.ribs"            "Snapshots")
(ui-string "sweep.type.skin"            "Connect Snapshots")
(ui-string "sweep.snap.ind"             "Individual")
(ui-string "sweep.snap.group"           "Grouped")
(ui-string "sweep.param.all"            "All")
(ui-string "sweep.param.global"         "Global")
(ui-string "sweep.param.local"          "Local")
(ui-string "sweep.hier.none"            "None")
(ui-string "sweep.hier.above"           "Above")
(ui-string "sweep.hier.below"           "Below")	
(ui-string "sweep.hier.both"            "Both")
(ui-string "sweep.range.all"            "All")
(ui-string "sweep.range.prompt"         "Prompt")
(ui-string "sweep.range.menu"           "Option Window") 

(ui-editor "sweep.options"              

	(list 'title 'sweep.name)

	(list 'symbols 	'ao_make_sweep			'ao_sweep_group
					'ao_sweep_paramtype		'ao_sweep_hierarchy
					'ao_sweep_rangefrom		'ao_sweep_startframe
					'ao_sweep_endframe		'ao_sweep_skipby
					'ao_sweep_function
					'AO_SWEEP_RIBS			'AO_SWEEP_SKIN
					'AO_SWEEP_SINGLE		'AO_SWEEP_GROUP
					'AO_PLAYBACK_ALL		'AO_PLAYBACK_GLOBAL_PARAM_CTRL
					'AO_PLAYBACK_LOCAL_PARAM_CTRL
					'AO_HIER_NONE			'AO_HIER_ABOVE
					'AO_HIER_BELOW			'AO_HIER_BOTH
					'AO_FROMALL				'AO_FROMPROMPT	'AO_FROMOPTMENU
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "ao_make_sweep"    
		(list 'columns 1)
		(ui-choice "sweep.type.ribs"    'AO_SWEEP_RIBS)
		(ui-choice "sweep.type.skin"    'AO_SWEEP_SKIN)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_sweep_group"   
		(ui-choice "sweep.snap.ind"     'AO_SWEEP_SINGLE)
		(ui-choice "sweep.snap.group"   'AO_SWEEP_GROUP)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_sweep_paramtype" 
		(list 'columns 3)
		(ui-choice "sweep.param.all"    'AO_PLAYBACK_ALL)
		(ui-choice "sweep.param.global" 'AO_PLAYBACK_GLOBAL_PARAM_CTRL)
		(ui-choice "sweep.param.local"  'AO_PLAYBACK_LOCAL_PARAM_CTRL)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_sweep_hierarchy" 
		(ui-choice "sweep.hier.none"    'AO_HIER_NONE)
		(ui-choice "sweep.hier.above"   'AO_HIER_ABOVE)
		(ui-choice "sweep.hier.below"   'AO_HIER_BELOW)
		(ui-choice "sweep.hier.both"    'AO_HIER_BOTH)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_sweep_rangefrom" 
		(list 'rebuild #t)
		(ui-choice "sweep.range.all"    'AO_FROMALL
			(list 'assign 'ao_sweep_function "AnimSweepOption")
		)
		(ui-choice "sweep.range.prompt" 'AO_FROMPROMPT
			(list 'assign 'ao_sweep_function "AnimSweepPrompt")
		)
		(ui-choice "sweep.range.menu"   'AO_FROMOPTMENU
			(list 'assign 'ao_sweep_function "AnimSweepOption")
		)
	)

	(ui-separator-widget)

	(ui-double-widget "ao_sweep_startframe" 
		(list 'enabled (ui-eq "ao_sweep_rangefrom" 'AO_FROMOPTMENU))
		(list 'precision "%f6.3")
		(list 'slider_range 1 100)
	)

	(ui-double-widget "ao_sweep_endframe" 
		(list 'enabled (ui-eq "ao_sweep_rangefrom" 'AO_FROMOPTMENU))
		(list 'precision "%f6.3")
		(list 'slider_range 1 100)
	)

	(ui-double-widget "ao_sweep_skipby" 
		(list 'enabled
			(ui-or
				(ui-eq "ao_sweep_rangefrom" 'AO_FROMOPTMENU)
				(ui-eq "ao_sweep_rangefrom" 'AO_FROMALL)))
		(list 'precision "%f6.3")
		(list 'slider_range 1 10)
	)
)
