;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Save Anim Options
;;;

(ui-string "save.name"                  "Export Anim Options")
(ui-string "ao_store_objects"           "Store")
(ui-string "ao_store_param"             "Parameters")
(ui-string "ao_store_hierarchy"         "Hierarchy")
(ui-string "ao_store_jointIK"           "Save Joint IK")
(ui-string "ao_store_data_per_frame"    "Data Per Frame")
(ui-string "ao_store_range"             "Time Range")
(ui-string "ao_store_start"             "Start")
(ui-string "ao_store_end"               "End")
(ui-string "ao_store_by"                "By")

(ui-string "save.store.curves"          "Curves")
(ui-string "save.store.hier"            "Hierarchy")
(ui-string "save.param.all"             "All")
(ui-string "save.param.global"          "Global")
(ui-string "save.param.local"           "Local")
(ui-string "save.hier.none"             "None")
(ui-string "save.hier.above"            "Above")
(ui-string "save.hier.below"            "Below")
(ui-string "save.hier.both"             "Both")
(ui-string "save.range.all"             "All")
(ui-string "save.range.menu"            "Option Window")

(ui-editor "save.anim.options"          

	(list 'title 'save.name)

	(list 'symbols 	'ao_store_objects		'ao_store_param
                    'ao_store_hierarchy     'ao_store_jointIK
                    'ao_store_data_per_frame
					'ao_store_range			'ao_store_start
					'ao_store_end			'ao_store_by
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "ao_store_objects" 
		(ui-choice "save.store.curves"  'AO_SAVE_ALL_AS)
		(ui-choice "save.store.hier"    'AO_SAVE_ACTIVE_AS)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_store_param"   
		(list 'columns 3)
		(ui-choice "save.param.all"     'AO_STORE_ALL_PARAM_CTRL)
		(ui-choice "save.param.global"  'AO_STORE_GLOBAL_PARAM_CTRL)
		(ui-choice "save.param.local"   'AO_STORE_LOCAL_PARAM_CTRL)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_store_hierarchy" 
		(ui-choice "save.hier.none"     'AO_HIER_NONE)
		(ui-choice "save.hier.above"    'AO_HIER_ABOVE)
		(ui-choice "save.hier.below"    'AO_HIER_BELOW)
		(ui-choice "save.hier.both"     'AO_HIER_BOTH)
	)

	(ui-separator-widget)

    (ui-boolean-widget "ao_store_jointIK"
	   (list 'enabled (ui-eq "ik_option" #t))	   
	)

	(ui-tick-widget "ao_store_data_per_frame" 
		(list 'rebuild #t)
	)

	(ui-radio-widget "ao_store_range"   
		(list 'columns 1)
		(list 'rebuild #t)
		(list 'enabled (ui-eq "ao_store_data_per_frame" #t))
		(ui-choice "save.range.all"     'AO_TIME_ALL)
		(ui-choice "save.range.menu"    'AO_FROMOPTMENU)
	)

	(ui-double-widget "ao_store_start"  
		(list 'enabled (ui-and
				(ui-eq "ao_store_data_per_frame" #t)	
				(ui-eq "ao_store_range" 'AO_FROMOPTMENU)))
		(list 'precision "%f6.3")
	)

	(ui-double-widget "ao_store_end"    
		(list 'enabled (ui-and
				(ui-eq "ao_store_data_per_frame" #t)	
				(ui-eq "ao_store_range" 'AO_FROMOPTMENU)))
		(list 'precision "%f6.3")
	)

	(ui-double-widget "ao_store_by"     
		(list 'enabled (ui-eq "ao_store_data_per_frame" #t))
		(list 'precision "%f6.3")
	)

)
