;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1996, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;
	 
;;; Retrieve Anim Options
;;;

(ui-string "retrieve_anim.name"			"Import Anim Options")

(ui-string "ao_retrieve_match"			"Match Method")
(ui-string "retrieve_anim.match.hierarchy"	"Hierarchy")
(ui-string "retrieve_anim.match.name"	"Name") 

(ui-string "ao_retrieve_method"			        "Retrieve Method")
(ui-string "retrieve_anim.method.replacePart"    "Replace Part")
(ui-string "retrieve_anim.method.insert"	    "Insert") 
(ui-string "retrieve_anim.method.replaceAll"	"Replace All")

(ui-string "ao_retrieve_parameters"     "Parameters")
(ui-string "retrieve_anim.parameters.all"       "All")
(ui-string "retrieve_anim.parameters.global"    "Global")
(ui-string "retrieve_anim.parameters.local"     "Local")

(ui-string "ao_retrieve_range"			"Frame Range")
(ui-string "retrieve_anim.range.all"	"All")
(ui-string "retrieve_anim.range.fromOpt"	"Option Window") 
(ui-string "ao_retrieve_start"          "Start")
(ui-string "ao_retrieve_end"            "End")

(ui-string "ao_retrieve_replace_method" "Placement")
(ui-string "ao_retrieve_insert_method"  "Placement")
(ui-string "retrieve_anim.pos.before"   "Before")
(ui-string "retrieve_anim.pos.after"    "After")
(ui-string "retrieve_anim.pos.fromSDL"  "From File")
(ui-string "retrieve_anim.pos.fromOpt"  "Option Window")
(ui-string "ao_retrieve_insert_start"   "Start Time")

(ui-string "ao_retrieve_overwriteNames"	"Overwrite Names")
(ui-string "ao_retrieve_spacing"		"Spacing")
(ui-string "ao_retrieve_copies"			"Copies")
(ui-string "ao_retrieve_jointIK"		"Retrieve Joint IK")

(ui-editor "retrieve.anim.options"      

	(list 'title 'retrieve_anim.name)

	(list 'symbols 	'ao_retrieve_match
					'ao_retrieve_method
                    'ao_retrieve_parameters
                    'ao_retrieve_range
                    'ao_retrieve_start
                    'ao_retrieve_end
                    'ao_retrieve_replace_method
                    'ao_retrieve_insert_method
                    'ao_retrieve_insert_start
                    'ao_retrieve_overwriteNames
					'ao_retrieve_spacing
					'ao_retrieve_copies
					'ao_retrieve_jointIK
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "ao_retrieve_match" 
		(list 'columns 2)
		(ui-choice "retrieve_anim.match.hierarchy" 'AO_RETRIEVE_HIERARCHY)
		(ui-choice "retrieve_anim.match.name" 'AO_RETRIEVE_NAME)
	)

	(ui-radio-widget "ao_retrieve_method" 
		(list 'columns 2)
   		(list 'rebuild #t)
		(ui-choice "retrieve_anim.method.replacePart"
                'AO_RETRIEVE_REPLACE_PART)
		(ui-choice "retrieve_anim.method.insert" 'AO_RETRIEVE_INSERT)
		(ui-choice "retrieve_anim.method.replaceAll" 'AO_RETRIEVE_REPLACE_ALL)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_retrieve_parameters" 
		(list 'columns 3)
		(ui-choice "retrieve_anim.parameters.all" 'AO_RETRIEVE_PARAM_ALL)
		(ui-choice "retrieve_anim.parameters.global" 'AO_RETRIEVE_PARAM_GLOBAL)
		(ui-choice "retrieve_anim.parameters.local" 'AO_RETRIEVE_PARAM_LOCAL)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_retrieve_range" 
		(list 'columns 2)
   		(list 'rebuild #t)
		(ui-choice "retrieve_anim.range.all" 'AO_RETRIEVE_ALL)
		(ui-choice "retrieve_anim.range.fromOpt" 'AO_RETRIEVE_FROMOPT)
	)

    (ui-double-widget "ao_retrieve_start"
        (list 'enabled (ui-eq "ao_retrieve_range" 'AO_RETRIEVE_FROMOPT))
        (list 'precision "%f6.3")
    )

    (ui-double-widget "ao_retrieve_end"
        (list 'enabled (ui-eq "ao_retrieve_range" 'AO_RETRIEVE_FROMOPT))
        (list 'precision "%f6.3")
    )

	(ui-separator-widget)

    ;
    ; These two button sets are mutually exclusive, both appearing under
    ; the heading of `Placement'.
    ;
    ; In theory we could merge them into one through the judicious use of
    ; `enabled' clauses on the individual choices. However, by keeping them
    ; separate we can give them different default values, which is
    ; desirable.
    ;
	(ui-radio-widget "ao_retrieve_replace_method" 
		(list 'columns 2)
   		(list 'rebuild #t)
        (list 'enabled (ui-ne "ao_retrieve_method" 'AO_RETRIEVE_INSERT))
		(ui-choice "retrieve_anim.pos.fromSDL" 'AO_RETRIEVE_POS_FROMSDL)
		(ui-choice "retrieve_anim.pos.fromOpt" 'AO_RETRIEVE_POS_FROMOPT)
	)

	(ui-radio-widget "ao_retrieve_insert_method" 
		(list 'columns 2)
   		(list 'rebuild #t)
        (list 'enabled (ui-eq "ao_retrieve_method" 'AO_RETRIEVE_INSERT))
		(ui-choice "retrieve_anim.pos.before" 'AO_RETRIEVE_POS_BEFORE)
		(ui-choice "retrieve_anim.pos.after" 'AO_RETRIEVE_POS_AFTER)
		(ui-choice "retrieve_anim.pos.fromSDL" 'AO_RETRIEVE_POS_FROMSDL)
		(ui-choice "retrieve_anim.pos.fromOpt" 'AO_RETRIEVE_POS_FROMOPT)
	)

    (ui-double-widget "ao_retrieve_insert_start"
        (list 'enabled
            (ui-or
                (ui-and
                    (ui-ne "ao_retrieve_method" 'AO_RETRIEVE_INSERT)
                    (ui-eq "ao_retrieve_replace_method" 'AO_RETRIEVE_POS_FROMOPT)
                )
                (ui-and
                    (ui-eq "ao_retrieve_method" 'AO_RETRIEVE_INSERT)
                    (ui-eq "ao_retrieve_insert_method" 'AO_RETRIEVE_POS_FROMOPT)
                )
            )
        )
        (list 'precision "%f6.3")
    )

	(ui-separator-widget)

	(ui-double-widget "ao_retrieve_spacing" 
		(list 'precision "%f6.3")
		(list 'slider_range 0 100)
	)

	(ui-integer-widget "ao_retrieve_copies"   
		(list 'range 1 10000)
		(list 'slider_range 1 50)
	)

    (ui-boolean-widget "ao_retrieve_jointIK")

    (ui-boolean-widget "ao_retrieve_overwriteNames"
        (list 'enabled (ui-eq "ao_retrieve_method" 'AO_RETRIEVE_REPLACE_ALL))
    )
)

