;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Pose Animation Options
;;;

(ui-string "pose.name"                  "Pose Animation Options")
(ui-string "ao_pose_source"             "Time Range")
(ui-string "ao_pose_start"              "Start Frame")
(ui-string "ao_pose_end"                "End Frame")
(ui-string "ao_pose_by"                 "By Frames")

(ui-string "pose.range.menu"            "Option Window")
(ui-string "pose.range.user"            "Prompt")
(ui-string "pose.range.keys"            "Key Frames")

(ui-editor "pose.options"               
	
	(list 'title 'pose.name)

	(list 'symbols 	'ao_pose_source			'ao_pose_start
					'ao_pose_end			'ao_pose_by
					'ao_pose_function
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "ao_pose_source"   
		(list 'rebuild #t)
		(ui-choice "pose.range.menu"    'AO_FROMOPTMENU
			(list 'assign 'ao_pose_function "PoseAnimationOption")
		)
		(ui-choice "pose.range.user"    'AO_USER_DEFINED
			(list 'assign 'ao_pose_function "PoseAnimationPrompt")
		)
		(ui-choice "pose.range.keys"    'AO_KEYFRAME
			(list 'assign 'ao_pose_function "PoseAnimationOption")
		)
	)

	(ui-separator-widget) 

	(ui-double-widget "ao_pose_start"   
		(list 'enabled (ui-eq "ao_pose_source" 'AO_FROMOPTMENU))
		(list 'precision "%f6.3")
		(list 'slider_range 1 100)
	)

	(ui-double-widget "ao_pose_end"     
		(list 'enabled (ui-eq "ao_pose_source" 'AO_FROMOPTMENU))
		(list 'precision "%f6.3")
		(list 'slider_range 1 100)
	)

	(ui-double-widget "ao_pose_by"      
		(list 'enabled (ui-eq "ao_pose_source" 'AO_FROMOPTMENU))
		(list 'precision "%f6.3")
		(list 'slider_range 1 10)
		(list 'range 'min .01)
	)

)
