;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1995, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;
	 
;;; Paste Keyframes Options
;;;

(ui-string "paste_keyframes.name"       "Paste Keyframes Options")

(ui-string "ao_pastekey_params"         "Parameters")
(ui-string "paste_keyframes.params.all" "All")
(ui-string "paste_keyframes.params.global" "Global")
(ui-string "paste_keyframes.params.local" "Local")

(ui-string "ao_pastekey_method"         "Paste method")
(ui-string "paste_keyframes.method.insert" "Insert")
(ui-string "paste_keyframes.method.replace" "Replace")

(ui-string "ao_pastekey_fit"            "Range fit")
(ui-string "paste_keyframes.fit.none"   "None")
(ui-string "paste_keyframes.fit.scale"  "Scale") 
(ui-string "paste_keyframes.fit.fit"    "Fit") 

(ui-string "ao_pastekey_integer"        "Integer")

(ui-string "ao_pastekey_range"             "Frame Range")
(ui-string "paste_keyframes.range.prompt"  "Prompt")
(ui-string "paste_keyframes.range.current" "Current")
(ui-string "paste_keyframes.range.option"  "Option Window") 

(ui-string "ao_pastekey_start"          "Start Frame")
(ui-string "ao_pastekey_end"            "End Frame")
(ui-string "ao_pastekey_repeat"         "Repeat")
(ui-string "ao_pastekey_gap"            "Gap")

(ui-editor "paste_keyframes.options"    

	(list 'title 'paste_keyframes.name)

	(list 'symbols 	'ao_pastekey_params
					'ao_pastekey_method
					'ao_pastekey_fit
					'ao_pastekey_integer
					'ao_pastekey_range
					'ao_pastekey_start
					'ao_pastekey_end
					'ao_pastekey_repeat
					'ao_pastekey_gap
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "ao_pastekey_params" 
		(list 'columns 3)
		(ui-choice "paste_keyframes.params.all" 'AO_EDITKEY_ALL)
		(ui-choice "paste_keyframes.params.global" 'AO_EDITKEY_GLOBAL)
		(ui-choice "paste_keyframes.params.local" 'AO_EDITKEY_LOCAL)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_pastekey_method" 
		(list 'columns 2)
		(ui-choice "paste_keyframes.method.insert" 'AO_EDITKEY_INSERT)
		(ui-choice "paste_keyframes.method.replace" 'AO_EDITKEY_REPLACE)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_pastekey_fit"  
		(list 'rebuild #t)
		(list 'columns 3)
		(ui-choice "paste_keyframes.fit.none" 'AO_EDITKEY_NOFIT)
		(ui-choice "paste_keyframes.fit.scale" 'AO_EDITKEY_SCALE)
		(ui-choice "paste_keyframes.fit.fit" 'AO_EDITKEY_FIT)
	)

	(ui-boolean-widget "ao_pastekey_integer" 
		(list 'enabled (ui-eq "ao_pastekey_fit" 'AO_EDITKEY_SCALE))
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_pastekey_range" 
		(list 'rebuild #t)
		(ui-choice "paste_keyframes.range.prompt"  'AO_EDITKEY_PROMPT)
		(ui-choice "paste_keyframes.range.current" 'AO_EDITKEY_CURRENT)
		(ui-choice "paste_keyframes.range.option"  'AO_EDITKEY_OPTION)
	)

	(ui-double-widget "ao_pastekey_start" 
		(list 'enabled (ui-eq "ao_pastekey_range" 'AO_EDITKEY_OPTION))
		(list 'precision "%f6.3")
		(list 'slider_range 1 100)
	)

	(ui-double-widget "ao_pastekey_end" 
		(list 'enabled (ui-and
				(ui-eq "ao_pastekey_range" 'AO_EDITKEY_OPTION)
				(ui-ne "ao_pastekey_fit" 'AO_EDITKEY_NONE)
			)
		)
		(list 'precision "%f6.3")
		(list 'slider_range 1 100)
	)

	(ui-integer-widget "ao_pastekey_repeat" 
		(list 'enabled (ui-eq "ao_pastekey_range" 'AO_EDITKEY_OPTION))
		(list 'slider_range 1 100)
	)

	(ui-double-widget "ao_pastekey_gap" 
		(list 'enabled (ui-eq "ao_pastekey_range" 'AO_EDITKEY_OPTION))
		(list 'precision "%f6.3")
		(list 'slider_range 1 100)
	)
)

