;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;
	 
;;; Set Motion Options
;;;

(ui-string "motion.name"                "Set Motion Options")
(ui-string "ao_motion_path"             "Motion Path")
(ui-string "ao_motion_follow"           "Follow")	
(ui-string "ao_motion_bank"             "Bank")
(ui-string "ao_motion_flow"             "Flow")
(ui-string "ao_motion_camera"           "Camera Up")
(ui-string "ao_motion_start"            "Start Frame")
(ui-string "ao_motion_end"              "End Frame")
(ui-string "ao_motion_by"               "Sample By")
(ui-string "ao_motion_range"            "Range")
(ui-string "ao_motion_bank_lean"        "Bank")
(ui-string "ao_motion_degrees"          "Maximum Bank")
(ui-string "ao_flow_slices"             "Flow Slices")

(ui-string "motion.range.all"           "All")
(ui-string "motion.range.opt"           "Option Window")
(ui-string "motion.bank.in"             "In")
(ui-string "motion.bank.out"            "Out")


(ui-editor "motion.options"             

	(list 'title 'motion.name)

	(list 'symbols 	'ao_motion_path			'ao_motion_follow
					'ao_motion_bank			'ao_motion_flow
					'ao_motion_camera		'ao_motion_start
					'ao_motion_end			'ao_motion_by
					'ao_motion_range		'ao_motion_bank_lean
					'ao_motion_degrees		'ao_flow_slices
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-tick-left-widget "ao_motion_path" 
		(list 'assign 'ao_motion_flow 	#f)
		(list 'rebuild #t)
	)
	
	(ui-tick-right-widget "ao_motion_camera" 
		(list 'rebuild #t)
	)

	(ui-tick-left-widget "ao_motion_follow" 
		(list 'rebuild #t)
		(list 'assign 'ao_motion_bank 		#f)
		(list 'assign 'ao_motion_flow 	#f)
	)

	(ui-tick-right-widget "ao_motion_bank" 
		(list 'rebuild #t)
		(list 'assign 'ao_motion_follow 	#t)
	)

	(ui-separator-widget
		(list 'enabled
			(ui-or
				(ui-eq "ao_motion_bank" #t)
				(ui-eq "ao_motion_camera" #t)))
	)

	(ui-radio-widget "ao_motion_bank_lean" 
		(list 'enabled
			(ui-or
				(ui-eq "ao_motion_bank" #t)
				(ui-eq "ao_motion_camera" #t)))
		(ui-choice "motion.bank.in"     'AO_MOTION_BANK_IN)
		(ui-choice "motion.bank.out"    'AO_MOTION_BANK_OUT)
	)

	(ui-angle-widget "ao_motion_degrees" 
		(list 'enabled
			(ui-or
				(ui-eq "ao_motion_bank" #t)
				(ui-eq "ao_motion_camera" #t)))
		(list 'precision "%f7.2")
		(list 'range 0.0 90.0)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_motion_range"  
		(list 'rebuild #t)
		(list 'enabled
			(ui-or
				(ui-eq "ao_motion_follow" #t)
				(ui-eq "ao_motion_flow" #t)
				(ui-eq "ao_motion_camera" #t)))
		(ui-choice "motion.range.all"   'AO_MOTION_FROMALL)
		(ui-choice "motion.range.opt"   'AO_MOTION_FROMOPT)
	)

	(ui-double-widget "ao_motion_start" 
		(list 'enabled 
			(ui-or
				(ui-eq "ao_motion_path" #t)
				(ui-and (ui-eq "ao_motion_range" 'AO_MOTION_FROMOPT)
					(ui-or
						(ui-eq "ao_motion_follow" #t)
						(ui-eq "ao_motion_flow" #t)
						(ui-eq "ao_motion_camera" #t)))))
		(list 'precision "%f7.2")
		(list 'slider_range 1 100)
	)

	(ui-double-widget "ao_motion_end"   
		(list 'enabled 
			(ui-or
				(ui-eq "ao_motion_path" #t)
				(ui-and (ui-eq "ao_motion_range" 'AO_MOTION_FROMOPT)
					(ui-or
						(ui-eq "ao_motion_follow" #t)
						(ui-eq "ao_motion_flow" #t)
						(ui-eq "ao_motion_camera" #t)))))
		(list 'precision "%f7.2")
		(list 'slider_range 1 100)
	)

	(ui-double-widget "ao_motion_by"    
		(list 'enabled
			(ui-or
				(ui-eq "ao_motion_follow" #t)
				(ui-eq "ao_motion_flow" #t)
				(ui-eq "ao_motion_camera" #t)))
		(list 'precision "%f7.2")
		(list 'range 'min 0.02)
		(list 'slider_range 1 10)
	)

	(ui-separator-widget)

	(ui-tick-widget "ao_motion_flow"    
		(list 'rebuild #t)
		(list 'assign 'ao_motion_follow 	#t)
		(list 'assign 'ao_motion_path 	#t)
	)

	(ui-integer-widget "ao_flow_slices" 
		(list 'enabled (ui-eq "ao_motion_flow" #t))	
		(list 'range 'min 1)
		(list 'slider_range 1 10)
	)
)

