;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;
	 
;;; Set Keyshape Options
;;;

(ui-string "keyshape.name"              "Set Keyshape Options")

(ui-string "ao_key_type"                "Interpolation")
(ui-string "keyshape.type.keyshape"     "Key shape")
(ui-string "keyshape.type.deltashape"   "ShapeShifter")

(ui-string "ao_key_origin"              "Shape Center")
(ui-string "keyshape.center.cv"         "First CV")
(ui-string "keyshape.center.centrd"     "Centroid")
(ui-string "keyshape.center.pivot"      "Scale Pivot")

(ui-string "ao_key_name"                "Control Name")
(ui-string "keyshape.name.prompt"       "Prompt")
(ui-string "keyshape.name.target"       "From target")

(ui-string "ao_key_param"               "Control Parameter")
(ui-string "keyshape.control.x"         "X Translate")
(ui-string "keyshape.control.y"         "Y Translate")
(ui-string "keyshape.control.z"         "Z Translate")

(ui-string "ao_key_start"               "Control Range")
(ui-string "ao_key_end"                 "")
(ui-string "ao_key_clamp"               "Limit translate to range")

(ui-string "ao_key_add0"                "Add 0% cluster CVs")

(ui-string "ao_key_geometry"            "Create control geometry")

(ui-string "ao_key_slider"              "Create slider geometry")

(ui-string "ao_key_xlatex"              "Slider position X")
(ui-string "ao_key_xlatey"              "Slider position Y")
(ui-string "ao_key_xlatez"              "Slider position Z")

(ui-editor "keyshape.options"           

	(list 'title 'keyshape.name)

	(list 'symbols	'ao_key_type		'ao_key_origin
					'ao_key_name		'ao_key_param
					'ao_key_start		'ao_key_end
					'ao_key_clamp		'ao_key_add0
					'ao_key_geometry	'ao_key_slider
					'ao_key_xlatex	'ao_key_xlatey	'ao_key_xlatez
					'clusters_option
					'expressions_option
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "ao_key_type"      
		(list 'rebuild #t)
		(ui-choice "keyshape.type.keyshape" 'AO_KEY_KEYSHAPE)
		(ui-choice "keyshape.type.deltashape" 'AO_KEY_DELTASHAPE)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_key_origin"    
		(ui-choice "keyshape.center.cv" 'AO_KEY_ORIGIN_CV)
		(ui-choice "keyshape.center.centrd" 'AO_KEY_ORIGIN_CENTROID)
		(ui-choice "keyshape.center.pivot" 'AO_KEY_ORIGIN_PIVOT)
	)

	(ui-separator-widget
		(list 'enabled (ui-eq "ao_key_type" 'AO_KEY_DELTASHAPE))
	)

	(ui-radio-widget "ao_key_name"      
		(list 'enabled (ui-eq "ao_key_type" 'AO_KEY_DELTASHAPE))
		(ui-choice "keyshape.name.prompt" 'AO_KEY_PROMPT)
		(ui-choice "keyshape.name.target" 'AO_KEY_TARGET)
	)

	(ui-separator-widget
		(list 'enabled (ui-eq "ao_key_type" 'AO_KEY_DELTASHAPE))
	)

	(ui-radio-widget "ao_key_param"     
		(list 'enabled (ui-eq "ao_key_type" 'AO_KEY_DELTASHAPE))
		(list 'rebuild #t)
		(list 'columns 1)
		(ui-choice "keyshape.control.x" 'AO_KEY_CONTROL_X)
		(ui-choice "keyshape.control.y" 'AO_KEY_CONTROL_Y)
		(ui-choice "keyshape.control.z" 'AO_KEY_CONTROL_Z)
	)

	(ui-separator-widget
		(list 'enabled (ui-eq "ao_key_type" 'AO_KEY_DELTASHAPE))
	)

	(ui-double-widget "ao_key_start"    
		(list 'enabled (ui-eq "ao_key_type" 'AO_KEY_DELTASHAPE))
		(list 'precision "%f6.3")
		(list 'slider_range 0 100)
	)

	(ui-double-widget "ao_key_end"      
		(list 'enabled (ui-eq "ao_key_type" 'AO_KEY_DELTASHAPE))
		(list 'precision "%f6.3")
		(list 'slider_range 0 100)
	)

	(ui-boolean-widget "ao_key_clamp"   
		(list 'enabled (ui-eq "ao_key_type" 'AO_KEY_DELTASHAPE))
	)

	(ui-separator-widget
		(list 'enabled (ui-eq "ao_key_type" 'AO_KEY_DELTASHAPE))
	)

	(ui-boolean-widget "ao_key_add0"    
		(list 'enabled (ui-eq "ao_key_type" 'AO_KEY_DELTASHAPE))
	)

	(ui-boolean-widget "ao_key_geometry" 
		(list 'enabled (ui-eq "ao_key_type" 'AO_KEY_DELTASHAPE))
		(list 'rebuild #t)
	)

	(ui-boolean-widget "ao_key_slider"  
		(list 'enabled (ui-and
			(ui-eq "ao_key_type"        'AO_KEY_DELTASHAPE)
			(ui-eq "ao_key_geometry"    #t))
		)
		(list 'rebuild #t)
	)

	(ui-double-widget "ao_key_xlatex"
		(list 'enabled (ui-and
			(ui-eq "ao_key_type"        'AO_KEY_DELTASHAPE)
			(ui-eq "ao_key_geometry"    #t)
			(ui-eq "ao_key_slider"      #t)
			(ui-ne "ao_key_param"		'AO_KEY_CONTROL_X))
		)
		(list 'precision "%f8.4")
	)

	(ui-double-widget "ao_key_xlatey"
		(list 'enabled (ui-and
			(ui-eq "ao_key_type"        'AO_KEY_DELTASHAPE)
			(ui-eq "ao_key_geometry"    #t)
			(ui-eq "ao_key_slider"      #t)
			(ui-ne "ao_key_param"		'AO_KEY_CONTROL_Y))
		)
		(list 'precision "%f8.4")
	)

	(ui-double-widget "ao_key_xlatez"
		(list 'enabled (ui-and
			(ui-eq "ao_key_type"        'AO_KEY_DELTASHAPE)
			(ui-eq "ao_key_geometry"    #t)
			(ui-eq "ao_key_slider"      #t)
			(ui-ne "ao_key_param"		'AO_KEY_CONTROL_Z))
		)
		(list 'precision "%f8.4")
	)
)
