;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;


;;; Set Keyframe Options
;;;

(ui-string "keyframe.name"              "Set Keyframe Options")
(ui-string "ao_set_obj"                 "Objects")
(ui-string "ao_set_param"               "Parameters")
(ui-string "ao_set_hier"                "Hierarchy")
(ui-string "ao_set_hier_and_ikh"        "And IK handles")
(ui-string "ao_set_current_time"        "Frame")
(ui-string "ao_in_tan_type"             "In Tangent Type")
(ui-string "ao_out_tan_type"            "Out Tangent Type")
(ui-string "ao_overwrite_tans"          "Overwrite Tangents")

(ui-string "keyframe.object.active"     "Active")
(ui-string "keyframe.object.sets"       "Sets")
(ui-string "keyframe.param.all"         "All")
(ui-string "keyframe.param.global"      "Global")
(ui-string "keyframe.param.local"       "Local")
(ui-string "keyframe.hier.none"         "None")
(ui-string "keyframe.hier.above"        "Above")
(ui-string "keyframe.hier.below"        "Below")
(ui-string "keyframe.hier.both"         "Both")
(ui-string "keyframe.hier.skeleton"     "Skeleton")
(ui-string "keyframe.hier.handle"       "IK chain")
(ui-string "keyframe.frame.current"     "Current")
(ui-string "keyframe.frame.prompt"      "Prompt")	
(ui-string "keyframe.type.smooth"       "Smooth")
(ui-string "keyframe.type.linear"       "Linear")
(ui-string "keyframe.type.fast"         "Fast")
(ui-string "keyframe.type.slow"         "Slow")
(ui-string "keyframe.type.flat"         "Flat")
(ui-string "keyframe.type.inout"        "In-Out")
(ui-string "keyframe.type.step"         "Step")

(ui-editor "keyframe.options"           
	
	(list 'title 'keyframe.name)

	(list 'symbols 	'ao_set_obj			'ao_set_param
					'ao_set_hier		'ao_set_current_time
					'ao_in_tan_type		'ao_out_tan_type
					'ao_overwrite_tans	'ao_keyframe_function
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "ao_set_obj"       
		(ui-choice "keyframe.object.active" 'AO_SET_ACTIVE)
		(ui-choice "keyframe.object.sets" 'AO_SET_SET)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_set_param"     
		(list 'columns 3)
		(ui-choice "keyframe.param.all" 'AO_SET_ALL)
		(ui-choice "keyframe.param.global" 'AO_SET_GLOBAL_PARAM_CTRL)
		(ui-choice "keyframe.param.local" 'AO_SET_LOCAL_PARAM_CTRL)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_set_hier"      
		(list	'rebuild #t)
		(ui-choice "keyframe.hier.none"		'AO_HIER_NONE)
		(ui-choice "keyframe.hier.above"	'AO_HIER_ABOVE)
		(ui-choice "keyframe.hier.below"	'AO_HIER_BELOW)
		(ui-choice "keyframe.hier.both"		'AO_HIER_BOTH)
		(ui-choice "keyframe.hier.handle"	'AO_HIER_IK)
		(ui-choice "keyframe.hier.skeleton"	'AO_HIER_SK)
	)
	(ui-tick-widget	"ao_set_hier_and_ikh"
		(list 'enabled (ui-eq "ao_set_hier" 'AO_HIER_IK))
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_set_current_time" 
		(ui-choice "keyframe.frame.current" #t
			(list 'assign 'ao_keyframe_function "SetKeyframeCurrent")
			(list 'assign 'ao_autokey_function "AutoKeyframeCurrent")
		)
		(ui-choice "keyframe.frame.prompt" #f
			(list 'assign 'ao_keyframe_function "SetKeyframePrompt")
			(list 'assign 'ao_autokey_function "AutoKeyframePrompt")
		)
	)

	(ui-separator-widget)

	(ui-popup-widget "ao_in_tan_type"   
		;(list 'rebuild #t) 
		(ui-choice "keyframe.type.smooth" 'AO_TAN_SMOOTH
			(list 'assign 'ao_out_tan_type		'AO_TAN_SMOOTH)
		)
		(ui-choice "keyframe.type.linear" 'AO_TAN_LINEAR_IN)
		(ui-choice "keyframe.type.fast" 'AO_TAN_FAST_IN)
		(ui-choice "keyframe.type.slow" 'AO_TAN_SLOW_IN)
		(ui-choice "keyframe.type.flat" 'AO_TAN_FLAT
			(list 'assign 'ao_out_tan_type		'AO_TAN_FLAT)
		)
		(ui-choice "keyframe.type.inout" 'AO_TAN_IN_OUT)
	)

	(ui-popup-widget "ao_out_tan_type"  
		;(list 'rebuild #t) 
		(ui-choice "keyframe.type.smooth" 'AO_TAN_SMOOTH
			(list 'assign 'ao_in_tan_type		'AO_TAN_SMOOTH)
		)
		(ui-choice "keyframe.type.linear" 'AO_TAN_LINEAR_OUT)
		(ui-choice "keyframe.type.fast" 'AO_TAN_FAST_OUT)
		(ui-choice "keyframe.type.slow" 'AO_TAN_SLOW_OUT)
		(ui-choice "keyframe.type.flat" 'AO_TAN_FLAT
			(list 'assign 'ao_in_tan_type		'AO_TAN_FLAT)
		)
		(ui-choice "keyframe.type.inout" 'AO_TAN_IN_OUT)
		(ui-choice "keyframe.type.step" 'AO_TAN_STEP)
	)

    (ui-tick-left-widget "ao_overwrite_tans")
)
