;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Cycle Options
;;;

(ui-string "cycle.name"                 "Cycle Options")
(ui-string "ao_cycle_objects"           "Objects")
(ui-string "ao_cycle_params"            "Parameters")
(ui-string "ao_cycle_hier"              "Hierarchy")
(ui-string "ao_cycle_oscillate"         "Oscillate")
(ui-string "ao_cycle_start"             "Loop Start Frame")
(ui-string "ao_cycle_paste"             "Paste To Frame")
(ui-string "ao_cycle_end"               "Loop End Frame")
(ui-string "ao_cycle_btwn"              "Between Loops")
(ui-string "ao_cycle_repeats"           "Repetitions")

(ui-string "cycle.object.all"           "All")
(ui-string "cycle.object.active"        "Active")
(ui-string "cycle.object.sets"          "Sets")
(ui-string "cycle.params.all"           "All")
(ui-string "cycle.params.global"        "Global")
(ui-string "cycle.params.local"         "Local")
(ui-string "cycle.hier.none"            "None")
(ui-string "cycle.hier.below"           "Below")

(ui-editor "cycle.options"              

	(list 'title 'cycle.name)

	(list 'symbols 	'ao_cycle_objects		'ao_cycle_params
					'ao_cycle_hier			'ao_cycle_oscillate
					'ao_cycle_start			'ao_cycle_paste
					'ao_cycle_end			'ao_cycle_btwn
					'ao_cycle_repeats
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget "ao_cycle_objects" 
		(list 'columns 3)
		(ui-choice "cycle.object.all"   'AO_TIME_ALL)
		(ui-choice "cycle.object.active" 'AO_TIME_ACTIVE)
		(ui-choice "cycle.object.sets"  'AO_TIME_SETS)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_cycle_params"  
		(list 'columns 3)
		(ui-choice "cycle.params.all"   'AO_TIME_ALL)
		(ui-choice "cycle.params.global" 'AO_TIME_GLOBAL_PARAM_CTRL)
		(ui-choice "cycle.params.local" 'AO_TIME_LOCAL_PARAM_CTRL)
	)

	(ui-separator-widget)

	(ui-radio-widget "ao_cycle_hier"    
		(list 'columns 3)
		(ui-choice "cycle.hier.none"    'AO_HIER_NONE)
		(ui-choice "cycle.hier.below"   'AO_HIER_BELOW)
	)

	(ui-separator-widget)

	(ui-tick-widget "ao_cycle_oscillate"
        (list 'rebuild #t)
    )

	(ui-double-widget "ao_cycle_start"  
		(list 'precision "%f6.3")
		(list 'slider_range 1 100)
	)

	(ui-double-widget "ao_cycle_end"    
		(list 'precision "%f6.3")
		(list 'slider_range 1 100)
	)

	(ui-double-widget "ao_cycle_paste"  
        (list 'enabled (ui-eq "ao_cycle_oscillate" #f))
		(list 'precision "%f6.3")
		(list 'slider_range 1 100)
	)

	(ui-double-widget "ao_cycle_btwn"   
		(list 'precision "%f6.2")
		(list 'range 0.0 10000.0)
		(list 'slider_range 0 100)
	)

	(ui-integer-widget "ao_cycle_repeats" 
		(list 'range 'min 0)
		(list 'slider_range 1 100)
	)

)
