;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1996, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;----------------------------------------
;; Action Editor Menu
;;----------------------------------------
;;

(ui-symbol "AW_LISTMODE"       1)
(ui-symbol "AW_EDIT"           2)
(ui-symbol "AW_CURVETOOLS"     3)
(ui-symbol "AW_PICK"           4)
(ui-symbol "AW_XFORM"          5)
(ui-symbol "AW_VIEWS"          6)
(ui-symbol "AW_DISPTOOLS"      7)
(ui-symbol "AW_ACTIONTOOLS"    8)
(ui-symbol "AW_TANGENTTYPE"    9)
(ui-symbol "AW_PREFERENCES"    10)
(ui-symbol "aw_listmode"       (ui-symbol-reference "AW_LISTMODE"))
(ui-symbol "aw_edit"           (ui-symbol-reference "AW_EDIT"))
(ui-symbol "aw_curvetools"     (ui-symbol-reference "AW_CURVETOOLS"))
(ui-symbol "aw_pick"           (ui-symbol-reference "AW_PICK"))
(ui-symbol "aw_xform"          (ui-symbol-reference "AW_XFORM"))
(ui-symbol "aw_views"          (ui-symbol-reference "AW_VIEWS"))
(ui-symbol "aw_disptools"      (ui-symbol-reference "AW_DISPTOOLS"))
(ui-symbol "aw_actiontools"    (ui-symbol-reference "AW_ACTIONTOOLS"))
(ui-symbol "aw_tangenttype"    (ui-symbol-reference "AW_TANGENTTYPE"))
(ui-symbol "aw_preferences"    (ui-symbol-reference "AW_PREFERENCES"))


;; ListMode ----------------------------------------------------
(ui-function "aw_listmode_picked"     
	(list 'command              "AW->Listmode->Picked")
	(list 'label_string         "Picked")
	(list 'attribute_string     "picked")
	(list 'active               (ui-eq "am_listmode_picked" #t))
)
(ui-function "aw_listmode_all"     
	(list 'command              "AW->Listmode->All")
	(list 'label_string         "All")
	(list 'attribute_string     "all")
	(list 'active               (ui-eq "am_listmode_all" #t))
)
;(ui-function "aw_listmode_below"     
;	(list 'command              "AW->Listmode->Below")
;	(list 'label_string         "Below")
;	(list 'attribute_string     "below")
;	(list 'active               (ui-eq "am_listmode_below" #t))
;)
;(ui-function "aw_listmode_above"     
;	(list 'command              "AW->Listmode->Above")
;	(list 'label_string         "Above")
;	(list 'attribute_string     "above")
;	(list 'active               (ui-eq "am_listmode_above" #t))
;)
;(ui-function "aw_listmode_hierarchy"     
;	(list 'command              "AW->Listmode->Hierarchy")
;	(list 'label_string         "Hierarchy")
;	(list 'attribute_string     "hier")
;	(list 'active               (ui-eq "am_listmode_hierarchy" #t))
;)

	(ui-menu "aw_listmode"                  
		(list 'select 'mp_menu 0)
		(list 'label_string "ListMode")
	)

(ui-menu-add-entry "aw_listmode"      'aw_listmode_picked)
(ui-menu-add-entry "aw_listmode"      'aw_listmode_all)
;(ui-menu-add-entry "aw_listmode"      'aw_listmode_below)
;(ui-menu-add-entry "aw_listmode"      'aw_listmode_above)
;(ui-menu-add-entry "aw_listmode"      'aw_listmode_hierarchy)

;; Edit ----------------------------------------------------
(ui-function "aw_edit_kfedit"     
	(list 'command              "AW->Edit->Kfedit")
	(list 'label_string         "Keyframe Edit")
	(list 'attribute_string     "kf edit")
	(list 'active               (ui-eq "am_edit_kfedit" #t))
)
(ui-function "aw_edit_expredit"     
	(list 'command              "AW->Edit->Expredit")
	(list 'label_string         "Edit expression")
	(list 'attribute_string     "edit ex")
	(list 'active               (ui-eq "am_edit_expredit" #t))
)
(ui-function "aw_edit_cut"     
	(list 'command              "AW->Edit->Cut")
	(list 'label_string         "Cut")
	(list 'attribute_string     "cut")
	(list 'active               (ui-eq "am_edit_cut" #t))
)
(ui-function "aw_edit_copy"     
	(list 'command              "AW->Edit->Copy")
	(list 'label_string         "Copy")
	(list 'attribute_string     "copy")
	(list 'active               (ui-eq "am_edit_copy" #t))
)
(ui-function "aw_edit_paste"     
	(list 'command              "AW->Edit->Paste")
	(list 'label_string         "Paste")
	(list 'attribute_string     "paste")
	(list 'active               (ui-eq "am_edit_paste" #t))
)
(ui-function "aw_edit_copysegment"     
	(list 'command              "AW->Edit->CopySegment")
	(list 'label_string         "Copy segment")
	(list 'attribute_string     "cpy seg")
	(list 'active               (ui-eq "am_edit_copysegment" #t))
)
(ui-function "aw_edit_pastesegment"     
	(list 'command              "AW->Edit->PasteSegment")
	(list 'label_string         "Paste segment")
	(list 'attribute_string     "pst seg")
	(list 'active               (ui-eq "am_edit_pastesegment" #t))
)
(ui-function "aw_edit_paste_offset_segment"
	(list 'command              "AW->Edit->PasteOffsetSegment")
	(list 'label_string         "Paste segment with offset")
	(list 'attribute_string     "pst oseg")
	(list 'active               (ui-eq "am_edit_paste_offset_segment" #t))
)
(ui-function "aw_edit_clear"     
	(list 'command              "AW->Edit->Clear")
	(list 'label_string         "Clear")
	(list 'attribute_string     "clear")
	(list 'active               (ui-eq "am_edit_clear" #t))
)
(ui-function "aw_edit_instance"     
	(list 'command              "AW->Edit->Instance")
	(list 'label_string         "Paste instance")
	(list 'attribute_string     "pst ins")
	(list 'active               (ui-eq "am_edit_instance" #t))
)
(ui-function "aw_edit_showlink"     
	(list 'command              "AW->Edit->ShowLink")
	(list 'label_string         "Show instance")
	(list 'attribute_string     "shw ins")
	(list 'active               (ui-eq "am_edit_showlink" #t))
)
(ui-function "aw_edit_undo"     
	(list 'command              "AW->Edit->Undo")
	(list 'label_string         "Undo")
	(list 'attribute_string     "undo")
	(list 'active               (ui-eq "am_edit_undo" #t))
)
(ui-function "aw_edit_redo"     
	(list 'command              "AW->Edit->Redo")
	(list 'label_string         "Redo")
	(list 'attribute_string     "redo")
	(list 'active               (ui-eq "am_edit_redo" #t))
)

	(ui-menu "aw_edit"                  
		(list 'select 'mp_menu 0)
		(list 'label_string "Edit")
	)

(ui-menu-add-entry "aw_edit"      'aw_edit_kfedit)
(ui-menu-add-entry "aw_edit"      'aw_edit_expredit)
(ui-menu-add-entry "aw_edit"      'aw_edit_cut)
(ui-menu-add-entry "aw_edit"      'aw_edit_copy)
(ui-menu-add-entry "aw_edit"      'aw_edit_paste)
(ui-menu-add-entry "aw_edit"      'aw_edit_copysegment)
(ui-menu-add-entry "aw_edit"      'aw_edit_pastesegment)
(ui-menu-add-entry "aw_edit"      'aw_edit_paste_offset_segment)
(ui-menu-add-entry "aw_edit"      'aw_edit_clear)
(ui-menu-add-entry "aw_edit"      'aw_edit_instance)
(ui-menu-add-entry "aw_edit"      'aw_edit_showlink)
(ui-menu-add-entry "aw_edit"      'aw_edit_undo)
(ui-menu-add-entry "aw_edit"      'aw_edit_redo)


;; CurveTools ----------------------------------------------------
(ui-function "aw_curvetools_appendframe"     
	(list 'command              "AW->Crvtools->Appendframe")
	(list 'label_string         "Append keyframes")
	(list 'attribute_string     "apnd kf")
	(list 'active               (ui-eq "am_crvtools_appendframe" #t))
)
(ui-function "aw_curvetools_insertframe"     
	(list 'command              "AW->Crvtools->Insertframe")
	(list 'label_string         "Insert keyframes")
	(list 'attribute_string     "inst kf")
	(list 'active               (ui-eq "am_crvtools_insertframe" #t))
)
(ui-function "aw_curvetools_result"     
	(list 'command              "AW->Crvtools->Result")
	(list 'label_string         "Use result")
	(list 'attribute_string     "use rslt")
	(list 'active               (ui-eq "am_crvtools_result" #t))
)
(ui-function "aw_curvetools_simplify"     
	(list 'command              "AW->Crvtools->Simplify")
	(list 'label_string         "Simplify")
	(list 'attribute_string     "simplify")
	(list 'active               (ui-eq "am_crvtools_simplify" #t))
)
(ui-function "aw_curvetools_lock"     
	(list 'command              "AW->Crvtools->Lock")
	(list 'label_string         "Tgl keyframe lock")
	(list 'attribute_string     "kf lock")
	(list 'active               (ui-eq "am_crvtools_lock" #t))
)

	(ui-menu "aw_curvetools"                  
		(list 'select 'mp_menu 0)
		(list 'label_string "CurveTools")
	)

(ui-menu-add-entry "aw_curvetools"      'aw_curvetools_appendframe)
(ui-menu-add-entry "aw_curvetools"      'aw_curvetools_insertframe)
(ui-menu-add-entry "aw_curvetools"      'aw_curvetools_result)
(ui-menu-add-entry "aw_curvetools"      'aw_curvetools_simplify)
(ui-menu-add-entry "aw_curvetools"      'aw_curvetools_lock)

;; Pick ----------------------------------------------------
(ui-function "aw_pick_nothing"     
	(list 'command              "AW->Pick->Nothing")
	(list 'label_string         "Nothing")
	(list 'attribute_string     "pk not")
	(list 'active               (ui-eq "am_pick_nothing" #t))
)
(ui-function "aw_pick_any"     
	(list 'command              "AW->Pick->Any")
	(list 'label_string         "Any")
	(list 'attribute_string     "pk any")
	(list 'active               (ui-eq "am_pick_any" #t))
)
(ui-function "aw_pick_keyframes"     
	(list 'command              "AW->Pick->KeyFrames")
	(list 'label_string         "Keyframes")
	(list 'attribute_string     "pk kf")
	(list 'active               (ui-eq "am_pick_keyframes" #t))
)
(ui-function "aw_pick_curves"     
	(list 'command              "AW->Pick->Curves")
	(list 'label_string         "Curves")
	(list 'attribute_string     "pk crv")
	(list 'active               (ui-eq "am_pick_curves" #t))
)
(ui-function "aw_pick_anytangents"     
	(list 'command              "AW->Pick->AnyTangents")
	(list 'label_string         "Any tangents")
	(list 'attribute_string     "pk anyT")
	(list 'active               (ui-eq "am_pick_anytangents" #t))
)
(ui-function "aw_pick_intangents"     
	(list 'command              "AW->Pick->InTangents")
	(list 'label_string         "In tangents")
	(list 'attribute_string     "pk inT")
	(list 'active               (ui-eq "am_pick_intangents" #t))
)
(ui-function "aw_pick_outtangents"     
	(list 'command              "AW->Pick->OutTangents")
	(list 'label_string         "Out tangents")
	(list 'attribute_string     "pk outT")
	(list 'active               (ui-eq "am_pick_outtangents" #t))
)
(ui-function "aw_pick_templates"     
	(list 'command              "AW->Pick->Templates")
	(list 'label_string         "Template")
	(list 'attribute_string     "pk tmpl")
	(list 'active               (ui-eq "am_pick_templates" #t))
)
	(ui-menu "aw_pick"                  
		(list 'select 'mp_menu 0)
		(list 'label_string "Pick")
	)

(ui-menu-add-entry "aw_pick"      'aw_pick_nothing)
(ui-menu-add-entry "aw_pick"      'aw_pick_any)
(ui-menu-add-entry "aw_pick"      'aw_pick_keyframes)
(ui-menu-add-entry "aw_pick"      'aw_pick_curves)
(ui-menu-add-entry "aw_pick"      'aw_pick_anytangents)
(ui-menu-add-entry "aw_pick"      'aw_pick_intangents)
(ui-menu-add-entry "aw_pick"      'aw_pick_outtangents)
(ui-menu-add-entry "aw_pick"      'aw_pick_templates)


;; Xform ----------------------------------------------------
(ui-function "aw_xform_move"     
	(list 'command              "AW->Xform->Move")
	(list 'label_string         "Move")
	(list 'attribute_string     "xfm move")
	(list 'active               (ui-eq "am_xform_move" #t))
)
(ui-function "aw_xform_scale_time"     
	(list 'command              "AW->Xform->Scale_time")
	(list 'label_string         "Scale time")
	(list 'attribute_string     "sc time")
	(list 'active               (ui-eq "am_xform_scale_time" #t))
)
(ui-function "aw_xform_scale_value"     
	(list 'command              "AW->Xform->Scale_value")
	(list 'label_string         "Scale value")
	(list 'attribute_string     "sc val")
	(list 'active               (ui-eq "am_xform_scale_value" #t))
)
(ui-function "aw_xform_random"     
	(list 'command              "AW->Xform->Random")
	(list 'label_string         "Randomize")
	(list 'attribute_string     "randmz")
	(list 'active               (ui-eq "am_xform_random" #t))
)

	(ui-menu "aw_xform"                  
		(list 'select 'mp_menu 0)
		(list 'label_string "Xform")
	)

(ui-menu-add-entry "aw_xform"      'aw_xform_move)
(ui-menu-add-entry "aw_xform"      'aw_xform_scale_time)
(ui-menu-add-entry "aw_xform"      'aw_xform_scale_value)
(ui-menu-add-entry "aw_xform"      'aw_xform_random)


;; Views ----------------------------------------------------
(ui-function "aw_viewtools_fitview"     
	(list 'command              "AW->Viewtools->FitView")
	(list 'label_string         "Look at")
	(list 'attribute_string     "look at")
	(list 'active               (ui-eq "am_viewtools_fitview" #t))
)
(ui-function "aw_viewtools_dolly"     
	(list 'command              "AW->Viewtools->Dolly")
	(list 'label_string         "Dolly")
	(list 'attribute_string     "dolly")
	(list 'active               (ui-eq "am_viewtools_dolly" #t))
)
(ui-function "aw_viewtools_track"     
	(list 'command              "AW->Viewtools->Track")
	(list 'label_string         "Track")
	(list 'attribute_string     "track")
	(list 'active               (ui-eq "am_viewtools_track" #t))
)
(ui-function "aw_viewtools_undoview"     
	(list 'command              "AW->Viewtools->UndoView")
	(list 'label_string         "Undo view")
	(list 'attribute_string     "undo vw")
	(list 'active               (ui-eq "am_viewtools_undoview" #t))
)
(ui-function "aw_viewtools_redoview"     
	(list 'command              "AW->Viewtools->RedoView")
	(list 'label_string         "Redo view")
	(list 'attribute_string     "redo vw")
	(list 'active               (ui-eq "am_viewtools_redoview" #t))
)

	(ui-menu "aw_views"                  
		(list 'select 'mp_menu 0)
		(list 'label_string "Views")
	)

(ui-menu-add-entry "aw_views"      'aw_viewtools_fitview)
(ui-menu-add-entry "aw_views"      'aw_viewtools_dolly)
(ui-menu-add-entry "aw_views"      'aw_viewtools_track)
(ui-menu-add-entry "aw_views"      'aw_viewtools_undoview)
(ui-menu-add-entry "aw_views"      'aw_viewtools_redoview)

;; DispTools ----------------------------------------------------
(ui-function "aw_disptools_tgltemplate"     
	(list 'command              "AW->Disptools->TglTemplate")
	(list 'label_string         "Tgl template")
	(list 'attribute_string     "t tmplt")
	(list 'active               (ui-eq "am_disptools_tgltemplate" #t))
)
(ui-function "aw_disptools_shwtangents"     
	(list 'command              "AW->Disptools->ShwTangents")
	(list 'label_string         "Tgl tangents")
	(list 'attribute_string     "t tang")
	(list 'active               (ui-eq "am_disptools_shwtangents" #t))
)
(ui-function "aw_disptools_shwinfinity"     
	(list 'command              "AW->Disptools->ShwInfinity")
	(list 'label_string         "Tgl infinity")
	(list 'attribute_string     "t infty")
	(list 'active               (ui-eq "am_disptools_shwinfinity" #t))
)
(ui-function "aw_disptools_shwcvs"     
	(list 'command              "AW->Disptools->ShwCvs")
	(list 'label_string         "Tgl keyframes")
	(list 'attribute_string     "t keyf")
	(list 'active               (ui-eq "am_disptools_shwcvs" #t))
)
(ui-function "aw_disptools_shwstats"     
	(list 'command              "AW->Disptools->ShwStats")
	(list 'label_string         "Tgl stats")
	(list 'attribute_string     "t stats")
	(list 'active               (ui-eq "am_disptools_shwstats" #t))
)
;(ui-function "aw_disptools_shwtemplate"     
;	(list 'command              "AW->Disptools->ShwTemplate")
;	(list 'label_string         "Tgl template")
;	(list 'active               (ui-eq "am_disptools_shwtemplate" #t))
;)
(ui-function "aw_disptools_shwresults"     
	(list 'command              "AW->Disptools->ShwResults")
	(list 'label_string         "Tgl result curves")
	(list 'attribute_string     "t rscv")
	(list 'active               (ui-eq "am_disptools_shwresults" #t))
	)
(ui-function "aw_disptools_shwsdl"     
	(list 'command              "AW->Disptools->ShwSdl")
	(list 'label_string         "Tgl curve names")
	(list 'attribute_string     "t crvNm")
	(list 'active               (ui-eq "am_disptools_shwsdl" #t))
)

	(ui-menu "aw_disptools"      
		(list 'select 'mp_menu 0)
		(list 'label_string "DispTools")
	)
(ui-menu-add-entry "aw_disptools"      'aw_disptools_tgltemplate)
(ui-menu-add-entry "aw_disptools"      'aw_disptools_shwtangents)
(ui-menu-add-entry "aw_disptools"      'aw_disptools_shwinfinity)
(ui-menu-add-entry "aw_disptools"      'aw_disptools_shwcvs)
(ui-menu-add-entry "aw_disptools"      'aw_disptools_shwstats)
;(ui-menu-add-entry "aw_disptools"      'aw_disptools_shwtemplate)
(ui-menu-add-entry "aw_disptools"      'aw_disptools_shwresults)
(ui-menu-add-entry "aw_disptools"      'aw_disptools_shwsdl)

;; ActionTools ----------------------------------------------------

(ui-function "aw_actiontools_bconst"     
	(list 'command              "AW->ActionTools->Bconst")
	(list 'label_string         "Constant before")
	(list 'attribute_string     "cnst b")
	(list 'active               (ui-eq "am_actiontools_bconst" #t))
)
(ui-function "aw_actiontools_aconst"     
	(list 'command              "AW->ActionTools->Aconst")
	(list 'label_string         "Constant after")
	(list 'attribute_string     "cnst a")
	(list 'active               (ui-eq "am_actiontools_aconst" #t))
)
(ui-function "aw_actiontools_bcycle"     
	(list 'command              "AW->ActionTools->Bcycle")
	(list 'label_string         "Cycle before")
	(list 'attribute_string     "cycl b")
	(list 'active               (ui-eq "am_actiontools_bcycle" #t))
)
(ui-function "aw_actiontools_acycle"     
	(list 'command              "AW->ActionTools->Acycle")
	(list 'label_string         "Cycle after")
	(list 'attribute_string     "cycl a")
	(list 'active               (ui-eq "am_actiontools_acycle" #t))
)
(ui-function "aw_actiontools_bcycleoff"     
	(list 'command              "AW->ActionTools->BcycleOff")
	(list 'label_string         "Cycle before with offset")
	(list 'attribute_string     "cyclo b")
	(list 'active               (ui-eq "am_actiontools_bcycleoff" #t))
)
(ui-function "aw_actiontools_acycleoff"     
	(list 'command              "AW->ActionTools->AcycleOff")
	(list 'label_string         "Cycle after with offset")
	(list 'attribute_string     "cyclo a")
	(list 'active               (ui-eq "am_actiontools_acycleoff" #t))
)
(ui-function "aw_actiontools_boscil"     
	(list 'command              "AW->ActionTools->Boscil")
	(list 'label_string         "Oscillate before")
	(list 'attribute_string     "oscl b")
	(list 'active               (ui-eq "am_actiontools_boscil" #t))
)
(ui-function "aw_actiontools_aoscil"     
	(list 'command              "AW->ActionTools->Aoscil")
	(list 'label_string         "Oscillate after")
	(list 'attribute_string     "oscl a")
	(list 'active               (ui-eq "am_actiontools_aoscil" #t))
)
(ui-function "aw_actiontools_blinear"     
	(list 'command              "AW->ActionTools->Blinear")
	(list 'label_string         "Linear before")
	(list 'attribute_string     "linr b")
	(list 'active               (ui-eq "am_actiontools_blinear" #t))
)
(ui-function "aw_actiontools_alinear"     
	(list 'command              "AW->ActionTools->Alinear")
	(list 'label_string         "Linear after")
	(list 'attribute_string     "linr a")
	(list 'active               (ui-eq "am_actiontools_alinear" #t))
)
(ui-function "aw_actiontools_bident"     
	(list 'command              "AW->ActionTools->Bident")
	(list 'label_string         "Identity before")
	(list 'attribute_string     "ident b")
	(list 'active               (ui-eq "am_actiontools_bident" #t))
)
(ui-function "aw_actiontools_aident"     
	(list 'command              "AW->ActionTools->Aident")
	(list 'label_string         "Identity after")
	(list 'attribute_string     "ident a")
	(list 'active               (ui-eq "am_actiontools_aident" #t))
)
(ui-function "aw_actiontools_comment"     
	(list 'command              "AW->ActionTools->Comment")
	(list 'label_string         "Comment")
	(list 'attribute_string     "commnt")
	(list 'active               (ui-eq "am_actiontools_comment" #t))
)

	(ui-menu "aw_actiontools"                  
		(list 'select 'mp_menu 0)
		(list 'label_string "ActionTools")
	)
(ui-menu-add-entry "aw_actiontools"      'aw_actiontools_bconst)
(ui-menu-add-entry "aw_actiontools"      'aw_actiontools_aconst)
(ui-menu-add-entry "aw_actiontools"      'aw_actiontools_bcycle)
(ui-menu-add-entry "aw_actiontools"      'aw_actiontools_acycle)
(ui-menu-add-entry "aw_actiontools"      'aw_actiontools_bcycleoff)
(ui-menu-add-entry "aw_actiontools"      'aw_actiontools_acycleoff)
(ui-menu-add-entry "aw_actiontools"      'aw_actiontools_boscil)
(ui-menu-add-entry "aw_actiontools"      'aw_actiontools_aoscil)
(ui-menu-add-entry "aw_actiontools"      'aw_actiontools_blinear)
(ui-menu-add-entry "aw_actiontools"      'aw_actiontools_alinear)
(ui-menu-add-entry "aw_actiontools"      'aw_actiontools_bident)
(ui-menu-add-entry "aw_actiontools"      'aw_actiontools_aident)
(ui-menu-add-entry "aw_actiontools"      'aw_actiontools_comment)

;; TangentType ----------------------------------------------------
(ui-function "aw_tangenttype_smooth"     
	(list 'command              "AW->Tangenttype->Smooth")
	(list 'label_string         "Smooth")
	(list 'attribute_string     "smooth")
	(list 'active               (ui-eq "am_tangenttype_smooth" #t))
)
(ui-function "aw_tangenttype_ilinear"     
	(list 'command              "AW->Tangenttype->Ilinear")
	(list 'label_string         "Linear seg in")
	(list 'attribute_string     "l segIn")
	(list 'active               (ui-eq "am_tangenttype_ilinear" #t))
)
(ui-function "aw_tangenttype_olinear"     
	(list 'command              "AW->Tangenttype->Olinear")
	(list 'label_string         "Linear seg out")
	(list 'attribute_string     "l segOut")
	(list 'active               (ui-eq "am_tangenttype_olinear" #t))
)
(ui-function "aw_tangenttype_islow"     
	(list 'command              "AW->Tangenttype->Islow")
	(list 'label_string         "Slow seg in")
	(list 'attribute_string     "s segIn")
	(list 'active               (ui-eq "am_tangenttype_islow" #t))
)
(ui-function "aw_tangenttype_oslow"     
	(list 'command              "AW->Tangenttype->Oslow")
	(list 'label_string         "Slow seg out")
	(list 'attribute_string     "s segOut")
	(list 'active               (ui-eq "am_tangenttype_oslow" #t))
)
(ui-function "aw_tangenttype_ifast"     
	(list 'command              "AW->Tangenttype->Ifast")
	(list 'label_string         "Fast seg in")
	(list 'attribute_string     "f segIn")
	(list 'active               (ui-eq "am_tangenttype_ifast" #t))
)
(ui-function "aw_tangenttype_ofast"     
	(list 'command              "AW->Tangenttype->Ofast")
	(list 'label_string         "Fast seg out")
	(list 'attribute_string     "f segOut")
	(list 'active               (ui-eq "am_tangenttype_ofast" #t))
)
(ui-function "aw_tangenttype_inout"     
	(list 'command              "AW->Tangenttype->InOut")
	(list 'label_string         "In/Out")
	(list 'attribute_string     "inOut")
	(list 'active               (ui-eq "am_tangenttype_inout" #t))
)
(ui-function "aw_tangenttype_flat"     
	(list 'command              "AW->Tangenttype->Flat")
	(list 'label_string         "Flat")
	(list 'attribute_string     "flat")
	(list 'active               (ui-eq "am_tangenttype_flat" #t))
)
(ui-function "aw_tangenttype_step"     
	(list 'command              "AW->Tangenttype->Step")
	(list 'label_string         "Step")
	(list 'attribute_string     "step")
	(list 'active               (ui-eq "am_tangenttype_step" #t))
)
(ui-function "aw_tangenttype_fixed"     
	(list 'command              "AW->Tangenttype->Fixed")
	(list 'label_string         "Fixed")
	(list 'attribute_string     "fixed")
	(list 'active               (ui-eq "am_tangenttype_fixed" #t))
)

	(ui-menu "aw_tangenttype"                  
		(list 'select 'mp_menu 0)
		(list 'label_string "TangentType")
	)
(ui-menu-add-entry "aw_tangenttype"      'aw_tangenttype_smooth)
(ui-menu-add-entry "aw_tangenttype"      'aw_tangenttype_ilinear)
(ui-menu-add-entry "aw_tangenttype"      'aw_tangenttype_olinear)
(ui-menu-add-entry "aw_tangenttype"      'aw_tangenttype_islow)
(ui-menu-add-entry "aw_tangenttype"      'aw_tangenttype_oslow)
(ui-menu-add-entry "aw_tangenttype"      'aw_tangenttype_ifast)
(ui-menu-add-entry "aw_tangenttype"      'aw_tangenttype_ofast)
(ui-menu-add-entry "aw_tangenttype"      'aw_tangenttype_inout)
(ui-menu-add-entry "aw_tangenttype"      'aw_tangenttype_flat)
(ui-menu-add-entry "aw_tangenttype"      'aw_tangenttype_step)
(ui-menu-add-entry "aw_tangenttype"      'aw_tangenttype_fixed)



;; Preferences ----------------------------------------------------
(ui-function "aw_preferences_markingmenus"     
	(list 'command              "AW->Preferences->MarkingMenus")
	(list 'label_string         "Edit marking menus...")
	(list 'attribute_string     "edit mm")
	(list 'active               (ui-eq "am_preferences_markingmenus" #t))
)
(ui-function "aw_preferences_updmodel"     
	(list 'command              "AW->Preferences->UpdModel")
	(list 'label_string         "Tgl update model")
	(list 'attribute_string     "t upd")
	(list 'active               (ui-eq "am_preferences_updmodel" #t))
)
(ui-function "aw_preferences_updmodelxform"     
	(list 'command              "AW->Preferences->UpdModelOnXform")
	(list 'label_string         "Tgl update model during Xform")
	(list 'attribute_string     "t xfrmupd")
	(list 'active               (ui-eq "mo_update_evaluate_actionWindow" #t))
)
(ui-function "aw_preferences_closewin"     
    (list 'command              "ClsActionWindow")
    (list 'label_string         "Action Window...")
    (list 'attribute_string     "actn win")
    (list 'active               (ui-eq "am_preferences_closewin" #t))
)
(ui-function "aw_preferences_shortexpressions"
    (list 'command              "AW->Preferences->ShortExpressions")
    (list 'label_string         "Tgl short expressions")
    (list 'attribute_string     "t sh expr")
    (list 'active               (ui-eq "am_preferences_shortexpressions" #t))
)

	(ui-menu "aw_preferences"                  
		(list 'select 'mp_menu 0)
		(list 'label_string "Preferences")
	)
(ui-menu-add-entry "aw_preferences"      'aw_preferences_markingmenus)
(ui-menu-add-entry "aw_preferences"      'aw_preferences_updmodel)
(ui-menu-add-entry "aw_preferences"      'aw_preferences_updmodelxform)
(ui-menu-add-entry "aw_preferences"      'aw_preferences_closewin)
(ui-menu-add-entry "aw_preferences"      'aw_preferences_shortexpressions)
