/*****************************************************************************
*                                                                            *
*            Copyright (C) 1998, Alias|Wavefront, Inc.                       *
*                                                                            *
*    These coded instructions,  statements and  computer programs contain    *
*    unpublished information proprietary to Alias|Wavefront, Inc. and are    *
*    protected by the Canadian and US Federal copyright law. They may not    *
*    be disclosed to third parties  or copied  or duplicated, in whole or    *
*    in part,  without the prior written consent of Alias|Wavefront,  Inc.   *
*                                                                            *
* Unpublished-rights reserved under the Copyright Laws of the United States. *
*                                                                            *
*****************************************************************************/

#include <stdio.h>

#ifdef _WIN32
#include <AlStyle.h>
#include <string.h>
extern "C" {
STUDIOAPI_DECL int getopt ( int argc, char **argv, char *optstring);
extern STUDIOAPI_DECL int  opterr;
extern STUDIOAPI_DECL int  optind;
extern STUDIOAPI_DECL char *optarg;
}
#else
#include <string.h>
#include <unistd.h>
extern int  opterr;
extern int  optind;
extern char *optarg;
#endif /* _WIN32 */

// OpenModel Environment Headers
#include "AlUniverse.h"


/* -------------------------------------------------------------------------- */

int main( int argc, char** argv )
{
	char    infile[FILENAME_MAX], outfile[FILENAME_MAX];

	const int defaultListSize = 3;
	const int defaultList[defaultListSize] = { 5000, 5010, 9999 };

	if( argc < 3 )
	{
		fprintf(stderr,
			"usage: %s [-i<index>]* <infile> <outfile>\n", argv[0] );
		fprintf(stderr,
				"Description:\n"
				"  This program deletes blind data on the universe.\n"
				"  If no indices are specified, then blind data\n"
				"  indices 5000, 5010 and 9999 will be deleted.\n" 
				"  The -i argument may be specified up to 10 times.\n"
				"  NOTE: This tool does not affect Metacycle Bloat.\n\n"
				);
		return 0;
	}

	const int userListSize = 10;
	int userList[userListSize] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	int userIndex = 0;
	int arg;
	opterr = 0; // to disable getopt error msgs.

	while( (arg = getopt(argc, argv, "i:I:")) != EOF )
	{
		switch(arg)
		{
			case 'i':
			case 'I':
				if( userIndex < userListSize )
					userList[userIndex++] = atoi( optarg );
				else
					printf( "Only have space for %d indices, Sorry.\n", userListSize );
				break;
			default:
				break;
		}
	}

	// Are the in and out files specified
	if ( ( argc - optind ) != 2 )
	{
		fprintf(stderr,"In/Out files not specified properly.\n");
		exit(-1);
	}

	strcpy( infile, argv[optind++] );
	strcpy( outfile, argv[optind] );

	if ( strcmp( infile, outfile) == 0 )
	{
		fprintf(stderr, "Infile name is the same as Outfile name.\n");
		exit(-1);
	}

	// Test to make sure that outfile name does not exist
	FILE *fOut = fopen( outfile, "r" );
	if ( fOut != NULL )
	{
		fclose( fOut );
		fprintf(stderr, "Outfile '%s' exists.\n",outfile);
		exit(-1);
	}

	statusCode status = AlUniverse::initialize( kZUp, TRUE );
	if ( status ==  sInsufficientMemory || status == sFailure )
	{
		fprintf( stderr, "Failed to initialize.\n");
		exit(-1);
	}

	if ( sSuccess != AlUniverse::retrieve( infile ) )
	{
		fprintf( stderr, "Could not retrieve %s.\n", infile );
		exit(-2);
	}

	printf( "Starting to look for Universe blind data...\n" );

	int *currentList = NULL;
	int currentListSize = 0;

	if ( userIndex > 0 )
	{
		currentList = userList;
		currentListSize = userIndex;
	}
	else
	{
		currentList = (int *) defaultList;
		currentListSize =  defaultListSize;
	}

	int totalCount = 0;
	for( int i = 0 ; i < currentListSize ; i++ )
	{
		int count = 0;
		statusCode status = AlUniverse::removeBlindData( currentList[i] );
		while ( status == sSuccess )
		{
			count++;
			status = AlUniverse::removeBlindData( currentList[i] );
		}
		totalCount += count;
		printf( "  Removed %d data items on index '%d'.\n", count, currentList[i] );
	}

	printf( "Finished removal loop.\n" );

	if ( totalCount == 0 )
	{
		fprintf( stderr, "No new file was created since blind data was not found.\n");
	}
	else
	{
		if( sSuccess == AlUniverse::store( outfile ) )
			printf( "File '%s' stored successfully.\n", outfile );
		else
			fprintf(stderr, "Error storing file '%s'.\n", outfile );
	}

	return ( 0 );

}
