
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <AlUniverse.h>
#include <AlViewFrame.h>

int main( int argc, char** argv )
{
	char	*infile;
	char	*outfile;
	float	frame;

	if( argc != 4 )
	{
		fprintf( stderr, "usage: %s <inputfilename> <frame> <outputfilename>\n",
				argv[0] );
		fprintf( stderr,
				"description:\n"
				"  This program retrieves an Alias wire file, views the\n"
				"  universe at the given frame time, and then stores the\n"
				"  universe to the output filename.\n"
				"  It is intended to be a source example of how to use the\n"
				"  Alias Wire File Interface Library.\n"
				);
		exit( 0 );
	}

	infile  = argv[1];
	outfile = argv[3];
	if( !strcmp( infile, outfile ) )
	{
		fprintf( stderr,
				"names of inputfile and outputfile must be different\n" );
		exit( 0 );
	}
	frame = (float) atof(argv[2]);

	AlUniverse::initialize( kYUp );
	if( sSuccess == AlUniverse::retrieve( infile ) )
		fprintf( stdout, "file %s retrieved successfully.\n", infile );
	else
	{
		fprintf( stderr, "Error retrieving file '%s'.\n", infile );
		exit( -1 );
	}

	fprintf(stdout, "Viewing frame %f...\n", frame);
	AlViewFrame::viewFrame(frame);

	if( sSuccess == AlUniverse::store( outfile ) )
		fprintf( stdout, "file %s stored successfully.\n", outfile );
	else
		fprintf( stderr, "Error storing file '%s'.\n", outfile );

	return 0;
}
