
#include <stdio.h>
#include <string.h>
#include <AlUniverse.h>
#include <AlDagNode.h>

#include <AlPrint.h>


int main( int argc, char** argv )
{
	char	*infile;
	char	*outfile;

	if( argc != 3 )
	{
		fprintf( stderr, "usage: %s <inputfilename> <outputfilename>\n",
				argv[0] );
		fprintf( stderr,
				"description:\n"
				"  This program retrieves an Alias wire file and then writes\n"
				"  it back out to a new wire file.  Before it stores the DAG\n"
				"  the names of all the dag_nodes in the DAG are displayed.\n"
				"  It is intended to be a source example of how to use the\n"
				"  Alias Wire File Interface Library.\n"
				);
		exit( 0 );
	}

	infile  = argv[1];
	outfile = argv[2];
	if( !strcmp( infile, outfile ) )
	{
		fprintf( stderr,
				"names of inputfile and outputfile must be different\n" );
		exit( 0 );
	}

	AlUniverse::initialize( kYUp );
	if( sSuccess == AlUniverse::retrieve( infile ) )
		fprintf( stderr, "file %s retrieved successfully.\n", infile );
	else
	{
		fprintf( stderr, "Error retrieving file '%s'.\n", infile );
		exit( -1 );
	}

	printAl_All( kStdout );

	if( sSuccess == AlUniverse::store( outfile ) )
		fprintf( stderr, "file %s stored successfully.\n", outfile );
	else
		fprintf( stderr, "Error storing file '%s'.\n", outfile );

    return 0;
}
