
#include <stdio.h>
#include <AlUniverse.h>
#include <AlGroupNode.h>
#include <AlModel.h>
#include <AlPrint.h>

#include <string.h>
#include <stdio.h>

extern "C" 
{
	//
	// Callback passed in AlUniverse::retrieve() method and is
	// used to output approximate progress percentage information.
	//
	void retrieveCallback( int val )
	{
		static boolean firstTime = TRUE;
		
		if ( firstTime )
			fprintf( stderr, "Retrieve progress: \n");

		firstTime = FALSE;
		
		fprintf( stderr, "%d%% ", val );
	}
}

int main( int argc, char** argv )
{
	char		*infile;
	char 		*showRetrieveProgress = "";

	if( argc == 2 )
	{
		infile = argv[1];
	}
	else if ( argc == 3 )
	{
		showRetrieveProgress = argv[1];
		infile = argv[2];
	}
	else
	{
		fprintf( stderr, "usage: %s [ -v ] <inputfilename> \n", argv[0] );
		fprintf( stderr,
			    "description:\n"
				"  This program retrieves a wire file and prints out data\n"
				"  stored in the DAG.\n"
				"  It is intended to be a source example of how to use the\n"
				"  Alias Wire File Interface Library.\n"
				"  The -v flag is optional and causes the display of\n"
				"  the retrieval progress of the wire file.\n"
				);
		exit( 0 );
	}

	AlUniverse::initialize( kYUp );

	if ( ( strcmp(showRetrieveProgress, "-v" ) == 0 ) && 
			sSuccess == AlUniverse::retrieve( infile, retrieveCallback ) ) 
	{
		fprintf( stderr, "\n" );
		fprintf( stderr, "File %s retrieved successfully.\n", infile );
	}
	else if( sSuccess == AlUniverse::retrieve( infile ) )
	{
		fprintf( stderr, "File %s retrieved successfully.\n", infile );
	}
	else
	{
		fprintf( stderr, "Error retrieving file '%s'.\n", infile );
		exit( -1 );
	}

	printAl_All( kStdout );

	return 0;
}
