
#include <stdio.h>
#include <AlUniverse.h>
#include <AlDagNode.h>
#include <AlGroupNode.h>
#include <AlPrint.h>

void printLocalMatrix( AlDagNode *dagNode )
{
	if( NULL == dagNode )
		return;

	double	tm[4][4];
	char	*space = indentSpace();

	dagNode->localTransformationMatrix( tm );

	fprintf( stdout, "%stm =\n", space );

	fprintf( stdout, "%s    %g %g %g %g\n",
			space, tm[0][0], tm[0][1], tm[0][2], tm[0][3] );
	fprintf( stdout, "%s    %g %g %g %g\n",
			space, tm[1][0], tm[1][1], tm[1][2], tm[1][3] );
	fprintf( stdout, "%s    %g %g %g %g\n",
			space, tm[2][0], tm[2][1], tm[2][2], tm[2][3] );
	fprintf( stdout, "%s    %g %g %g %g\n",
			space, tm[3][0], tm[3][1], tm[3][2], tm[3][3] );
}


void printComments( AlDagNode *dagNode )
{
	if( NULL == dagNode )
		return;

	long		size;
	const char*	data;

	printObjectName( dagNode );
	dagNode->comment( size, data );
	if( size > 0 )
		{
		fprintf( stdout, "Begin Comment{\n" );
		fwrite( data, sizeof(char), size, stdout );
		fprintf( stdout, "\n}End Comment\n" );
		}
	printLocalMatrix( dagNode );

	if( kGroupNodeType == dagNode->type() )
	{
		setIndentation( 4 );
		AlGroupNode *groupNode = dagNode->asGroupNodePtr();
		if( groupNode )
		{
			AlDagNode *downNode = groupNode->childNode();
			if( downNode )
				printComments( downNode );
		}
		setIndentation( -4 );
	}

	AlDagNode *nextNode = dagNode->nextNode();
	if( nextNode )
	printComments( nextNode );

}


int main( int argc, char** argv )
{
	char	*infile;

	if( argc != 2 )
	{
		fprintf( stderr, "usage: %s <inputfilename>\n", argv[0] );
		fprintf( stderr, 
			"description:\n"
			"  This program retrieves an Alias wire file and then displays\n"
			"  the name of each dag node, its local transformation matrix\n"
			"  and any associated comment.\n"
			"  It is intended to be a source example of how to use the\n"
			"  Alias Wire File Interface Library.\n"
				);
		exit( 0 );
	}

	infile  = argv[1];

	AlUniverse::initialize( kYUp );
	if( sSuccess == AlUniverse::retrieve( infile ) )
	{
		fprintf( stderr, "file %s retrieved successfully.\n", infile );
		printComments( AlUniverse::firstDagNode() );
	}
	else
	{
		fprintf( stderr, "Error retrieving file '%s'.\n", infile );
		exit( -1 );
	}

    return 0;
}
