#include <stdio.h>
#include <AlUniverse.h>
#include <AlGroupNode.h>
#include <AlCurve.h>
#include <AlCurveNode.h>
#include <AlTM.h>

#include <AlPrint.h>


void findAndPrintCurves( AlDagNode *startingHere )
//
//	Description:
//		Recursive function to print out all the curves in the dag
//		under (and including) the given dag node.
//
{
	if( ! AlIsValid( startingHere ) )
		return;

	// If the given dag node is a curve node,  then print out its
	// associated info.
	//
	if( kCurveNodeType == startingHere->type() )
		{
		AlTM tm = AlTM::identity();
		printAlCurveNode( startingHere->asCurveNodePtr(), tm );
		}
	else
		{
		// if the starting node is a group dag node, decend to
		// the children and print any curves there.
		//
		AlGroupNode *groupNode = startingHere->asGroupNodePtr();
		if( groupNode != NULL )
			{
			// Process the children by recursion.
			//
			AlDagNode *childNode = groupNode->childNode();
			if( childNode != NULL )
				{
				findAndPrintCurves( childNode );
				delete childNode;
				}
			}
		}
	
	// Okay, we now traverse the sibling chain at this level,
	// recursing sideways now.
	//
	AlDagNode *tmpNode = startingHere->nextNode();
	if( tmpNode != NULL )
		{
		findAndPrintCurves( tmpNode );
		delete tmpNode;
		}
	
}	// findAndPrintCurves()



int main( int argc, char** argv )
{
	char	*infile;

	if( argc != 2 )
	{
		fprintf(stderr, "usage: %s <inputfilename>\n", argv[0] );
		fprintf(stderr,
			"description:\n"
			"  This program retrieves an Alias wire file and displays\n"
			"  information about curves therein. Curves are the only\n"
			"  geometry reported as this is to be a simple example.\n"
			"  It is intended to be a source example of how to use the\n"
			"  Alias Wire File Interface Library.\n"
			);
		exit( 0 );
	}
	infile  = argv[1];

	AlUniverse::initialize( kYUp );

	if( sSuccess != AlUniverse::retrieve( infile ) )
		{
		fprintf(stderr, "Error retrieving file '%s'.\n", infile );
		exit( -1 );
		}

	fprintf( stderr, "File '%s' retrieved successfully.\n", infile );

	findAndPrintCurves( AlUniverse::firstDagNode() );

    return 0;
}
