#include <AlUniverse.h>
#include <AlGroupNode.h>
#include <AlPrint.h>
#include <AlTM.h>


int main( int argc, char** argv )
{
	char		*outfile;
	statusCode	status;

	if( argc != 2 )
	{
		fprintf( stderr, "usage: %s <outputfilename>\n", argv[0] );
		fprintf( stderr, 
				"description:\n"
				"  This program creates an AlGroupNode with three instances\n"
				"  as children.  Each instance has the same AlGroupNode as a\n"
				"  child.  The instances and its child are moved around in\n"
				"  the dag hierarchy so that the use of the addSiblingNode()\n"
				"  and addChildNode() methods can be demonstrated.\n"
				"  It is intended to be a source example of how to use the\n"
				"  Alias Wire File Interface Library.\n"
				);
		exit( 0 );
	}

	outfile = argv[1];

	AlUniverse::initialize( kYUp );

	fprintf( stdout, "--------------------------------------\n" );

	// create a group node (it will be added to the firstDagNode() )
	AlGroupNode *groupNode1 = new AlGroupNode();
	AL_ASSERT( NULL != groupNode1, "could not allocate an AlGroupNode" );
	status = groupNode1->create();
	AL_ASSERT( sSuccess == status, "could not create an AlGroupNode" );
	groupNode1->setName( "groupNode1" );

	printAllAlObjects( AlUniverse::firstDagNode(), AlTM::identity() );
	fprintf( stdout, "--------------------------------------\n" );

	// create another group node which will be an instance
	AlGroupNode *instance1 = new AlGroupNode();
	AL_ASSERT( NULL != instance1, "could not allocate an AlGroupNode" );
	status = instance1->create();
	AL_ASSERT( sSuccess == status, "could not create an AlGroupNode" );
	instance1->setName( "instance1" );

	// make the instance a child of the groupNode
	status = groupNode1->addChildNode( instance1 );
	AL_ASSERT( sSuccess == status,
			  "could not add a node as a child of a group node" );

	printAllAlObjects( AlUniverse::firstDagNode(), AlTM::identity() );
	fprintf( stdout, "--------------------------------------\n" );

	// create a leaf group node
	AlGroupNode *leaf1 = new AlGroupNode;
	AL_ASSERT( NULL != leaf1, "could not allocate an AlGroupNode" );
	status = leaf1->create();
	AL_ASSERT( sSuccess == status, "could not create an AlGroupNode" );
	leaf1->setName( "leaf1" );

	// make the leaf a child of the instance AlGroupNode
	status = instance1->addChildNode( leaf1 );
	AL_ASSERT( sSuccess == status,
			  "could not add a node as a child of a group node" );

	printAllAlObjects( AlUniverse::firstDagNode(), AlTM::identity() );
	fprintf( stdout, "--------------------------------------\n" );

	// Declare the copy options and set the necessary flags
	AlDagNode::AlCopyOptions co;
	co.setInstanceCopy( TRUE );
	
	// create 2nd and 3rd instance
	AlGroupNode *instance2 = (AlGroupNode *) instance1->copyObject(&co);
	AL_ASSERT( NULL != instance2, "could not create 2nd group node instance" );
	instance2->setName( "instance2" );

	AlGroupNode *instance3 = (AlGroupNode *) instance1->copyObject(&co);
	AL_ASSERT( NULL != instance3, "could not create 3rd group node instance" );
	instance3->setName( "instance3" );

	printAllAlObjects( AlUniverse::firstDagNode(), AlTM::identity() );
	fprintf( stdout, "--------------------------------------\n" );

	// make the instances siblings of the groupNode
	status = groupNode1->addSiblingNode( instance1 );
	AL_ASSERT( sSuccess == status,
			  "could not make a node a sibling of another" );

	printAllAlObjects( AlUniverse::firstDagNode(), AlTM::identity() );
	fprintf( stdout, "--------------------------------------\n" );

	// make the leaf a sibling of the groupNode
	status = groupNode1->addSiblingNode( leaf1 );
	AL_ASSERT( sSuccess == status,
			  "could not make a node a sibling of another" );

	printAllAlObjects( AlUniverse::firstDagNode(), AlTM::identity() );
	fprintf( stdout, "--------------------------------------\n" );

	// make the leaf a child of the instances
	status = instance2->addChildNode( leaf1 );
	AL_ASSERT( sSuccess == status,
			  "could not add a node as a child of a group node" );
	status = groupNode1->addChildNode( instance3 );
	AL_ASSERT( sSuccess == status,
			  "could not add a node as a child of a group node" );

	printAllAlObjects( AlUniverse::firstDagNode(), AlTM::identity() );
	fprintf( stdout, "--------------------------------------\n" );

	// create another leaf group node
	AlGroupNode *leaf2 = new AlGroupNode;
	AL_ASSERT( NULL != leaf2, "could not allocate an AlGroupNode" );
	status = leaf2->create();
	AL_ASSERT( sSuccess == status, "could not create an AlGroupNode" );
	leaf2->setName( "leaf2" );

	// make the leaf a child of the instance AlGroupNode
	status = instance1->addChildNode( leaf2 );
	AL_ASSERT( sSuccess == status,
			  "could not add a node as a child of a group node" );

	printAllAlObjects( AlUniverse::firstDagNode(), AlTM::identity() );
	fprintf( stdout, "--------------------------------------\n" );

	// create another group node
	AlGroupNode *groupNode2 = new AlGroupNode();
	AL_ASSERT( NULL != groupNode2, "could not allocate an AlGroupNode" );
	status = groupNode2->create();
	AL_ASSERT( sSuccess == status, "could not create an AlGroupNode" );
	groupNode2->setName( "groupNode2" );

	status = groupNode2->addChildNode( instance1 );
	AL_ASSERT( sSuccess == status,
			  "could not add a node as a child of a group node" );

	printAllAlObjects( AlUniverse::firstDagNode(), AlTM::identity() );
	fprintf( stdout, "--------------------------------------\n" );

	status = AlUniverse::store( outfile );
	if( sSuccess == status )
	{
		fprintf( stderr, "file %s stored successfully.\n", outfile );
	}
	else
	{
		fprintf( stderr, "Error storing file '%s'.\n", outfile );
	}
	AL_ASSERT( sSuccess == status, "error" );

    return 0;
}
