#include <AlUniverse.h>
#include <AlGroupNode.h>
#include <AlTM.h>
#include <AlPrint.h>


int main( int argc, char** argv )
{
	statusCode	status;

	fprintf( stderr, "usage: %s\n", argv[0] );
	fprintf( stderr, 
	"description:\n"
	"  This program creates an AlGroupNode with three instances\n"
	"  as children.  Each instance has the same AlGroupNode as a\n"
	"  child.  Each instance group node is then deleted so as to\n"
	"  demonstrate the behavior of instances.\n"
	"  The only output is the text written to stdout, there is no\n"
	"  wire file created.\n"
	"  It is intended to be a source example of how to use the\n"
	"  Alias Wire File Interface Library.\n"
	);

	if( argc != 1 )
	{
		exit( 0 );
	}

	AlUniverse::initialize( kYUp );

	fprintf( stdout, "--------------------------------------\n" );

	// create a group node (it will be added to the world )
	//
	AlGroupNode *groupNode = new AlGroupNode();
	AL_ASSERT( NULL != groupNode, "could not allocate an AlGroupNode" );
	status = groupNode->create();
	AL_ASSERT( sSuccess == status, "could not create an AlGroupNode" );
	groupNode->setName( "groupNode" );

	// create another group node which will be an instance
	//
	AlGroupNode *instance1 = new AlGroupNode();
	AL_ASSERT( NULL != instance1, "could not allocate an AlGroupNode" );
	status = instance1->create();
	AL_ASSERT( sSuccess == status, "could not create an AlGroupNode" );
	instance1->setName( "instance1" );

	// make the instance a child of the groupNode
	//
	status = groupNode->addChildNode( instance1 );
	AL_ASSERT( sSuccess == status,
			  "could not add a node as a child of a group node" );


	// create a leaf group node
	//
	AlGroupNode *leaf = new AlGroupNode;
	AL_ASSERT( NULL != leaf, "could not allocate an AlGroupNode" );
	status = leaf->create();
	AL_ASSERT( sSuccess == status, "could not create an AlGroupNode" );
	leaf->setName( "leaf" );

	// make the leaf a child of the instance AlGroupNode
	//
	instance1->addChildNode( leaf );
	AL_ASSERT( sSuccess == status,
			  "could not add a node as a child of a group node" );

	// set up the copy options
	AlDagNode::AlCopyOptions options;
	options.setInstanceCopy(TRUE);

	// create instances

	// use copyObject, the cast is safe since we are copying an AlGroupNode
	AlGroupNode *instance2 = (AlGroupNode *) instance1->copyObject( &options );

	AL_ASSERT( NULL != instance2, "could not create an instanced group node" );
	instance2->setName( "instance2" );

	AlGroupNode *instance3 = (AlGroupNode *) instance1->copyObject( &options );
	AL_ASSERT( NULL != instance3, "could not create an instanced group node" );
	instance3->setName( "instance3" );

	fprintf( stdout, "--------------------------------------\n" );
	printAllAlObjects( AlUniverse::firstDagNode(), AlTM::identity() );
	fprintf( stdout, "--------------------------------------\n" );

	delete instance3;
	printAllAlObjects( AlUniverse::firstDagNode(), AlTM::identity() );
	fprintf( stdout, "--------------------------------------\n" );

	delete instance2;
	printAllAlObjects( AlUniverse::firstDagNode(), AlTM::identity() );
	fprintf( stdout, "--------------------------------------\n" );

	delete instance1;
	printAllAlObjects( AlUniverse::firstDagNode(), AlTM::identity() );
	fprintf( stdout, "--------------------------------------\n" );

    return 0;
}

