#include <stdio.h>
#include <AlUniverse.h>
#include <AlGroupNode.h>
#include <AlTM.h>
#include <AlPrint.h>


int main( int argc, char** argv )
{
	char		*outfile;
	statusCode	status;


	if( argc != 2 )
	{
		fprintf( stderr, "usage: %s <outputfilename>\n", argv[0] );
		fprintf( stderr,
		"description:\n"
		"  This program demonstrates the use of the AlDagNode method\n"
		"  addSiblingNode() and the AlGroupNode method addChildNode().\n"
		"  It creates four AlGroupNodes, makes \n"
		"  two AlGroupNodes children of the first AlGroupNode and makes\n"
		"  the same two AlGroupNodes siblings of the AlGroupNode again.\n"
		"  Examine the output file in Alias in the SBD window to see\n"
		"  the results.  GroupNodes 1 and 2 will be siblings (at the\n"
		"  same level as) of the GroupNode with GroupNode 3 left as the\n"
		"  only child of the GroupNode.  There is no visible geometry\n"
		"  created so you do not see anything in the regular windows.\n"
		"  It is intended to be a source example of how to use the\n"
		"  Alias Wire File Interface Library.\n"
		);
		exit( 0 );
	}
	outfile = argv[1];

	AlUniverse::initialize( kYUp );

	fprintf( stdout, "--------------------------------------\n" );

	// create a group node (it will be added to the world )
	AlGroupNode *groupNode = new AlGroupNode();
	groupNode->create();
	groupNode->setName( "groupNode" );

	// create a first group node (it will be added to the world )
	AlGroupNode *groupNode1 = new AlGroupNode;
	groupNode1->create();
	groupNode1->setName( "groupNode1" );

	// create a second group node (it will be added to the world )
	AlGroupNode *groupNode2 = new AlGroupNode;
	groupNode2->create();
	groupNode2->setName( "groupNode2" );

	// create a third group node (it will be added to the world )
	AlGroupNode *groupNode3 = new AlGroupNode;
	groupNode3->create();
	groupNode3->setName( "dagNode3" );

	printAllAlObjects( AlUniverse::firstDagNode(), AlTM::identity() );
	fprintf( stdout, "--------------------------------------\n" );
	fprintf( stdout, "All created now\n" );

	// make the first group node a child of the group node
	status = groupNode->addChildNode( groupNode1 );
	AL_ASSERT( sSuccess == status, "Failed to add child node" );
	
	// and make the second group node a child of the group node
	groupNode->addChildNode( groupNode2 );
	AL_ASSERT( sSuccess == status, "Failed to add child node" );
	
	// and make the third group node a child of the group node
	groupNode1->addSiblingNode( groupNode3 );
	AL_ASSERT( sSuccess == status, "Failed to add sibling node" );
	
	printAllAlObjects( AlUniverse::firstDagNode(), AlTM::identity() );
	fprintf( stdout, "--------------------------------------\n" );
	fprintf( stdout, "They are kids now\n" );

	// make the first group node a sibling of the group node
	groupNode->addSiblingNode( groupNode1 );
	AL_ASSERT( sSuccess == status, "Failed to add sibling node" );

	// make the second group node a sibling of the group node
	groupNode->addSiblingNode( groupNode2 );
	AL_ASSERT( sSuccess == status, "Failed to add sibling node" );

	printAllAlObjects( AlUniverse::firstDagNode(), AlTM::identity() );
	fprintf( stdout, "They are brothers now\n" );
	fprintf( stdout, "--------------------------------------\n" );

	if( sSuccess == AlUniverse::store( outfile ) )
		fprintf( stderr, "file %s stored successfully.\n", outfile );
	else
		fprintf( stderr, "Error storing file '%s'.\n", outfile );

    return 0;
}

