

#include <stdio.h>
#include <string.h>

#include <AlUniverse.h>
#include <AlGroupNode.h>

#include <AlSurface.h>
#include <AlSurfaceNode.h>
#include <AlDebug.h>

AlSurfaceNode*		createASurface()
//
//  Create a single span bi-cubic b-spline surface.  The surface defines
//  a unit square centered about the origin and oriented in the xy-plane.
//  The surface node is added to the DAG when it is created.
//
{
AlSurface		*surface;
AlSurfaceNode	*surfaceNode = NULL;
static double	surfaceUKnots[] = { 0.0, 1.0 };
static double	surfaceVKnots[] = { -1.0, 1.0 };
static double	surfacePoints[][4] = {
	{ -0.5,    -0.5,    0.0, 1.0 },	// first v row
	{ -0.1667, -0.5,    0.0, 1.0 },
	{  0.1667, -0.5,    0.0, 1.0 },
	{  0.5,    -0.5,    0.0, 1.0 },
	{ -0.5,    -0.1667, 0.0, 1.0 },	// second v row
	{ -0.1667, -0.1667, 0.0, 1.0 },
	{  0.1667, -0.1667, 0.0, 1.0 },
	{  0.5,    -0.1667, 0.0, 1.0 },
	{ -0.5,     0.1667, 0.0, 1.0 },	// third v row
	{ -0.1667,  0.1667, 0.0, 1.0 },
	{  0.1667,  0.1667, 0.0, 1.0 },
	{  0.5,     0.1667, 0.0, 1.0 },
	{ -0.5,     0.5,    0.0, 1.0 },	// fourth v row
	{ -0.1667,  0.5,    0.0, 1.0 },
	{  0.1667,  0.5,    0.0, 1.0 },
	{  0.5,     0.5,    0.0, 1.0 }
	};
static int		uMultiplicity[] = { 1, 1, 1, 1 };
static int		vMultiplicity[] = { 1, 1, 1, 1 };
int				uDegree = 3;
int				vDegree = 3;
curveFormType	uForm   = kOpen;
curveFormType	vForm   = kOpen;
int				numUKnots = 2;
int				numVKnots = 2;
int				uLengthControlP = 4;
int				vLengthControlP = 4;

surface = new AlSurface;
if( NULL != surface )
	{
	if  ( sSuccess != surface->create( uDegree, vDegree, uForm, vForm,
			numUKnots, numVKnots, surfaceUKnots, surfaceVKnots,
			uLengthControlP, vLengthControlP, (double*)surfacePoints,
			uMultiplicity, vMultiplicity )
		)
		{
		delete surface;
		return NULL;
		}
	else
		{
		surfaceNode = new AlSurfaceNode;
		if( NULL != surfaceNode )
			{
			if( sSuccess != surfaceNode->create( surface )) 
				{
				delete surfaceNode;
				return NULL;
				}
			}
		else
			{
			delete surface;
			return NULL;
			}
		}
	}
	return surfaceNode;
}


// ------------------------------------------------


int main( int argc, char** argv )
{
	char	*outfile;
	AlGroupNode		*groupNode;
	AlGroupNode		*instanceNode;
	AlSurfaceNode	*surfaceNode;
	statusCode		status;

	if( argc != 2 )
	{
		fprintf(stderr, "usage: %s <outputfilename>\n", argv[0] );
		fprintf(stderr,
				"description:\n"
				"  This program creates a surface, instances and transforms\n"
				"  the instances to create a cube and groups these objects\n"
				"  under a group node.  It then stores the objects as an\n"
				"  Alias Wire file.\n"
				"  It is intended to be a source example of how to use the\n"
				"  Alias Wire File Interface Library.\n"
				);
		exit( 0 );
	}
	outfile  = argv[1];

	// this must be called before any other Alias Wire File Interface
	// method can be called
	//
	AlUniverse::initialize( kYUp );
	

	// the group node is added to the universe upon creation
	groupNode = new AlGroupNode;
	AL_ASSERT( NULL != groupNode, "error: could not allocate a group node" );

	status = groupNode->create();
	AL_ASSERT( sSuccess == status, "error: could not create a group node" );


	// create a unit square surface
	surfaceNode = createASurface();
	AL_ASSERT( NULL != surfaceNode, "error: could not create a surface" );

	// front side
	groupNode->addChildNode( surfaceNode );
	groupNode->setTranslation( 0.0, 0.0, 0.5 );
	delete surfaceNode;

	// Declare the copy options and set the necessary flags
	AlDagNode::AlCopyOptions co;
	co.setInstanceCopy( TRUE );

	// back side
	instanceNode = (AlGroupNode *) groupNode->copyObject(&co);
	instanceNode->setTranslation( 0.0, 0.0, -0.5 );
	delete instanceNode;

	// right side
	instanceNode = (AlGroupNode *) groupNode->copyObject(&co);
	instanceNode->setRotation( 0.0, 90.0, 0.0 );
	instanceNode->setTranslation( 0.5, 0.0, 0.0 );
	delete instanceNode;

	// left side
	instanceNode = (AlGroupNode *) groupNode->copyObject(&co);
	instanceNode->setRotation( 0.0, 90.0, 0.0 );
	instanceNode->setTranslation( -0.5, 0.0, 0.0 );
	delete instanceNode;

	// top side
	instanceNode = (AlGroupNode *) groupNode->copyObject(&co);
	instanceNode->setRotation( 90.0, 0.0, 0.0 );
	instanceNode->setTranslation( 0.0, 0.5, 0.0 );
	delete instanceNode;

	// bottom side
	instanceNode = (AlGroupNode *) groupNode->copyObject(&co);
	instanceNode->setRotation( 90.0, 0.0, 0.0 );
	instanceNode->setTranslation( 0.0, -0.5, 0.0 );
	delete instanceNode;
	
	// write the DAG out as an Alias Wire File
	if( sSuccess == AlUniverse::store( outfile ) )
		fprintf(stderr, "File '%s' stored successfully.\n", outfile );
	else
		fprintf(stderr, "Error storing file '%s'.\n", outfile );

	delete groupNode;

    return 0;
}
