;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ; Copyright  (C)  Alias Systems,  a division of Silicon Graphics  Limited.
; All rights  reserved.  These coded  instructions,  statements and computer
; programs contain unpublished information  proprietary to  Alias Systems,
; a  division  of  Silicon  Graphics  Limited,  which  is  protected by  the
; Canadian  and  US federal copyright law and  may not be disclosed to third
; parties or  copied  or  duplicated,  in  whole  or in part,  without prior
; written consent of Alias Systems, a division of Silicon Graphics Limited
; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Bake Options
;;;

(ui-string 'results.name				"Bake Animation")

(ui-string 'ao_expr_results_constraints "Constraints")
(ui-string 'ao_expr_results_expressions "Expressions")

(ui-string 'ao_expr_results_objects		"Objects")
(ui-string 'results.objects.all			"All")
(ui-string 'results.objects.active		"Active")

(ui-string 'ao_expr_results_params		"Parameters")
(ui-string 'results.params.all			"All")
(ui-string 'results.params.global		"Global")
(ui-string 'results.params.local		"Local")

(ui-string 'ao_expr_results_hierarchy	"Hierarchy")
(ui-string 'results.hier.none			"None")
(ui-string 'results.hier.above			"Above")
(ui-string 'results.hier.below			"Below")
(ui-string 'results.hier.both			"Both")

(ui-string 'ao_expr_results_rangefrom	"Frame Range")
(ui-string 'results.range.current		"Time Slider")
(ui-string 'results.range.menu			"Option Window") 

(ui-string 'ao_expr_results_startframe	"Start Frame")
(ui-string 'ao_expr_results_endframe	"End Frame")
(ui-string 'ao_expr_results_byframe		"By")

(ui-string "ao_bake_compensation"      "Compensation")
(ui-string "bake.cmp.none"             "None")
(ui-string "bake.cmp.mb"               "Motion Blur")
(ui-string "bake.cmp.fd"               "Fields Render")
(ui-string "bake.cmp.both"             "Both")

(ui-string "ao_bake_cmp_detect"        "Detection Only")
(ui-string "ao_bake_cmp_transtol"      "Translation Tol")
(ui-string "ao_bake_cmp_rottol"        "Rotation Tol")

(ui-string "ao_bake_delete_constr"     "Delete Constraints")

(ui-editor 'bakeAnimation.options

	(list 'title 'results.name)

	(list 'symbols 	'ao_expr_results_constraints
					'ao_expr_results_expressions
					'ao_expr_results_objects
					'ao_expr_results_params
					'ao_expr_results_hierarchy
					'ao_expr_results_rangefrom
					'ao_expr_results_startframe
					'ao_expr_results_endframe
					'ao_expr_results_byframe
					'ao_bake_compensation
					'ao_bake_cmp_detect
					'ao_bake_cmp_transtol
					'ao_bake_cmp_rottol
					'ao_bake_delete_constr
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-tick-widget 'ao_expr_results_constraints
		(list 'rebuild #t))
	(ui-tick-widget 'ao_expr_results_expressions)

	(ui-separator-widget)

	(ui-radio-widget 'ao_expr_results_objects
		(list 'columns 2)
		(ui-choice 'results.objects.all			0)
		(ui-choice 'results.objects.active		1)
	)

	(ui-separator-widget)

	(ui-radio-widget 'ao_expr_results_params
		(list 'columns 3)
		(ui-choice 'results.params.all			'AO_SET_ALL)
		(ui-choice 'results.params.global		'AO_SET_GLOBAL_PARAM_CTRL)
		(ui-choice 'results.params.local		'AO_SET_LOCAL_PARAM_CTRL)
	)

	(ui-separator-widget)

	(ui-radio-widget 'ao_expr_results_hierarchy
		(ui-choice 'results.hier.none			0)
		(ui-choice 'results.hier.above			1)
		(ui-choice 'results.hier.below			2)
		(ui-choice 'results.hier.both			3)
	)

	(ui-separator-widget)

	(ui-radio-widget 'ao_expr_results_rangefrom
		(list 'rebuild #t)
		(ui-choice 'results.range.current		'AO_FROMCURRENT)
		(ui-choice 'results.range.menu			'AO_FROMOPTMENU)
	)

	(ui-double-widget 'ao_expr_results_startframe
		(list 'enabled (ui-eq 'ao_expr_results_rangefrom 'AO_FROMOPTMENU))
		(list 'precision "%f6.3")
		(list 'slider_range 1 100)
	)

	(ui-double-widget 'ao_expr_results_endframe
		(list 'enabled (ui-eq 'ao_expr_results_rangefrom 'AO_FROMOPTMENU))
		(list 'precision "%f6.3")
		(list 'slider_range 1 100)
	)

	(ui-double-widget 'ao_expr_results_byframe
		(list 'enabled (ui-eq 'ao_expr_results_rangefrom 'AO_FROMOPTMENU))
		(list 'precision "%f6.3")
		(list 'slider_range 1 100)
	)




	(ui-separator-widget
		(list 'enabled (ui-eq 'ao_expr_results_constraints #t))
	)
	(ui-radio-widget	"ao_bake_compensation"
		(list 'rebuild #t)
		(list 'enabled (ui-eq 'ao_expr_results_constraints #t))

		(ui-choice "bake.cmp.none"     0
            (list 'assign 'ao_bake_cmp_detect #f))
        (ui-choice "bake.cmp.mb"       1)
        (ui-choice "bake.cmp.fd"       2)
        (ui-choice "bake.cmp.both"     3)
	)
    (ui-tick-widget "ao_bake_cmp_detect"
		(list 'enabled (ui-and (ui-eq 'ao_expr_results_constraints	#t)
                               (ui-not (ui-eq "ao_bake_compensation" 0))))
    )
    (ui-double-widget "ao_bake_cmp_transtol"
        (list 'enabled (ui-and (ui-eq 'ao_expr_results_constraints #t)
                               (ui-not (ui-eq "ao_bake_compensation" 0))))
        (list 'precision "%7.4")
        (list 'range 'min 0)
        (list 'slider_range 0 1)
    )
    (ui-double-widget "ao_bake_cmp_rottol"
        (list 'enabled (ui-and (ui-eq 'ao_expr_results_constraints #t)
                               (ui-not (ui-eq "ao_bake_compensation" 0))))
        (list 'precision "%7.4")
		(list 'range 'min 0)
		(list 'slider_range 0 5)
	)

	(ui-separator-widget
		(list 'enabled (ui-eq 'ao_expr_results_constraints #t))
	)

	(ui-tick-widget	"ao_bake_delete_constr"
		(list 'enabled (ui-eq 'ao_expr_results_constraints #t))
	)

)

