;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ; Copyright  (C)  Alias Systems,  a division of Silicon Graphics  Limited.
; All rights  reserved.  These coded  instructions,  statements and computer
; programs contain unpublished information  proprietary to  Alias Systems,
; a  division  of  Silicon  Graphics  Limited,  which  is  protected by  the
; Canadian  and  US federal copyright law and  may not be disclosed to third
; parties or  copied  or  duplicated,  in  whole  or in part,  without prior
; written consent of Alias Systems, a division of Silicon Graphics Limited
; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;
 ;  
 ;  
 ;  
 ;  
 ;

;;; Sun Shine Options
;;;

(ui-string 'sunshine.name				"Sun Shine")

(ui-string 'ao_sunshine_position		"Sun position")
(ui-string 'sunshine.position.time		"Time/Location")
(ui-string 'sunshine.position.azimuth	"Alt/Azimuth")

(ui-string 'ao_sunshine_altitude		"Altitude")
(ui-string 'ao_sunshine_azimuth			"Azimuth")

(ui-string 'ao_sunshine_month			"Month")
(ui-string 'ao_sunshine_day				"Day")
(ui-string 'ao_sunshine_hour			"Hour")
(ui-string 'ao_sunshine_minute			"Minute")

(ui-string 'ao_sunshine_ampm			"")
(ui-string 'sunshine.ampm.am			"AM")
(ui-string 'sunshine.ampm.pm			"PM") 

(ui-string 'ao_sunshine_latitude		"Latitude")

(ui-string 'ao_sunshine_ns				"")
(ui-string 'sunshine.latitude.north		"North")
(ui-string 'sunshine.latitude.south		"South") 

(ui-editor 'sunshine.options

	(list 'title 'sunshine.name)

	(list 'symbols 	'ao_sunshine_position
					'ao_sunshine_altitude
					'ao_sunshine_azimuth
					'ao_sunshine_month
					'ao_sunshine_day
					'ao_sunshine_hour
					'ao_sunshine_minute
					'ao_sunshine_ampm
					'ao_sunshine_latitude
					'ao_sunshine_ns
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-radio-widget 'ao_sunshine_position
		(list 'rebuild #t)
		(list 'columns 2)
		(ui-choice 'sunshine.position.time		0)
		(ui-choice 'sunshine.position.azimuth	1)
	)

	(ui-angle-widget 'ao_sunshine_altitude
		(list 'enabled (ui-eq 'ao_sunshine_position 1))
		(list 'precision "%f6.2")
		(list 'range -90.0 90.0)
		(list 'display-range -90.0 90.0)
	)

	(ui-angle-widget 'ao_sunshine_azimuth
		(list 'enabled (ui-eq 'ao_sunshine_position 1))
		(list 'precision "%f6.2")
		(list 'range 0.0 360.0)
		(list 'display-range 0.0 360.0)
	)

	(ui-integer-widget 'ao_sunshine_month
		(list 'enabled (ui-eq 'ao_sunshine_position 0))
		(list 'range 1 12)
		(list 'slider_range 1 12)
	)

	(ui-integer-widget 'ao_sunshine_day
		(list 'enabled (ui-eq 'ao_sunshine_position 0))
		(list 'range 1 31)
		(list 'slider_range 1 31)
	)

	(ui-integer-widget 'ao_sunshine_hour
		(list 'enabled (ui-eq 'ao_sunshine_position 0))
		(list 'range 1 12)
		(list 'slider_range 1 12)
	)

	(ui-integer-widget 'ao_sunshine_minute
		(list 'enabled (ui-eq 'ao_sunshine_position 0))
		(list 'range 0 60)
		(list 'slider_range 0 60)
	)

	(ui-radio-widget 'ao_sunshine_ampm
		(list 'enabled (ui-eq 'ao_sunshine_position 0))
		(ui-choice 'sunshine.ampm.am			0)
		(ui-choice 'sunshine.ampm.pm			1)
	)

	(ui-angle-widget 'ao_sunshine_latitude
		(list 'enabled (ui-eq 'ao_sunshine_position 0))
		(list 'precision "%f6.2")
		(list 'range 0.0 90.0)
		(list 'display-range 0.0 90.0)
	)

	(ui-radio-widget 'ao_sunshine_ns
		(list 'enabled (ui-eq 'ao_sunshine_position 0))
		(ui-choice 'sunshine.latitude.north		0)
		(ui-choice 'sunshine.latitude.south		1)
	)
)

