;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; exportCurveCoordinates Option Box.
(ui-string "exportCurveCoordinates.title" "Export Curve Coordinate Options")

; Sampling axis.
(ui-string 'exportCurveCoordinates.SAMPLE_AXIS_T "Parameter")
(ui-string 'exportCurveCoordinates.SAMPLE_AXIS_X "X axis")
(ui-string 'exportCurveCoordinates.SAMPLE_AXIS_Y "Y axis")
(ui-string 'exportCurveCoordinates.SAMPLE_AXIS_Z "Z axis")
(ui-string 'exportCurveCoordinates.sampleAxis "")

; Sampling mode.
(ui-string 'exportCurveCoordinates.SAMPLE_MODE_SUBDIVISION    "Subdivision")
(ui-string 'exportCurveCoordinates.SAMPLE_MODE_STEP_INTERVAL  "Arc length")
(ui-string 'exportCurveCoordinates.sampleMode  "")
; Sampling for degree one curves
(ui-string 'exportCurveCoordinates.degreeOneSampling "Sample Degree 1 curves")

; Sampling parameters.
(ui-string 'exportCurveCoordinates.numSubdivisions "Number of subdivisions")
(ui-string 'exportCurveCoordinates.stepInterval    "Step size")

; Output options.
(ui-string 'exportCurveCoordinates.writeT "Parameter coordinate")
(ui-string 'exportCurveCoordinates.writeX "X coordinate")
(ui-string 'exportCurveCoordinates.writeY "Y coordinate")
(ui-string 'exportCurveCoordinates.writeZ "Z coordinate")
(ui-string 'exportCurveCoordinates.precision "Number of digits")

(ui-editor "exportCurveCoordinates.options"
           
    (list 'title 'exportCurveCoordinates.title)

    ; Setup symbols so that reset/save buttons work.
    (list 'symbols  'exportCurveCoordinates.SAMPLE_AXIS_T
					'exportCurveCoordinates.SAMPLE_AXIS_X
					'exportCurveCoordinates.SAMPLE_AXIS_Y
					'exportCurveCoordinates.SAMPLE_AXIS_Z
					'exportCurveCoordinates.sampleAxis
					'exportCurveCoordinates.SAMPLE_MODE_SUBDIVISION
					'exportCurveCoordinates.SAMPLE_MODE_STEP_INTERVAL
                    'exportCurveCoordinates.sampleMode
                    'exportCurveCoordinates.degreeOneSampling
                    'exportCurveCoordinates.numSubdivisions
                    'exportCurveCoordinates.stepInterval
                    'exportCurveCoordinates.writeT
                    'exportCurveCoordinates.writeX
                    'exportCurveCoordinates.writeY
                    'exportCurveCoordinates.writeZ
                    'exportCurveCoordinates.precision
	)

    ; Axis options.
    (ui-group-widget 
        (list 'title "With respect to:")
    )

        (ui-radio-widget 'exportCurveCoordinates.sampleAxis
            (ui-choice 'exportCurveCoordinates.SAMPLE_AXIS_T 'exportCurveCoordinates.SAMPLE_AXIS_T
                (list 'assign 'exportCurveCoordinates.writeT #t)
            )    
            (ui-choice 'exportCurveCoordinates.SAMPLE_AXIS_X 'exportCurveCoordinates.SAMPLE_AXIS_X
                (list 'assign 'exportCurveCoordinates.writeX #t)
            )
            (ui-choice 'exportCurveCoordinates.SAMPLE_AXIS_Y 'exportCurveCoordinates.SAMPLE_AXIS_Y
                (list 'assign 'exportCurveCoordinates.writeY #t)
            )
            (ui-choice 'exportCurveCoordinates.SAMPLE_AXIS_Z 'exportCurveCoordinates.SAMPLE_AXIS_Z
                (list 'assign 'exportCurveCoordinates.writeZ #t)
            )
        )


    ; Mode options.
    (ui-group-widget
        (list 'title "Sampling Mode:")        
    )
        
        ; Mode selector.
        (ui-radio-widget 'exportCurveCoordinates.sampleMode
            (list 'rebuild)
            (ui-choice 'exportCurveCoordinates.SAMPLE_MODE_SUBDIVISION 'exportCurveCoordinates.SAMPLE_MODE_SUBDIVISION)
            (ui-choice 'exportCurveCoordinates.SAMPLE_MODE_STEP_INTERVAL 'exportCurveCoordinates.SAMPLE_MODE_STEP_INTERVAL)
        )

        ; Degree one sampling.
        (ui-tick-widget 'exportCurveCoordinates.degreeOneSampling)

        ; Sampling parameters.
        (ui-integer-widget 'exportCurveCoordinates.numSubdivisions
            (list 'enabled (ui-eq 'exportCurveCoordinates.sampleMode 'exportCurveCoordinates.SAMPLE_MODE_SUBDIVISION))
            (list 'slider_range 1 100)
            (list 'range 1 10000)
        )

        (ui-distance-widget 'exportCurveCoordinates.stepInterval
            (list 'enabled (ui-eq 'exportCurveCoordinates.sampleMode 'exportCurveCoordinates.SAMPLE_MODE_STEP_INTERVAL))
            (list 'precision "%f8.4")
            (list 'slider_range 0.01 2)
            (list 'range 0.0001 10000)
        )


    ; Ouput options.
    (ui-group-widget
        (list 'title "Output Options")
    )

        (ui-tick-left-widget 'exportCurveCoordinates.writeT)
        (ui-tick-right-widget 'exportCurveCoordinates.writeX)

        (ui-tick-left-widget 'exportCurveCoordinates.writeY)
        (ui-tick-right-widget 'exportCurveCoordinates.writeZ)

        (ui-integer-widget 'exportCurveCoordinates.precision
            (list 'slider_range 1 16)
            (list 'range 1 16)
        )

    (list 'buttons 'Reset 'Save 'Exit 'Go)
)
