/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

/*
 * statusHandler.cpp
 *
 * This is a sample plug-in that illustrates the use of the
 * AlStatusHandler class.  This class provides text messages
 * when errors occur in ambigious states.
 */

#include <AlUniverse.h>
#include <AlLiveData.h>
#include <AlFunction.h>
#include <AlFunctionHandle.h>

#include <AlStatusHandler.h>

void handlerCallback( int num, const char *string )
{
	if ( string == NULL )
		return;
		
	printf("Status: %d %s\n",num,string);
	AlStatusHandler::clear();
}

//
//	Toggle the status handler on or off.
//
static void toggleStatusHandler( void )
{
	static int ss = 0;
	
	if ( ss == 0 )
	{
		if ( AlStatusHandler::installHandler( handlerCallback ) != sSuccess )
			printf("** failed to install handler\n");
		ss = 1;
	}
	else
	{
		if ( AlStatusHandler::removeHandler( handlerCallback ) != sSuccess )
			printf("** failed to remove handler\n");
		ss = 0;
	}
	printf("toggled status handler state: %d\n",ss);
}

//
// Standard plug-in declarations below.
//
static AlFunctionHandle h;
static AlMomentaryFunction hFunc;

extern "C"
PLUGINAPI_DECL int plugin_init( char *dirName )
{
	AlUniverse::initialize( kZUp );

	hFunc.create( toggleStatusHandler );
	h.create( "Status Handler", &hFunc ); 
	h.setAttributeString( "StatusHandler" );
	h.appendToMenu( "al_goto" );
	
	AlPrintf( kPrompt, "Status Listener installed on the Utilities menu." );
	return 0;
}

extern "C"
PLUGINAPI_DECL int plugin_exit( void )
{
    h.deleteObject();
    hFunc.deleteObject();
	return 0;
}
