/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

// simpleEditorExample.plugin
// 
// This is a skeleton momentary function plugin.  It implements a simple
// momentary function that calls the do_stuff_here() function.  
// But it does it with an option box!
//

#include <AlUniverse.h>
#include <AlPickList.h>
#include <AlObject.h>

#include <AlLiveData.h>
#include <AlFunction.h>
#include <AlFunctionHandle.h>
#include <AlIterator.h>

#ifdef _WIN32
#include <string.h>
#else
#include <strings.h>
#endif

void do_stuff_here( void ) {
/* */
}

// This handle may have to be global if you wish to remove the
// plugin from the menu using the h.destroy() method in the
// 'momentary_exit' function.
// The menu entry is automatically removed when Alias exits.
//
static AlFunctionHandle h;
static AlMomentaryFunction hFunc;

extern "C"
PLUGINAPI_DECL int plugin_init( const char *dirName )
//
// This routine initializes the plugins and attaches it to the menu.
// It returns 0 if there is no initialization error.
//
{
	char *dirScm;

	// Initialize the universe. This must be done by all
	// plugins. If the universe is not initialized the plugin
	// will fail.
	AlUniverse::initialize( );

	dirScm = makeAltPath(dirName,"scm");

	// Invoke the scheme file which sets defaults for the scheme
	// variables.
	AlInvokeSchemeFile( "simpleEditorExample_init.scm", dirScm);

	//	Create the function as a AlMomentaryFunction
	//	note that the icon name will be simpleEditor_func.S, simpleEditor_func.M
	hFunc.create( "simpleEditor_func", do_stuff_here );

	// Allocate a function handle. The first argument is the label on
	// the menu and the second is the function to invoke when the
	// menu item is selected.

	h.create( "Do SimpleEditor", &hFunc ); 

	// Define the attribute string for the attribute line below
	// the prompt line.
	h.setAttributeString( "SimpleEditor" );

	// Read in the option box. The first argument is the
	// option box in $ALIAS_WORKENV or an absolute path, and
	// the second argument is the name of the option box given
	// in the scheme file. The third argument(possibly null)
	// contains a path to the scheme file.  If a call to this method 
	// is omitted, there will be no option box
    if ( sSuccess != h.setOptionBox( "simpleEditorExample.scm", "simpleEditor.options", 
		dirScm ) ) {
        AlPrintf( 
			kPrompt, 
			"Sinple Editor plug-in unable to find .scm file for option box"
		);
        return (1);
    }

	h.setIconPath( makeAltPath( dirName, NULL ) );

	//	Alternatively, you could have used:
	//	h.setOptionBox( "simpleEditor.scm", "simpleEditor.options" )
	//
	//	Then the scheme file and the icon images would be loaded from
	//	the standard locations

	// Indicate which menu to add the plugin to. 
	h.installOnMenu( "mp_objtools", FALSE /* top */ );

	// Return a success code.
	// Returning a non zero indicates an error.
	// An error value ( a non-zero ) will be printed on the prompt
	// line in Alias.
	AlPrintf( kPrompt, "Simple Editor plug-in installed on Palette 'Object Edit'");
	return 0;
}

extern "C"
PLUGINAPI_DECL int plugin_exit( void )
{
	// Remove the plugin from the menu and free the FunctionHandle.
	// Note that h.destroy() implicitly calls h.removeFromMenu()
	h.deleteObject();
	hFunc.deleteObject();
	return 0;
}

