/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

#include <stdio.h>
#include <AlUniverse.h>

#include <AlLiveData.h>
#include <AlFunction.h>
#include <AlFunctionHandle.h>

extern "C" void printAl_All( AlOutputType ot );

//
//	This plugin prints out all of the geometry in the current universe.
//	It provides an example of how to walk all of the data structures.
//

void do_pow()
{
	AlPrintf( kPrompt, "Print Out World begin");

	printAl_All( kStdout );

	AlPrintf( kPrompt, "Print Out World end");
}

static AlFunctionHandle h;
static AlMomentaryFunction hFunc;

extern "C"
PLUGINAPI_DECL int plugin_init( const char *dirName )
{
	AlUniverse::initialize( kZUp );

	hFunc.create( do_pow );
	h.create( "Print Out World", &hFunc ); 
	h.setAttributeString( "pow" );
	h.appendToMenu( "mp_objtools" );
	h.setIconPath( makeAltPath( dirName, NULL ) );
	AlPrintf( kPrompt, "Print out world installed on Palette 'Object Edit'");
	
	return 0;
}

extern "C"
PLUGINAPI_DECL int plugin_exit( void )
{
	h.deleteObject();
	hFunc.deleteObject();
	return 0;
}

