/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

#include <AlCoordinateSystem.h>
#include <AlIterator.h>
#include <AlUniverse.h>

#include <AlLiveData.h>
#include <AlFunction.h>
#include <AlFunctionHandle.h>

#include <AlPickList.h>
#include <AlObject.h>

//
//	This is an example of an iterator used in conjunction with the picklist.
//	Note that with iterators, your function can have its own private data.
//
//

class countPick : public AlIterator
{
    private:
      int count;
    public:
      countPick()	{ count=0; }
      ~countPick()	{}
      virtual int func (AlObject* obj)
      {	
		  // Don't include Shaders, TExtures, or Environments
		  if (!(obj->asShaderPtr() || obj->asTexturePtr() ||
				obj->asEnvironmentPtr()))
            count++;
          return 0;
      }
      int getcount()
      {
          return count;
      }
};

void do_pickCount( void )
{
    int returnCode;
    countPick Counter;

    if (sSuccess == AlPickList::applyIteratorToItems( &Counter, returnCode))
		AlPrintf(kPrompt,	"Current number of picked items: %d",
         					Counter.getcount());
    else
    	AlPrintf(kPrompt, "Iteration Failed.");
}

static AlMomentaryFunction hFunc;
static AlFunctionHandle handle;

extern "C"
PLUGINAPI_DECL int plugin_init( const char *dirName )
{
	AlUniverse::initialize( kZUp );

	hFunc.create( "PickCount", do_pickCount );

	handle.create( "PickCount", &hFunc );
	handle.setAttributeString( "Count Picked Items" );
	handle.setIconPath( makeAltPath( dirName, NULL ) );
    handle.appendToMenu( "mp_pick" );

	AlPrintf( kPrompt, "Pick Count installed on Palette 'Pick'");
	return 0;
}

extern "C"
PLUGINAPI_DECL int plugin_exit( void )
{
	handle.deleteObject();
    hFunc.deleteObject();

	return 0;
}
