/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

#include <string.h>
#include <stdlib.h>
#ifdef _WIN32
# include <process.h>
#endif
#include <AlUniverse.h>
#include <AlLiveData.h>
#include <AlFunction.h>
#include <AlFunctionHandle.h>

//
// launchPaint.plugin ( formerly xpaint.plugin )
//

int isAnAliasPalette( char *filename )
{
    FILE *infile;
    char  buffer[ 256 ];

    if (! (infile = fopen( filename, "r" ) ) ) {

        return FALSE;

    }

    if (! fgets( buffer, 256, infile ) ) {

        return FALSE;
    }

    if ( strncmp( buffer, "cmap colors", 11 ) ) {

        return FALSE;
    }

    fclose( infile );
    return TRUE;

}


int ConvertToXpaint( char *input, char *output )
{
    FILE *infile, *outfile;
    char  buffer[ 256 ], buffer2[128], buffer3[128];
    int   colors = 0, i;
    int   r, g, b;

    if (! (infile = fopen( input, "r" ) ) ) {

        return -1;

    }

    if (! (outfile = fopen( output, "w" ) ) ) {

        fclose( infile );
        return -1;
    }

    bool failed = false;

    if (! fgets( buffer, 256, infile ) ) {

        failed = true;
    }
    
    if ( !failed && sscanf( buffer, "%s %s %d", buffer2, buffer3, &colors ) != 3 ) {

        failed = true;
    }

    fprintf( outfile, "reset\n\n" );

    for ( i = 0; i < colors && !failed; i++ ) {

        if (! fgets( buffer, 256, infile ) ) {

            failed = true;
            break;
        }

        if ( sscanf( buffer, "%d %d %d", &r, &g, &b ) != 3 ) {
            
            failed = true;
            break;
        }

        fprintf( outfile, "solid #%02x%02x%02x\n", r, g, b );

    }
    fclose( infile );
    fclose( outfile );

    return failed ? -1 : 0;
}


// The actual plugin function.
void my_lpaint()
{
	char command[ 4096 ];

#ifndef _WIN32
	// Instantiate an iterator and apply it to all picked
	// objects.
	int  readq, readi;
	char *palfile;
	char *imgfile;

	imgfile = "\0";
	palfile = "\0";

	AlPrintf( kPrompt, "Launching Xpaint." );
	if ( (sSuccess == AlGetInteger( "ReadQuantizerOut", readq ) ) &&
		 (sSuccess == AlGetInteger( "ReadImage", readi ) ) )  {
	
		AlPrintf( kPrompt, "Launching Xpaint." );
		
		if ( (! readq ) || (AlFileBrowser( kFileBrowseRead, &palfile,
										   "Palette File", FALSE, NULL ) ==
							sSuccess) ) {

			if ( (!readi) || (AlFileBrowser( kFileBrowseRead, &imgfile,
							  "Image File", FALSE, NULL ) == sSuccess) ) {


				if ( readq ) {
					
					if ( isAnAliasPalette( palfile ) ) {
						char tmp[1024];

						sprintf( tmp, "%s/.XPaintrc", getenv( "HOME" ) );

						ConvertToXpaint( palfile, tmp );
					}
					else {

						AlPrintf(kPrompt, "%s is not a palette file from quantizer.",
								 palfile );	
					}
				}
					
				const char *alias_loc = getenv("ALIAS_LOCATION");
				if ( alias_loc != NULL )
					sprintf( command, "%s/Gifts/bin/xpaint %s &", alias_loc, imgfile );
				else
					sprintf( command, "xpaint %s &", imgfile );

				system( command );
			}
		}
		AlPrintf( kPrompt, "Launched Paint." );
	}

#else
	sprintf( command, "start mspaint.exe" );
	system( command );
	AlPrintf( kPrompt, "Launched Paint." );
#endif

	AlUniverse::redrawScreen();

}

// This handle may have to be global if you wish to remove the
// plugin from the menu using the h.destroy() method in the
// 'momentary_exit' function.
// The menu entry is automatically removed when Alias exits.
//
static AlFunctionHandle h;
static AlMomentaryFunction hFunc;

extern "C"
PLUGINAPI_DECL int plugin_init( const char *dirName )
//
// This routine initializes the plugins and attaches it to the menu.
// It returns 0 if there is no initialization error.
//
{
	char *dirScm;

	// Initialize the universe. This must be done by all
	// plugins. If the universe is not initialized the plugin
	// will fail.
	AlUniverse::initialize( );

	dirScm = makeAltPath(dirName,"scm");

#ifndef _WIN32
	// Invoke the scheme file which sets defaults for the scheme
	// variables.
	AlInvokeSchemeFile( "launchPaint_init.scm", dirScm );
#endif

	// Allocate a function handle. The first argument is the label on
	// the menu and the second is the function to invoke when the
	// menu item is selected.
	hFunc.create( "pl_XPaint", my_lpaint );
	h.create( "Launch Paint", &hFunc ); 

	// Define the attribute string for the attribute line below
	// the prompt line.
	h.setAttributeString( "lpaint" );

#ifndef _WIN32
	// Read in the option box. The first argument is the
	// option box in $ALIAS_WORKENV or an absolute path, and
	// the second argument is the name of the option box given
	// in the scheme file. If a call to this method is omitted
	// there will be no option box.
	if ( sSuccess != h.setOptionBox( "launchPaint.scm", "lpaint.options", dirScm ) ) {
		AlPrintf( kPrompt, "launchPaint plug-in unable to find .scm file for option box" );
		return 1;
	}
#endif

	// Indicate which menu to add the plugin to. 
	h.installOnMenu( "al_goto", FALSE /* bottom */ );

	h.setIconPath( makeAltPath( dirName, NULL ) );

	// Return a success code.
	// Returning a non zero indicates an error.
	// An error value ( a non-zero ) will be printed on the prompt
	// line in Alias.

    AlPrintf( kPrompt, "Launch Paint plug-in installed under 'Utilities' menu." );

	return 0;
}

extern "C"
PLUGINAPI_DECL int plugin_exit( void )
{
	// Remove the plugin from the menu and free the FunctionHandle.
	// Note that h.destroy() implicitly calls h.removeFromMenu()
	h.deleteObject();
	hFunc.deleteObject();
	return 0;
}

