/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

#include <AlUniverse.h>
#include <AlDagNode.h>

#include <AlLiveData.h>
#include <AlFunction.h>
#include <AlFunctionHandle.h>

#include <AlSurface.h>
#include <AlSurfaceNode.h>

#include <AlUniverse.h>
#include <AlCurve.h>
#include <AlCurveNode.h>
#include <AlSurface.h>
#include <AlSurfaceNode.h>

AlSurfaceNode* makeCylinder( double radius, double height )
{
    statusCode      st;
	double			lineEnd1[3], lineEnd2[3];
	double			axis1[3], axis2[3];

	lineEnd1[0] = radius;	lineEnd1[1] = 0;		lineEnd1[2] = 0;
	lineEnd2[0] = radius;	lineEnd2[1] = height;	lineEnd2[2] = 0;

	axis1[0] = 0;	axis1[1] = 0;			axis1[2] = 0;
	axis2[0] = 0;	axis2[1] = 1;			axis2[2] = 0;

	AlCurve * line = new AlCurve;
    AlSurfaceNode * surfaceNode = ( AlSurfaceNode *)0;

	if( line->createLine( lineEnd1, lineEnd2 ) == sSuccess )
	{
    	AlSurface   * surface   = new AlSurface;
		
     	st = surface->createRevolvedSurface( axis1, axis2, 0.0, 90.0, line );
		line->deleteObject();
		delete line;

		if( st == sSuccess )
		{
			surfaceNode = new AlSurfaceNode;
			st = surfaceNode->create( surface );

			if( st != sSuccess )
			{
				surface->deleteObject();
				delete surfaceNode;
				surfaceNode = (AlSurfaceNode *)0;
			}
		}
		delete surface;
	}
	return surfaceNode;
}

static void cylinder()
{
	AlSurfaceNode *surfaceNode = makeCylinder( 5, 100 );
	delete surfaceNode;
	AlUniverse::redrawScreen();
}

static AlMomentaryFunction	cylinderFunc;
static AlFunctionHandle		handle;

extern "C" 
PLUGINAPI_DECL int plugin_init (const char *dirName)
{
	// Initialize OpenAlias
	//
	AlUniverse::initialize (kYUp);

	// Establish ourselves as a OpenAlias plug-in
	//
	cylinderFunc.create (cylinder);
	handle.create ("create Cylinder", &cylinderFunc);
	handle.setAttributeString ("cylinder");

	// Attach our option box
	//
	handle.appendToMenu ("mp_objtools");
	handle.setIconPath( makeAltPath( dirName, NULL ) );
	return (0);
}

extern "C" 
PLUGINAPI_DECL int plugin_exit (void)
{
	handle.deleteObject ();
	return (0);
}

