/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/


#include <AlUniverse.h>
#include <AlConstructionEntity.h>
#include <AlConstructionPlane.h>
#include <AlConstructionVector.h>
#include <AlPoint.h>
#include <AlObject.h>

#include <stdio.h>
#include <string.h>

AlConstructionEntity* attachedToConstructionEntity( AlConstructionEntity *entity )
{
	// If its not a point, it cannot be attached to a selected
	// construction entity.
	if ( entity->asPointPtr() == NULL )
		return NULL;
		
	AlConstructionEntity *ce = AlUniverse::firstConstructionEntity();
	if ( ce != NULL )
	{
		while ( ce != NULL )
		{
			AlConstructionPlane *cp = ce->asConstructionPlanePtr();
			if ( cp != NULL )
			{
				AlPoint *first = cp->first();
				AlPoint *second = cp->second();
				AlPoint *third = cp->third();

				if ( first == NULL && second == NULL && third == NULL )
					return NULL;

				boolean result = FALSE;
				if ( first != NULL && AlAreEqual( entity, first ) )
					result = TRUE;
				else if ( second != NULL && AlAreEqual( entity, second ) )
					result  = TRUE;
				else if ( third != NULL && AlAreEqual( entity, third ) )
					result = TRUE;

				if ( first )
					delete first;
				if ( second )
					delete second;
				if ( third )
					delete third;

				if ( result )
					return ce;
			}
			AlConstructionVector *cvec = ce->asConstructionVectorPtr();
			if ( cvec != NULL )
			{
				AlPoint *origin = cvec->origin();
				AlPoint *end = cvec->end();
				if ( origin == NULL && end == NULL )
					return NULL;

				boolean result = FALSE;
				if ( origin != NULL && AlAreEqual( entity, origin ) )
					result = TRUE;
				else if ( end != NULL && AlAreEqual( entity, end ) )
					result = TRUE;				

				if ( origin != NULL )
					delete origin;
				if ( end != NULL )
					delete end;

				if ( result )
					return ce;
			}
			AlConstructionEntity *cur = ce;
			ce = AlUniverse::nextConstructionEntity(ce);
			delete cur;
		}
		delete ce;
	}
	return NULL;
}

boolean attachedToUnSelectedConstructionEntity( AlConstructionEntity *ce )
{
	AlConstructionEntity *localce = attachedToConstructionEntity( ce );
	if ( localce != NULL )
		return ( ! localce->isPicked() );
	return FALSE;
} 

boolean attachedToInvisibileConstructionEntity( AlConstructionEntity *ce )
{
	AlConstructionEntity *localce = attachedToConstructionEntity( ce );
	if ( localce != NULL )
		return ( localce->invisible() );
	return FALSE;
} 


